/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.toolbar.floating;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.editor.toolbar.floating.AbstractFloatingToolbarComponentKt;
import com.intellij.openapi.editor.toolbar.floating.FloatingToolbarComponent;
import com.intellij.openapi.editor.toolbar.floating.TransparentComponent;
import com.intellij.openapi.editor.toolbar.floating.TransparentComponentAnimator;
import com.intellij.ui.ClientProperty;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u00012\u00020\u0002:\u0001<B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010-\u001a\u00020&H\u0014J\b\u0010.\u001a\u00020/H\u0016J\u001e\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020&2\f\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0014J\b\u00105\u001a\u00020/H\u0016J\b\u00106\u001a\u00020/H\u0016J\b\u00107\u001a\u00020/H\u0016J\u0010\u00108\u001a\u00020/2\u0006\u00109\u001a\u00020:H\u0014J\u0010\u0010;\u001a\u00020/2\u0006\u00109\u001a\u00020:H\u0014R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R+\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d*\u0004\b\u0018\u0010\u0019R+\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b \u0010\u001b\"\u0004\b!\u0010\u001d*\u0004\b\u001f\u0010\u0019R+\u0010\"\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b$\u0010\u001b\"\u0004\b%\u0010\u001d*\u0004\b#\u0010\u0019R+\u0010'\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020&8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,*\u0004\b(\u0010\u0019\u00a8\u0006="}, d2={"Lcom/intellij/openapi/editor/toolbar/floating/AbstractFloatingToolbarComponent;", "Lcom/intellij/openapi/actionSystem/impl/ActionToolbarImpl;", "Lcom/intellij/openapi/editor/toolbar/floating/FloatingToolbarComponent;", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "ownerComponent", "Ljavax/swing/JComponent;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/actionSystem/ActionGroup;Ljavax/swing/JComponent;Lcom/intellij/openapi/Disposable;)V", "transparentComponent", "Lcom/intellij/openapi/editor/toolbar/floating/AbstractFloatingToolbarComponent$ToolbarTransparentComponent;", "componentAnimator", "Lcom/intellij/openapi/editor/toolbar/floating/TransparentComponentAnimator;", "backgroundAlpha", "", "getBackgroundAlpha", "()F", "setBackgroundAlpha", "(F)V", "<set-?>", "", "showingTime", "getShowingTime$delegate", "(Lcom/intellij/openapi/editor/toolbar/floating/AbstractFloatingToolbarComponent;)Ljava/lang/Object;", "getShowingTime", "()I", "setShowingTime", "(I)V", "hidingTime", "getHidingTime$delegate", "getHidingTime", "setHidingTime", "retentionTime", "getRetentionTime$delegate", "getRetentionTime", "setRetentionTime", "", "autoHideable", "getAutoHideable$delegate", "getAutoHideable", "()Z", "setAutoHideable", "(Z)V", "isComponentOnHold", "addNotify", "", "actionsUpdated", "forced", "newVisibleActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "scheduleShow", "scheduleHide", "hideImmediately", "paintComponent", "g", "Ljava/awt/Graphics;", "paintChildren", "ToolbarTransparentComponent", "intellij.platform.ide.impl"})
@ApiStatus.NonExtendable
public abstract class AbstractFloatingToolbarComponent
extends ActionToolbarImpl
implements FloatingToolbarComponent {
    @NotNull
    private final ToolbarTransparentComponent transparentComponent;
    @NotNull
    private final TransparentComponentAnimator componentAnimator;
    private float backgroundAlpha;

    public AbstractFloatingToolbarComponent(@NotNull ActionGroup actionGroup, @NotNull JComponent ownerComponent, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)actionGroup, (String)"actionGroup");
        Intrinsics.checkNotNullParameter((Object)ownerComponent, (String)"ownerComponent");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super("ContextToolbar", actionGroup, true, false, false, 24, null);
        this.transparentComponent = new ToolbarTransparentComponent();
        this.componentAnimator = new TransparentComponentAnimator(this.transparentComponent, parentDisposable);
        this.backgroundAlpha = 0.55f;
        this.setTargetComponent(ownerComponent);
        this.setMinimumButtonSize(new Dimension(22, 22));
        this.setSkipWindowAdjustments(true);
        this.setReservePlaceAutoPopupIcon(false);
        this.setOpaque(false);
        ToolbarLayoutStrategy toolbarLayoutStrategy = ToolbarLayoutStrategy.NOWRAP_STRATEGY;
        Intrinsics.checkNotNullExpressionValue((Object)toolbarLayoutStrategy, (String)"NOWRAP_STRATEGY");
        this.setLayoutStrategy(toolbarLayoutStrategy);
    }

    @Override
    public float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    @Override
    public void setBackgroundAlpha(float f) {
        this.backgroundAlpha = f;
    }

    @Override
    public int getShowingTime() {
        return this.componentAnimator.getShowingTime();
    }

    @Override
    public void setShowingTime(int n) {
        this.componentAnimator.setShowingTime(n);
    }

    private static Object getShowingTime$delegate(AbstractFloatingToolbarComponent abstractFloatingToolbarComponent) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)abstractFloatingToolbarComponent.componentAnimator, TransparentComponentAnimator.class, "showingTime", "getShowingTime()I", 0)));
    }

    @Override
    public int getHidingTime() {
        return this.componentAnimator.getHidingTime();
    }

    @Override
    public void setHidingTime(int n) {
        this.componentAnimator.setHidingTime(n);
    }

    private static Object getHidingTime$delegate(AbstractFloatingToolbarComponent abstractFloatingToolbarComponent) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)abstractFloatingToolbarComponent.componentAnimator, TransparentComponentAnimator.class, "hidingTime", "getHidingTime()I", 0)));
    }

    @Override
    public int getRetentionTime() {
        return this.componentAnimator.getRetentionTime();
    }

    @Override
    public void setRetentionTime(int n) {
        this.componentAnimator.setRetentionTime(n);
    }

    private static Object getRetentionTime$delegate(AbstractFloatingToolbarComponent abstractFloatingToolbarComponent) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)abstractFloatingToolbarComponent.componentAnimator, TransparentComponentAnimator.class, "retentionTime", "getRetentionTime()I", 0)));
    }

    @Override
    public boolean getAutoHideable() {
        return this.componentAnimator.getAutoHideable();
    }

    @Override
    public void setAutoHideable(boolean bl) {
        this.componentAnimator.setAutoHideable(bl);
    }

    private static Object getAutoHideable$delegate(AbstractFloatingToolbarComponent abstractFloatingToolbarComponent) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)abstractFloatingToolbarComponent.componentAnimator, TransparentComponentAnimator.class, "autoHideable", "getAutoHideable()Z", 0)));
    }

    protected boolean isComponentOnHold() {
        return false;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateActionsImmediately(true);
    }

    @Override
    protected void actionsUpdated(boolean forced, @NotNull List<? extends AnAction> newVisibleActions) {
        Intrinsics.checkNotNullParameter(newVisibleActions, (String)"newVisibleActions");
        super.actionsUpdated(forced, newVisibleActions);
        this.transparentComponent.fireActionsUpdated();
    }

    @Override
    public void scheduleShow() {
        this.componentAnimator.scheduleShow();
    }

    @Override
    public void scheduleHide() {
        this.componentAnimator.scheduleHide();
    }

    @Override
    public void hideImmediately() {
        this.componentAnimator.hideImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        try {
            if (graphics instanceof Graphics2D) {
                float opacity = this.transparentComponent.getOpacity() * this.getBackgroundAlpha();
                ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, opacity));
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            graphics.setColor((Color)AbstractFloatingToolbarComponentKt.access$getBACKGROUND$p());
            graphics.fillRoundRect(0, 0, this.getBounds().width, this.getBounds().height, 6, 6);
            Intrinsics.checkNotNull((Object)graphics);
            super.paintComponent(graphics);
        }
        finally {
            graphics.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintChildren(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        try {
            if (graphics instanceof Graphics2D) {
                float opacity = this.transparentComponent.getOpacity();
                ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, opacity));
            }
            super.paintChildren(graphics);
        }
        finally {
            graphics.dispose();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\u0006\u0010\u0011\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/editor/toolbar/floating/AbstractFloatingToolbarComponent$ToolbarTransparentComponent;", "Lcom/intellij/openapi/editor/toolbar/floating/TransparentComponent;", "<init>", "(Lcom/intellij/openapi/editor/toolbar/floating/AbstractFloatingToolbarComponent;)V", "toolbar", "Lcom/intellij/openapi/editor/toolbar/floating/AbstractFloatingToolbarComponent;", "isVisible", "", "opacity", "", "getOpacity", "setOpacity", "", "isComponentOnHold", "showComponent", "hideComponent", "repaintComponent", "fireActionsUpdated", "intellij.platform.ide.impl"})
    private final class ToolbarTransparentComponent
    implements TransparentComponent {
        @NotNull
        private final AbstractFloatingToolbarComponent toolbar;
        private boolean isVisible;
        private float opacity;

        public ToolbarTransparentComponent() {
            this.toolbar = AbstractFloatingToolbarComponent.this;
            ClientProperty.put((JComponent)this.toolbar, ActionToolbarImpl.Companion.getSUPPRESS_FAST_TRACK(), (Object)true);
        }

        public final float getOpacity() {
            return this.opacity;
        }

        @Override
        public void setOpacity(float opacity) {
            this.opacity = opacity;
        }

        @Override
        public boolean isComponentOnHold() {
            return this.toolbar.isComponentOnHold();
        }

        @Override
        public void showComponent() {
            this.isVisible = true;
            this.toolbar.updateActionsImmediately(true);
        }

        @Override
        public void hideComponent() {
            if (!this.isVisible) {
                return;
            }
            this.isVisible = false;
            this.toolbar.updateActionsImmediately(false);
        }

        @Override
        public void repaintComponent() {
            this.toolbar.getComponent().repaint();
        }

        public final void fireActionsUpdated() {
            this.toolbar.setVisible(this.isVisible && this.toolbar.hasVisibleActions());
        }
    }
}

