/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileNodeDescriptor
extends NodeDescriptor<FileElement> {
    private FileElement myFileElement;
    private final Icon myOriginalIcon;
    private final String myComment;

    public FileNodeDescriptor(Project project2, @NotNull FileElement element, NodeDescriptor parentDescriptor, Icon closedIcon, String name2, @NlsSafe String comment2) {
        if (element == null) {
            FileNodeDescriptor.$$$reportNull$$$0(0);
        }
        super(project2, parentDescriptor);
        this.myOriginalIcon = closedIcon;
        this.myComment = comment2;
        this.myFileElement = element;
        this.myName = name2;
    }

    public boolean update() {
        Icon icon2;
        VirtualFile file2;
        boolean changed = false;
        if (this.myName == null || this.myComment == null) {
            String newName = this.myFileElement.toString();
            if (!newName.equals(this.myName)) {
                changed = true;
            }
            this.myName = newName;
        }
        if ((file2 = this.myFileElement.getFile()) == null) {
            return true;
        }
        this.setIcon(this.myOriginalIcon);
        if (this.myFileElement.isHidden() && (icon2 = this.getIcon()) != null) {
            this.setIcon(IconLoader.getTransparentIcon((Icon)icon2));
        }
        this.myColor = this.myFileElement.isHidden() ? SimpleTextAttributes.DARK_TEXT.getFgColor() : null;
        return changed;
    }

    @NotNull
    public FileElement getElement() {
        FileElement fileElement = this.myFileElement;
        if (fileElement == null) {
            FileNodeDescriptor.$$$reportNull$$$0(1);
        }
        return fileElement;
    }

    private void setElement(FileElement descriptor2) {
        this.myFileElement = descriptor2;
    }

    @NlsSafe
    @Nullable
    public String getComment() {
        return this.myComment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/ex/FileNodeDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/ex/FileNodeDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

