/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.actions.CollectZippedLogsAction;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.UnlockOption;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.fileEditor.impl.IdeScriptEngineUsageCollector;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.util.net.JdkProxyProvider;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.proxy.CommonProxy;
import com.intellij.util.system.OS;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class IdeUiServiceImpl
extends IdeUiService {
    public void revealFile(Path file2) {
        RevealFileAction.openFile(file2);
    }

    public UnlockOption askForUnlock(@NotNull Project project2, List<? extends VirtualFile> files2) {
        NonProjectFileWritingAccessDialog dialog2;
        if (project2 == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(0);
        }
        if (!(dialog2 = new NonProjectFileWritingAccessDialog(project2, files2)).showAndGet()) {
            return null;
        }
        return dialog2.getUnlockOption();
    }

    public boolean isFileRecentlyChanged(Project project2, VirtualFile file2) {
        IdeDocumentHistory documentHistory = IdeDocumentHistory.getInstance(project2);
        return documentHistory instanceof IdeDocumentHistoryImpl && ((IdeDocumentHistoryImpl)documentHistory).isRecentlyChanged(file2);
    }

    public void logIdeScriptUsageEvent(Class<?> clazz) {
        IdeScriptEngineUsageCollector.logUsageEvent(clazz);
    }

    public void systemNotify(@NlsContexts.SystemNotificationTitle String title2, @NlsContexts.SystemNotificationText String text2) {
        SystemNotifications.getInstance().notify("SessionLogger", title2, StringUtil.stripHtml((String)text2, (boolean)true));
    }

    @NotNull
    public DataContext createUiDataContext(Component component2) {
        DataContext dataContext2 = Utils.createAsyncDataContext(component2);
        if (dataContext2 == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(1);
        }
        return dataContext2;
    }

    @NotNull
    public DataContext createAsyncDataContext(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(2);
        }
        DataContext dataContext3 = Utils.createAsyncDataContext(dataContext2);
        if (dataContext3 == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(3);
        }
        return dataContext3;
    }

    @NotNull
    public DataContext createCustomizedDataContext(@NotNull DataContext dataContext2, @NotNull DataProvider dataProvider) {
        if (dataContext2 == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(4);
        }
        if (dataProvider == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(5);
        }
        DataContext dataContext3 = Utils.createAsyncDataContext(dataContext2, dataProvider);
        if (dataContext3 == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(6);
        }
        return dataContext3;
    }

    public Component getComponentFromRecentMouseEvent() {
        return SwingHelper.getComponentFromRecentMouseEvent();
    }

    public void browse(URL url) {
        BrowserUtil.browse((URL)url);
    }

    public void browse(String url) {
        BrowserUtil.browse((String)url);
    }

    public void performAction(@NotNull AnAction action2, @NotNull AnActionEvent event) {
        if (action2 == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(7);
        }
        if (event == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(8);
        }
        ActionUtil.performAction((AnAction)action2, (AnActionEvent)event);
    }

    public URLConnection openHttpConnection(String url) throws IOException {
        return HttpConfigurable.getInstance().openConnection(url);
    }

    public VirtualFile[] chooseFiles(FileChooserDescriptor descriptor2, Project project2, VirtualFile toSelect) {
        return FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project2, (VirtualFile)toSelect);
    }

    public VirtualFile chooseFile(FileChooserDescriptor descriptor2, JComponent component2, Project project2, VirtualFile dir) {
        return FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Component)component2, (Project)project2, (VirtualFile)dir);
    }

    public SSLContext getSslContext() {
        return CertificateManager.getInstance().getSslContext();
    }

    public String getProxyLogin() {
        return HttpConfigurable.getInstance().getProxyLogin();
    }

    public String getPlainProxyPassword() {
        return HttpConfigurable.getInstance().getPlainProxyPassword();
    }

    public boolean isProxyAuth() {
        return HttpConfigurable.getInstance().PROXY_AUTHENTICATION;
    }

    public List<Proxy> getProxyList(URL url) {
        return CommonProxy.getInstance().select(url);
    }

    public void prepareURL(String url) throws IOException {
        HttpConfigurable.getInstance().prepareURL(url);
    }

    public void showRefactoringMessageDialog(@NlsContexts.DialogTitle String title2, @NlsContexts.DialogMessage String message, String helpTopic, String iconId, boolean showCancelButton, Project project2) {
        RefactoringMessageDialog dialog2 = new RefactoringMessageDialog(title2, message, helpTopic, iconId, showCancelButton, project2);
        dialog2.show();
    }

    public void showErrorHint(Editor editor2, @NlsContexts.HintText String message) {
        HintManager.getInstance().showErrorHint(editor2, message);
    }

    public boolean showErrorDialog(@NlsContexts.DialogTitle String title2, @NlsContexts.DetailedDescription String message) {
        return IOExceptionDialog.showErrorDialog((String)title2, (String)message);
    }

    @Nullable
    public String getMacOsNetworkSolutionMessage(@NotNull Throwable error2, boolean full) {
        if (error2 == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(9);
        }
        if (OS.CURRENT == OS.macOS && OS.CURRENT.isAtLeast(15, 0) && (error2 instanceof NoRouteToHostException || error2.getCause() instanceof NoRouteToHostException)) {
            return IdeCoreBundle.message((String)(full ? "mac15.local.network.issue.full.message" : "mac15.local.network.issue.message"), (Object[])new Object[0]);
        }
        return null;
    }

    public void showProxyAuthNotification() {
        JdkProxyProvider.showProxyAuthNotification();
    }

    public void invokeLogCollectionAction(@Nullable Project project2) {
        new CollectZippedLogsAction().perform(project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/IdeUiServiceImpl";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/IdeUiServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUiDataContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAsyncDataContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomizedDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "askForUnlock";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAsyncDataContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCustomizedDataContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMacOsNetworkSolutionMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6 -> new IllegalStateException(string);
        };
    }
}

