/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB3\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\nJ\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u001f\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0003\u00a2\u0006\u0002\u0010\u001bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR2\u0010\u000f\u001a&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/progress/impl/CancellationCheck;", "", "thresholdMs", "Lkotlin/Function0;", "", "checkEnabled", "", "trackTrace", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "(J)V", "getThresholdMs", "()Lkotlin/jvm/functions/Function0;", "getCheckEnabled", "getTrackTrace", "statusRecord", "Ljava/lang/ThreadLocal;", "Lcom/intellij/openapi/progress/impl/CancellationCheck$CanceledStatusRecord;", "kotlin.jvm.PlatformType", "checkCancellationDiff", "", "record", "failure", "", "withCancellationCheck", "T", "block", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "CanceledStatusRecord", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nCancellationCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CancellationCheck.kt\ncom/intellij/openapi/progress/impl/CancellationCheck\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class CancellationCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Long> thresholdMs;
    @NotNull
    private final Function0<Boolean> checkEnabled;
    @NotNull
    private final Function0<Boolean> trackTrace;
    private final ThreadLocal<CanceledStatusRecord> statusRecord;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final CancellationCheck INSTANCE;

    private CancellationCheck(Function0<Long> thresholdMs, Function0<Boolean> checkEnabled, Function0<Boolean> trackTrace) {
        this.thresholdMs = thresholdMs;
        this.checkEnabled = checkEnabled;
        this.trackTrace = trackTrace;
        this.statusRecord = ThreadLocal.withInitial(CancellationCheck::statusRecord$lambda$0);
    }

    @NotNull
    public final Function0<Long> getThresholdMs() {
        return this.thresholdMs;
    }

    @NotNull
    public final Function0<Boolean> getCheckEnabled() {
        return this.checkEnabled;
    }

    @NotNull
    public final Function0<Boolean> getTrackTrace() {
        return this.trackTrace;
    }

    @TestOnly
    public CancellationCheck(long thresholdMs) {
        this((Function0<Long>)((Function0)() -> CancellationCheck._init_$lambda$0(thresholdMs)), (Function0<Boolean>)((Function0)CancellationCheck::_init_$lambda$1), (Function0<Boolean>)((Function0)CancellationCheck::_init_$lambda$2));
    }

    private final void checkCancellationDiff(CanceledStatusRecord record, Throwable failure) {
        if (record.getEnabled()) {
            long now = Clock.getTime();
            long diff = now - record.getTimestamp();
            if (diff > ((Number)this.thresholdMs.invoke()).longValue()) {
                Exception exception;
                StringBuilder stringBuilder;
                StringBuilder $this$checkCancellationDiff_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean $i$a$-buildString-CancellationCheck$checkCancellationDiff$message$22 = false;
                $this$checkCancellationDiff_u24lambda_u240.append(Thread.currentThread().getName() + " last checkCanceled was " + diff + " ms ago");
                if (failure != null) {
                    $this$checkCancellationDiff_u24lambda_u240.append(" (" + failure + ")");
                }
                String message = stringBuilder.toString();
                Exception $i$a$-buildString-CancellationCheck$checkCancellationDiff$message$22 = exception = record.getLastCancellationCall();
                String string = message;
                boolean bl = false;
                boolean bl2 = (Boolean)this.trackTrace.invoke();
                Throwable throwable = bl2 ? exception : null;
                String string2 = string;
                Throwable t = new Throwable(string2, throwable);
                LOG.error(message, t);
            }
            record.setTimestamp(now);
            if (((Boolean)this.trackTrace.invoke()).booleanValue()) {
                record.setLastCancellationCall(new Exception("previous check cancellation call"));
            }
        }
    }

    public final <T> T withCancellationCheck(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!((Boolean)this.checkEnabled.invoke()).booleanValue()) {
            return (T)block.invoke();
        }
        CanceledStatusRecord record = this.statusRecord.get();
        if (record.getEnabled()) {
            return (T)block.invoke();
        }
        CoreProgressManager.CheckCanceledHook hook = arg_0 -> CancellationCheck.withCancellationCheck$lambda$0(this, arg_0);
        Ref.ObjectRef r = new Ref.ObjectRef();
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNull((Object)progressManager, (String)"null cannot be cast to non-null type com.intellij.openapi.progress.impl.ProgressManagerImpl");
        ((ProgressManagerImpl)progressManager).runWithHook(hook, () -> CancellationCheck.withCancellationCheck$lambda$1(record, r, block, this));
        return (T)r.element;
    }

    private static final long _init_$lambda$0(long $thresholdMs) {
        return $thresholdMs;
    }

    private static final boolean _init_$lambda$1() {
        return true;
    }

    private static final boolean _init_$lambda$2() {
        return true;
    }

    private static final CanceledStatusRecord statusRecord$lambda$0() {
        return new CanceledStatusRecord(false, 0L, null, 7, null);
    }

    private static final boolean withCancellationCheck$lambda$0(CancellationCheck this$0, ProgressIndicator it) {
        CanceledStatusRecord canceledStatusRecord = this$0.statusRecord.get();
        Intrinsics.checkNotNullExpressionValue((Object)canceledStatusRecord, (String)"get(...)");
        this$0.checkCancellationDiff(canceledStatusRecord, null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void withCancellationCheck$lambda$1(CanceledStatusRecord $record, Ref.ObjectRef $r, Function0 $block, CancellationCheck this$0) {
        $record.setEnabled(true);
        $record.setTimestamp(Clock.getTime());
        $record.setLastCancellationCall(null);
        try {
            Object object;
            Ref.ObjectRef objectRef = $r;
            try {
                Ref.ObjectRef objectRef2 = objectRef;
                object = $block.invoke();
            }
            catch (Throwable throwable) {
                void e;
                Ref.ObjectRef objectRef3 = objectRef;
                Intrinsics.checkNotNull((Object)$record);
                this$0.checkCancellationDiff($record, (Throwable)e);
                throw e;
            }
            objectRef2.element = object;
            Intrinsics.checkNotNull((Object)$record);
            this$0.checkCancellationDiff($record, null);
        }
        finally {
            $record.setEnabled(false);
            $record.setTimestamp(Clock.getTime());
            $record.setLastCancellationCall(null);
        }
    }

    private static final long INSTANCE$lambda$0() {
        return Registry.Companion.intValue("ide.cancellation.check.threshold");
    }

    private static final boolean INSTANCE$lambda$1() {
        return Registry.Companion.is("ide.cancellation.check.enabled");
    }

    private static final boolean INSTANCE$lambda$2() {
        return Registry.Companion.is("ide.cancellation.check.trace.all");
    }

    @JvmStatic
    public static final <T> T runWithCancellationCheck(@NotNull Function0<? extends T> block) {
        return Companion.runWithCancellationCheck(block);
    }

    static {
        Logger logger2 = Logger.getInstance(CancellationCheck.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        INSTANCE = new CancellationCheck((Function0<Long>)((Function0)CancellationCheck::INSTANCE$lambda$0), (Function0<Boolean>)((Function0)CancellationCheck::INSTANCE$lambda$1), (Function0<Boolean>)((Function0)CancellationCheck::INSTANCE$lambda$2));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u0011\u0010\u0019\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bH\u00c6\u0003J/\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bH\u00c6\u0001J\u0014\u0010\u001b\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u00d6\u0081\u0004J\n\u0010\u001f\u001a\u00020 H\u00d6\u0081\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/progress/impl/CancellationCheck$CanceledStatusRecord;", "", "enabled", "", "timestamp", "", "lastCancellationCall", "Ljava/lang/Exception;", "Lkotlin/Exception;", "<init>", "(ZJLjava/lang/Exception;)V", "getEnabled", "()Z", "setEnabled", "(Z)V", "getTimestamp", "()J", "setTimestamp", "(J)V", "getLastCancellationCall", "()Ljava/lang/Exception;", "setLastCancellationCall", "(Ljava/lang/Exception;)V", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    private static final class CanceledStatusRecord {
        private boolean enabled;
        private long timestamp;
        @Nullable
        private Exception lastCancellationCall;

        public CanceledStatusRecord(boolean enabled2, long timestamp, @Nullable Exception lastCancellationCall) {
            this.enabled = enabled2;
            this.timestamp = timestamp;
            this.lastCancellationCall = lastCancellationCall;
        }

        public /* synthetic */ CanceledStatusRecord(boolean bl, long l, Exception exception, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                l = Clock.getTime();
            }
            if ((n & 4) != 0) {
                exception = null;
            }
            this(bl, l, exception);
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(long l) {
            this.timestamp = l;
        }

        @Nullable
        public final Exception getLastCancellationCall() {
            return this.lastCancellationCall;
        }

        public final void setLastCancellationCall(@Nullable Exception exception) {
            this.lastCancellationCall = exception;
        }

        public final boolean component1() {
            return this.enabled;
        }

        public final long component2() {
            return this.timestamp;
        }

        @Nullable
        public final Exception component3() {
            return this.lastCancellationCall;
        }

        @NotNull
        public final CanceledStatusRecord copy(boolean enabled2, long timestamp, @Nullable Exception lastCancellationCall) {
            return new CanceledStatusRecord(enabled2, timestamp, lastCancellationCall);
        }

        public static /* synthetic */ CanceledStatusRecord copy$default(CanceledStatusRecord canceledStatusRecord, boolean bl, long l, Exception exception, int n, Object object) {
            if ((n & 1) != 0) {
                bl = canceledStatusRecord.enabled;
            }
            if ((n & 2) != 0) {
                l = canceledStatusRecord.timestamp;
            }
            if ((n & 4) != 0) {
                exception = canceledStatusRecord.lastCancellationCall;
            }
            return canceledStatusRecord.copy(bl, l, exception);
        }

        @NotNull
        public String toString() {
            return "CanceledStatusRecord(enabled=" + this.enabled + ", timestamp=" + this.timestamp + ", lastCancellationCall=" + this.lastCancellationCall + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.enabled);
            result2 = result2 * 31 + Long.hashCode(this.timestamp);
            result2 = result2 * 31 + (this.lastCancellationCall == null ? 0 : this.lastCancellationCall.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CanceledStatusRecord)) {
                return false;
            }
            CanceledStatusRecord canceledStatusRecord = (CanceledStatusRecord)other;
            if (this.enabled != canceledStatusRecord.enabled) {
                return false;
            }
            if (this.timestamp != canceledStatusRecord.timestamp) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lastCancellationCall, (Object)canceledStatusRecord.lastCancellationCall);
        }

        public CanceledStatusRecord() {
            this(false, 0L, null, 7, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\rH\u0007\u00a2\u0006\u0002\u0010\u000eR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0003\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/progress/impl/CancellationCheck$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "INSTANCE", "Lcom/intellij/openapi/progress/impl/CancellationCheck;", "getINSTANCE$annotations", "runWithCancellationCheck", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getINSTANCE$annotations() {
        }

        @JvmStatic
        public final <T> T runWithCancellationCheck(@NotNull Function0<? extends T> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return INSTANCE.withCancellationCheck(block);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

