/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.configuration;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManagerListener;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.configuration.ChannelingProgressIndicator;
import com.intellij.openapi.project.configuration.HeadlessLogging;
import com.intellij.openapi.util.text.Formats;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/project/configuration/HeadlessProgressListener;", "Lcom/intellij/openapi/progress/ProgressManagerListener;", "<init>", "()V", "taskDurationMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "beforeTaskStart", "", "task", "Lcom/intellij/openapi/progress/Task;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "afterTaskFinished", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class HeadlessProgressListener
implements ProgressManagerListener {
    @NotNull
    private final ConcurrentHashMap<Integer, Long> taskDurationMap = new ConcurrentHashMap();

    public void beforeTaskStart(@NotNull Task task, @NotNull ProgressIndicator indicator2) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        if (!(indicator2 instanceof ProgressIndicatorEx)) {
            return;
        }
        HeadlessLogging.INSTANCE.logMessage("[IDE]: Task '" + task.getTitle() + "' started");
        ((Map)this.taskDurationMap).put(System.identityHashCode(task), System.currentTimeMillis());
        ((ProgressIndicatorEx)indicator2).addStateDelegate((ProgressIndicatorEx)new ChannelingProgressIndicator("IDE"));
        super.beforeTaskStart(task, indicator2);
    }

    public void afterTaskFinished(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        long currentTime = System.currentTimeMillis();
        Long startTime = this.taskDurationMap.remove(System.identityHashCode(task));
        String elapsedTimeSuffix = startTime == null ? "" : " in " + Formats.formatDuration((long)(currentTime - startTime));
        HeadlessLogging.INSTANCE.logMessage("[IDE]: Task '" + task.getTitle() + "' ended" + elapsedTimeSuffix);
    }
}

