/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public interface IPersistentFSRecordsStorage
extends Forceable,
AutoCloseable {
    public int recordsCount();

    public <R> R readRecord(int var1, @NotNull RecordReader<R> var2) throws IOException;

    public int updateRecord(int var1, @NotNull RecordUpdater var2) throws IOException;

    public <R> R readHeader(@NotNull HeaderReader<R> var1) throws IOException;

    public void updateHeader(@NotNull HeaderUpdater var1) throws IOException;

    public static interface HeaderForUpdate
    extends HeaderForRead {
        public void setVersion(int var1) throws IOException;
    }

    public static interface HeaderForRead {
        public long getTimestamp() throws IOException;

        public int getVersion() throws IOException;

        public int getGlobalModCount() throws IOException;
    }

    public static interface RecordForUpdate
    extends RecordForRead {
        public void setAttributeRecordId(int var1) throws IOException;

        public void setParent(int var1) throws IOException;

        public void setNameId(int var1) throws IOException;

        public boolean setFlags(@PersistentFS.Attributes int var1) throws IOException;

        default public boolean addFlags(@PersistentFS.Attributes int flagBits) throws IOException {
            int oldFlags = this.getFlags();
            int newFlags = oldFlags | flagBits;
            if (newFlags != oldFlags) {
                return this.setFlags(newFlags);
            }
            return false;
        }

        default public boolean removeFlags(@PersistentFS.Attributes int flagBits) throws IOException {
            int oldFlags = this.getFlags();
            int newFlags = oldFlags & ~flagBits;
            if (newFlags != oldFlags) {
                return this.setFlags(newFlags);
            }
            return false;
        }

        public boolean setLength(long var1) throws IOException;

        public boolean setTimestamp(long var1) throws IOException;

        public boolean setContentRecordId(int var1) throws IOException;
    }

    public static interface RecordForRead {
        public int recordId();

        public int getAttributeRecordId() throws IOException;

        public int getParent() throws IOException;

        public int getNameId() throws IOException;

        public long getLength() throws IOException;

        public long getTimestamp() throws IOException;

        public int getModCount() throws IOException;

        public int getContentRecordId() throws IOException;

        public @PersistentFS.Attributes int getFlags() throws IOException;
    }

    @FunctionalInterface
    public static interface HeaderUpdater {
        public boolean updateHeader(@NotNull HeaderForUpdate var1) throws IOException;
    }

    @FunctionalInterface
    public static interface HeaderReader<R> {
        public R readHeader(@NotNull HeaderForRead var1) throws IOException;
    }

    @FunctionalInterface
    public static interface RecordReader<R> {
        public R readRecord(@NotNull RecordForRead var1) throws IOException;
    }

    @FunctionalInterface
    public static interface RecordUpdater {
        public boolean updateRecord(@NotNull RecordForUpdate var1) throws IOException;
    }
}

