/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.async;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.async.AsyncPopupStep;
import com.intellij.util.concurrency.EdtScheduler;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B3\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0012\u001a\u00020\tH\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ui/popup/async/AsyncPopupWaiter;", "Lcom/intellij/openapi/Disposable;", "step", "Lcom/intellij/ui/popup/async/AsyncPopupStep;", "point", "Lcom/intellij/ui/awt/RelativePoint;", "onReady", "Lkotlin/Function1;", "Lcom/intellij/openapi/ui/popup/PopupStep;", "", "<init>", "(Lcom/intellij/ui/popup/async/AsyncPopupStep;Lcom/intellij/ui/awt/RelativePoint;Lkotlin/jvm/functions/Function1;)V", "myGlassPane", "Ljavax/swing/JComponent;", "myIcon", "myDisposed", "", "createLoadingIcon", "dispose", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class AsyncPopupWaiter
implements Disposable {
    @Nullable
    private final JComponent myGlassPane;
    @Nullable
    private final JComponent myIcon;
    private boolean myDisposed;

    public AsyncPopupWaiter(@NotNull AsyncPopupStep<?> step2, @NotNull RelativePoint point, @NotNull Function1<? super PopupStep<?>, Unit> onReady) {
        Intrinsics.checkNotNullParameter(step2, (String)"step");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter(onReady, (String)"onReady");
        JRootPane jRootPane = UIUtil.getRootPane((Component)point.getComponent());
        Component component2 = jRootPane != null ? jRootPane.getGlassPane() : null;
        this.myGlassPane = component2 instanceof JComponent ? (JComponent)component2 : null;
        this.myIcon = this.createLoadingIcon(point);
        step2.getPromise().onSuccess(arg_0 -> AsyncPopupWaiter._init_$lambda$1(arg_0 -> AsyncPopupWaiter._init_$lambda$0(this, onReady, arg_0), arg_0));
        step2.getPromise().onError(arg_0 -> AsyncPopupWaiter._init_$lambda$3(arg_0 -> AsyncPopupWaiter._init_$lambda$2(this, arg_0), arg_0));
    }

    private final JComponent createLoadingIcon(RelativePoint point) {
        if (this.myGlassPane == null) {
            return null;
        }
        JLabel icon2 = new JLabel((Icon)AnimatedIcon.Default.INSTANCE);
        Dimension size2 = icon2.getPreferredSize();
        icon2.setSize(size2);
        Point point2 = point.getPoint((Component)this.myGlassPane);
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getPoint(...)");
        Point location = point2;
        location.x -= size2.width * 3;
        location.y -= size2.height / 2;
        icon2.setLocation(location);
        EdtScheduler.Companion.getInstance().schedule(Registry.Companion.intValue("actionSystem.popup.progress.icon.delay", 500), () -> AsyncPopupWaiter.createLoadingIcon$lambda$0(icon2, this));
        return icon2;
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        if (this.myGlassPane != null && this.myIcon != null) {
            this.myGlassPane.remove(this.myIcon);
        }
    }

    private static final Unit _init_$lambda$0(AsyncPopupWaiter this$0, Function1 $onReady, PopupStep it) {
        if (this$0.myDisposed) {
            return Unit.INSTANCE;
        }
        Intrinsics.checkNotNull((Object)it);
        $onReady.invoke((Object)it);
        Disposer.dispose((Disposable)this$0);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit _init_$lambda$2(AsyncPopupWaiter this$0, Throwable it) {
        Disposer.dispose((Disposable)this$0);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void createLoadingIcon$lambda$0(JLabel $icon, AsyncPopupWaiter this$0) {
        if ($icon.isVisible() && !this$0.myDisposed) {
            this$0.myGlassPane.add($icon);
        }
    }
}

