/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5.report;

import com.intellij.junit5.report.AbstractTestReporter;
import com.intellij.junit5.report.ExecutionState;
import com.intellij.junit5.report.TeamCityTestReporter;
import com.intellij.junit5.report.TestReporter;
import com.intellij.rt.execution.junit.MapSerializerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestIdentifier;

public class SuiteReporter
extends AbstractTestReporter {
    public SuiteReporter(TestIdentifier identifier, ExecutionState state) {
        super(identifier, state);
    }

    public boolean isSkipped() {
        UniqueId id = UniqueId.parse((String)this.identifier.getUniqueId());
        List segments = id.getSegments();
        if (segments.isEmpty()) {
            return false;
        }
        UniqueId.Segment lastSegment = (UniqueId.Segment)segments.get(segments.size() - 1);
        if ("engine".equals(lastSegment.getType())) {
            return true;
        }
        String root = this.state.getRootName();
        return root != null && root.equals(lastSegment.getValue());
    }

    @Override
    public List<String> start() {
        if (this.isSkipped()) {
            return Collections.emptyList();
        }
        this.state.resetFinishCount();
        String start = MapSerializerUtil.asString((String)"testSuiteStarted", this.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID, AbstractTestReporter.ReportedField.HINT, AbstractTestReporter.ReportedField.METAINFO));
        return Collections.singletonList(start);
    }

    @Override
    public List<String> finish(TestExecutionResult result) {
        Set descendants;
        if (this.isSkipped() && result.getStatus() != TestExecutionResult.Status.FAILED) {
            return Collections.emptyList();
        }
        ArrayList<String> out = new ArrayList<String>();
        TestExecutionResult.Status status = result.getStatus();
        Throwable throwable = result.getThrowable().orElse(null);
        Set set = descendants = this.state.plan() != null ? this.state.plan().getDescendants(this.identifier) : Collections.emptySet();
        if (status == TestExecutionResult.Status.FAILED) {
            SyntheticTestReporter reporter = new SyntheticTestReporter(this, "Class Configuration");
            out.add(MapSerializerUtil.asString((String)"testStarted", reporter.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID, AbstractTestReporter.ReportedField.HINT, AbstractTestReporter.ReportedField.METAINFO)));
            out.addAll(reporter.reportFailure(throwable, 0L, true, "testFailed", null));
            out.add(MapSerializerUtil.asString((String)"testFinished", reporter.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID)));
        } else if (status == TestExecutionResult.Status.ABORTED && descendants.isEmpty()) {
            Map<String, String> attrs = this.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID);
            if (throwable != null) {
                attrs.put("message", throwable.getMessage());
            }
            out.add(MapSerializerUtil.asString((String)"testIgnored", attrs));
        }
        if (!descendants.isEmpty() && this.state.finishCount() == 0) {
            String reason = throwable != null ? throwable.getMessage() : null;
            for (TestIdentifier child : descendants) {
                AbstractTestReporter reporter = TeamCityTestReporter.get(child, this.state);
                if (!(reporter instanceof TestReporter)) continue;
                Throwable childEx = status == TestExecutionResult.Status.ABORTED ? throwable : null;
                out.addAll(((TestReporter)reporter).ignore(childEx, reason));
            }
            this.state.resetFinishCount();
        }
        if (!this.isSkipped()) {
            out.add(MapSerializerUtil.asString((String)"testSuiteFinished", this.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID)));
        }
        return out;
    }

    @Override
    public List<String> treeStarted() {
        if (this.isSkipped()) {
            return Collections.emptyList();
        }
        String started = MapSerializerUtil.asString((String)"suiteTreeStarted", this.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID, AbstractTestReporter.ReportedField.HINT, AbstractTestReporter.ReportedField.METAINFO));
        return Collections.singletonList(started);
    }

    @Override
    public List<String> treeFinished() {
        if (this.isSkipped()) {
            return Collections.emptyList();
        }
        String finished = MapSerializerUtil.asString((String)"suiteTreeEnded", this.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID));
        return Collections.singletonList(finished);
    }

    @Override
    public List<String> skip(String reason) {
        Set descendants;
        ArrayList<String> out = new ArrayList<String>();
        Set set = descendants = this.state.plan() != null ? this.state.plan().getDescendants(this.identifier) : Collections.emptySet();
        if (descendants.isEmpty()) {
            Map<String, String> attrs = this.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID);
            if (reason != null && !reason.isEmpty()) {
                attrs.put("message", reason);
            }
            out.add(MapSerializerUtil.asString((String)"testIgnored", attrs));
        } else {
            for (TestIdentifier child : descendants) {
                AbstractTestReporter reporter = TeamCityTestReporter.get(child, this.state);
                out.addAll(reporter.start());
                out.addAll(reporter.skip(reason));
            }
            this.state.resetFinishCount();
        }
        if (!this.isSkipped()) {
            out.add(MapSerializerUtil.asString((String)"testSuiteFinished", this.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID)));
        }
        return out;
    }

    private static class SyntheticTestReporter
    extends TestReporter {
        private final SuiteReporter myOriginal;
        private final boolean isMethodSource;

        SyntheticTestReporter(SuiteReporter original, String name) {
            super(original.identifier, original.state, name);
            this.myOriginal = original;
            this.isMethodSource = this.identifier.getSource().map(s -> s instanceof MethodSource).orElse(false);
        }

        @Override
        protected String id() {
            if (this.isMethodSource) {
                return super.id();
            }
            return super.id() + "/[synthetic:method:configuration()]";
        }

        @Override
        protected Optional<SuiteReporter> getParent() {
            if (this.isMethodSource || this.myOriginal.isSkipped()) {
                return super.getParent();
            }
            return Optional.of(this.myOriginal);
        }
    }
}

