/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/plugins/UntilBuildDeprecation;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "MINIMAL_API_VERSION", "Lcom/intellij/openapi/util/BuildNumber;", "Lorg/jetbrains/annotations/Nullable;", "forceHonorUntilBuild", "", "getForceHonorUntilBuild", "()Z", "nullizeIfTargetsMinimalApiOrLater", "", "untilBuild", "diagnosticId", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class UntilBuildDeprecation {
    @NotNull
    public static final UntilBuildDeprecation INSTANCE = new UntilBuildDeprecation();
    @NotNull
    private static final BuildNumber MINIMAL_API_VERSION;
    private static final boolean forceHonorUntilBuild;

    private UntilBuildDeprecation() {
    }

    private final Logger getLOG() {
        return PluginManagerCore.getLogger();
    }

    public final boolean getForceHonorUntilBuild() {
        return forceHonorUntilBuild;
    }

    @Nullable
    public final String nullizeIfTargetsMinimalApiOrLater(@Nullable String untilBuild, @Nullable String diagnosticId) {
        if (forceHonorUntilBuild || untilBuild == null) {
            return untilBuild;
        }
        try {
            BuildNumber untilBuildNumber = BuildNumber.fromStringOrNull((String)untilBuild);
            if (untilBuildNumber != null && untilBuildNumber.compareTo(MINIMAL_API_VERSION) >= 0) {
                if (untilBuildNumber.compareTo(PluginManagerCore.getBuildNumber()) < 0) {
                    Logger logger = this.getLOG();
                    StringBuilder stringBuilder = new StringBuilder().append("Plugin ");
                    String string = diagnosticId;
                    if (string == null) {
                        string = "<no name>";
                    }
                    logger.info(stringBuilder.append(string).append(" has until-build set to ").append(untilBuild).append(". Until-build _from plugin configuration file (plugin.xml)_ for plugins targeting ").append(MINIMAL_API_VERSION).append("+ is ignored. Effective until-build value can be set via the Marketplace.").toString());
                }
                return null;
            }
        }
        catch (Throwable e) {
            this.getLOG().warn("failed to parse until-build number", e);
        }
        return untilBuild;
    }

    static {
        BuildNumber buildNumber = BuildNumber.fromString((String)"252.*");
        Intrinsics.checkNotNull((Object)buildNumber);
        MINIMAL_API_VERSION = buildNumber;
        forceHonorUntilBuild = Boolean.parseBoolean(System.getProperty("idea.plugins.honor.until.build", "true"));
    }
}

