/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.tree;

import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.impl.builder.CompositeMarker;
import com.intellij.platform.syntax.parser.ProductionMarkerList;
import com.intellij.platform.syntax.parser.SyntaxTreeBuilder;
import com.intellij.platform.syntax.tree.ASTMarkersImpl;
import com.intellij.platform.syntax.tree.ASTMarkersKt;
import com.intellij.platform.syntax.tree.MarkerKind;
import com.intellij.platform.syntax.tree.ToAstMarkersKt;
import com.intellij.util.fastutil.ints.IntArrayList;
import com.intellij.util.fastutil.ints.MutableIntList;
import com.intellij.util.fastutil.ints.MutableIntListExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/syntax/tree/AstMarkerBuilder;", "", "builder", "Lcom/intellij/platform/syntax/parser/SyntaxTreeBuilder;", "productions", "Lcom/intellij/platform/syntax/parser/ProductionMarkerList;", "<init>", "(Lcom/intellij/platform/syntax/parser/SyntaxTreeBuilder;Lcom/intellij/platform/syntax/parser/ProductionMarkerList;)V", "astMarkersResult", "Lcom/intellij/platform/syntax/tree/ASTMarkersImpl;", "build", "nodeProductionIndices", "Lcom/intellij/util/fastutil/ints/IntArrayList;", "astTreeIndices", "lastErrorLexemeIndex", "", "isInsideChameleon", "", "markersInsideChameleonCount", "processTree", "", "processStartMarker", "item", "Lcom/intellij/platform/syntax/parser/SyntaxTreeBuilder$Production;", "i", "processErrorMarker", "processDoneMarker", "processLeafChameleons", "intellij.platform.syntax"})
final class AstMarkerBuilder {
    @NotNull
    private final SyntaxTreeBuilder builder;
    @NotNull
    private final ProductionMarkerList productions;
    @NotNull
    private final ASTMarkersImpl astMarkersResult;
    @NotNull
    private final IntArrayList nodeProductionIndices;
    @NotNull
    private final IntArrayList astTreeIndices;
    private int lastErrorLexemeIndex;
    private boolean isInsideChameleon;
    private int markersInsideChameleonCount;

    public AstMarkerBuilder(@NotNull SyntaxTreeBuilder builder, @NotNull ProductionMarkerList productions2) {
        this.builder = builder;
        this.productions = productions2;
        this.astMarkersResult = new ASTMarkersImpl();
        this.nodeProductionIndices = new IntArrayList();
        this.astTreeIndices = new IntArrayList();
        this.lastErrorLexemeIndex = -1;
    }

    @NotNull
    public final ASTMarkersImpl build() {
        if (this.productions.getSize() == 0) {
            return this.astMarkersResult;
        }
        this.processTree();
        this.processLeafChameleons();
        return this.astMarkersResult;
    }

    private final void processTree() {
        int n = this.productions.getSize();
        for (int i = 0; i < n; ++i) {
            SyntaxTreeBuilder.Production item = this.productions.getMarker(i);
            if (this.productions.isDoneMarker(i)) {
                this.processDoneMarker(item, i);
                continue;
            }
            if (item.isErrorMarker()) {
                this.processErrorMarker(item, i);
                continue;
            }
            this.processStartMarker(item, i);
        }
    }

    private final void processStartMarker(SyntaxTreeBuilder.Production item, int i) {
        if (this.isInsideChameleon) {
            ++this.markersInsideChameleonCount;
            return;
        }
        int astTreeIndex = this.astMarkersResult.pushBack();
        Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.intellij.platform.syntax.impl.builder.CompositeMarker");
        int markerId = ((CompositeMarker)item).getMarkerId();
        this.astMarkersResult.setMarker(astTreeIndex, markerId, MarkerKind.Start, ((CompositeMarker)item).isCollapsed(), null, ((CompositeMarker)item).getNodeType());
        if (((CompositeMarker)item).getNodeType().isLazyParseable() && ((CompositeMarker)item).isCollapsed()) {
            this.astMarkersResult.setChameleon(((CompositeMarker)item).getStartIndex(), ASTMarkersKt.newChameleonRef());
            this.isInsideChameleon = true;
        }
        this.astTreeIndices.add(astTreeIndex);
        this.nodeProductionIndices.add(i);
    }

    private final void processErrorMarker(SyntaxTreeBuilder.Production item, int i) {
        int startLexemeIndex = item.getStartTokenIndex();
        if (startLexemeIndex == this.lastErrorLexemeIndex) {
            return;
        }
        int prevLexemeIndex = ToAstMarkersKt.access$getLexemeIndexAt(this.productions, i - 1);
        int startLexeme = item.getStartTokenIndex();
        int endLexeme = item.getEndTokenIndex();
        this.lastErrorLexemeIndex = startLexemeIndex;
        int index = this.astMarkersResult.pushBack();
        this.astMarkersResult.setMarker(index, i, MarkerKind.Error, false, item.getErrorMessage(), item.getNodeType());
        this.astMarkersResult.setLexemeInfo(index, endLexeme - startLexeme, startLexeme - prevLexemeIndex);
    }

    private final void processDoneMarker(SyntaxTreeBuilder.Production item, int i) {
        ASTMarkersImpl aSTMarkersImpl;
        if (this.isInsideChameleon) {
            if (this.markersInsideChameleonCount != 0) {
                --this.markersInsideChameleonCount;
                return;
            }
            this.isInsideChameleon = false;
        }
        int nodeProductionStartIndex = MutableIntListExtensionsKt.pop((MutableIntList)((MutableIntList)this.nodeProductionIndices));
        int astIndexStart = MutableIntListExtensionsKt.pop((MutableIntList)((MutableIntList)this.astTreeIndices));
        int astIndexEnd = this.astMarkersResult.pushBack();
        int prevLexemeIndex = astIndexStart > 0 ? ToAstMarkersKt.access$getLexemeIndexAt(this.productions, nodeProductionStartIndex - 1) : 0;
        int lexemeStartIndex = ToAstMarkersKt.access$getLexemeIndexAt(this.productions, nodeProductionStartIndex);
        int lexemeEndIndex = ToAstMarkersKt.access$getLexemeIndexAt(this.productions, i);
        ASTMarkersImpl $this$processDoneMarker_u24lambda_u240 = aSTMarkersImpl = this.astMarkersResult;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.intellij.platform.syntax.impl.builder.CompositeMarker");
        $this$processDoneMarker_u24lambda_u240.setMarker(astIndexEnd, ((CompositeMarker)item).getMarkerId(), MarkerKind.End, ((CompositeMarker)item).isCollapsed(), null, ((CompositeMarker)item).getNodeType());
        $this$processDoneMarker_u24lambda_u240.setLexemeInfo(astIndexEnd, lexemeEndIndex - lexemeStartIndex, lexemeStartIndex - prevLexemeIndex);
        $this$processDoneMarker_u24lambda_u240.setLexemeInfo(astIndexStart, lexemeEndIndex - lexemeStartIndex, lexemeStartIndex - prevLexemeIndex);
        $this$processDoneMarker_u24lambda_u240.setMarkersCount(astIndexEnd, astIndexEnd - astIndexStart);
        $this$processDoneMarker_u24lambda_u240.setMarkersCount(astIndexStart, astIndexEnd - astIndexStart);
    }

    private final void processLeafChameleons() {
        int n = this.builder.getTokens().getTokenCount();
        for (int i = 0; i < n; ++i) {
            SyntaxElementType type;
            if (this.builder.getTokens().getTokenType(i) == null || !type.isLazyParseable()) continue;
            this.astMarkersResult.setChameleon(i, ASTMarkersKt.newChameleonRef());
        }
    }
}

