/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassITableGlobalSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.FieldGlobalSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.FuncSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.FunctionHeapTypeSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.FunctionTypeSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.GcHeapTypeSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.GcTypeSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LiteralGlobalSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.RttiGlobalSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VTableGlobalSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VTableHeapTypeSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VTableTypeSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.wasm.ir.DeclarationResolver;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u00b7\u0001\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u0003\u0012\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\u0003\u0012\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\"H\u0016J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u001d\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/DefinedDeclarationsResolver;", "Lorg/jetbrains/kotlin/wasm/ir/DeclarationResolver;", "functions", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "globalFields", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "globalVTables", "globalClassITables", "globalRTTI", "gcTypes", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "vTableGcTypes", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructDeclaration;", "functionTypes", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "<init>", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "getFunctions", "()Ljava/util/Map;", "getGlobalFields", "getGlobalVTables", "getGlobalClassITables", "getGlobalRTTI", "getGcTypes", "getVTableGcTypes", "getFunctionTypes", "globalLiteralGlobals", "", "getGlobalLiteralGlobals", "resolve", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType$Type;", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$TypeIdx;", "global", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$GlobalIdx;", "function", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$FuncIdx;", "backend.wasm"})
public final class DefinedDeclarationsResolver
extends DeclarationResolver {
    @NotNull
    private final Map<IdSignature, WasmFunction> functions;
    @NotNull
    private final Map<IdSignature, WasmGlobal> globalFields;
    @NotNull
    private final Map<IdSignature, WasmGlobal> globalVTables;
    @NotNull
    private final Map<IdSignature, WasmGlobal> globalClassITables;
    @NotNull
    private final Map<IdSignature, WasmGlobal> globalRTTI;
    @NotNull
    private final Map<IdSignature, WasmTypeDeclaration> gcTypes;
    @NotNull
    private final Map<IdSignature, WasmStructDeclaration> vTableGcTypes;
    @NotNull
    private final Map<IdSignature, WasmFunctionType> functionTypes;
    @NotNull
    private final Map<String, WasmGlobal> globalLiteralGlobals;

    public DefinedDeclarationsResolver(@NotNull Map<IdSignature, WasmFunction> functions, @NotNull Map<IdSignature, WasmGlobal> globalFields, @NotNull Map<IdSignature, WasmGlobal> globalVTables, @NotNull Map<IdSignature, WasmGlobal> globalClassITables, @NotNull Map<IdSignature, WasmGlobal> globalRTTI, @NotNull Map<IdSignature, WasmTypeDeclaration> gcTypes, @NotNull Map<IdSignature, WasmStructDeclaration> vTableGcTypes, @NotNull Map<IdSignature, WasmFunctionType> functionTypes) {
        Intrinsics.checkNotNullParameter(functions, (String)"functions");
        Intrinsics.checkNotNullParameter(globalFields, (String)"globalFields");
        Intrinsics.checkNotNullParameter(globalVTables, (String)"globalVTables");
        Intrinsics.checkNotNullParameter(globalClassITables, (String)"globalClassITables");
        Intrinsics.checkNotNullParameter(globalRTTI, (String)"globalRTTI");
        Intrinsics.checkNotNullParameter(gcTypes, (String)"gcTypes");
        Intrinsics.checkNotNullParameter(vTableGcTypes, (String)"vTableGcTypes");
        Intrinsics.checkNotNullParameter(functionTypes, (String)"functionTypes");
        this.functions = functions;
        this.globalFields = globalFields;
        this.globalVTables = globalVTables;
        this.globalClassITables = globalClassITables;
        this.globalRTTI = globalRTTI;
        this.gcTypes = gcTypes;
        this.vTableGcTypes = vTableGcTypes;
        this.functionTypes = functionTypes;
        this.globalLiteralGlobals = new LinkedHashMap();
    }

    public /* synthetic */ DefinedDeclarationsResolver(Map map, Map map2, Map map3, Map map4, Map map5, Map map6, Map map7, Map map8, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 2) != 0) {
            map2 = new LinkedHashMap();
        }
        if ((n & 4) != 0) {
            map3 = new LinkedHashMap();
        }
        if ((n & 8) != 0) {
            map4 = new LinkedHashMap();
        }
        if ((n & 0x10) != 0) {
            map5 = new LinkedHashMap();
        }
        if ((n & 0x20) != 0) {
            map6 = new LinkedHashMap();
        }
        if ((n & 0x40) != 0) {
            map7 = new LinkedHashMap();
        }
        if ((n & 0x80) != 0) {
            map8 = new LinkedHashMap();
        }
        this(map, map2, map3, map4, map5, map6, map7, map8);
    }

    @NotNull
    public final Map<IdSignature, WasmFunction> getFunctions() {
        return this.functions;
    }

    @NotNull
    public final Map<IdSignature, WasmGlobal> getGlobalFields() {
        return this.globalFields;
    }

    @NotNull
    public final Map<IdSignature, WasmGlobal> getGlobalVTables() {
        return this.globalVTables;
    }

    @NotNull
    public final Map<IdSignature, WasmGlobal> getGlobalClassITables() {
        return this.globalClassITables;
    }

    @NotNull
    public final Map<IdSignature, WasmGlobal> getGlobalRTTI() {
        return this.globalRTTI;
    }

    @NotNull
    public final Map<IdSignature, WasmTypeDeclaration> getGcTypes() {
        return this.gcTypes;
    }

    @NotNull
    public final Map<IdSignature, WasmStructDeclaration> getVTableGcTypes() {
        return this.vTableGcTypes;
    }

    @NotNull
    public final Map<IdSignature, WasmFunctionType> getFunctionTypes() {
        return this.functionTypes;
    }

    @NotNull
    public final Map<String, WasmGlobal> getGlobalLiteralGlobals() {
        return this.globalLiteralGlobals;
    }

    @NotNull
    public WasmTypeDeclaration resolve(@NotNull WasmHeapType.Type type) {
        WasmTypeDeclaration wasmTypeDeclaration;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        WasmHeapType.Type type2 = type;
        if (type2 instanceof GcHeapTypeSymbol) {
            wasmTypeDeclaration = (WasmTypeDeclaration)MapsKt.getValue(this.gcTypes, (Object)((GcHeapTypeSymbol)type).getType());
        } else if (type2 instanceof VTableHeapTypeSymbol) {
            wasmTypeDeclaration = (WasmTypeDeclaration)MapsKt.getValue(this.vTableGcTypes, (Object)((VTableHeapTypeSymbol)type).getType());
        } else if (type2 instanceof FunctionHeapTypeSymbol) {
            wasmTypeDeclaration = (WasmTypeDeclaration)MapsKt.getValue(this.functionTypes, (Object)((FunctionHeapTypeSymbol)type).getType());
        } else {
            throw new IllegalStateException(("Unsupported Type type: " + Reflection.getOrCreateKotlinClass(type.getClass()).getSimpleName()).toString());
        }
        return wasmTypeDeclaration;
    }

    @NotNull
    public WasmTypeDeclaration resolve(@NotNull WasmImmediate.TypeIdx type) {
        WasmTypeDeclaration wasmTypeDeclaration;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        WasmImmediate.TypeIdx typeIdx = type;
        if (typeIdx instanceof GcTypeSymbol) {
            wasmTypeDeclaration = (WasmTypeDeclaration)MapsKt.getValue(this.gcTypes, (Object)((GcTypeSymbol)type).getValue());
        } else if (typeIdx instanceof VTableTypeSymbol) {
            wasmTypeDeclaration = (WasmTypeDeclaration)MapsKt.getValue(this.vTableGcTypes, (Object)((VTableTypeSymbol)type).getValue());
        } else if (typeIdx instanceof FunctionTypeSymbol) {
            wasmTypeDeclaration = (WasmTypeDeclaration)MapsKt.getValue(this.functionTypes, (Object)((FunctionTypeSymbol)type).getValue());
        } else {
            throw new IllegalStateException(("Unsupported TypeSymbol type: " + Reflection.getOrCreateKotlinClass(type.getClass()).getSimpleName()).toString());
        }
        return wasmTypeDeclaration;
    }

    @NotNull
    public WasmGlobal resolve(@NotNull WasmImmediate.GlobalIdx global) {
        WasmGlobal wasmGlobal;
        Intrinsics.checkNotNullParameter((Object)global, (String)"global");
        WasmImmediate.GlobalIdx globalIdx = global;
        if (globalIdx instanceof FieldGlobalSymbol) {
            wasmGlobal = (WasmGlobal)MapsKt.getValue(this.globalFields, (Object)((FieldGlobalSymbol)global).getValue());
        } else if (globalIdx instanceof VTableGlobalSymbol) {
            wasmGlobal = (WasmGlobal)MapsKt.getValue(this.globalVTables, (Object)((VTableGlobalSymbol)global).getValue());
        } else if (globalIdx instanceof ClassITableGlobalSymbol) {
            wasmGlobal = (WasmGlobal)MapsKt.getValue(this.globalClassITables, (Object)((ClassITableGlobalSymbol)global).getValue());
        } else if (globalIdx instanceof RttiGlobalSymbol) {
            wasmGlobal = (WasmGlobal)MapsKt.getValue(this.globalRTTI, (Object)((RttiGlobalSymbol)global).getValue());
        } else if (globalIdx instanceof LiteralGlobalSymbol) {
            wasmGlobal = (WasmGlobal)MapsKt.getValue(this.globalLiteralGlobals, (Object)((LiteralGlobalSymbol)global).getValue());
        } else {
            throw new IllegalStateException(("Unsupported GlobalSymbol type: " + Reflection.getOrCreateKotlinClass(global.getClass()).getSimpleName()).toString());
        }
        return wasmGlobal;
    }

    @NotNull
    public WasmFunction resolve(@NotNull WasmImmediate.FuncIdx function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (!(function2 instanceof FuncSymbol)) {
            throw new IllegalStateException(("Unsupported FuncSymbolBase type: " + Reflection.getOrCreateKotlinClass(function2.getClass()).getSimpleName()).toString());
        }
        return (WasmFunction)MapsKt.getValue(this.functions, (Object)((FuncSymbol)function2).getValue());
    }

    public DefinedDeclarationsResolver() {
        this(null, null, null, null, null, null, null, null, 255, null);
    }
}

