/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.Hash128Bits;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmTypeDeclaratorByFingerprint;
import org.jetbrains.kotlin.wasm.ir.WasmAnyRef;
import org.jetbrains.kotlin.wasm.ir.WasmArrayDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmArrayRef;
import org.jetbrains.kotlin.wasm.ir.WasmEqRef;
import org.jetbrains.kotlin.wasm.ir.WasmExternRef;
import org.jetbrains.kotlin.wasm.ir.WasmF32;
import org.jetbrains.kotlin.wasm.ir.WasmF64;
import org.jetbrains.kotlin.wasm.ir.WasmFuncRef;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI16;
import org.jetbrains.kotlin.wasm.ir.WasmI31Ref;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmI64;
import org.jetbrains.kotlin.wasm.ir.WasmI8;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullExternrefType;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullrefType;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructFieldDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructRef;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmV128;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\f\u0010\r\u001a$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00020\u0012H\u0002\u001aB\u0010\u0014\u001a\u00020\u00152\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u00172\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00020\u00122\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0012H\u0000\"\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006*\u0016\u0010\u0000\"\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u001b"}, d2={"RecursiveTypeGroup", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "indexes", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "[Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "encodeIndex", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructFieldDeclaration;", "index", "Lkotlin/ULong;", "encodeIndex-VKZWuLQ", "(J)Ljava/util/List;", "wasmTypeDeclarationOrderKey", "", "declaration", "resolver", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType$Type;", "canonicalStableSort", "", "group", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/RecursiveTypeGroup;", "getStableId", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructDeclaration;", "Lorg/jetbrains/kotlin/backend/common/serialization/Hash128Bits;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nRecursiveTypesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecursiveTypesUtils.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/RecursiveTypesUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n1#2:184\n1021#3,2:185\n*S KotlinDebug\n*F\n+ 1 RecursiveTypesUtils.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/RecursiveTypesUtilsKt\n*L\n123#1:185,2\n*E\n"})
public final class RecursiveTypesUtilsKt {
    @NotNull
    private static final WasmType[] indexes;

    @NotNull
    public static final List<WasmStructFieldDeclaration> encodeIndex-VKZWuLQ(long index) {
        long current = index;
        List result = new ArrayList();
        int indexesSize = UInt.constructor-impl((int)indexes.length);
        boolean wasI31 = false;
        while (current != 0L) {
            WasmType fieldType = indexes[(int)Long.remainderUnsigned(current, ULong.constructor-impl((long)((long)indexesSize & 0xFFFFFFFFL)))];
            result.add(new WasmStructFieldDeclaration("", fieldType, false));
            wasI31 = wasI31 || Intrinsics.areEqual((Object)fieldType, (Object)WasmI31Ref.INSTANCE);
            current = Long.divideUnsigned(current, ULong.constructor-impl((long)((long)indexesSize & 0xFFFFFFFFL)));
        }
        if (!wasI31) {
            result.add(new WasmStructFieldDeclaration("", (WasmType)WasmI31Ref.INSTANCE, false));
        }
        return result;
    }

    private static final int wasmTypeDeclarationOrderKey(WasmTypeDeclaration declaration, Function1<? super WasmHeapType.Type, ? extends WasmTypeDeclaration> resolver) {
        int n;
        WasmTypeDeclaration wasmTypeDeclaration = declaration;
        if (wasmTypeDeclaration instanceof WasmArrayDeclaration) {
            n = 0;
        } else if (wasmTypeDeclaration instanceof WasmFunctionType) {
            n = 0;
        } else if (wasmTypeDeclaration instanceof WasmStructDeclaration) {
            WasmHeapType.Type type = ((WasmStructDeclaration)declaration).getSuperType();
            if (type != null) {
                WasmHeapType.Type it = type;
                boolean bl = false;
                n = RecursiveTypesUtilsKt.wasmTypeDeclarationOrderKey((WasmTypeDeclaration)resolver.invoke((Object)it), resolver) + 1;
            } else {
                n = 0;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    public static final void canonicalStableSort(@NotNull List<WasmTypeDeclaration> group, @NotNull Function1<? super WasmHeapType.Type, ? extends WasmTypeDeclaration> resolver, @NotNull Function1<? super WasmStructDeclaration, Hash128Bits> getStableId) {
        Intrinsics.checkNotNullParameter(group, (String)"group");
        Intrinsics.checkNotNullParameter(resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter(getStableId, (String)"getStableId");
        if (group.size() == 1) {
            return;
        }
        CollectionsKt.sortWith(group, (Comparator)new WasmTypeDeclaratorByFingerprint(resolver, getStableId));
        Function1 sortMethod = arg_0 -> RecursiveTypesUtilsKt.canonicalStableSort$lambda$0(resolver, arg_0);
        List<WasmTypeDeclaration> $this$sortBy$iv = group;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(sortMethod){
                final /* synthetic */ Function1 $selector;
                {
                    this.$selector = $selector;
                }

                public final int compare(T a, T b) {
                    Function1 function1 = this.$selector;
                    return ComparisonsKt.compareValues((Comparable)((Comparable)function1.invoke(a)), (Comparable)((Comparable)function1.invoke(b)));
                }
            });
        }
    }

    private static final int canonicalStableSort$lambda$0(Function1<? super WasmHeapType.Type, ? extends WasmTypeDeclaration> $resolver, WasmTypeDeclaration declaration) {
        return RecursiveTypesUtilsKt.wasmTypeDeclarationOrderKey(declaration, $resolver);
    }

    static {
        WasmType[] wasmTypeArray = new WasmType[]{WasmI32.INSTANCE, WasmI64.INSTANCE, WasmF32.INSTANCE, WasmF64.INSTANCE, WasmV128.INSTANCE, WasmI8.INSTANCE, WasmI16.INSTANCE, WasmFuncRef.INSTANCE, WasmExternRef.INSTANCE, WasmAnyRef.INSTANCE, WasmEqRef.INSTANCE, WasmRefNullrefType.INSTANCE, WasmRefNullExternrefType.INSTANCE, WasmI31Ref.INSTANCE, WasmStructRef.INSTANCE, WasmArrayRef.INSTANCE};
        indexes = wasmTypeArray;
    }
}

