/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.AssociatedObjectBySymbols;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.FunctionHeapTypeSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.JsModuleAndQualifierReference;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ModuleReferencedDeclarations;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.Synthetics;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VTableHeapTypeSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledFileFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFileCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmServiceImportExportKind;
import org.jetbrains.kotlin.ir.declarations.IdSignatureRetriever;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImportDescriptor;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u001a\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0013H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0013H\u0016J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0013H\u0016J\u001e\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00152\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContextWithImport;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;", "wasmFileFragment", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledFileFragment;", "idSignatureRetriever", "Lorg/jetbrains/kotlin/ir/declarations/IdSignatureRetriever;", "moduleName", "", "moduleReferencedDeclarations", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ModuleReferencedDeclarations;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledFileFragment;Lorg/jetbrains/kotlin/ir/declarations/IdSignatureRetriever;Ljava/lang/String;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ModuleReferencedDeclarations;)V", "value", "", "declarationImported", "getDeclarationImported", "()Z", "handleFunctionWithImport", "declaration", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "handleVTableWithImport", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "handleClassITableWithImport", "handleRTTIWithImport", "superType", "handleGlobalField", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "addObjectInstanceFieldInitializer", "", "initializer", "addNonConstantFieldInitializers", "addMainFunctionWrapper", "mainFunctionWrapper", "addTestFunDeclarator", "testFunctionDeclarator", "addEquivalentFunction", "key", "function", "addClassAssociatedObjects", "klass", "associatedObjectsGetters", "", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/AssociatedObjectBySymbols;", "addJsModuleAndQualifierReferences", "reference", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/JsModuleAndQualifierReference;", "backend.wasm"})
public final class WasmFileCodegenContextWithImport
extends WasmFileCodegenContext {
    @NotNull
    private final String moduleName;
    @NotNull
    private final ModuleReferencedDeclarations moduleReferencedDeclarations;
    private boolean declarationImported;

    public WasmFileCodegenContextWithImport(@NotNull WasmCompiledFileFragment wasmFileFragment, @NotNull IdSignatureRetriever idSignatureRetriever, @NotNull String moduleName, @NotNull ModuleReferencedDeclarations moduleReferencedDeclarations) {
        Intrinsics.checkNotNullParameter((Object)wasmFileFragment, (String)"wasmFileFragment");
        Intrinsics.checkNotNullParameter((Object)idSignatureRetriever, (String)"idSignatureRetriever");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)moduleReferencedDeclarations, (String)"moduleReferencedDeclarations");
        super(wasmFileFragment, idSignatureRetriever);
        this.moduleName = moduleName;
        this.moduleReferencedDeclarations = moduleReferencedDeclarations;
    }

    public final boolean getDeclarationImported() {
        return this.declarationImported;
    }

    @Override
    public boolean handleFunctionWithImport(@NotNull IrFunctionSymbol declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IdSignature signature = this.getIdSignatureRetriever().declarationSignature((IrDeclaration)declaration.getOwner());
        if (!CollectionsKt.contains((Iterable)this.moduleReferencedDeclarations.getReferencedFunction(), (Object)signature)) {
            return true;
        }
        FunctionHeapTypeSymbol functionTypeSymbol = this.referenceFunctionHeapType(declaration);
        this.defineFunction(declaration, (WasmFunction)new WasmFunction.Imported(String.valueOf(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration.getOwner()))), (WasmHeapType.Type.FunctionType)functionTypeSymbol, new WasmImportDescriptor(this.moduleName, (WasmSymbolReadOnly)new WasmSymbol((Object)(WasmServiceImportExportKind.FUNC.getPrefix() + signature)))));
        this.declarationImported = true;
        return true;
    }

    @Override
    public boolean handleVTableWithImport(@NotNull IrClassSymbol declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IdSignature signature = this.getIdSignatureRetriever().declarationSignature((IrDeclaration)declaration.getOwner());
        if (!CollectionsKt.contains((Iterable)this.moduleReferencedDeclarations.getReferencedGlobalVTable(), (Object)signature)) {
            return true;
        }
        WasmGlobal global = new WasmGlobal("<classVTable>", (WasmType)new WasmRefType((WasmHeapType)new VTableHeapTypeSymbol(this.getReferenceKey((IrSymbol)declaration))), false, CollectionsKt.emptyList(), new WasmImportDescriptor(this.moduleName, (WasmSymbolReadOnly)new WasmSymbol((Object)(WasmServiceImportExportKind.VTABLE.getPrefix() + signature))));
        this.defineGlobalVTable(declaration, global);
        this.declarationImported = true;
        return true;
    }

    @Override
    public boolean handleClassITableWithImport(@NotNull IrClassSymbol declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IdSignature signature = this.getIdSignatureRetriever().declarationSignature((IrDeclaration)declaration.getOwner());
        if (!CollectionsKt.contains((Iterable)this.moduleReferencedDeclarations.getReferencedGlobalClassITable(), (Object)signature)) {
            return true;
        }
        WasmGlobal global = new WasmGlobal("<classITable>", (WasmType)new WasmRefType((WasmHeapType)Synthetics.HeapTypes.INSTANCE.getWasmAnyArrayType()), false, CollectionsKt.emptyList(), new WasmImportDescriptor(this.moduleName, (WasmSymbolReadOnly)new WasmSymbol((Object)(WasmServiceImportExportKind.ITABLE.getPrefix() + signature))));
        this.defineGlobalClassITable(declaration, global);
        this.declarationImported = true;
        return true;
    }

    @Override
    public boolean handleRTTIWithImport(@NotNull IrClassSymbol declaration, @Nullable IrClassSymbol superType) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IdSignature signature = this.getIdSignatureRetriever().declarationSignature((IrDeclaration)declaration.getOwner());
        if (!CollectionsKt.contains((Iterable)this.moduleReferencedDeclarations.getReferencedRttiGlobal(), (Object)signature)) {
            return true;
        }
        WasmGlobal rttiGlobal = new WasmGlobal(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration.getOwner())) + "_rtti", (WasmType)new WasmRefType((WasmHeapType)Synthetics.HeapTypes.INSTANCE.getRttiType()), false, CollectionsKt.emptyList(), new WasmImportDescriptor(this.moduleName, (WasmSymbolReadOnly)new WasmSymbol((Object)(WasmServiceImportExportKind.RTTI.getPrefix() + signature))));
        this.defineRttiGlobal(rttiGlobal, declaration, superType);
        this.declarationImported = true;
        return true;
    }

    @Override
    public boolean handleGlobalField(@NotNull IrFieldSymbol declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return true;
    }

    @Override
    public void addObjectInstanceFieldInitializer(@NotNull IrFunctionSymbol initializer) {
        Intrinsics.checkNotNullParameter((Object)initializer, (String)"initializer");
    }

    @Override
    public void addNonConstantFieldInitializers(@NotNull IrFunctionSymbol initializer) {
        Intrinsics.checkNotNullParameter((Object)initializer, (String)"initializer");
    }

    @Override
    public void addMainFunctionWrapper(@NotNull IrFunctionSymbol mainFunctionWrapper) {
        Intrinsics.checkNotNullParameter((Object)mainFunctionWrapper, (String)"mainFunctionWrapper");
    }

    @Override
    public void addTestFunDeclarator(@NotNull IrFunctionSymbol testFunctionDeclarator) {
        Intrinsics.checkNotNullParameter((Object)testFunctionDeclarator, (String)"testFunctionDeclarator");
    }

    @Override
    public void addEquivalentFunction(@NotNull String key, @NotNull IrFunctionSymbol function2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
    }

    @Override
    public void addClassAssociatedObjects(@NotNull IrClassSymbol klass, @NotNull List<AssociatedObjectBySymbols> associatedObjectsGetters) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter(associatedObjectsGetters, (String)"associatedObjectsGetters");
    }

    @Override
    public void addJsModuleAndQualifierReferences(@NotNull JsModuleAndQualifierReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
    }
}

