/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ULong;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.Hash128Bits;
import org.jetbrains.kotlin.wasm.ir.TypesKt;
import org.jetbrains.kotlin.wasm.ir.WasmArrayDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00162\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0001\u0016B/\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmTypeDeclaratorByFingerprint;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "Lkotlin/Comparator;", "resolver", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType$Type;", "getStableId", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructDeclaration;", "Lorg/jetbrains/kotlin/backend/common/serialization/Hash128Bits;", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "combine", "hash", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "declaration", "getFingerprint", "compare", "", "o1", "o2", "Companion", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nRecursiveTypesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecursiveTypesUtils.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmTypeDeclaratorByFingerprint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n1849#2,3:184\n1849#2,3:187\n*S KotlinDebug\n*F\n+ 1 RecursiveTypesUtils.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmTypeDeclaratorByFingerprint\n*L\n159#1:184,3\n160#1:187,3\n*E\n"})
final class WasmTypeDeclaratorByFingerprint
implements Comparator<WasmTypeDeclaration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<WasmHeapType.Type, WasmTypeDeclaration> resolver;
    @NotNull
    private final Function1<WasmStructDeclaration, Hash128Bits> getStableId;
    private static final long k0 = -4348849565147123417L;
    private static final long k1 = -5435081209227447693L;
    private static final long k2 = -7286425919675154353L;
    @NotNull
    private static final Hash128Bits structHash = new Hash128Bits(k0, k1, null);
    @NotNull
    private static final Hash128Bits functionHash = new Hash128Bits(k1, k2, null);
    @NotNull
    private static final Hash128Bits arrayHash = new Hash128Bits(k2, k0, null);

    public WasmTypeDeclaratorByFingerprint(@NotNull Function1<? super WasmHeapType.Type, ? extends WasmTypeDeclaration> resolver, @NotNull Function1<? super WasmStructDeclaration, Hash128Bits> getStableId) {
        Intrinsics.checkNotNullParameter(resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter(getStableId, (String)"getStableId");
        this.resolver = resolver;
        this.getStableId = getStableId;
    }

    private final Hash128Bits combine(Hash128Bits hash, WasmType type) {
        Hash128Bits hash128Bits;
        WasmHeapType wasmHeapType;
        WasmType wasmType = type;
        if (wasmType instanceof WasmRefType) {
            wasmHeapType = TypesKt.getHeapType((WasmType)type);
        } else if (wasmType instanceof WasmRefNullType) {
            wasmHeapType = TypesKt.getHeapType((WasmType)type);
        } else {
            return hash.combineWith(new Hash128Bits(ULong.constructor-impl((long)type.getCode()), 0L, 2, null));
        }
        WasmHeapType heapType = wasmHeapType;
        wasmType = heapType;
        if (wasmType instanceof WasmHeapType.Type) {
            hash128Bits = this.combine(hash, (WasmTypeDeclaration)this.resolver.invoke((Object)heapType));
        } else if (wasmType instanceof WasmHeapType.Simple) {
            hash128Bits = hash.combineWith(new Hash128Bits(ULong.constructor-impl((long)((WasmHeapType.Simple)heapType).getCode()), 0L, 2, null));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return hash128Bits;
    }

    private final Hash128Bits combine(Hash128Bits hash, WasmTypeDeclaration declaration) {
        Hash128Bits hash128Bits;
        WasmTypeDeclaration wasmTypeDeclaration = declaration;
        if (wasmTypeDeclaration instanceof WasmStructDeclaration) {
            hash128Bits = hash.combineWith(structHash).combineWith((Hash128Bits)this.getStableId.invoke((Object)declaration));
        } else if (wasmTypeDeclaration instanceof WasmFunctionType) {
            WasmType p1;
            Hash128Bits p0;
            Iterable $this$fold$iv;
            Hash128Bits functionHash = hash.combineWith(WasmTypeDeclaratorByFingerprint.functionHash);
            Iterable iterable = ((WasmFunctionType)declaration).getParameterTypes();
            Hash128Bits initial$iv = functionHash;
            boolean $i$f$fold = false;
            Hash128Bits accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                WasmType wasmType = (WasmType)element$iv;
                p0 = accumulator$iv;
                boolean bl = false;
                accumulator$iv = this.combine(p0, p1);
            }
            Hash128Bits parametersHash = accumulator$iv;
            $this$fold$iv = ((WasmFunctionType)declaration).getResultTypes();
            initial$iv = parametersHash;
            $i$f$fold = false;
            accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                p1 = (WasmType)element$iv;
                p0 = accumulator$iv;
                boolean bl = false;
                accumulator$iv = this.combine(p0, p1);
            }
            hash128Bits = accumulator$iv;
        } else if (wasmTypeDeclaration instanceof WasmArrayDeclaration) {
            Hash128Bits arrayHash = hash.combineWith(WasmTypeDeclaratorByFingerprint.arrayHash);
            hash128Bits = this.combine(arrayHash, ((WasmArrayDeclaration)declaration).getField().getType());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return hash128Bits;
    }

    private final Hash128Bits getFingerprint(WasmTypeDeclaration type) {
        return this.combine(new Hash128Bits(0L, 0L, null), type);
    }

    @Override
    public int compare(@NotNull WasmTypeDeclaration o1, @NotNull WasmTypeDeclaration o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        Hash128Bits o1Hash = this.getFingerprint(o1);
        Hash128Bits o2Hash = this.getFingerprint(o2);
        return o1Hash.getHighBytes-s-VKNKU() == o2Hash.getHighBytes-s-VKNKU() ? Long.compareUnsigned(o1Hash.getLowBytes-s-VKNKU(), o2Hash.getLowBytes-s-VKNKU()) : Long.compareUnsigned(o1Hash.getHighBytes-s-VKNKU(), o2Hash.getHighBytes-s-VKNKU());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmTypeDeclaratorByFingerprint$Companion;", "", "<init>", "()V", "k0", "Lkotlin/ULong;", "J", "k1", "k2", "structHash", "Lorg/jetbrains/kotlin/backend/common/serialization/Hash128Bits;", "functionHash", "arrayHash", "backend.wasm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

