/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmIrAttributesKt;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferencedSymbolRemapper;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$H\u0002J\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0&*\u00020'2\u0006\u0010(\u001a\u00020\u001bH\u0002J\f\u0010)\u001a\u00020$*\u00020*H\u0002J&\u0010+\u001a\u00020\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0&2\u0006\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020*H\u0002J\u001e\u0010/\u001a\u00020\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0&2\u0006\u0010.\u001a\u00020*H\u0002J\u0010\u00100\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020*H\u0002J \u00103\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020*2\u0006\u0010(\u001a\u00020\u001bH\u0002J\u0018\u00104\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00105\u001a\u00020$H\u0002J\u0018\u00106\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020*H\u0002J\u0010\u00107\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u00108\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020*H\u0002J\u0018\u00109\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020*H\u0002J\u0018\u0010:\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020*H\u0002J\u0018\u0010;\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020=H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmBaseTypeOperatorTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "jsToKotlinAnyAdapter", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getJsToKotlinAnyAdapter", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "kotlinToJsAnyAdapter", "getKotlinToJsAnyAdapter", "unitGetInstance", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getUnitGetInstance", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "unitGetInstance$delegate", "Lkotlin/Lazy;", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitVariable", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "lowerInstanceOf", "inverted", "", "cacheValue", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBuilder;", "value", "isInlined", "Lorg/jetbrains/kotlin/ir/types/IrType;", "generateCCE", "valueProvider", "fromType", "toType", "generateTypeCheck", "lowerIntegerCoercion", "generateTypeCheckNonNull", "argument", "narrowType", "lowerCast", "isSafe", "shouldGenerateKotlinCast", "lowerImplicitCast", "generateTypeCheckWithTypeParameter", "generateIsInterface", "generateIsSubClass", "generateIsExternalClass", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmTypeOperatorLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmTypeOperatorLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmBaseTypeOperatorTransformer\n+ 2 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 3 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 6 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n*L\n1#1,433:1\n434#2,13:434\n434#2,13:449\n434#2,13:464\n434#2,13:479\n434#2,13:494\n133#3,2:447\n133#3,2:462\n133#3,2:477\n133#3,2:492\n133#3,2:507\n1849#4,3:509\n17#5,16:512\n33#5:529\n19#6:528\n*S KotlinDebug\n*F\n+ 1 WasmTypeOperatorLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmBaseTypeOperatorTransformer\n*L\n86#1:434,13\n199#1:449,13\n212#1:464,13\n283#1:479,13\n315#1:494,13\n86#1:447,2\n199#1:462,2\n212#1:477,2\n283#1:492,2\n315#1:507,2\n375#1:509,3\n99#1:512,16\n99#1:529\n99#1:528\n*E\n"})
public final class WasmBaseTypeOperatorTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final WasmSymbols symbols;
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final Lazy unitGetInstance$delegate;
    private DeclarationIrBuilder builder;

    public WasmBaseTypeOperatorTransformer(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.symbols = this.context.getWasmSymbols();
        this.builtIns = this.context.getIrBuiltIns();
        this.unitGetInstance$delegate = LazyKt.lazy(() -> WasmBaseTypeOperatorTransformer.unitGetInstance_delegate$lambda$0(this));
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    private final IrSimpleFunctionSymbol getJsToKotlinAnyAdapter() {
        return this.symbols.getJsRelatedSymbols().getJsInteropAdapters().getJsToKotlinAnyAdapter();
    }

    private final IrSimpleFunctionSymbol getKotlinToJsAnyAdapter() {
        return this.symbols.getJsRelatedSymbols().getJsInteropAdapters().getKotlinToJsAnyAdapter();
    }

    private final IrSimpleFunction getUnitGetInstance() {
        Lazy lazy = this.unitGetInstance$delegate;
        return (IrSimpleFunction)lazy.getValue();
    }

    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitTypeOperator(expression2);
        LoweringContext loweringContext = (LoweringContext)this.context;
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        this.builder = (DeclarationIrBuilder)LowerUtilsKt.at((IrBuilder)((IrBuilder)LowerUtilsKt.createIrBuilder$default((LoweringContext)loweringContext, (IrSymbol)scopeWithIr.getScope().getScopeOwnerSymbol(), (int)0, (int)0, (int)6, null)), (IrElement)((IrElement)expression2));
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
            case 1: {
                irExpression = this.lowerImplicitCast(expression2);
                break;
            }
            case 2: {
                throw new IllegalStateException("Dynamic casts are not supported in Wasm backend".toString());
            }
            case 3: {
                irExpression = (IrExpression)expression2;
                break;
            }
            case 4: {
                irExpression = this.lowerIntegerCoercion(expression2);
                break;
            }
            case 5: {
                irExpression = this.lowerImplicitCast(expression2);
                break;
            }
            case 6: {
                irExpression = this.lowerInstanceOf(expression2, false);
                break;
            }
            case 7: {
                irExpression = this.lowerInstanceOf(expression2, true);
                break;
            }
            case 8: {
                irExpression = this.lowerCast(expression2, false);
                break;
            }
            case 9: {
                irExpression = this.lowerCast(expression2, true);
                break;
            }
            case 10: {
                String string = "SAM conversion: " + RenderIrElementKt.render$default((IrElement)((IrElement)expression2), null, (int)1, null);
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            case 11: {
                irExpression = (IrExpression)expression2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return irExpression;
    }

    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrExpression initializer = declaration.getInitializer();
        if (initializer != null && !Intrinsics.areEqual((Object)initializer.getType(), (Object)declaration.getType())) {
            LoweringContext loweringContext = (LoweringContext)this.context;
            ScopeWithIr scopeWithIr = this.getCurrentScope();
            Intrinsics.checkNotNull((Object)scopeWithIr);
            this.builder = (DeclarationIrBuilder)LowerUtilsKt.at((IrBuilder)((IrBuilder)LowerUtilsKt.createIrBuilder$default((LoweringContext)loweringContext, (IrSymbol)scopeWithIr.getScope().getScopeOwnerSymbol(), (int)0, (int)0, (int)6, null)), (IrElement)((IrElement)declaration));
            declaration.setInitializer(this.narrowType(initializer.getType(), declaration.getType(), initializer));
        }
        return super.visitVariable(declaration);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression lowerInstanceOf(IrTypeOperatorCall expression2, boolean inverted) {
        void this_$iv$iv;
        void $this$irComposite_u24default$iv;
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        }
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)declarationIrBuilder;
        IrType resultType$iv = this.builtIns.getBooleanType();
        int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irComposite = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
        boolean $i$f$block = false;
        void $this$lowerInstanceOf_u24lambda_u240 = this_$iv$iv;
        boolean bl = false;
        Function0<IrExpression> argument = this.cacheValue((IrBlockBuilder)$this$lowerInstanceOf_u24lambda_u240, expression2.getArgument());
        IrExpression check2 = this.generateTypeCheck(argument, expression2.getTypeOperand());
        if (inverted) {
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder2 = null;
            }
            $this$lowerInstanceOf_u24lambda_u240.unaryPlus((IrStatement)LowerUtilsKt.irNot((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder2), (IrExpression)check2));
        } else {
            $this$lowerInstanceOf_u24lambda_u240.unaryPlus((IrStatement)check2);
        }
        return (IrExpression)this_$iv$iv.doBuild();
    }

    private final Function0<IrExpression> cacheValue(IrBlockBuilder $this$cacheValue, IrExpression value) {
        if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isPure$default((IrExpression)value, (boolean)true, (boolean)false, null, (int)6, null) && IrUtilsKt.isTrivial((IrExpression)value)) {
            return () -> WasmBaseTypeOperatorTransformer.cacheValue$lambda$0(value);
        }
        IrVariable tmpVal = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)((IrStatementsBuilder)$this$cacheValue), (IrExpression)value, null, (boolean)false, null, null, (int)30, null);
        return () -> WasmBaseTypeOperatorTransformer.cacheValue$lambda$1(this, tmpVal);
    }

    private final boolean isInlined(IrType $this$isInlined) {
        return this.context.getInlineClassesUtils().isTypeInlined($this$isInlined);
    }

    private final IrExpression generateCCE(Function0<? extends IrExpression> valueProvider, IrType fromType, IrType toType) {
        IrCall irCall;
        IrCall irCall2;
        IrClass klass = IrTypeErasureUtilsKt.getErasedUpperBound((IrType)toType);
        if (IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)((IrPossiblyExternalDeclaration)klass)) && IrUtilsKt.isInterface((IrClass)klass)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            return (IrExpression)ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)declarationIrBuilder), (IrSimpleFunctionSymbol)this.context.getSymbols().getThrowTypeCastException());
        }
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        }
        IrCall getKClassCall = irCall2 = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)declarationIrBuilder), (IrSimpleFunctionSymbol)this.context.getReflectionSymbols().getGetKClass());
        boolean bl = false;
        getKClassCall.getTypeArguments().set(0, IrUtilsKt.getDefaultType((IrClass)klass));
        IrCall kClass = irCall2;
        IrExpression value = this.narrowType(fromType, this.context.getIrBuiltIns().getAnyNType(), (IrExpression)valueProvider.invoke());
        DeclarationIrBuilder declarationIrBuilder2 = this.builder;
        if (declarationIrBuilder2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder2 = null;
        }
        IrCall cceCall = irCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)declarationIrBuilder2), (IrSimpleFunctionSymbol)this.context.getSymbols().getThrowTypeCastWithInfoException());
        boolean bl2 = false;
        cceCall.getArguments().set(0, (Object)value);
        cceCall.getArguments().set(1, (Object)kClass);
        IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = cceCall.getArguments();
        DeclarationIrBuilder declarationIrBuilder3 = this.builder;
        if (declarationIrBuilder3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder3 = null;
        }
        valueArgumentsList.set(2, (Object)ExpressionHelpersKt.irBoolean((IrBuilder)((IrBuilder)declarationIrBuilder3), (boolean)IrTypeUtilsKt.isNullable((IrType)toType)));
        return (IrExpression)irCall;
    }

    private final IrExpression generateTypeCheck(Function0<? extends IrExpression> valueProvider, IrType toType) {
        IrExpression irExpression;
        if (Intrinsics.areEqual((Object)toType, (Object)this.context.getIrBuiltIns().getNothingType())) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            return (IrExpression)ExpressionHelpersKt.irFalse((IrBuilder)((IrBuilder)declarationIrBuilder));
        }
        IrType toNotNullable = IrTypesKt.makeNotNull((IrType)toType);
        IrExpression valueInstance = (IrExpression)valueProvider.invoke();
        IrType fromType = valueInstance.getType();
        if (this.isInlined(fromType)) {
            boolean result = IrUtilsKt.isSubclassOf((IrClass)IrTypeErasureUtilsKt.getErasedUpperBound((IrType)fromType), (IrClass)IrTypeErasureUtilsKt.getErasedUpperBound((IrType)toType));
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            return (IrExpression)ExpressionHelpersKt.irBoolean((IrBuilder)((IrBuilder)declarationIrBuilder), (boolean)result);
        }
        IrExpression instanceCheck = this.generateTypeCheckNonNull(valueInstance, toNotNullable);
        boolean isFromNullable = IrTypeUtilsKt.isNullable((IrType)valueInstance.getType());
        boolean isToNullable = IrTypeUtilsKt.isNullable((IrType)toType);
        if (!isFromNullable) {
            irExpression = instanceCheck;
        } else {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrBuilder irBuilder = (IrBuilder)declarationIrBuilder;
            IrType irType = this.builtIns.getBooleanType();
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder2 = null;
            }
            IrExpression irExpression2 = ExpressionHelpersKt.irEqualsNull((IrBuilder)((IrBuilder)declarationIrBuilder2), (IrExpression)((IrExpression)valueProvider.invoke()));
            DeclarationIrBuilder declarationIrBuilder3 = this.builder;
            if (declarationIrBuilder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder3 = null;
            }
            irExpression = (IrExpression)ExpressionHelpersKt.irIfThenElse$default((IrBuilder)irBuilder, (IrType)irType, (IrExpression)irExpression2, (IrExpression)((IrExpression)ExpressionHelpersKt.irBoolean((IrBuilder)((IrBuilder)declarationIrBuilder3), (boolean)isToNullable)), (IrExpression)instanceCheck, null, (int)16, null);
        }
        return irExpression;
    }

    private final IrExpression lowerIntegerCoercion(IrTypeOperatorCall expression2) {
        IrExpression irExpression;
        IrType irType = expression2.getTypeOperand();
        if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getByteType()) || Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getShortType())) {
            irExpression = expression2.getArgument();
        } else if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getLongType())) {
            IrCall irCall;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrCall $this$lowerIntegerCoercion_u24lambda_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)declarationIrBuilder), (IrSimpleFunctionSymbol)this.symbols.getIntToLong());
            boolean bl = false;
            $this$lowerIntegerCoercion_u24lambda_u240.getArguments().set(0, (Object)expression2.getArgument());
            irExpression = (IrExpression)irCall;
        } else {
            throw new IllegalStateException("Unreachable execution (coercion to non-Integer type".toString());
        }
        return irExpression;
    }

    private final IrExpression generateTypeCheckNonNull(IrExpression argument, IrType toType) {
        IrExpression irExpression;
        boolean bl;
        boolean bl2 = bl = !IrTypePredicatesKt.isMarkedNullable((IrType)toType);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        IrClass classOrInterface = IrTypeErasureUtilsKt.getErasedUpperBound((IrType)toType);
        if (classOrInterface.isExternal()) {
            if (classOrInterface.getKind() == ClassKind.INTERFACE) {
                DeclarationIrBuilder declarationIrBuilder = this.builder;
                if (declarationIrBuilder == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    declarationIrBuilder = null;
                }
                irExpression = (IrExpression)ExpressionHelpersKt.irTrue((IrBuilder)((IrBuilder)declarationIrBuilder));
            } else {
                irExpression = this.generateIsExternalClass(argument, classOrInterface);
            }
        } else if (IrTypePredicatesKt.isNothing((IrType)toType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            irExpression = (IrExpression)ExpressionHelpersKt.irFalse((IrBuilder)((IrBuilder)declarationIrBuilder));
        } else {
            irExpression = IrTypeUtilsKt.isTypeParameter((IrType)toType) ? this.generateTypeCheckWithTypeParameter(argument, toType) : (IrTypeUtilsKt.isInterface((IrType)toType) ? this.generateIsInterface(argument, toType) : this.generateIsSubClass(argument, toType));
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression narrowType(IrType fromType, IrType toType, IrExpression value) {
        IrCall irCall;
        if (Intrinsics.areEqual((Object)fromType, (Object)toType)) {
            return value;
        }
        if (Intrinsics.areEqual((Object)toType, (Object)this.builtIns.getNothingNType())) {
            void this_$iv$iv;
            void $this$irComposite_u24default$iv;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)declarationIrBuilder;
            IrType resultType$iv = this.builtIns.getNothingNType();
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            void $this$narrowType_u24lambda_u240 = this_$iv$iv;
            boolean bl = false;
            $this$narrowType_u24lambda_u240.unaryPlus((IrStatement)value);
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder2 = null;
            }
            $this$narrowType_u24lambda_u240.unaryPlus((IrStatement)ExpressionHelpersKt.irNull((IrBuilder)((IrBuilder)declarationIrBuilder2)));
            return (IrExpression)this_$iv$iv.doBuild();
        }
        if (IrTypePredicatesKt.isUnit((IrType)toType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrBuilderWithScope $this$irComposite_u24default$iv = (IrBuilderWithScope)declarationIrBuilder;
            IrType resultType$iv = this.builtIns.getUnitType();
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            IrBlockBuilder $this$narrowType_u24lambda_u241 = this_$iv$iv;
            boolean bl = false;
            $this$narrowType_u24lambda_u241.unaryPlus((IrStatement)value);
            DeclarationIrBuilder declarationIrBuilder3 = this.builder;
            if (declarationIrBuilder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder3 = null;
            }
            $this$narrowType_u24lambda_u241.unaryPlus((IrStatement)ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)declarationIrBuilder3), (IrFunction)((IrFunction)this.getUnitGetInstance())));
            return (IrExpression)this_$iv$iv.doBuild();
        }
        if (Intrinsics.areEqual((Object)toType, (Object)this.builtIns.getAnyNType()) && Intrinsics.areEqual((Object)fromType, (Object)this.builtIns.getNothingNType()) && value instanceof IrConst && Intrinsics.areEqual((Object)((IrConst)value).getKind(), (Object)IrConstKind.Null.INSTANCE)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            return (IrExpression)ExpressionHelpersKt.irNull((IrBuilder)((IrBuilder)declarationIrBuilder), (IrType)this.builtIns.getNothingNType());
        }
        if (this.isInlined(toType) && !this.isInlined(fromType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrType[] $this$irComposite_u24default$iv = new IrType[]{fromType, toType};
            IrType[] it = $this$irComposite_u24default$iv = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)declarationIrBuilder), (IrFunctionSymbol)((IrFunctionSymbol)this.symbols.getUnboxIntrinsic()), (IrType)toType, (List)CollectionsKt.listOf((Object[])$this$irComposite_u24default$iv));
            boolean bl = false;
            it.getArguments().set(0, (Object)value);
            return (IrExpression)$this$irComposite_u24default$iv;
        }
        if (!this.isInlined(toType) && this.isInlined(fromType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrType[] $this$irComposite_u24default$iv = new IrType[]{fromType, toType};
            IrType[] it = $this$irComposite_u24default$iv = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)declarationIrBuilder), (IrFunctionSymbol)((IrFunctionSymbol)this.symbols.getBoxIntrinsic()), (IrType)toType, (List)CollectionsKt.listOf((Object[])$this$irComposite_u24default$iv));
            boolean bl = false;
            it.getArguments().set(0, (Object)value);
            return (IrExpression)$this$irComposite_u24default$iv;
        }
        IrClass fromClass = IrTypeErasureUtilsKt.getErasedUpperBound((IrType)fromType);
        IrClass toClass = IrTypeErasureUtilsKt.getErasedUpperBound((IrType)toType);
        if (fromClass.isExternal() && toClass.isExternal()) {
            return value;
        }
        if (IrUtilsKt.isNullConst((IrExpression)value) && fromClass.isExternal() != toClass.isExternal()) {
            value.setType(toType);
            return value;
        }
        if (fromClass.isExternal() && !toClass.isExternal()) {
            IrCall origin$iv;
            if (!this.context.isWasmJsTarget()) {
                String bl = "Implement externalize adapter for wasi mode";
                throw new NotImplementedError("An operation is not implemented: " + bl);
            }
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrCall it = origin$iv = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)declarationIrBuilder), (IrSimpleFunctionSymbol)this.getJsToKotlinAnyAdapter());
            boolean bl = false;
            it.getArguments().set(0, (Object)value);
            IrCall narrowingToAny2 = origin$iv;
            return this.narrowType(this.context.getIrBuiltIns().getAnyType(), toType, (IrExpression)narrowingToAny2);
        }
        if (toClass.isExternal() && !fromClass.isExternal()) {
            IrCall narrowingToAny2;
            if (!this.context.isWasmJsTarget()) {
                String narrowingToAny2 = "Implement internalize adapter for wasi mode";
                throw new NotImplementedError("An operation is not implemented: " + narrowingToAny2);
            }
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrCall it = narrowingToAny2 = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)declarationIrBuilder), (IrSimpleFunctionSymbol)this.getKotlinToJsAnyAdapter());
            boolean bl = false;
            it.getArguments().set(0, (Object)value);
            return (IrExpression)narrowingToAny2;
        }
        if (IrUtilsKt.isSubclassOf((IrClass)fromClass, (IrClass)toClass)) {
            return value;
        }
        if (IrTypePredicatesKt.isNothing((IrType)toType)) {
            void this_$iv$iv;
            void $this$irComposite_u24default$iv;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrBuilderWithScope narrowingToAny2 = (IrBuilderWithScope)declarationIrBuilder;
            IrType resultType$iv = this.context.getIrBuiltIns().getNothingType();
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder $this$narrowType_u24lambda_u241 = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            void $this$narrowType_u24lambda_u246 = this_$iv$iv;
            boolean bl = false;
            $this$narrowType_u24lambda_u246.unaryPlus((IrStatement)value);
            $this$narrowType_u24lambda_u246.unaryPlus((IrStatement)ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$narrowType_u24lambda_u246), (IrSimpleFunctionSymbol)this.symbols.getWasmUnreachable()));
            return (IrExpression)this_$iv$iv.doBuild();
        }
        if (Intrinsics.areEqual((Object)toType, (Object)this.symbols.getVoidType())) {
            IrCall irCall2;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrCall $this$narrowType_u24lambda_u247 = irCall2 = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)declarationIrBuilder), (IrSimpleFunctionSymbol)this.symbols.findVoidConsumer(value.getType()));
            boolean bl = false;
            $this$narrowType_u24lambda_u247.getArguments().set(0, (Object)value);
            return (IrExpression)irCall2;
        }
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        }
        IrCall $this$narrowType_u24lambda_u248 = irCall = ExpressionHelpersKt.irCall$default((IrBuilder)((IrBuilder)declarationIrBuilder), (IrSimpleFunctionSymbol)this.symbols.getRefCastNull(), (IrType)toType, (int)0, null, (int)12, null);
        boolean bl = false;
        $this$narrowType_u24lambda_u248.getTypeArguments().set(0, toType);
        $this$narrowType_u24lambda_u248.getArguments().set(0, (Object)value);
        return (IrExpression)irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression lowerCast(IrTypeOperatorCall expression2, boolean isSafe) {
        void this_$iv$iv;
        void $this$irComposite_u24default$iv;
        IrType toType = expression2.getTypeOperand();
        IrType fromType = expression2.getArgument().getType();
        IrType expressionType = expression2.getType();
        if (!Intrinsics.areEqual((Object)toType, (Object)this.context.getIrBuiltIns().getNothingType()) && IrUtilsKt.isSubclassOf((IrClass)IrTypeErasureUtilsKt.getErasedUpperBound((IrType)fromType), (IrClass)IrTypeErasureUtilsKt.getErasedUpperBound((IrType)expressionType))) {
            return this.narrowType(fromType, expressionType, expression2.getArgument());
        }
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        }
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)declarationIrBuilder;
        IrType resultType$iv = expressionType;
        int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irComposite = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
        boolean $i$f$block = false;
        void $this$lowerCast_u24lambda_u240 = this_$iv$iv;
        boolean bl = false;
        Function0<IrExpression> argument = this.cacheValue((IrBlockBuilder)$this$lowerCast_u24lambda_u240, expression2.getArgument());
        IrExpression check2 = this.generateTypeCheck(argument, toType);
        if (check2 instanceof IrConst) {
            Object object = ((IrConst)check2).getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            boolean value = (Boolean)object;
            if (value) {
                $this$lowerCast_u24lambda_u240.unaryPlus((IrStatement)this.narrowType(fromType, expressionType, (IrExpression)argument.invoke()));
            } else {
                IrExpression irExpression;
                if (!isSafe) {
                    irExpression = this.generateCCE(argument, fromType, toType);
                } else {
                    DeclarationIrBuilder declarationIrBuilder2 = this.builder;
                    if (declarationIrBuilder2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                        declarationIrBuilder2 = null;
                    }
                    irExpression = (IrExpression)ExpressionHelpersKt.irNull((IrBuilder)((IrBuilder)declarationIrBuilder2));
                }
                IrExpression cceOrNull = irExpression;
                $this$lowerCast_u24lambda_u240.unaryPlus((IrStatement)cceOrNull);
            }
        } else {
            IrExpression irExpression;
            DeclarationIrBuilder declarationIrBuilder3 = this.builder;
            if (declarationIrBuilder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder3 = null;
            }
            IrBuilder irBuilder = (IrBuilder)declarationIrBuilder3;
            IrExpression irExpression2 = this.narrowType(fromType, expressionType, (IrExpression)argument.invoke());
            if (!isSafe) {
                irExpression = this.generateCCE(argument, fromType, toType);
            } else {
                DeclarationIrBuilder declarationIrBuilder4 = this.builder;
                if (declarationIrBuilder4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    declarationIrBuilder4 = null;
                }
                irExpression = (IrExpression)ExpressionHelpersKt.irNull((IrBuilder)((IrBuilder)declarationIrBuilder4));
            }
            $this$lowerCast_u24lambda_u240.unaryPlus((IrStatement)ExpressionHelpersKt.irIfThenElse$default((IrBuilder)irBuilder, (IrType)expressionType, (IrExpression)check2, (IrExpression)irExpression2, (IrExpression)irExpression, null, (int)16, null));
        }
        return (IrExpression)this_$iv$iv.doBuild();
    }

    private final boolean shouldGenerateKotlinCast(IrExpression expression2, IrType toType) {
        IrType irType;
        if (IrTypePredicatesKt.isNullableAny((IrType)toType)) {
            return false;
        }
        if (IrTypeUtilsKt.isTypeParameter((IrType)toType)) {
            return false;
        }
        IrExpression irExpression = expression2;
        if (irExpression instanceof IrCall) {
            IrSimpleFunction function2 = (IrSimpleFunction)((IrCall)expression2).getSymbol().getOwner();
            IrPackageFragment packageFragment = IrUtilsKt.getPackageFragment((IrDeclaration)((IrDeclaration)function2));
            if (Intrinsics.areEqual((Object)this.context.getExcludedPackageFragment(packageFragment.getPackageFqName()), (Object)packageFragment)) {
                return false;
            }
            irType = function2.getReturnType();
        } else {
            irType = irExpression instanceof IrGetField ? ((IrField)((IrGetField)expression2).getSymbol().getOwner()).getType() : expression2.getType();
        }
        IrType argumentType = irType;
        return IrTypeUtilsKt.isTypeParameter((IrType)argumentType);
    }

    private final IrExpression lowerImplicitCast(IrTypeOperatorCall expression2) {
        return this.shouldGenerateKotlinCast(expression2.getArgument(), expression2.getTypeOperand()) ? this.lowerCast(expression2, false) : this.narrowType(expression2.getArgument().getType(), expression2.getTypeOperand(), expression2.getArgument());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateTypeCheckWithTypeParameter(IrExpression argument, IrType toType) {
        void $this$fold$iv;
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull((IrType)toType);
        IrSymbolOwner irSymbolOwner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
        IrTypeParameter irTypeParameter = irSymbolOwner instanceof IrTypeParameter ? (IrTypeParameter)irSymbolOwner : null;
        if (irTypeParameter == null) {
            throw new IllegalStateException(("expected type parameter, but got " + toType).toString());
        }
        IrTypeParameter typeParameter = irTypeParameter;
        Iterable iterable = typeParameter.getSuperTypes();
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        }
        IrConstImpl irConstImpl = ExpressionHelpersKt.irTrue((IrBuilder)((IrBuilder)declarationIrBuilder));
        Intrinsics.checkNotNull((Object)irConstImpl, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
        IrExpression initial$iv = (IrExpression)irConstImpl;
        boolean $i$f$fold = false;
        IrExpression accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            IrCall irCall;
            void t;
            IrType irType = (IrType)element$iv;
            IrExpression r = accumulator$iv;
            boolean bl = false;
            IrExpression check2 = this.generateTypeCheckNonNull(IrUtilsKt.shallowCopy((IrExpression)argument), IrTypesKt.makeNotNull((IrType)t));
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder2 = null;
            }
            IrCall $this$generateTypeCheckWithTypeParameter_u24lambda_u240_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)declarationIrBuilder2), (IrSimpleFunctionSymbol)this.symbols.getBooleanAnd());
            boolean bl2 = false;
            $this$generateTypeCheckWithTypeParameter_u24lambda_u240_u240.getArguments().set(0, (Object)r);
            $this$generateTypeCheckWithTypeParameter_u24lambda_u240_u240.getArguments().set(1, (Object)check2);
            accumulator$iv = (IrExpression)irCall;
        }
        return accumulator$iv;
    }

    private final IrExpression generateIsInterface(IrExpression argument, IrType toType) {
        IrCall irCall;
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        }
        IrCall $this$generateIsInterface_u24lambda_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)declarationIrBuilder), (IrSimpleFunctionSymbol)this.symbols.getWasmIsInterface());
        boolean bl = false;
        $this$generateIsInterface_u24lambda_u240.getArguments().set(0, (Object)argument);
        $this$generateIsInterface_u24lambda_u240.getTypeArguments().set(0, toType);
        return (IrExpression)irCall;
    }

    private final IrExpression generateIsSubClass(IrExpression argument, IrType toType) {
        IrCall irCall;
        IrClass toTypeErased;
        if (IrTypePredicatesKt.isAny((IrType)toType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            return (IrExpression)ExpressionHelpersKt.irTrue((IrBuilder)((IrBuilder)declarationIrBuilder));
        }
        if (IrTypePredicatesKt.isNothing((IrType)toType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            return (IrExpression)ExpressionHelpersKt.irFalse((IrBuilder)((IrBuilder)declarationIrBuilder));
        }
        IrType fromType = argument.getType();
        if (TypeTransformerKt.isExternalType(fromType) != TypeTransformerKt.isExternalType(toType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            return (IrExpression)ExpressionHelpersKt.irFalse((IrBuilder)((IrBuilder)declarationIrBuilder));
        }
        IrClass fromTypeErased = TypeTransformerKt.getRuntimeClass(fromType, this.context.getIrBuiltIns());
        if (IrUtilsKt.isSubclassOf((IrClass)fromTypeErased, (IrClass)(toTypeErased = TypeTransformerKt.getRuntimeClass(toType, this.context.getIrBuiltIns())))) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            return (IrExpression)ExpressionHelpersKt.irTrue((IrBuilder)((IrBuilder)declarationIrBuilder));
        }
        if (!IrUtilsKt.isSubclassOf((IrClass)toTypeErased, (IrClass)fromTypeErased)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            return (IrExpression)ExpressionHelpersKt.irFalse((IrBuilder)((IrBuilder)declarationIrBuilder));
        }
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        }
        IrCall $this$generateIsSubClass_u24lambda_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)declarationIrBuilder), (IrSimpleFunctionSymbol)this.symbols.getRefTest());
        boolean bl = false;
        $this$generateIsSubClass_u24lambda_u240.getArguments().set(0, (Object)argument);
        $this$generateIsSubClass_u24lambda_u240.getTypeArguments().set(0, toType);
        return (IrExpression)irCall;
    }

    private final IrExpression generateIsExternalClass(IrExpression argument, IrClass klass) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrSimpleFunction irSimpleFunction = WasmIrAttributesKt.getInstanceCheckForExternalClass(klass);
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        IrSimpleFunction instanceCheckFunction = irSimpleFunction;
        if (TypeTransformerKt.isExternalType(argument.getType()) && WasmIrAttributesKt.getJsFunctionForExternalAdapterFunction((IrFunction)instanceCheckFunction) != null) {
            IrFunctionAccessExpression irFunctionAccessExpression2;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrBuilder irBuilder = (IrBuilder)declarationIrBuilder;
            IrSimpleFunction irSimpleFunction2 = WasmIrAttributesKt.getJsFunctionForExternalAdapterFunction((IrFunction)instanceCheckFunction);
            Intrinsics.checkNotNull((Object)irSimpleFunction2);
            IrFunctionAccessExpression it = irFunctionAccessExpression2 = ExpressionHelpersKt.irCall((IrBuilder)irBuilder, (IrFunction)((IrFunction)irSimpleFunction2));
            boolean bl = false;
            it.getArguments().set(0, (Object)argument);
            return (IrExpression)irFunctionAccessExpression2;
        }
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        }
        IrFunctionAccessExpression it = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)declarationIrBuilder), (IrFunction)((IrFunction)instanceCheckFunction));
        boolean bl = false;
        it.getArguments().set(0, (Object)this.narrowType(argument.getType(), this.context.getIrBuiltIns().getAnyType(), argument));
        return (IrExpression)irFunctionAccessExpression;
    }

    private static final IrSimpleFunction unitGetInstance_delegate$lambda$0(WasmBaseTypeOperatorTransformer this$0) {
        return MiscKt.findUnitGetInstanceFunction(this$0.context);
    }

    private static final IrExpression cacheValue$lambda$0(IrExpression $value) {
        IrElement $this$deepCopyWithSymbols_u24default$iv = (IrElement)$value;
        IrDeclarationParent initialParent$iv = null;
        boolean $i$f$deepCopyWithSymbols = false;
        IrElement $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
        boolean $i$f$deepCopyImpl = false;
        DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
        IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyImpl$iv$iv, (IrVisitorVoid)((IrVisitorVoid)symbolRemapper$iv$iv));
        DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
        boolean bl = false;
        ReferencedSymbolRemapper p0 = (ReferencedSymbolRemapper)deepCopySymbolRemapper;
        TypeRemapper typeRemapper$iv$iv = (TypeRemapper)new DeepCopyTypeRemapper(p0);
        IrElement irElement = $this$deepCopyImpl$iv$iv.transform((IrTransformer)new DeepCopyIrTreeWithSymbols((SymbolRemapper)symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
        if (irElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
        }
        return (IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrElement)((IrExpression)irElement)), initialParent$iv);
    }

    private static final IrExpression cacheValue$lambda$1(WasmBaseTypeOperatorTransformer this$0, IrVariable $tmpVal) {
        DeclarationIrBuilder declarationIrBuilder = this$0.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        }
        return (IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)declarationIrBuilder), (IrValueDeclaration)((IrValueDeclaration)$tmpVal));
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.IMPLICIT_CAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_DYNAMIC_CAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_INTEGER_COERCION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.CAST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAM_CONVERSION.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.REINTERPRET_CAST.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

