/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.java.codeserver.core.JavaPsiEnumUtil;
import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.MethodChecker;
import com.intellij.java.codeserver.highlighting.errors.JavaCompilationError;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.java.codeserver.highlighting.errors.JavaIncompatibleTypeErrorContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.IncompleteModelUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GenericsChecker {
    @NotNull
    private final JavaErrorVisitor myVisitor;
    private final Set<PsiClass> myOverrideEquivalentMethodsVisitedClasses;
    private final Map<PsiMember, JavaCompilationError<PsiMember, ?>> myOverrideEquivalentMethodsErrors;

    GenericsChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            GenericsChecker.$$$reportNull$$$0(0);
        }
        this.myOverrideEquivalentMethodsVisitedClasses = new HashSet<PsiClass>();
        this.myOverrideEquivalentMethodsErrors = new HashMap();
        this.myVisitor = visitor;
    }

    void checkElementInTypeParameterExtendsList(@NotNull PsiReferenceList referenceList, @NotNull PsiTypeParameter typeParameter, @NotNull JavaResolveResult resolveResult, @NotNull PsiJavaCodeReferenceElement element) {
        if (referenceList == null) {
            GenericsChecker.$$$reportNull$$$0(1);
        }
        if (typeParameter == null) {
            GenericsChecker.$$$reportNull$$$0(2);
        }
        if (resolveResult == null) {
            GenericsChecker.$$$reportNull$$$0(3);
        }
        if (element == null) {
            GenericsChecker.$$$reportNull$$$0(4);
        }
        PsiJavaCodeReferenceElement[] referenceElements = referenceList.getReferenceElements();
        PsiClass extendFrom = (PsiClass)resolveResult.getElement();
        if (extendFrom == null) {
            return;
        }
        if (!extendFrom.isInterface() && referenceElements.length != 0 && element != referenceElements[0]) {
            this.myVisitor.report(JavaErrorKinds.TYPE_PARAMETER_EXTENDS_INTERFACE_EXPECTED.create(element, typeParameter));
        } else if (referenceElements.length != 0 && element != referenceElements[0] && referenceElements[0].resolve() instanceof PsiTypeParameter) {
            this.myVisitor.report(JavaErrorKinds.TYPE_PARAMETER_CANNOT_BE_FOLLOWED_BY_OTHER_BOUNDS.create(element, typeParameter));
        }
    }

    void checkCannotInheritFromTypeParameter(@Nullable PsiClass superClass, @NotNull PsiJavaCodeReferenceElement toHighlight) {
        if (toHighlight == null) {
            GenericsChecker.$$$reportNull$$$0(5);
        }
        if (superClass instanceof PsiTypeParameter) {
            this.myVisitor.report(JavaErrorKinds.CLASS_INHERITS_TYPE_PARAMETER.create(toHighlight, superClass));
        }
    }

    void checkTypeParametersList(@NotNull PsiTypeParameterList list, PsiTypeParameter @NotNull [] parameters) {
        PsiClass psiClass;
        PsiElement parent;
        if (list == null) {
            GenericsChecker.$$$reportNull$$$0(6);
        }
        if (parameters == null) {
            GenericsChecker.$$$reportNull$$$0(7);
        }
        if ((parent = list.getParent()) instanceof PsiClass && (psiClass = (PsiClass)parent).isEnum()) {
            this.myVisitor.report(JavaErrorKinds.TYPE_PARAMETER_ON_ENUM.create(list));
            return;
        }
        if (PsiUtil.isAnnotationMethod((PsiElement)parent)) {
            this.myVisitor.report(JavaErrorKinds.TYPE_PARAMETER_ON_ANNOTATION_MEMBER.create(list));
            return;
        }
        if (parent instanceof PsiClass && (psiClass = (PsiClass)parent).isAnnotationType()) {
            this.myVisitor.report(JavaErrorKinds.TYPE_PARAMETER_ON_ANNOTATION.create(list));
            return;
        }
        for (int i = 0; i < parameters.length; ++i) {
            PsiTypeParameter typeParameter1 = parameters[i];
            this.myVisitor.myClassChecker.checkCyclicInheritance((PsiClass)typeParameter1);
            if (this.myVisitor.hasErrorResults()) {
                return;
            }
            String name1 = typeParameter1.getName();
            for (int j = i + 1; j < parameters.length; ++j) {
                PsiTypeParameter typeParameter2 = parameters[j];
                String name2 = typeParameter2.getName();
                if (!Objects.equals(name1, name2)) continue;
                this.myVisitor.report(JavaErrorKinds.TYPE_PARAMETER_DUPLICATE.create(typeParameter2));
            }
        }
    }

    void checkForEachParameterType(@NotNull PsiForeachStatement statement, @NotNull PsiParameter parameter) {
        PsiExpression expression;
        PsiType itemType;
        if (statement == null) {
            GenericsChecker.$$$reportNull$$$0(8);
        }
        if (parameter == null) {
            GenericsChecker.$$$reportNull$$$0(9);
        }
        PsiType psiType = itemType = (expression = statement.getIteratedValue()) == null ? null : JavaGenericsUtil.getCollectionItemType((PsiExpression)expression);
        if (itemType == null) {
            return;
        }
        PsiType parameterType = parameter.getType();
        if (TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)itemType)) {
            return;
        }
        if (this.myVisitor.isIncompleteModel() && IncompleteModelUtil.isPotentiallyConvertible((PsiType)parameterType, (PsiType)itemType, (PsiElement)expression)) {
            return;
        }
        this.myVisitor.reportIncompatibleType(itemType, parameterType, (PsiElement)parameter);
    }

    void checkDiamondTypeNotAllowed(@NotNull PsiNewExpression expression) {
        PsiReferenceParameterList typeArgumentList;
        PsiTypeElement[] typeParameterElements;
        if (expression == null) {
            GenericsChecker.$$$reportNull$$$0(10);
        }
        if ((typeParameterElements = (typeArgumentList = expression.getTypeArgumentList()).getTypeParameterElements()).length == 1 && typeParameterElements[0].getType() instanceof PsiDiamondType) {
            this.myVisitor.report(JavaErrorKinds.NEW_EXPRESSION_DIAMOND_NOT_ALLOWED.create(typeArgumentList));
        }
    }

    void checkSelectStaticClassFromParameterizedType(@Nullable PsiElement resolved, @NotNull PsiJavaCodeReferenceElement ref) {
        PsiJavaCodeReferenceElement referenceElement;
        PsiReferenceParameterList parameterList;
        PsiElement qualifier;
        PsiClass psiClass;
        if (ref == null) {
            GenericsChecker.$$$reportNull$$$0(11);
        }
        if (resolved instanceof PsiClass && (psiClass = (PsiClass)resolved).hasModifierProperty("static") && (qualifier = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement && (parameterList = (referenceElement = (PsiJavaCodeReferenceElement)qualifier).getParameterList()) != null && parameterList.getTypeArguments().length > 0) {
            this.myVisitor.report(JavaErrorKinds.REFERENCE_TYPE_ARGUMENT_STATIC_CLASS.create(parameterList, psiClass));
        }
    }

    void checkRawOnParameterizedType(@NotNull PsiJavaCodeReferenceElement parent, @Nullable PsiElement resolved) {
        PsiTypeParameterListOwner typeParameterListOwner;
        PsiJavaCodeReferenceElement ref;
        PsiReferenceParameterList list;
        if (parent == null) {
            GenericsChecker.$$$reportNull$$$0(12);
        }
        if ((list = parent.getParameterList()) == null || list.getTypeArguments().length > 0) {
            return;
        }
        PsiElement psiElement = parent.getQualifier();
        if (psiElement instanceof PsiJavaCodeReferenceElement && (ref = (PsiJavaCodeReferenceElement)psiElement).getTypeParameters().length > 0 && resolved instanceof PsiTypeParameterListOwner && (typeParameterListOwner = (PsiTypeParameterListOwner)resolved).hasTypeParameters() && !typeParameterListOwner.hasModifierProperty("static") && parent.getReferenceNameElement() != null) {
            this.myVisitor.report(JavaErrorKinds.REFERENCE_TYPE_NEEDS_TYPE_ARGUMENTS.create(parent));
        }
    }

    void checkInterfaceMultipleInheritance(@NotNull PsiClass aClass) {
        PsiClassType[] types;
        if (aClass == null) {
            GenericsChecker.$$$reportNull$$$0(13);
        }
        if ((types = aClass.getSuperTypes()).length < 2) {
            return;
        }
        this.checkInterfaceMultipleInheritance(aClass, aClass, PsiSubstitutor.EMPTY, new HashMap<PsiClass, PsiSubstitutor>(), new HashSet());
    }

    private void checkInterfaceMultipleInheritance(@NotNull PsiClass aClass, @NotNull PsiClass place, @NotNull PsiSubstitutor derivedSubstitutor, @NotNull Map<PsiClass, PsiSubstitutor> inheritedClasses, @NotNull Set<? super PsiClass> visited) {
        if (aClass == null) {
            GenericsChecker.$$$reportNull$$$0(14);
        }
        if (place == null) {
            GenericsChecker.$$$reportNull$$$0(15);
        }
        if (derivedSubstitutor == null) {
            GenericsChecker.$$$reportNull$$$0(16);
        }
        if (inheritedClasses == null) {
            GenericsChecker.$$$reportNull$$$0(17);
        }
        if (visited == null) {
            GenericsChecker.$$$reportNull$$$0(18);
        }
        List superTypes = PsiClassImplUtil.getScopeCorrectedSuperTypes((PsiClass)aClass, (GlobalSearchScope)place.getResolveScope());
        for (PsiClassType.ClassResolveResult result : superTypes) {
            PsiClass superClass = result.getElement();
            if (superClass == null || visited.contains(superClass)) continue;
            PsiSubstitutor superTypeSubstitutor = result.getSubstitutor();
            superTypeSubstitutor = PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)aClass, (PsiSubstitutor)derivedSubstitutor) ? this.myVisitor.factory().createRawSubstitutor((PsiTypeParameterListOwner)superClass) : MethodSignatureUtil.combineSubstitutors((PsiSubstitutor)superTypeSubstitutor, (PsiSubstitutor)derivedSubstitutor);
            PsiSubstitutor inheritedSubstitutor = inheritedClasses.get(superClass);
            if (inheritedSubstitutor != null) {
                PsiTypeParameter[] typeParameters;
                for (PsiTypeParameter typeParameter : typeParameters = superClass.getTypeParameters()) {
                    PsiType type2;
                    PsiType type1 = inheritedSubstitutor.substitute(typeParameter);
                    if (Comparing.equal((Object)type1, (Object)(type2 = superTypeSubstitutor.substitute(typeParameter)))) continue;
                    JavaErrorKinds.InheritTypeClashContext context = new JavaErrorKinds.InheritTypeClashContext(superClass, type1, type2);
                    if (type1 != null && type2 != null) {
                        this.myVisitor.report(JavaErrorKinds.CLASS_INHERITANCE_DIFFERENT_TYPE_ARGUMENTS.create(place, context));
                    } else {
                        this.myVisitor.report(JavaErrorKinds.CLASS_INHERITANCE_RAW_AND_GENERIC.create(place, context));
                    }
                    return;
                }
            }
            inheritedClasses.put(superClass, superTypeSubstitutor);
            visited.add((PsiClass)superClass);
            this.checkInterfaceMultipleInheritance(superClass, place, superTypeSubstitutor, inheritedClasses, visited);
            visited.remove(superClass);
            if (!this.myVisitor.hasErrorResults()) continue;
            return;
        }
    }

    void checkClassSupersAccessibility(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GenericsChecker.$$$reportNull$$$0(19);
        }
        this.checkClassSupersAccessibility((PsiElement)aClass, aClass, aClass.getResolveScope(), true);
    }

    void checkClassSupersAccessibility(@NotNull PsiClass aClass, @NotNull PsiElement ref, @NotNull GlobalSearchScope scope) {
        if (aClass == null) {
            GenericsChecker.$$$reportNull$$$0(20);
        }
        if (ref == null) {
            GenericsChecker.$$$reportNull$$$0(21);
        }
        if (scope == null) {
            GenericsChecker.$$$reportNull$$$0(22);
        }
        this.checkClassSupersAccessibility(ref, aClass, scope, false);
    }

    private void checkClassSupersAccessibility(@NotNull PsiElement anchor, @NotNull PsiClass aClass, @NotNull GlobalSearchScope resolveScope, boolean checkParameters) {
        if (anchor == null) {
            GenericsChecker.$$$reportNull$$$0(23);
        }
        if (aClass == null) {
            GenericsChecker.$$$reportNull$$$0(24);
        }
        if (resolveScope == null) {
            GenericsChecker.$$$reportNull$$$0(25);
        }
        JavaPsiFacade factory = JavaPsiFacade.getInstance((Project)this.myVisitor.project());
        for (PsiClassType superType : aClass.getSuperTypes()) {
            HashSet<PsiClass> checked = new HashSet<PsiClass>();
            checked.add(aClass);
            this.checkTypeAccessible(anchor, (PsiType)superType, checked, checkParameters, true, resolveScope, factory);
        }
    }

    private void checkTypeAccessible(@NotNull PsiElement anchor, @Nullable PsiType type, @NotNull Set<? super PsiClass> classes, boolean checkParameters, boolean checkSuperTypes, @NotNull GlobalSearchScope resolveScope, @NotNull JavaPsiFacade factory) {
        PsiClass aClass;
        if (anchor == null) {
            GenericsChecker.$$$reportNull$$$0(26);
        }
        if (classes == null) {
            GenericsChecker.$$$reportNull$$$0(27);
        }
        if (resolveScope == null) {
            GenericsChecker.$$$reportNull$$$0(28);
        }
        if (factory == null) {
            GenericsChecker.$$$reportNull$$$0(29);
        }
        if ((aClass = PsiUtil.resolveClassInType((PsiType)(type = PsiClassImplUtil.correctType((PsiType)type, (GlobalSearchScope)resolveScope)))) != null && classes.add((PsiClass)aClass)) {
            VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)aClass);
            if (vFile == null) {
                return;
            }
            FileIndexFacade index = FileIndexFacade.getInstance((Project)this.myVisitor.project());
            if (!index.isInSource(vFile) && !index.isInLibraryClasses(vFile)) {
                return;
            }
            PsiImplicitClass parentImplicitClass = (PsiImplicitClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiImplicitClass.class);
            String qualifiedName = aClass.getQualifiedName();
            if (parentImplicitClass == null && qualifiedName != null && factory.findClass(qualifiedName, resolveScope) == null) {
                this.myVisitor.report(JavaErrorKinds.CLASS_NOT_ACCESSIBLE.create(anchor, aClass));
                return;
            }
            if (!checkParameters) {
                return;
            }
            if (type instanceof PsiClassType) {
                PsiClassType classType = (PsiClassType)type;
                for (PsiType psiType : classType.getParameters()) {
                    this.checkTypeAccessible(anchor, psiType, classes, true, false, resolveScope, factory);
                    if (!this.myVisitor.hasErrorResults()) continue;
                    return;
                }
            }
            if (!checkSuperTypes) {
                return;
            }
            boolean isInLibrary = !index.isInContent(vFile);
            for (PsiType psiType : aClass.getSuperTypes()) {
                this.checkTypeAccessible(anchor, psiType, classes, !isInLibrary, true, resolveScope, factory);
                if (!this.myVisitor.hasErrorResults()) continue;
                return;
            }
        }
    }

    void checkInferredIntersections(@NotNull PsiSubstitutor substitutor, @NotNull PsiMethodCallExpression call) {
        if (substitutor == null) {
            GenericsChecker.$$$reportNull$$$0(30);
        }
        if (call == null) {
            GenericsChecker.$$$reportNull$$$0(31);
        }
        for (Map.Entry typeEntry : substitutor.getSubstitutionMap().entrySet()) {
            PsiIntersectionType intersectionType;
            String conflictingConjunctsMessage;
            Object v = typeEntry.getValue();
            if (!(v instanceof PsiIntersectionType) || (conflictingConjunctsMessage = (intersectionType = (PsiIntersectionType)v).getConflictingConjunctsMessage()) == null) continue;
            this.myVisitor.report(JavaErrorKinds.TYPE_PARAMETER_INCOMPATIBLE_UPPER_BOUNDS.create(call, new JavaErrorKinds.IncompatibleIntersectionContext((PsiTypeParameter)typeEntry.getKey(), conflictingConjunctsMessage)));
        }
    }

    void checkParameterizedReferenceTypeArguments(@Nullable PsiElement resolved, @NotNull PsiJavaCodeReferenceElement referenceElement, @NotNull PsiSubstitutor substitutor) {
        if (referenceElement == null) {
            GenericsChecker.$$$reportNull$$$0(32);
        }
        if (substitutor == null) {
            GenericsChecker.$$$reportNull$$$0(33);
        }
        if (!(resolved instanceof PsiTypeParameterListOwner)) {
            return;
        }
        PsiTypeParameterListOwner typeParameterListOwner = (PsiTypeParameterListOwner)resolved;
        this.checkReferenceTypeArgumentList(typeParameterListOwner, referenceElement.getParameterList(), substitutor);
    }

    /*
     * Unable to fully structure code
     */
    void checkReferenceTypeArgumentList(@NotNull PsiTypeParameterListOwner typeParameterListOwner, @Nullable PsiReferenceParameterList referenceParameterList, @NotNull PsiSubstitutor substitutor) {
        block19: {
            block17: {
                block18: {
                    if (typeParameterListOwner == null) {
                        GenericsChecker.$$$reportNull$$$0(34);
                    }
                    if (substitutor == null) {
                        GenericsChecker.$$$reportNull$$$0(35);
                    }
                    inferenceResult = null;
                    referenceElements = null;
                    if (referenceParameterList != null && (referenceElements = referenceParameterList.getTypeParameterElements()).length == 1 && (var7_6 = referenceElements[0].getType()) instanceof PsiDiamondType) {
                        diamondType = (PsiDiamondType)var7_6;
                        if (!typeParameterListOwner.hasTypeParameters()) {
                            this.myVisitor.report(JavaErrorKinds.NEW_EXPRESSION_DIAMOND_NOT_APPLICABLE.create(referenceParameterList));
                            return;
                        }
                        inferenceResult = diamondType.resolveInferredTypes();
                        errorMessage = inferenceResult.getErrorMessage();
                        if (errorMessage != null) {
                            expectedType = GenericsChecker.detectExpectedType(referenceParameterList);
                            if (!(inferenceResult.failedToInfer() && expectedType instanceof PsiClassType && (classType = (PsiClassType)expectedType).isRaw() || inferenceResult != PsiDiamondType.DiamondInferenceResult.ANONYMOUS_INNER_RESULT && inferenceResult != PsiDiamondType.DiamondInferenceResult.EXPLICIT_CONSTRUCTOR_TYPE_ARGS)) {
                                this.myVisitor.report(JavaErrorKinds.NEW_EXPRESSION_DIAMOND_INFERENCE_FAILURE.create(referenceParameterList, inferenceResult));
                                return;
                            }
                        }
                        if ((parent = referenceParameterList.getParent().getParent()) instanceof PsiAnonymousClass && ContainerUtil.exists((Object[])(anonymousClass = (PsiAnonymousClass)parent).getMethods(), (Condition)(Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkReferenceTypeArgumentList$0(com.intellij.psi.PsiMethod ), (Lcom/intellij/psi/PsiMethod;)Z)())) {
                            this.myVisitor.report(JavaErrorKinds.NEW_EXPRESSION_DIAMOND_ANONYMOUS_INNER_NON_PRIVATE.create(referenceParameterList));
                            return;
                        }
                    }
                    typeParameters = typeParameterListOwner.getTypeParameters();
                    targetParametersNum = typeParameters.length;
                    v0 = refParametersNum = referenceParameterList == null ? 0 : referenceParameterList.getTypeArguments().length;
                    if (targetParametersNum == refParametersNum || refParametersNum == 0) break block17;
                    if (targetParametersNum != 0) break block18;
                    if (PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiCall.class) == null || !(typeParameterListOwner instanceof PsiMethod)) ** GOTO lbl-1000
                    psiMethod = (PsiMethod)typeParameterListOwner;
                    if (this.myVisitor.sdkVersion().isAtLeast(JavaSdkVersion.JDK_1_7) || GenericsChecker.hasSuperMethodsWithTypeParams(psiMethod) || psiMethod.isDefaultConstructor()) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = shouldSuppress = false;
                    }
                    if (!shouldSuppress) {
                        if (typeParameterListOwner instanceof PsiMethod) {
                            psiMethod = (PsiMethod)typeParameterListOwner;
                            this.myVisitor.report(JavaErrorKinds.TYPE_PARAMETER_ABSENT_METHOD.create(referenceParameterList, psiMethod));
                        } else if (typeParameterListOwner instanceof PsiClass) {
                            psiClass = (PsiClass)typeParameterListOwner;
                            this.myVisitor.report(JavaErrorKinds.TYPE_PARAMETER_ABSENT_CLASS.create(referenceParameterList, psiClass));
                        }
                        return;
                    }
                    break block17;
                }
                this.myVisitor.report(JavaErrorKinds.TYPE_PARAMETER_COUNT_MISMATCH.create(referenceParameterList, typeParameterListOwner));
                return;
            }
            if (targetParametersNum <= 0 || refParametersNum == 0) break block19;
            if (inferenceResult != null) {
                types = inferenceResult.getTypes();
                for (i = 0; i < typeParameters.length; ++i) {
                    this.checkTypeParameterWithinItsBound(typeParameters[i], substitutor, types[i], referenceElements[0], referenceParameterList);
                    if (!this.myVisitor.hasErrorResults()) continue;
                    return;
                }
            } else {
                for (i = 0; i < typeParameters.length; ++i) {
                    typeElement = referenceElements[i];
                    this.checkTypeParameterWithinItsBound(typeParameters[i], substitutor, typeElement.getType(), typeElement, referenceParameterList);
                    if (!this.myVisitor.hasErrorResults()) continue;
                    return;
                }
            }
        }
    }

    private void checkTypeParameterWithinItsBound(@NotNull PsiTypeParameter classParameter, @NotNull PsiSubstitutor substitutor, @NotNull PsiType type, @NotNull PsiTypeElement typeElement2Highlight, @Nullable PsiReferenceParameterList referenceParameterList) {
        PsiClassType[] bounds;
        PsiClass psiClass;
        if (classParameter == null) {
            GenericsChecker.$$$reportNull$$$0(36);
        }
        if (substitutor == null) {
            GenericsChecker.$$$reportNull$$$0(37);
        }
        if (type == null) {
            GenericsChecker.$$$reportNull$$$0(38);
        }
        if (typeElement2Highlight == null) {
            GenericsChecker.$$$reportNull$$$0(39);
        }
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            psiClass = classType.resolve();
        } else {
            psiClass = null;
        }
        PsiClass referenceClass = psiClass;
        PsiType psiType = substitutor.substitute(classParameter);
        if (psiType instanceof PsiClassType && !(PsiUtil.resolveClassInType((PsiType)psiType) instanceof PsiTypeParameter) && GenericsUtil.checkNotInBounds((PsiType)type, (PsiType)psiType, (PsiReferenceParameterList)referenceParameterList)) {
            this.myVisitor.report(JavaErrorKinds.TYPE_PARAMETER_ACTUAL_INFERRED_MISMATCH.create(typeElement2Highlight));
            return;
        }
        for (PsiClassType bound : bounds = classParameter.getSuperTypes()) {
            PsiClass psiClass2;
            if ((bound = substitutor.substitute((PsiType)bound)).equalsToText("java.lang.Object") || !GenericsUtil.checkNotInBounds((PsiType)type, (PsiType)bound, (PsiReferenceParameterList)referenceParameterList)) continue;
            if (bound instanceof PsiClassType) {
                PsiClassType classType = bound;
                psiClass2 = classType.resolve();
            } else {
                psiClass2 = null;
            }
            PsiClass boundClass = psiClass2;
            boolean extend = boundClass == null || referenceClass == null || referenceClass.isInterface() == boundClass.isInterface() || referenceClass instanceof PsiTypeParameter;
            JavaErrorKind.Parameterized<PsiTypeElement, JavaErrorKinds.TypeParameterBoundMismatchContext> kind = extend ? JavaErrorKinds.TYPE_PARAMETER_TYPE_NOT_WITHIN_EXTEND_BOUND : JavaErrorKinds.TYPE_PARAMETER_TYPE_NOT_WITHIN_IMPLEMENT_BOUND;
            this.myVisitor.report(kind.create(typeElement2Highlight, new JavaErrorKinds.TypeParameterBoundMismatchContext(classParameter, (PsiType)bound, type)));
        }
    }

    void checkCatchParameterIsClass(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            GenericsChecker.$$$reportNull$$$0(40);
        }
        if (!(parameter.getDeclarationScope() instanceof PsiCatchSection)) {
            return;
        }
        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter);
        for (PsiTypeElement typeElement : typeElements) {
            if (!(PsiUtil.resolveClassInClassTypeOnly((PsiType)typeElement.getType()) instanceof PsiTypeParameter)) continue;
            this.myVisitor.report(JavaErrorKinds.CATCH_TYPE_PARAMETER.create(typeElement));
        }
    }

    void checkReferenceTypeUsedAsTypeArgument(@NotNull PsiTypeElement typeElement) {
        PsiType wildCardBind;
        PsiType type;
        if (typeElement == null) {
            GenericsChecker.$$$reportNull$$$0(41);
        }
        if ((type = typeElement.getType()) instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)type;
            v0 = wildcardType.getBound();
        } else {
            v0 = wildCardBind = null;
        }
        if (type != PsiTypes.nullType() && type instanceof PsiPrimitiveType || wildCardBind instanceof PsiPrimitiveType) {
            PsiElement psiElement = typeElement.getParent();
            if (!(psiElement instanceof PsiReferenceParameterList)) {
                return;
            }
            PsiReferenceParameterList list = (PsiReferenceParameterList)psiElement;
            PsiElement parent = list.getParent();
            if (!(parent instanceof PsiJavaCodeReferenceElement) && !(parent instanceof PsiNewExpression)) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.TYPE_ARGUMENT_PRIMITIVE.create(typeElement));
        }
    }

    void checkWildcardUsage(@NotNull PsiTypeElement typeElement) {
        PsiType type;
        if (typeElement == null) {
            GenericsChecker.$$$reportNull$$$0(42);
        }
        if ((type = typeElement.getType()) instanceof PsiWildcardType) {
            if (typeElement.getParent() instanceof PsiReferenceParameterList) {
                PsiTypeParameter typeParameter;
                PsiElement refPParent;
                PsiElement parent = typeElement.getParent().getParent();
                PsiElement refParent = parent.getParent();
                if (refParent instanceof PsiAnonymousClass) {
                    refParent = refParent.getParent();
                }
                if (refParent instanceof PsiNewExpression) {
                    PsiNewExpression newExpression = (PsiNewExpression)refParent;
                    if (!(newExpression.getType() instanceof PsiArrayType)) {
                        this.myVisitor.report(JavaErrorKinds.TYPE_WILDCARD_CANNOT_BE_INSTANTIATED.create(typeElement));
                    }
                } else if (refParent instanceof PsiReferenceList && (!((refPParent = refParent.getParent()) instanceof PsiTypeParameter) || refParent != (typeParameter = (PsiTypeParameter)refPParent).getExtendsList())) {
                    this.myVisitor.report(JavaErrorKinds.TYPE_WILDCARD_NOT_EXPECTED.create(typeElement));
                }
            } else if (!typeElement.isInferredType()) {
                this.myVisitor.report(JavaErrorKinds.TYPE_WILDCARD_MAY_BE_USED_ONLY_AS_REFERENCE_PARAMETERS.create(typeElement));
            }
        }
    }

    void checkParametersAllowed(@NotNull PsiReferenceParameterList refParamList) {
        PsiElement grandParent;
        PsiElement parent;
        if (refParamList == null) {
            GenericsChecker.$$$reportNull$$$0(43);
        }
        if ((parent = refParamList.getParent()) instanceof PsiReferenceExpression && !((grandParent = parent.getParent()) instanceof PsiMethodCallExpression) && !(parent instanceof PsiMethodReferenceExpression)) {
            this.myVisitor.report(JavaErrorKinds.TYPE_ARGUMENT_NOT_ALLOWED.create(refParamList));
        }
    }

    void checkParametersOnRaw(@NotNull PsiReferenceParameterList refParamList) {
        if (refParamList == null) {
            GenericsChecker.$$$reportNull$$$0(44);
        }
        JavaResolveResult resolveResult = null;
        PsiElement parent = refParamList.getParent();
        PsiElement qualifier = null;
        if (parent instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parent;
            resolveResult = referenceElement.advancedResolve(false);
            qualifier = referenceElement.getQualifier();
        } else if (parent instanceof PsiCallExpression) {
            PsiCallExpression callExpression = (PsiCallExpression)parent;
            resolveResult = callExpression.resolveMethodGenerics();
            if (parent instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                qualifier = methodExpression.getQualifier();
            }
        }
        if (resolveResult != null) {
            PsiJavaCodeReferenceElement referenceElement;
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiTypeParameterListOwner)) {
                return;
            }
            PsiTypeParameterListOwner owner = (PsiTypeParameterListOwner)element;
            if (owner.hasModifierProperty("static")) {
                return;
            }
            if (qualifier instanceof PsiJavaCodeReferenceElement && (referenceElement = (PsiJavaCodeReferenceElement)qualifier).resolve() instanceof PsiTypeParameter) {
                return;
            }
            PsiClass containingClass = owner.getContainingClass();
            if (containingClass != null && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)resolveResult.getSubstitutor())) {
                if (element instanceof PsiMethod) {
                    PsiMethod psiMethod = (PsiMethod)element;
                    if (this.myVisitor.languageLevel().isAtLeast(LanguageLevel.JDK_1_7)) {
                        return;
                    }
                    if (psiMethod.findSuperMethods().length > 0) {
                        return;
                    }
                    if (qualifier instanceof PsiReferenceExpression) {
                        PsiClass typeParameter;
                        PsiReferenceExpression expression = (PsiReferenceExpression)qualifier;
                        PsiType type = expression.getType();
                        boolean isJavac7 = JavaVersionService.getInstance().isAtLeast((PsiElement)containingClass, JavaSdkVersion.JDK_1_7);
                        if (type instanceof PsiClassType) {
                            PsiClassType psiClassType = (PsiClassType)type;
                            if (isJavac7 && psiClassType.isRaw()) {
                                return;
                            }
                        }
                        if ((typeParameter = PsiUtil.resolveClassInType((PsiType)type)) instanceof PsiTypeParameter) {
                            if (isJavac7) {
                                return;
                            }
                            for (PsiClassType classType : typeParameter.getExtendsListTypes()) {
                                PsiMethod[] superMethods;
                                PsiClass resolve = classType.resolve();
                                if (resolve == null) continue;
                                for (PsiMethod superMethod : superMethods = resolve.findMethodsBySignature(psiMethod, true)) {
                                    if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)superMethod, (PsiSubstitutor)resolveResult.getSubstitutor())) continue;
                                    return;
                                }
                            }
                        }
                    }
                }
                JavaErrorKind.Simple<PsiReferenceParameterList> kind = element instanceof PsiClass ? JavaErrorKinds.TYPE_ARGUMENT_ON_RAW_TYPE : JavaErrorKinds.TYPE_ARGUMENT_ON_RAW_METHOD;
                this.myVisitor.report(kind.create(refParamList));
            }
        }
    }

    void checkInstanceOfGenericType(@NotNull PsiInstanceOfExpression expression) {
        PsiTypeElement typeElement;
        if (expression == null) {
            GenericsChecker.$$$reportNull$$$0(45);
        }
        if ((typeElement = expression.getCheckType()) == null) {
            typeElement = JavaPsiPatternUtil.getPatternTypeElement((PsiCaseLabelElement)expression.getPattern());
        }
        if (typeElement == null) {
            return;
        }
        PsiType checkType = typeElement.getType();
        if (this.myVisitor.isApplicable(JavaFeature.PATTERNS)) {
            PsiPrimaryPattern pattern = expression.getPattern();
            if (pattern != null) {
                this.myVisitor.myPatternChecker.checkUncheckedPatternConversion((PsiPattern)pattern);
            } else {
                this.checkUnsafeCastInInstanceOf(typeElement, checkType, expression.getOperand().getType());
            }
        } else {
            this.checkIllegalForInstanceOf(checkType, typeElement);
        }
    }

    void checkTypeParameterReference(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiTypeParameter typeParameter) {
        PsiClass ownerContainingClass;
        PsiModifierListOwner staticElement;
        PsiTypeParameterListOwner owner;
        if (ref == null) {
            GenericsChecker.$$$reportNull$$$0(46);
        }
        if (typeParameter == null) {
            GenericsChecker.$$$reportNull$$$0(47);
        }
        if ((owner = typeParameter.getOwner()) instanceof PsiClass) {
            PsiClass outerClass = (PsiClass)owner;
            if (!InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)outerClass, (PsiElement)ref, (boolean)false, (boolean)false)) {
                this.myVisitor.myExpressionChecker.checkIllegalEnclosingUsage((PsiElement)ref, null, outerClass, (PsiElement)ref);
            }
        } else if (owner instanceof PsiMethod && (staticElement = PsiUtil.getEnclosingStaticElement((PsiElement)ref, null)) != null && PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)staticElement, (boolean)true) && (ownerContainingClass = owner.getContainingClass()) != null) {
            this.myVisitor.report(JavaErrorKinds.REFERENCE_OUTER_TYPE_PARAMETER_FROM_STATIC_CONTEXT.create(ref, typeParameter));
        }
    }

    private void checkUnsafeCastInInstanceOf(@NotNull PsiTypeElement checkTypeElement, @NotNull PsiType checkType, @Nullable PsiType expressionType) {
        if (checkTypeElement == null) {
            GenericsChecker.$$$reportNull$$$0(48);
        }
        if (checkType == null) {
            GenericsChecker.$$$reportNull$$$0(49);
        }
        if (expressionType != null && JavaGenericsUtil.isUncheckedCast((PsiType)checkType, (PsiType)expressionType)) {
            this.myVisitor.report(JavaErrorKinds.INSTANCEOF_UNSAFE_CAST.create(checkTypeElement, new JavaIncompatibleTypeErrorContext(expressionType, checkType)));
        }
    }

    private void checkIllegalForInstanceOf(@Nullable PsiType type, @NotNull PsiTypeElement typeElement) {
        PsiClass resolved;
        if (typeElement == null) {
            GenericsChecker.$$$reportNull$$$0(50);
        }
        if ((resolved = PsiUtil.resolveClassInClassTypeOnly((PsiType)type)) instanceof PsiTypeParameter) {
            this.myVisitor.report(JavaErrorKinds.INSTANCEOF_TYPE_PARAMETER.create(typeElement));
        } else if (!JavaGenericsUtil.isReifiableType((PsiType)type)) {
            this.myVisitor.report(JavaErrorKinds.INSTANCEOF_ILLEGAL_GENERIC_TYPE.create(typeElement));
        }
    }

    void checkDefaultMethodOverridesMemberOfJavaLangObject(@NotNull PsiClass aClass, @NotNull PsiMethod method) {
        if (aClass == null) {
            GenericsChecker.$$$reportNull$$$0(51);
        }
        if (method == null) {
            GenericsChecker.$$$reportNull$$$0(52);
        }
        if (!(this.myVisitor.isApplicable(JavaFeature.EXTENSION_METHODS) && aClass.isInterface() && method.hasModifierProperty("default"))) {
            return;
        }
        if (GenericsChecker.doesMethodOverrideMemberOfJavaLangObject(method)) {
            this.myVisitor.report(JavaErrorKinds.METHOD_DEFAULT_OVERRIDES_OBJECT_MEMBER.create(method));
        }
    }

    void checkUnrelatedConcrete(@NotNull PsiClass psiClass) {
        PsiClass superClass;
        if (psiClass == null) {
            GenericsChecker.$$$reportNull$$$0(53);
        }
        if ((superClass = psiClass.getSuperClass()) != null && superClass.hasTypeParameters()) {
            Collection visibleSignatures = superClass.getVisibleSignatures();
            Map overrideEquivalent = MethodSignatureUtil.createErasedMethodSignatureMap();
            for (HierarchicalMethodSignature hms : visibleSignatures) {
                PsiClass containingClass;
                PsiMethod method = hms.getMethod();
                if (method.isConstructor() || method.hasModifierProperty("abstract") || method.hasModifierProperty("default") || method.hasModifierProperty("static") || psiClass.findMethodsBySignature(method, false).length > 0 || (containingClass = method.getContainingClass()) == null) continue;
                PsiSubstitutor containingClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)psiClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                PsiSubstitutor finalSubstitutor = PsiSuperMethodUtil.obtainFinalSubstitutor((PsiClass)containingClass, (PsiSubstitutor)containingClassSubstitutor, (PsiSubstitutor)hms.getSubstitutor(), (boolean)false);
                MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create((PsiMethod)method, (PsiSubstitutor)finalSubstitutor, (boolean)false);
                PsiMethod foundMethod = (PsiMethod)overrideEquivalent.get(signature);
                if (foundMethod != null && !foundMethod.hasModifierProperty("abstract") && !foundMethod.hasModifierProperty("default") && foundMethod.getContainingClass() != null) {
                    this.myVisitor.report(JavaErrorKinds.CLASS_INHERITANCE_METHOD_CLASH.create(psiClass, new JavaErrorKinds.OverrideClashContext(method, foundMethod)));
                    return;
                }
                overrideEquivalent.put(signature, method);
            }
        }
    }

    void checkGenericCannotExtendException(@NotNull PsiReferenceList list) {
        block6: {
            PsiMethod method;
            PsiElement parent;
            block5: {
                if (list == null) {
                    GenericsChecker.$$$reportNull$$$0(54);
                }
                if (!((parent = list.getParent()) instanceof PsiClass)) break block5;
                PsiClass klass = (PsiClass)parent;
                if (!GenericsChecker.hasGenericSignature(klass) || klass.getExtendsList() != list) break block6;
                PsiClass throwableClass = null;
                for (PsiJavaCodeReferenceElement refElement : list.getReferenceElements()) {
                    PsiElement resolved = refElement.resolve();
                    if (!(resolved instanceof PsiClass)) continue;
                    PsiClass psiClass = (PsiClass)resolved;
                    if (throwableClass == null) {
                        throwableClass = JavaPsiFacade.getInstance((Project)this.myVisitor.project()).findClass("java.lang.Throwable", klass.getResolveScope());
                    }
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, throwableClass, (boolean)true)) continue;
                    this.myVisitor.report(JavaErrorKinds.CLASS_GENERIC_EXTENDS_EXCEPTION.create(refElement));
                }
                break block6;
            }
            if (parent instanceof PsiMethod && (method = (PsiMethod)parent).getThrowsList() == list) {
                for (PsiJavaCodeReferenceElement refElement : list.getReferenceElements()) {
                    PsiReferenceParameterList parameterList = refElement.getParameterList();
                    if (parameterList == null || parameterList.getTypeParameterElements().length == 0) continue;
                    this.myVisitor.report(JavaErrorKinds.CLASS_GENERIC_EXTENDS_EXCEPTION.create(refElement));
                }
            }
        }
    }

    void checkGenericCannotExtendException(@NotNull PsiAnonymousClass anonymousClass) {
        if (anonymousClass == null) {
            GenericsChecker.$$$reportNull$$$0(55);
        }
        if (GenericsChecker.hasGenericSignature((PsiClass)anonymousClass) && InheritanceUtil.isInheritor((PsiClass)anonymousClass, (boolean)true, (String)"java.lang.Throwable")) {
            this.myVisitor.report(JavaErrorKinds.CLASS_GENERIC_EXTENDS_EXCEPTION.create(anonymousClass.getBaseClassReference()));
        }
    }

    void checkClassObjectAccessExpression(@NotNull PsiClassObjectAccessExpression expression) {
        PsiType arrayComponentType;
        PsiType type;
        if (expression == null) {
            GenericsChecker.$$$reportNull$$$0(56);
        }
        if ((type = expression.getOperand().getType()) instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            this.checkClassAccess(classType, expression.getOperand());
        }
        if (type instanceof PsiArrayType && (arrayComponentType = type.getDeepComponentType()) instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)arrayComponentType;
            this.checkClassAccess(classType, expression.getOperand());
        }
    }

    private void checkClassAccess(@NotNull PsiClassType type, @NotNull PsiTypeElement operand) {
        PsiClass aClass;
        if (type == null) {
            GenericsChecker.$$$reportNull$$$0(57);
        }
        if (operand == null) {
            GenericsChecker.$$$reportNull$$$0(58);
        }
        if ((aClass = type.resolve()) instanceof PsiTypeParameter) {
            this.myVisitor.report(JavaErrorKinds.EXPRESSION_CLASS_TYPE_PARAMETER.create(operand));
            return;
        }
        if (type.getParameters().length > 0) {
            this.myVisitor.report(JavaErrorKinds.EXPRESSION_CLASS_PARAMETERIZED_TYPE.create(operand));
        }
    }

    void checkTypeParameterInstantiation(@NotNull PsiNewExpression expression) {
        PsiJavaCodeReferenceElement classReference;
        if (expression == null) {
            GenericsChecker.$$$reportNull$$$0(59);
        }
        if ((classReference = expression.getClassOrAnonymousClassReference()) == null) {
            return;
        }
        JavaResolveResult result = classReference.advancedResolve(false);
        PsiElement element = result.getElement();
        if (element instanceof PsiTypeParameter) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)element;
            this.myVisitor.report(JavaErrorKinds.NEW_EXPRESSION_TYPE_PARAMETER.create(classReference, typeParameter));
        }
    }

    void checkAccessStaticFieldFromEnumConstructor(@NotNull PsiReferenceExpression expr, @NotNull JavaResolveResult result) {
        PsiField field;
        if (expr == null) {
            GenericsChecker.$$$reportNull$$$0(60);
        }
        if (result == null) {
            GenericsChecker.$$$reportNull$$$0(61);
        }
        if ((field = (PsiField)ObjectUtils.tryCast((Object)result.getElement(), PsiField.class)) == null) {
            return;
        }
        PsiClass enumClass = JavaPsiEnumUtil.getEnumClassForExpressionInInitializer((PsiExpression)expr);
        if (enumClass == null || !JavaPsiEnumUtil.isRestrictedStaticEnumField((PsiField)field, (PsiClass)enumClass)) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.ENUM_CONSTANT_ILLEGAL_ACCESS_IN_CONSTRUCTOR.create(expr, field));
    }

    private static boolean hasGenericSignature(@NotNull PsiClass klass) {
        if (klass == null) {
            GenericsChecker.$$$reportNull$$$0(62);
        }
        PsiClass containingClass = klass;
        while (containingClass != null && PsiUtil.isLocalOrAnonymousClass((PsiClass)containingClass)) {
            if (containingClass.hasTypeParameters()) {
                return true;
            }
            containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class);
        }
        return containingClass != null && PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)containingClass).hasNext();
    }

    private static boolean doesMethodOverrideMemberOfJavaLangObject(@NotNull PsiMethod method) {
        if (method == null) {
            GenericsChecker.$$$reportNull$$$0(63);
        }
        for (HierarchicalMethodSignature methodSignature : method.getHierarchicalMethodSignature().getSuperSignatures()) {
            PsiMethod objectMethod = methodSignature.getMethod();
            PsiClass containingClass = objectMethod.getContainingClass();
            if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && objectMethod.hasModifierProperty("public")) {
                return true;
            }
            if (!GenericsChecker.doesMethodOverrideMemberOfJavaLangObject(objectMethod)) continue;
            return true;
        }
        return false;
    }

    private static PsiType detectExpectedType(@NotNull PsiReferenceParameterList referenceParameterList) {
        PsiParameter parameter;
        Object[] expressions;
        int idx;
        PsiMethod method;
        PsiCallExpression callExpression;
        PsiExpressionList argumentList;
        PsiElement pParent;
        PsiAssignmentExpression expression;
        PsiVariable psiVariable;
        if (referenceParameterList == null) {
            GenericsChecker.$$$reportNull$$$0(64);
        }
        PsiNewExpression newExpression = Objects.requireNonNull((PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiNewExpression.class));
        PsiElement parent = newExpression.getParent();
        PsiType expectedType = null;
        if (parent instanceof PsiVariable && newExpression.equals((Object)(psiVariable = (PsiVariable)parent).getInitializer())) {
            expectedType = psiVariable.getType();
        } else if (parent instanceof PsiAssignmentExpression && newExpression.equals((Object)(expression = (PsiAssignmentExpression)parent).getRExpression())) {
            expectedType = expression.getLExpression().getType();
        } else if (parent instanceof PsiReturnStatement) {
            PsiElement method2 = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (method2 instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)method2;
                expectedType = psiMethod.getReturnType();
            }
        } else if (parent instanceof PsiExpressionList && (pParent = parent.getParent()) instanceof PsiCallExpression && parent.equals((Object)(argumentList = (callExpression = (PsiCallExpression)pParent).getArgumentList())) && (method = callExpression.resolveMethod()) != null && (idx = ArrayUtilRt.find((Object[])(expressions = argumentList.getExpressions()), (Object)newExpression)) > -1 && (parameter = method.getParameterList().getParameter(idx)) != null) {
            expectedType = parameter.getType();
        }
        return expectedType;
    }

    private static boolean hasSuperMethodsWithTypeParams(@NotNull PsiMethod method) {
        if (method == null) {
            GenericsChecker.$$$reportNull$$$0(65);
        }
        for (PsiMethod superMethod : method.findDeepestSuperMethods()) {
            if (!superMethod.hasTypeParameters()) continue;
            return true;
        }
        return false;
    }

    void checkGenericArrayCreation(@NotNull PsiElement element, @Nullable PsiType type) {
        if (element == null) {
            GenericsChecker.$$$reportNull$$$0(66);
        }
        if (type instanceof PsiArrayType) {
            PsiReferenceParameterList typeArgumentList;
            PsiArrayType arrayType = (PsiArrayType)type;
            if (element instanceof PsiNewExpression) {
                PsiReferenceParameterList parameterList;
                PsiNewExpression newExpression = (PsiNewExpression)element;
                typeArgumentList = newExpression.getTypeArgumentList();
                if (typeArgumentList.getTypeArgumentCount() > 0) {
                    this.myVisitor.report(JavaErrorKinds.ARRAY_TYPE_ARGUMENTS.create(typeArgumentList));
                    return;
                }
                PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
                if (classReference != null && (parameterList = classReference.getParameterList()) != null) {
                    PsiTypeElement[] typeParameterElements = parameterList.getTypeParameterElements();
                    if (typeParameterElements.length == 1 && typeParameterElements[0].getType() instanceof PsiDiamondType) {
                        this.myVisitor.report(JavaErrorKinds.ARRAY_EMPTY_DIAMOND.create(parameterList));
                        return;
                    }
                    if (typeParameterElements.length >= 1 && !JavaGenericsUtil.isReifiableType((PsiType)arrayType.getComponentType())) {
                        this.myVisitor.report(JavaErrorKinds.ARRAY_GENERIC.create((PsiElement)parameterList));
                        return;
                    }
                }
            }
            if (!JavaGenericsUtil.isReifiableType((PsiType)arrayType.getComponentType())) {
                PsiReferenceParameterList parameterList;
                PsiTypeElement typeElement;
                PsiJavaCodeReferenceElement referenceElement;
                if (element.getParent() instanceof PsiMethodReferenceExpression && (typeArgumentList = element.getFirstChild()) instanceof PsiTypeElement && (referenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.findChildOfType((PsiElement)(typeElement = (PsiTypeElement)typeArgumentList), PsiJavaCodeReferenceElement.class)) != null && (parameterList = referenceElement.getParameterList()) != null && parameterList.getTypeArgumentCount() > 0) {
                    this.myVisitor.report(JavaErrorKinds.ARRAY_GENERIC.create((PsiElement)parameterList));
                    return;
                }
                this.myVisitor.report(JavaErrorKinds.ARRAY_GENERIC.create(element));
            }
        }
    }

    Map<PsiMember, JavaCompilationError<PsiMember, ?>> computeOverrideEquivalentMethodErrors(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GenericsChecker.$$$reportNull$$$0(67);
        }
        if (this.myOverrideEquivalentMethodsVisitedClasses.add(aClass)) {
            Collection signaturesWithSupers = aClass.getVisibleSignatures();
            PsiManager manager = aClass.getManager();
            Map sameErasureMethods = MethodSignatureUtil.createErasedMethodSignatureMap();
            Set foundProblems = MethodSignatureUtil.createErasedMethodSignatureSet();
            for (HierarchicalMethodSignature signature : signaturesWithSupers) {
                JavaCompilationError<PsiMember, ?> error = GenericsChecker.checkSameErasureNotSubSignatureInner(signature, manager, aClass, sameErasureMethods);
                if (error != null && foundProblems.add(signature)) {
                    this.myOverrideEquivalentMethodsErrors.put(error.psi(), error);
                }
                if (!(aClass instanceof PsiTypeParameter) || (error = MethodChecker.getMethodIncompatibleReturnType((PsiMember)aClass, (MethodSignatureBackedByPsiMethod)signature, signature.getSuperSignatures())) == null) continue;
                this.myOverrideEquivalentMethodsErrors.put((PsiMember)aClass, error);
            }
        }
        return this.myOverrideEquivalentMethodsErrors;
    }

    private static JavaCompilationError<PsiMember, ?> checkSameErasureNotSubSignatureInner(@NotNull HierarchicalMethodSignature signature, @NotNull PsiManager manager, @NotNull PsiClass aClass, @NotNull Map<MethodSignature, MethodSignatureBackedByPsiMethod> sameErasureMethods) {
        JavaCompilationError<PsiMember, ?> error;
        if (signature == null) {
            GenericsChecker.$$$reportNull$$$0(68);
        }
        if (manager == null) {
            GenericsChecker.$$$reportNull$$$0(69);
        }
        if (aClass == null) {
            GenericsChecker.$$$reportNull$$$0(70);
        }
        if (sameErasureMethods == null) {
            GenericsChecker.$$$reportNull$$$0(71);
        }
        PsiMethod method = signature.getMethod();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        if (!facade.getResolveHelper().isAccessible((PsiMember)method, (PsiElement)aClass, null)) {
            return null;
        }
        MethodSignature signatureToErase = method.getSignature(PsiSubstitutor.EMPTY);
        MethodSignatureBackedByPsiMethod sameErasure = sameErasureMethods.get(signatureToErase);
        if (sameErasure == null) {
            sameErasureMethods.put(signatureToErase, (MethodSignatureBackedByPsiMethod)signature);
        } else if ((aClass instanceof PsiTypeParameter || MethodSignatureUtil.findMethodBySuperMethod((PsiClass)aClass, (PsiMethod)sameErasure.getMethod(), (boolean)false) != null || !InheritanceUtil.isInheritorOrSelf((PsiClass)sameErasure.getMethod().getContainingClass(), (PsiClass)method.getContainingClass(), (boolean)true) && !InheritanceUtil.isInheritorOrSelf((PsiClass)method.getContainingClass(), (PsiClass)sameErasure.getMethod().getContainingClass(), (boolean)true)) && (error = GenericsChecker.checkSameErasureNotSubSignatureOrSameClass(sameErasure, signature, aClass, method)) != null) {
            return error;
        }
        List supers = signature.getSuperSignatures();
        for (HierarchicalMethodSignature superSignature : supers) {
            JavaCompilationError<PsiMember, ?> error2 = GenericsChecker.checkSameErasureNotSubSignatureInner(superSignature, manager, aClass, sameErasureMethods);
            if (error2 != null) {
                return error2;
            }
            if (!superSignature.isRaw() || signature.isRaw()) continue;
            PsiType[] parameterTypes = signature.getParameterTypes();
            PsiType[] erasedTypes = superSignature.getErasedParameterTypes();
            for (int i = 0; i < erasedTypes.length; ++i) {
                if (Comparing.equal((Object)parameterTypes[i], (Object)erasedTypes[i])) continue;
                return GenericsChecker.getSameErasureMessage(method, superSignature.getMethod(), (PsiMember)aClass);
            }
        }
        return null;
    }

    private static JavaCompilationError<PsiMember, ?> checkSameErasureNotSubSignatureOrSameClass(@NotNull MethodSignatureBackedByPsiMethod signatureToCheck, @NotNull HierarchicalMethodSignature superSignature, @NotNull PsiClass aClass, @NotNull PsiMethod superMethod) {
        PsiType retErasure2;
        boolean differentReturnTypeErasure;
        PsiMethod checkMethod;
        if (signatureToCheck == null) {
            GenericsChecker.$$$reportNull$$$0(72);
        }
        if (superSignature == null) {
            GenericsChecker.$$$reportNull$$$0(73);
        }
        if (aClass == null) {
            GenericsChecker.$$$reportNull$$$0(74);
        }
        if (superMethod == null) {
            GenericsChecker.$$$reportNull$$$0(75);
        }
        if (superMethod.equals((Object)(checkMethod = signatureToCheck.getMethod()))) {
            return null;
        }
        PsiClass checkContainingClass = Objects.requireNonNull(checkMethod.getContainingClass());
        PsiClass superContainingClass = superMethod.getContainingClass();
        boolean checkEqualsSuper = checkContainingClass.equals((Object)superContainingClass);
        if (checkMethod.isConstructor() ? !superMethod.isConstructor() || !checkEqualsSuper : superMethod.isConstructor()) {
            return null;
        }
        JavaVersionService javaVersionService = JavaVersionService.getInstance();
        boolean atLeast17 = javaVersionService.isAtLeast((PsiElement)aClass, JavaSdkVersion.JDK_1_7);
        if (checkMethod.hasModifierProperty("static") && !checkEqualsSuper && !atLeast17) {
            return null;
        }
        if (superMethod.hasModifierProperty("static") && superContainingClass != null && superContainingClass.isInterface() && !checkEqualsSuper && PsiUtil.isAvailable((JavaFeature)JavaFeature.STATIC_INTERFACE_CALLS, (PsiElement)superContainingClass)) {
            return null;
        }
        PsiType retErasure1 = TypeConversionUtil.erasure((PsiType)checkMethod.getReturnType());
        boolean bl = differentReturnTypeErasure = !Comparing.equal((Object)retErasure1, (Object)(retErasure2 = TypeConversionUtil.erasure((PsiType)superMethod.getReturnType())));
        if (checkEqualsSuper && atLeast17 && retErasure1 != null && retErasure2 != null) {
            boolean bl2 = differentReturnTypeErasure = !TypeConversionUtil.isAssignable((PsiType)retErasure1, (PsiType)retErasure2);
        }
        if (!(!differentReturnTypeErasure || TypeConversionUtil.isVoidType((PsiType)retErasure1) || TypeConversionUtil.isVoidType((PsiType)retErasure2) || checkEqualsSuper && Arrays.equals(superSignature.getParameterTypes(), signatureToCheck.getParameterTypes()) || atLeast17)) {
            int idx = 0;
            PsiType[] erasedTypes = signatureToCheck.getErasedParameterTypes();
            boolean erasure = erasedTypes.length > 0;
            for (PsiType type : superSignature.getParameterTypes()) {
                erasure &= Comparing.equal((Object)type, (Object)erasedTypes[idx]);
                ++idx;
            }
            if (!erasure) {
                return null;
            }
        }
        if (!checkEqualsSuper && MethodSignatureUtil.isSubsignature((MethodSignature)superSignature, (MethodSignature)signatureToCheck)) {
            return null;
        }
        if (!javaVersionService.isCompilerVersionAtLeast((PsiElement)aClass, JavaSdkVersion.JDK_1_7) && superContainingClass != null && !superContainingClass.isInterface() && checkContainingClass.isInterface() && !aClass.equals((Object)superContainingClass)) {
            return null;
        }
        PsiMethod anchor = aClass.equals((Object)checkContainingClass) ? checkMethod : aClass;
        return GenericsChecker.getSameErasureMessage(checkMethod, superMethod, (PsiMember)anchor);
    }

    private static JavaCompilationError<PsiMember, ?> getSameErasureMessage(@NotNull PsiMethod method, @NotNull PsiMethod superMethod, @NotNull PsiMember anchor) {
        if (method == null) {
            GenericsChecker.$$$reportNull$$$0(76);
        }
        if (superMethod == null) {
            GenericsChecker.$$$reportNull$$$0(77);
        }
        if (anchor == null) {
            GenericsChecker.$$$reportNull$$$0(78);
        }
        return JavaErrorKinds.METHOD_GENERIC_CLASH.create(anchor, new JavaErrorKinds.OverrideClashContext(method, superMethod));
    }

    void checkTypeParameterOverrideEquivalentMethods(@NotNull PsiClass typeParameter) {
        JavaCompilationError<PsiMember, ?> error;
        PsiReferenceList extendsList;
        if (typeParameter == null) {
            GenericsChecker.$$$reportNull$$$0(79);
        }
        if (typeParameter instanceof PsiTypeParameter && this.myVisitor.languageLevel().isAtLeast(LanguageLevel.JDK_1_7) && (extendsList = typeParameter.getExtendsList()).getReferenceElements().length > 1 && (error = this.computeOverrideEquivalentMethodErrors(typeParameter).get(typeParameter)) != null) {
            this.myVisitor.report(error);
        }
    }

    void checkMemberSignatureTypesAccessibility(@NotNull PsiReferenceExpression ref) {
        if (ref == null) {
            GenericsChecker.$$$reportNull$$$0(80);
        }
        PsiClass psiClass = null;
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression expression = (PsiMethodCallExpression)parent;
            JavaResolveResult resolveResult = expression.resolveMethodGenerics();
            PsiMethod method = (PsiMethod)resolveResult.getElement();
            if (method != null) {
                HashSet classes = new HashSet();
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)ref.getProject());
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                GlobalSearchScope resolveScope = ref.getResolveScope();
                psiClass = GenericsChecker.getInaccessibleClass(substitutor.substitute(method.getReturnType()), classes, resolveScope, facade);
                if (psiClass == null) {
                    PsiType type;
                    PsiType[] psiTypeArray = method.getSignature(substitutor).getParameterTypes();
                    int n = psiTypeArray.length;
                    for (int i = 0; i < n && (psiClass = GenericsChecker.getInaccessibleClass(type = psiTypeArray[i], classes, resolveScope, facade)) == null; ++i) {
                    }
                }
            }
        } else {
            PsiElement resolve = ref.resolve();
            if (resolve instanceof PsiField) {
                PsiField psiField = (PsiField)resolve;
                GlobalSearchScope resolveScope = ref.getResolveScope();
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)ref.getProject());
                psiClass = GenericsChecker.getInaccessibleClass(psiField.getType(), new HashSet(), resolveScope, facade);
            }
        }
        if (psiClass != null) {
            this.myVisitor.report(JavaErrorKinds.CLASS_NOT_ACCESSIBLE.create((PsiElement)ref, psiClass));
        }
    }

    @Nullable
    private static PsiClass getInaccessibleClass(@Nullable PsiType type, @NotNull Set<? super PsiClass> classes, @NotNull GlobalSearchScope resolveScope, @NotNull JavaPsiFacade factory) {
        if (classes == null) {
            GenericsChecker.$$$reportNull$$$0(81);
        }
        if (resolveScope == null) {
            GenericsChecker.$$$reportNull$$$0(82);
        }
        if (factory == null) {
            GenericsChecker.$$$reportNull$$$0(83);
        }
        return GenericsChecker.getInaccessibleClass(type, classes, false, true, resolveScope, factory);
    }

    @Nullable
    private static PsiClass getInaccessibleClass(@Nullable PsiType type, @NotNull Set<? super PsiClass> classes, boolean checkParameters, boolean checkSuperTypes, @NotNull GlobalSearchScope resolveScope, @NotNull JavaPsiFacade factory) {
        PsiClass aClass;
        if (classes == null) {
            GenericsChecker.$$$reportNull$$$0(84);
        }
        if (resolveScope == null) {
            GenericsChecker.$$$reportNull$$$0(85);
        }
        if (factory == null) {
            GenericsChecker.$$$reportNull$$$0(86);
        }
        if ((aClass = PsiUtil.resolveClassInType((PsiType)(type = PsiClassImplUtil.correctType((PsiType)type, (GlobalSearchScope)resolveScope)))) != null && classes.add((PsiClass)aClass)) {
            PsiClass cls;
            VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)aClass);
            if (vFile == null) {
                return null;
            }
            FileIndexFacade index = FileIndexFacade.getInstance((Project)aClass.getProject());
            if (!index.isInSource(vFile) && !index.isInLibraryClasses(vFile)) {
                return null;
            }
            PsiImplicitClass parentImplicitClass = (PsiImplicitClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiImplicitClass.class);
            String qualifiedName = aClass.getQualifiedName();
            if (parentImplicitClass == null && qualifiedName != null && factory.findClass(qualifiedName, resolveScope) == null) {
                return aClass;
            }
            if (!checkParameters) {
                return null;
            }
            if (type instanceof PsiClassType) {
                PsiClassType classType = (PsiClassType)type;
                for (PsiType psiType : classType.getParameters()) {
                    cls = GenericsChecker.getInaccessibleClass(psiType, classes, true, false, resolveScope, factory);
                    if (cls == null) continue;
                    return cls;
                }
            }
            if (!checkSuperTypes) {
                return null;
            }
            boolean isInLibrary = !index.isInContent(vFile);
            for (PsiType psiType : aClass.getSuperTypes()) {
                cls = GenericsChecker.getInaccessibleClass(psiType, classes, !isInLibrary, true, resolveScope, factory);
                if (cls == null) continue;
                return cls;
            }
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$checkReferenceTypeArgumentList$0(PsiMethod method) {
        return !method.hasModifierProperty("private") && method.findSuperMethods().length == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceList";
                break;
            }
            case 2: 
            case 47: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 4: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toHighlight";
                break;
            }
            case 6: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 10: 
            case 45: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: 
            case 21: 
            case 46: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 24: 
            case 51: 
            case 67: 
            case 70: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedSubstitutor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritedClasses";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 23: 
            case 26: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 25: 
            case 28: 
            case 82: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 27: 
            case 81: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 29: 
            case 83: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 30: 
            case 33: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterListOwner";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classParameter";
                break;
            }
            case 38: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement2Highlight";
                break;
            }
            case 41: 
            case 42: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refParamList";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkTypeElement";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkType";
                break;
            }
            case 52: 
            case 63: 
            case 65: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anonymousClass";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceParameterList";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sameErasureMethods";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureToCheck";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSignature";
                break;
            }
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/highlighting/GenericsChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkElementInTypeParameterExtendsList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCannotInheritFromTypeParameter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypeParametersList";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForEachParameterType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDiamondTypeNotAllowed";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSelectStaticClassFromParameterizedType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRawOnParameterizedType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInterfaceMultipleInheritance";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassSupersAccessibility";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypeAccessible";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInferredIntersections";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "checkParameterizedReferenceTypeArguments";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReferenceTypeArgumentList";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypeParameterWithinItsBound";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCatchParameterIsClass";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReferenceTypeUsedAsTypeArgument";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[2] = "checkWildcardUsage";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "checkParametersAllowed";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "checkParametersOnRaw";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInstanceOfGenericType";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypeParameterReference";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUnsafeCastInInstanceOf";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIllegalForInstanceOf";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDefaultMethodOverridesMemberOfJavaLangObject";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUnrelatedConcrete";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[2] = "checkGenericCannotExtendException";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassObjectAccessExpression";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassAccess";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypeParameterInstantiation";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAccessStaticFieldFromEnumConstructor";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[2] = "hasGenericSignature";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[2] = "doesMethodOverrideMemberOfJavaLangObject";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[2] = "detectExpectedType";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSuperMethodsWithTypeParams";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[2] = "checkGenericArrayCreation";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[2] = "computeOverrideEquivalentMethodErrors";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSameErasureNotSubSignatureInner";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSameErasureNotSubSignatureOrSameClass";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[2] = "getSameErasureMessage";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypeParameterOverrideEquivalentMethods";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMemberSignatureTypesAccessibility";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[2] = "getInaccessibleClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

