/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.codeInsight.UnhandledExceptions;
import com.intellij.java.codeserver.core.JavaPreviewFeatureUtil;
import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.java.codeserver.highlighting.AnnotationChecker;
import com.intellij.java.codeserver.highlighting.ClassChecker;
import com.intellij.java.codeserver.highlighting.ControlFlowChecker;
import com.intellij.java.codeserver.highlighting.ExpressionChecker;
import com.intellij.java.codeserver.highlighting.FunctionChecker;
import com.intellij.java.codeserver.highlighting.GenericsChecker;
import com.intellij.java.codeserver.highlighting.ImportChecker;
import com.intellij.java.codeserver.highlighting.JavaErrorFilter;
import com.intellij.java.codeserver.highlighting.JavaSyntaxErrorChecker;
import com.intellij.java.codeserver.highlighting.LiteralChecker;
import com.intellij.java.codeserver.highlighting.MethodChecker;
import com.intellij.java.codeserver.highlighting.ModifierChecker;
import com.intellij.java.codeserver.highlighting.ModuleChecker;
import com.intellij.java.codeserver.highlighting.PatternChecker;
import com.intellij.java.codeserver.highlighting.ReceiverChecker;
import com.intellij.java.codeserver.highlighting.RecordChecker;
import com.intellij.java.codeserver.highlighting.StatementChecker;
import com.intellij.java.codeserver.highlighting.SwitchChecker;
import com.intellij.java.codeserver.highlighting.TypeChecker;
import com.intellij.java.codeserver.highlighting.errors.JavaCompilationError;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.java.codeserver.highlighting.errors.JavaIncompatibleTypeErrorContext;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeconstructionList;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachPatternStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFragment;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiTemplate;
import com.intellij.psi.PsiTemplateExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiUnnamedPattern;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.IncompleteModelUtil;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JavaErrorVisitor
extends JavaElementVisitor {
    @NotNull
    private final Consumer<JavaCompilationError<?, ?>> myErrorConsumer;
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiFile myPsiFile;
    @NotNull
    private final PsiElementFactory myFactory;
    @NotNull
    private final LanguageLevel myLanguageLevel;
    @NotNull
    private final AnnotationChecker myAnnotationChecker;
    @NotNull
    final ClassChecker myClassChecker;
    @NotNull
    private final RecordChecker myRecordChecker;
    @NotNull
    private final ImportChecker myImportChecker;
    @NotNull
    final GenericsChecker myGenericsChecker;
    @NotNull
    final TypeChecker myTypeChecker;
    @NotNull
    final MethodChecker myMethodChecker;
    @NotNull
    private final ReceiverChecker myReceiverChecker;
    @NotNull
    final ControlFlowChecker myControlFlowChecker;
    @NotNull
    private final FunctionChecker myFunctionChecker;
    @NotNull
    final PatternChecker myPatternChecker;
    @NotNull
    final ModuleChecker myModuleChecker;
    @NotNull
    final ModifierChecker myModifierChecker;
    @NotNull
    final ExpressionChecker myExpressionChecker;
    @NotNull
    private final SwitchChecker mySwitchChecker;
    @NotNull
    private final StatementChecker myStatementChecker;
    @NotNull
    private final LiteralChecker myLiteralChecker;
    @Nullable
    private final PsiJavaModule myJavaModule;
    @NotNull
    private final JavaSdkVersion myJavaSdkVersion;
    private boolean myHasError;

    JavaErrorVisitor(@NotNull PsiFile psiFile, @NotNull Consumer<JavaCompilationError<?, ?>> consumer) {
        if (psiFile == null) {
            JavaErrorVisitor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JavaErrorVisitor.$$$reportNull$$$0(1);
        }
        this.myAnnotationChecker = new AnnotationChecker(this);
        this.myClassChecker = new ClassChecker(this);
        this.myRecordChecker = new RecordChecker(this);
        this.myImportChecker = new ImportChecker(this);
        this.myGenericsChecker = new GenericsChecker(this);
        this.myTypeChecker = new TypeChecker(this);
        this.myMethodChecker = new MethodChecker(this);
        this.myReceiverChecker = new ReceiverChecker(this);
        this.myControlFlowChecker = new ControlFlowChecker(this);
        this.myFunctionChecker = new FunctionChecker(this);
        this.myPatternChecker = new PatternChecker(this);
        this.myModuleChecker = new ModuleChecker(this);
        this.myModifierChecker = new ModifierChecker(this);
        this.myExpressionChecker = new ExpressionChecker(this);
        this.mySwitchChecker = new SwitchChecker(this);
        this.myStatementChecker = new StatementChecker(this);
        this.myLiteralChecker = new LiteralChecker(this);
        this.myPsiFile = psiFile;
        this.myProject = psiFile.getProject();
        this.myLanguageLevel = PsiUtil.getLanguageLevel((PsiElement)psiFile);
        this.myErrorConsumer = consumer;
        this.myJavaModule = this.isApplicable(JavaFeature.MODULES) ? JavaPsiModuleUtil.findDescriptorByElement((PsiElement)psiFile) : null;
        this.myJavaSdkVersion = (JavaSdkVersion)ObjectUtils.notNull((Object)JavaVersionService.getInstance().getJavaSdkVersion((PsiElement)psiFile), (Object)JavaSdkVersion.fromLanguageLevel((LanguageLevel)this.myLanguageLevel));
        this.myFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
    }

    void report(@NotNull JavaCompilationError<?, ?> error) {
        if (error == null) {
            JavaErrorVisitor.$$$reportNull$$$0(2);
        }
        this.myHasError = true;
        if (ContainerUtil.exists((Iterable)JavaErrorFilter.EP_NAME.getExtensionList(), ep -> ep.shouldSuppressError(this.myPsiFile, error))) {
            return;
        }
        this.myErrorConsumer.accept(error);
    }

    @Contract(pure=true)
    boolean isApplicable(@NotNull JavaFeature feature) {
        if (feature == null) {
            JavaErrorVisitor.$$$reportNull$$$0(3);
        }
        return feature.isSufficient(this.myLanguageLevel);
    }

    @NotNull
    PsiFile file() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            JavaErrorVisitor.$$$reportNull$$$0(4);
        }
        return psiFile;
    }

    @NotNull
    Project project() {
        Project project = this.myProject;
        if (project == null) {
            JavaErrorVisitor.$$$reportNull$$$0(5);
        }
        return project;
    }

    @Nullable
    PsiJavaModule javaModule() {
        return this.myJavaModule;
    }

    @NotNull
    PsiElementFactory factory() {
        PsiElementFactory psiElementFactory = this.myFactory;
        if (psiElementFactory == null) {
            JavaErrorVisitor.$$$reportNull$$$0(6);
        }
        return psiElementFactory;
    }

    @NotNull
    LanguageLevel languageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            JavaErrorVisitor.$$$reportNull$$$0(7);
        }
        return languageLevel;
    }

    @NotNull
    JavaSdkVersion sdkVersion() {
        JavaSdkVersion javaSdkVersion = this.myJavaSdkVersion;
        if (javaSdkVersion == null) {
            JavaErrorVisitor.$$$reportNull$$$0(8);
        }
        return javaSdkVersion;
    }

    @Contract(pure=true)
    boolean hasErrorResults() {
        return this.myHasError;
    }

    @Contract(pure=true)
    boolean isIncompleteModel() {
        return IncompleteModelUtil.isIncompleteModel((PsiElement)this.myPsiFile);
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            JavaErrorVisitor.$$$reportNull$$$0(9);
        }
        super.visitElement(element);
        if (!(this.myPsiFile instanceof ServerPageFile)) {
            this.checkUnicodeBadCharacter(element);
        }
        this.myHasError = false;
    }

    private void checkUnicodeBadCharacter(@NotNull PsiElement element) {
        ASTNode node;
        if (element == null) {
            JavaErrorVisitor.$$$reportNull$$$0(10);
        }
        if ((node = element.getNode()) != null && node.getElementType() == TokenType.BAD_CHARACTER) {
            char c = element.textToCharArray()[0];
            this.report(JavaErrorKinds.ILLEGAL_CHARACTER.create(element, Character.valueOf(c)));
        }
    }

    public void visitErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            JavaErrorVisitor.$$$reportNull$$$0(11);
        }
        super.visitErrorElement(element);
        if (JavaSyntaxErrorChecker.shouldHighlightErrorElement((PsiErrorElement)element)) {
            this.report(JavaErrorKinds.SYNTAX_ERROR.create(element));
        }
    }

    public void visitRecordComponent(@NotNull PsiRecordComponent recordComponent) {
        if (recordComponent == null) {
            JavaErrorVisitor.$$$reportNull$$$0(12);
        }
        super.visitRecordComponent(recordComponent);
        if (!this.hasErrorResults()) {
            this.myRecordChecker.checkRecordComponentWellFormed(recordComponent);
        }
        if (!this.hasErrorResults()) {
            this.myRecordChecker.checkRecordAccessorReturnType(recordComponent);
        }
        if (!this.hasErrorResults()) {
            this.myControlFlowChecker.checkRecordComponentInitialized(recordComponent);
        }
    }

    public void visitStatement(@NotNull PsiStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(13);
        }
        super.visitStatement(statement);
        if (!this.hasErrorResults()) {
            this.myStatementChecker.checkNotAStatement(statement);
        }
    }

    public void visitTryStatement(@NotNull PsiTryStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(14);
        }
        super.visitTryStatement(statement);
        if (!this.hasErrorResults()) {
            UnhandledExceptions thrownTypes = UnhandledExceptions.fromTryStatement((PsiTryStatement)statement);
            if (thrownTypes.hasUnresolvedCalls()) {
                return;
            }
            for (PsiParameter parameter : statement.getCatchBlockParameters()) {
                this.myStatementChecker.checkExceptionAlreadyCaught(parameter);
                if (this.hasErrorResults()) continue;
                this.myStatementChecker.checkExceptionThrownInTry(parameter, thrownTypes.exceptions());
            }
        }
    }

    public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(15);
        }
        super.visitBreakStatement(statement);
        if (!this.hasErrorResults()) {
            this.myStatementChecker.checkBreakTarget(statement);
        }
    }

    public void visitYieldStatement(@NotNull PsiYieldStatement statement) {
        PsiExpression expression;
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(16);
        }
        super.visitYieldStatement(statement);
        if (!this.hasErrorResults()) {
            this.mySwitchChecker.checkYieldOutsideSwitchExpression(statement);
        }
        if (!this.hasErrorResults() && (expression = statement.getExpression()) != null) {
            this.mySwitchChecker.checkYieldExpressionType(expression);
        }
    }

    public void visitExpressionStatement(@NotNull PsiExpressionStatement statement) {
        PsiSwitchExpression expr;
        PsiSwitchLabeledRuleStatement ruleStatement;
        PsiSwitchBlock switchBlock;
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(17);
        }
        super.visitExpressionStatement(statement);
        PsiElement parent = statement.getParent();
        if (parent instanceof PsiSwitchLabeledRuleStatement && (switchBlock = (ruleStatement = (PsiSwitchLabeledRuleStatement)parent).getEnclosingSwitchBlock()) instanceof PsiSwitchExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)(expr = (PsiSwitchExpression)switchBlock))) {
            this.mySwitchChecker.checkYieldExpressionType(statement.getExpression());
        }
    }

    public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(18);
        }
        super.visitContinueStatement(statement);
        if (!this.hasErrorResults()) {
            this.myStatementChecker.checkContinueTarget(statement);
        }
    }

    public void visitTypeElement(@NotNull PsiTypeElement type) {
        if (type == null) {
            JavaErrorVisitor.$$$reportNull$$$0(19);
        }
        super.visitTypeElement(type);
        if (!this.hasErrorResults()) {
            this.myTypeChecker.checkIllegalType(type);
        }
        if (!this.hasErrorResults()) {
            this.myTypeChecker.checkVarTypeApplicability(type);
        }
        if (!this.hasErrorResults()) {
            this.myTypeChecker.checkArrayType(type);
        }
        if (!this.hasErrorResults()) {
            this.myGenericsChecker.checkReferenceTypeUsedAsTypeArgument(type);
        }
        if (!this.hasErrorResults()) {
            this.myGenericsChecker.checkWildcardUsage(type);
        }
        if (!this.hasErrorResults()) {
            this.checkPreviewFeature((PsiElement)type);
        }
    }

    public void visitParameter(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            JavaErrorVisitor.$$$reportNull$$$0(20);
        }
        super.visitParameter(parameter);
        PsiElement parent = parameter.getParent();
        if (parent instanceof PsiParameterList && parameter.isVarArgs()) {
            if (!this.hasErrorResults()) {
                this.checkFeature((PsiElement)parameter, JavaFeature.VARARGS);
            }
            if (!this.hasErrorResults()) {
                this.myMethodChecker.checkVarArgParameterWellFormed(parameter);
            }
        } else if (parent instanceof PsiCatchSection) {
            if (!this.hasErrorResults() && parameter.getType() instanceof PsiDisjunctionType) {
                this.checkFeature((PsiElement)parameter, JavaFeature.MULTI_CATCH);
            }
            if (!this.hasErrorResults()) {
                this.myTypeChecker.checkMustBeThrowable((PsiElement)parameter, parameter.getType());
            }
            if (!this.hasErrorResults()) {
                this.myStatementChecker.checkCatchTypeIsDisjoint(parameter);
            }
            if (!this.hasErrorResults()) {
                this.myGenericsChecker.checkCatchParameterIsClass(parameter);
            }
        } else if (parent instanceof PsiForeachStatement) {
            PsiForeachStatement forEach = (PsiForeachStatement)parent;
            this.checkFeature((PsiElement)forEach, JavaFeature.FOR_EACH);
            if (!this.hasErrorResults()) {
                this.myGenericsChecker.checkForEachParameterType(forEach, parameter);
            }
        }
    }

    public void visitAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            JavaErrorVisitor.$$$reportNull$$$0(21);
        }
        super.visitAnnotation(annotation);
        if (!this.hasErrorResults()) {
            this.checkFeature((PsiElement)annotation, JavaFeature.ANNOTATIONS);
        }
        this.myAnnotationChecker.checkAnnotation(annotation);
    }

    public void visitPackageStatement(@NotNull PsiPackageStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(22);
        }
        super.visitPackageStatement(statement);
        if (!this.hasErrorResults()) {
            this.myAnnotationChecker.checkPackageAnnotationContainingFile(statement);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkPackageNotAllowedInImplicitClass(statement);
        }
        if (this.isApplicable(JavaFeature.MODULES) && !this.hasErrorResults()) {
            this.myModuleChecker.checkPackageStatement(statement);
        }
    }

    public void visitReceiverParameter(@NotNull PsiReceiverParameter parameter) {
        if (parameter == null) {
            JavaErrorVisitor.$$$reportNull$$$0(23);
        }
        super.visitReceiverParameter(parameter);
        this.myReceiverChecker.checkReceiver(parameter);
    }

    public void visitNameValuePair(@NotNull PsiNameValuePair pair) {
        if (pair == null) {
            JavaErrorVisitor.$$$reportNull$$$0(24);
        }
        super.visitNameValuePair(pair);
        this.myAnnotationChecker.checkNameValuePair(pair);
    }

    public void visitEnumConstant(@NotNull PsiEnumConstant enumConstant) {
        if (enumConstant == null) {
            JavaErrorVisitor.$$$reportNull$$$0(25);
        }
        super.visitEnumConstant(enumConstant);
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkEnumWithAbstractMethods(enumConstant);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkUnhandledExceptions((PsiElement)enumConstant);
        }
        if (!this.hasErrorResults()) {
            PsiClassType type = this.factory().createType(Objects.requireNonNull(enumConstant.getContainingClass()));
            this.myExpressionChecker.checkConstructorCall(type.resolveGenerics(), (PsiConstructorCall)enumConstant, null);
        }
    }

    public void visitTemplateExpression(@NotNull PsiTemplateExpression expression) {
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(26);
        }
        super.visitTemplateExpression(expression);
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkTemplateExpression(expression);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkUnhandledExceptions((PsiElement)expression);
        }
    }

    public void visitTemplate(@NotNull PsiTemplate template) {
        if (template == null) {
            JavaErrorVisitor.$$$reportNull$$$0(27);
        }
        super.visitTemplate(template);
        this.checkFeature((PsiElement)template, JavaFeature.STRING_TEMPLATES);
        if (this.hasErrorResults()) {
            return;
        }
        for (PsiExpression embeddedExpression : template.getEmbeddedExpressions()) {
            if (!PsiTypes.voidType().equals((Object)embeddedExpression.getType())) continue;
            this.report(JavaErrorKinds.STRING_TEMPLATE_VOID_NOT_ALLOWED_IN_EMBEDDED.create(embeddedExpression));
        }
    }

    public void visitNewExpression(@NotNull PsiNewExpression expression) {
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(28);
        }
        super.visitNewExpression(expression);
        PsiType type = expression.getType();
        PsiClass aClass = PsiUtil.resolveClassInType((PsiType)type);
        if (aClass != null && !this.hasErrorResults()) {
            this.myClassChecker.checkIllegalInstantiation(aClass, (PsiExpression)expression);
        }
        if (!(aClass == null || type instanceof PsiArrayType || type instanceof PsiPrimitiveType || this.hasErrorResults())) {
            this.myExpressionChecker.checkCreateInnerClassFromStaticContext(expression, aClass);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkAnonymousInheritFinal(expression);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkAnonymousInheritProhibited(expression);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkAnonymousSealedProhibited(expression);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkQualifiedNew(expression, type, aClass);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkUnhandledExceptions((PsiElement)expression);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkNewExpression(expression, type);
        }
        if (!this.hasErrorResults()) {
            this.myGenericsChecker.checkTypeParameterInstantiation(expression);
        }
        if (!this.hasErrorResults()) {
            this.myGenericsChecker.checkGenericArrayCreation((PsiElement)expression, type);
        }
        if (!this.hasErrorResults()) {
            this.checkPreviewFeature((PsiElement)expression);
        }
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            JavaErrorVisitor.$$$reportNull$$$0(29);
        }
        super.visitComment(comment);
        if (!this.hasErrorResults()) {
            this.checkShebangComment(comment);
        }
        if (!this.hasErrorResults()) {
            this.checkUnclosedComment(comment);
        }
        if (!this.hasErrorResults()) {
            this.checkIllegalUnicodeEscapes((PsiElement)comment);
        }
    }

    public void visitDocComment(@NotNull PsiDocComment comment) {
        if (comment == null) {
            JavaErrorVisitor.$$$reportNull$$$0(30);
        }
        if (!this.hasErrorResults()) {
            this.checkUnclosedComment((PsiComment)comment);
        }
        if (!this.hasErrorResults()) {
            this.checkIllegalUnicodeEscapes((PsiElement)comment);
        }
    }

    public void visitFragment(@NotNull PsiFragment fragment) {
        if (fragment == null) {
            JavaErrorVisitor.$$$reportNull$$$0(31);
        }
        super.visitFragment(fragment);
        this.checkIllegalUnicodeEscapes((PsiElement)fragment);
        if (!this.hasErrorResults()) {
            this.myLiteralChecker.checkFragmentError(fragment);
        }
    }

    public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(32);
        }
        super.visitLiteralExpression(expression);
        if (!this.hasErrorResults() && expression.getParent() instanceof PsiCaseLabelElementList && expression.textMatches((CharSequence)"null")) {
            this.checkFeature((PsiElement)expression, JavaFeature.PATTERNS_IN_SWITCH);
        }
        if (!this.hasErrorResults()) {
            this.checkIllegalUnicodeEscapes((PsiElement)expression);
        }
        if (!this.hasErrorResults()) {
            this.myLiteralChecker.getLiteralExpressionParsingError(expression);
        }
    }

    public void visitTypeParameterList(@NotNull PsiTypeParameterList list) {
        PsiTypeParameter[] typeParameters;
        if (list == null) {
            JavaErrorVisitor.$$$reportNull$$$0(33);
        }
        if ((typeParameters = list.getTypeParameters()).length > 0) {
            this.checkFeature((PsiElement)list, JavaFeature.GENERICS);
            if (!this.hasErrorResults()) {
                this.myGenericsChecker.checkTypeParametersList(list, typeParameters);
            }
        }
    }

    public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
        PsiMethod psiMethod;
        PsiElement qualifier;
        PsiClass containingClass;
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(34);
        }
        this.visitElement((PsiElement)expression);
        this.checkFeature((PsiElement)expression, JavaFeature.METHOD_REFERENCES);
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
        if (JavaErrorVisitor.toReportFunctionalExpressionProblemOnParent(parent)) {
            return;
        }
        PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
        if (functionalInterfaceType != null && !PsiTypesUtil.allTypeParametersResolved((PsiElement)expression, (PsiType)functionalInterfaceType)) {
            return;
        }
        JavaResolveResult[] results = expression.multiResolve(true);
        JavaResolveResult result = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        PsiElement method = result.getElement();
        if (method instanceof PsiJvmMember) {
            PsiJvmMember member = (PsiJvmMember)method;
            if (!result.isAccessible()) {
                this.myModifierChecker.reportAccessProblem((PsiElement)expression, (PsiModifierListOwner)member, result);
                return;
            }
        }
        if (!(parent instanceof DummyHolder) && !LambdaUtil.isValidLambdaContext((PsiElement)parent)) {
            this.report(JavaErrorKinds.METHOD_REFERENCE_NOT_EXPECTED.create(expression));
            return;
        }
        if (!this.hasErrorResults()) {
            this.myFunctionChecker.checkMethodReferenceQualifier(expression);
        }
        if (!this.hasErrorResults()) {
            MethodCandidateInfo methodInfo;
            JavaResolveResult javaResolveResult;
            boolean resolvedButNonApplicable;
            boolean bl = resolvedButNonApplicable = results.length == 1 && (javaResolveResult = results[0]) instanceof MethodCandidateInfo && !(methodInfo = (MethodCandidateInfo)javaResolveResult).isApplicable() && functionalInterfaceType != null;
            if ((results.length != 1 || resolvedButNonApplicable) && expression.isConstructor() && (containingClass = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)expression).getContainingClass()) != null) {
                this.myClassChecker.checkIllegalInstantiation(containingClass, (PsiExpression)expression);
            }
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkUnhandledExceptions((PsiElement)expression);
        }
        if (!this.hasErrorResults() && (qualifier = expression.getQualifier()) instanceof PsiTypeElement) {
            PsiTypeElement typeElement = (PsiTypeElement)qualifier;
            PsiType psiType = typeElement.getType();
            this.myGenericsChecker.checkGenericArrayCreation(qualifier, psiType);
            if (this.hasErrorResults()) {
                return;
            }
        }
        if (method instanceof PsiMethod && (psiMethod = (PsiMethod)method).hasModifierProperty("static")) {
            if (!this.hasErrorResults() && psiMethod.hasTypeParameters()) {
                this.myGenericsChecker.checkParameterizedReferenceTypeArguments(method, (PsiJavaCodeReferenceElement)expression, result.getSubstitutor());
            }
            containingClass = psiMethod.getContainingClass();
            if (!this.hasErrorResults() && containingClass != null && containingClass.isInterface()) {
                this.myExpressionChecker.checkStaticInterfaceCallQualifier((PsiJavaCodeReferenceElement)expression, result, containingClass);
            }
        }
        if (!this.hasErrorResults()) {
            this.myFunctionChecker.checkRawConstructorReference(expression);
        }
        if (functionalInterfaceType != null) {
            if (!this.hasErrorResults()) {
                this.myFunctionChecker.checkExtendsSealedClass((PsiFunctionalExpression)expression, functionalInterfaceType);
            }
            boolean isFunctional = LambdaUtil.isFunctionalType((PsiType)functionalInterfaceType);
            if (!(this.hasErrorResults() || isFunctional || this.isIncompleteModel() && IncompleteModelUtil.isUnresolvedClassType((PsiType)functionalInterfaceType))) {
                this.report(JavaErrorKinds.LAMBDA_NOT_FUNCTIONAL_INTERFACE.create((PsiElement)expression, functionalInterfaceType));
            }
            if (!this.hasErrorResults()) {
                this.myFunctionChecker.checkMethodReferenceContext(expression, functionalInterfaceType);
            }
            if (!this.hasErrorResults()) {
                this.myFunctionChecker.checkFunctionalInterfaceTypeAccessible((PsiFunctionalExpression)expression, functionalInterfaceType);
            }
        }
        if (!this.hasErrorResults()) {
            this.myFunctionChecker.checkMethodReferenceResolve(expression, results, functionalInterfaceType);
        }
        if (!this.hasErrorResults()) {
            this.myFunctionChecker.checkMethodReferenceReturnType(expression, result, functionalInterfaceType);
        }
        if (!this.hasErrorResults() && method instanceof PsiModifierListOwner) {
            this.checkPreviewFeature((PsiElement)expression);
        }
    }

    public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(35);
        }
        this.myExpressionChecker.checkUnhandledExceptions((PsiElement)statement);
        if (!this.hasErrorResults()) {
            this.visitStatement((PsiStatement)statement);
        }
    }

    public void visitModifierList(@NotNull PsiModifierList list) {
        PsiClass aClass;
        if (list == null) {
            JavaErrorVisitor.$$$reportNull$$$0(36);
        }
        super.visitModifierList(list);
        PsiElement parent = list.getParent();
        if (parent instanceof PsiMethod) {
            JavaCompilationError<PsiMember, ?> error;
            List superMethodSignatures;
            PsiMethod method = (PsiMethod)parent;
            if (!this.hasErrorResults()) {
                this.myClassChecker.checkConstructorCallsBaseClassConstructor(method);
            }
            if (!this.hasErrorResults()) {
                this.myMethodChecker.checkMethodCanHaveBody(method);
            }
            if (!this.hasErrorResults()) {
                this.myMethodChecker.checkMethodMustHaveBody(method);
            }
            if (!this.hasErrorResults()) {
                this.myMethodChecker.checkStaticMethodOverride(method);
            }
            MethodSignatureBackedByPsiMethod methodSignature = MethodSignatureBackedByPsiMethod.create((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiClass aClass2 = method.getContainingClass();
            if (!method.isConstructor() && !(superMethodSignatures = method.getHierarchicalMethodSignature().getSuperSignatures()).isEmpty()) {
                if (!method.hasModifierProperty("static")) {
                    if (!this.hasErrorResults()) {
                        this.myMethodChecker.checkMethodWeakerPrivileges((PsiMember)method, methodSignature, superMethodSignatures);
                    }
                    if (!this.hasErrorResults()) {
                        this.myMethodChecker.checkMethodOverridesFinal(methodSignature, superMethodSignatures);
                    }
                }
                if (!this.hasErrorResults()) {
                    this.myMethodChecker.checkMethodIncompatibleReturnType((PsiMember)method, methodSignature, superMethodSignatures);
                }
                if (aClass2 != null && !this.hasErrorResults()) {
                    this.myMethodChecker.checkMethodIncompatibleThrows((PsiMember)method, methodSignature, superMethodSignatures, aClass2);
                }
            }
            if (!this.hasErrorResults() && aClass2 != null && (error = this.myGenericsChecker.computeOverrideEquivalentMethodErrors(aClass2).get(method)) != null) {
                this.report(error);
            }
        } else if (parent instanceof PsiClass && (aClass = (PsiClass)parent).getModifierList() == list) {
            JavaCompilationError<PsiMember, ?> error;
            if (!this.hasErrorResults()) {
                this.myClassChecker.checkDuplicateNestedClass(aClass);
            }
            if (!this.hasErrorResults() && !(aClass instanceof PsiAnonymousClass)) {
                this.myClassChecker.checkClassMustBeAbstract(aClass);
            }
            if (!this.hasErrorResults()) {
                this.myClassChecker.checkClassDoesNotCallSuperConstructorOrHandleExceptions(aClass);
            }
            if (!this.hasErrorResults()) {
                this.myClassChecker.checkCyclicInheritance(aClass);
            }
            if (!this.hasErrorResults()) {
                this.myMethodChecker.checkOverrideEquivalentInheritedMethods(aClass);
            }
            if (!this.hasErrorResults() && (error = this.myGenericsChecker.computeOverrideEquivalentMethodErrors(aClass).get(aClass)) != null) {
                this.report(error);
            }
        }
    }

    public void visitJavaFile(@NotNull PsiJavaFile file) {
        if (file == null) {
            JavaErrorVisitor.$$$reportNull$$$0(37);
        }
        super.visitJavaFile(file);
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkImplicitClassWellFormed(file);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkDuplicateClassesWithImplicit(file);
        }
    }

    public void visitJavaToken(@NotNull PsiJavaToken token) {
        PsiElement psiElement;
        if (token == null) {
            JavaErrorVisitor.$$$reportNull$$$0(38);
        }
        super.visitJavaToken(token);
        IElementType type = token.getTokenType();
        if (!this.hasErrorResults() && type == JavaTokenType.TEXT_BLOCK_LITERAL) {
            this.checkFeature((PsiElement)token, JavaFeature.TEXT_BLOCKS);
        }
        if (!this.hasErrorResults()) {
            this.myImportChecker.checkExtraSemicolonBetweenImportStatements(token, type);
        }
        if (!this.hasErrorResults() && type == JavaTokenType.RBRACE && (psiElement = token.getParent()) instanceof PsiCodeBlock) {
            PsiCodeBlock block = (PsiCodeBlock)psiElement;
            this.myControlFlowChecker.checkMissingReturn(block);
        }
    }

    public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
        if (initializer == null) {
            JavaErrorVisitor.$$$reportNull$$$0(39);
        }
        super.visitClassInitializer(initializer);
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkImplicitClassMember((PsiMember)initializer);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkIllegalInstanceMemberInRecord((PsiMember)initializer);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkThingNotAllowedInInterface((PsiMember)initializer);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkInitializersInImplicitClass(initializer);
        }
        if (!this.hasErrorResults()) {
            this.myControlFlowChecker.checkUnreachableStatement(initializer.getBody());
        }
        if (!this.hasErrorResults()) {
            this.myControlFlowChecker.checkInitializerCompleteNormally(initializer);
        }
    }

    public void visitField(@NotNull PsiField field) {
        if (field == null) {
            JavaErrorVisitor.$$$reportNull$$$0(40);
        }
        super.visitField(field);
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkIllegalInstanceMemberInRecord((PsiMember)field);
        }
        if (!this.hasErrorResults()) {
            this.myControlFlowChecker.checkFinalFieldInitialized(field);
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(41);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkConstructorCallProblems(expression);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkSuperAbstractMethodDirectCall(expression);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkEnumSuperConstructorCall(expression);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkSuperQualifierType(expression);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkMethodCall(expression);
        }
        if (!this.hasErrorResults()) {
            this.visitExpression((PsiExpression)expression);
        }
        if (!this.hasErrorResults()) {
            this.checkPreviewFeature((PsiElement)expression);
        }
    }

    public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(42);
        }
        super.visitReturnStatement(statement);
        if (!this.hasErrorResults()) {
            this.myStatementChecker.checkReturnStatement(statement);
        }
    }

    public void visitReferenceParameterList(@NotNull PsiReferenceParameterList list) {
        if (list == null) {
            JavaErrorVisitor.$$$reportNull$$$0(43);
        }
        super.visitReferenceParameterList(list);
        if (list.getTextLength() == 0) {
            return;
        }
        this.checkFeature((PsiElement)list, JavaFeature.GENERICS);
        if (!this.hasErrorResults()) {
            for (PsiTypeElement typeElement : list.getTypeParameterElements()) {
                if (!(typeElement.getType() instanceof PsiDiamondType)) continue;
                this.checkFeature((PsiElement)list, JavaFeature.DIAMOND_TYPES);
            }
        }
        if (!this.hasErrorResults()) {
            this.myGenericsChecker.checkParametersAllowed(list);
        }
        if (!this.hasErrorResults()) {
            this.myGenericsChecker.checkParametersOnRaw(list);
        }
    }

    public void visitIdentifier(@NotNull PsiIdentifier identifier) {
        PsiElement parent;
        if (identifier == null) {
            JavaErrorVisitor.$$$reportNull$$$0(44);
        }
        if ((parent = identifier.getParent()) instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)parent;
            this.myStatementChecker.checkVariableAlreadyDefined(variable);
            if (variable.isUnnamed()) {
                this.checkFeature((PsiElement)variable, JavaFeature.UNNAMED_PATTERNS_AND_VARIABLES);
                if (!this.hasErrorResults()) {
                    this.myExpressionChecker.checkUnnamedVariableDeclaration(variable);
                }
            } else if (variable instanceof PsiField) {
                PsiField field = (PsiField)variable;
                this.myClassChecker.checkImplicitClassMember((PsiMember)field);
            }
        } else if (parent instanceof PsiClass) {
            PsiClass aClass = (PsiClass)parent;
            if (aClass.isAnnotationType()) {
                this.checkFeature((PsiElement)identifier, JavaFeature.ANNOTATIONS);
            }
            if (!this.hasErrorResults()) {
                this.myClassChecker.checkClassAlreadyImported(aClass);
            }
            if (!this.hasErrorResults()) {
                this.myClassChecker.checkClassRestrictedKeyword(identifier);
            }
            if (!this.hasErrorResults()) {
                this.myGenericsChecker.checkUnrelatedConcrete(aClass);
            }
            if (!this.hasErrorResults() && this.isApplicable(JavaFeature.EXTENSION_METHODS)) {
                this.myMethodChecker.checkUnrelatedDefaultMethods(aClass);
            }
        } else if (parent instanceof PsiMethod) {
            PsiClass aClass;
            PsiMethod method = (PsiMethod)parent;
            this.myClassChecker.checkImplicitClassMember((PsiMember)method);
            if (method.isConstructor()) {
                this.myMethodChecker.checkConstructorName(method);
            }
            if ((aClass = method.getContainingClass()) != null) {
                this.myGenericsChecker.checkDefaultMethodOverridesMemberOfJavaLangObject(aClass, method);
            }
        }
        this.myExpressionChecker.checkUnderscore(identifier);
    }

    public void visitKeyword(@NotNull PsiKeyword keyword) {
        PsiElement parent;
        if (keyword == null) {
            JavaErrorVisitor.$$$reportNull$$$0(45);
        }
        super.visitKeyword(keyword);
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkStaticDeclarationInInnerClass(keyword);
        }
        if (!this.hasErrorResults()) {
            this.myTypeChecker.checkIllegalVoidType(keyword);
        }
        if ((parent = keyword.getParent()) instanceof PsiModifierList) {
            PsiModifierList psiModifierList = (PsiModifierList)parent;
            if (!this.hasErrorResults()) {
                this.myModifierChecker.checkNotAllowedModifier(keyword, psiModifierList);
            }
            if (!this.hasErrorResults()) {
                this.myModifierChecker.checkIllegalModifierCombination(keyword, psiModifierList);
            }
            PsiElement pParent = psiModifierList.getParent();
            String text = keyword.getText();
            if ("abstract".equals(text) && pParent instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)pParent;
                if (!this.hasErrorResults()) {
                    this.myMethodChecker.checkAbstractMethodInConcreteClass(psiMethod, keyword);
                }
            } else if (pParent instanceof PsiEnumConstant) {
                this.report(JavaErrorKinds.ENUM_CONSTANT_MODIFIER.create(keyword));
            }
        }
    }

    public void visitLabeledStatement(@NotNull PsiLabeledStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(46);
        }
        super.visitLabeledStatement(statement);
        if (!this.hasErrorResults()) {
            this.myStatementChecker.checkLabelWithoutStatement(statement);
        }
        if (!this.hasErrorResults()) {
            this.myStatementChecker.checkLabelAlreadyInUse(statement);
        }
    }

    public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(47);
        }
        super.visitSwitchExpression(expression);
        this.mySwitchChecker.checkSwitchBlock((PsiSwitchBlock)expression);
        if (!this.hasErrorResults()) {
            this.checkFeature(expression.getFirstChild(), JavaFeature.SWITCH_EXPRESSION);
        }
        if (!this.hasErrorResults()) {
            this.mySwitchChecker.checkSwitchExpressionReturnTypeCompatible(expression);
        }
        if (!this.hasErrorResults()) {
            this.mySwitchChecker.checkSwitchExpressionHasResult(expression);
        }
    }

    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(48);
        }
        super.visitSwitchStatement(statement);
        this.mySwitchChecker.checkSwitchBlock((PsiSwitchBlock)statement);
    }

    public void visitModule(@NotNull PsiJavaModule module) {
        if (module == null) {
            JavaErrorVisitor.$$$reportNull$$$0(49);
        }
        super.visitModule(module);
        if (!this.hasErrorResults()) {
            this.checkFeature((PsiElement)module, JavaFeature.MODULES);
        }
        if (!this.hasErrorResults()) {
            this.myModuleChecker.checkFileName(module);
        }
        if (!this.hasErrorResults()) {
            this.myModuleChecker.checkFileDuplicates(module);
        }
        if (!this.hasErrorResults()) {
            this.myModuleChecker.checkDuplicateStatements(module);
        }
        if (!this.hasErrorResults()) {
            this.myModuleChecker.checkClashingReads(module);
        }
        if (!this.hasErrorResults()) {
            this.myModuleChecker.checkFileLocation(module);
        }
    }

    public void visitProvidesStatement(@NotNull PsiProvidesStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(50);
        }
        super.visitProvidesStatement(statement);
        if (this.isApplicable(JavaFeature.MODULES) && !this.hasErrorResults()) {
            this.myModuleChecker.checkServiceImplementations(statement);
        }
    }

    public void visitRequiresStatement(@NotNull PsiRequiresStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(51);
        }
        super.visitRequiresStatement(statement);
        if (this.isApplicable(JavaFeature.MODULES)) {
            if (!this.hasErrorResults() && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_10)) {
                this.myModuleChecker.checkModifiers(statement);
            }
            if (!this.hasErrorResults()) {
                this.myModuleChecker.checkModuleReference(statement);
            }
        }
    }

    public void visitPackageAccessibilityStatement(@NotNull PsiPackageAccessibilityStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(52);
        }
        super.visitPackageAccessibilityStatement(statement);
        if (this.isApplicable(JavaFeature.MODULES)) {
            if (!this.hasErrorResults()) {
                this.myModuleChecker.checkHostModuleStrength(statement);
            }
            if (!this.hasErrorResults()) {
                this.myModuleChecker.checkDuplicateModuleReferences(statement);
            }
            if (!this.hasErrorResults()) {
                this.myModuleChecker.checkPackageReference(statement);
            }
        }
    }

    public void visitModuleStatement(@NotNull PsiStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(53);
        }
        super.visitModuleStatement(statement);
        if (!this.hasErrorResults()) {
            this.checkPreviewFeature((PsiElement)statement);
        }
    }

    public void visitUsesStatement(@NotNull PsiUsesStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(54);
        }
        super.visitUsesStatement(statement);
        if (this.isApplicable(JavaFeature.MODULES) && !this.hasErrorResults()) {
            this.myModuleChecker.checkServiceReference(statement.getClassReference());
        }
    }

    public void visitImportModuleStatement(@NotNull PsiImportModuleStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(55);
        }
        super.visitImportModuleStatement(statement);
        if (!this.hasErrorResults()) {
            this.checkFeature((PsiElement)statement, JavaFeature.MODULE_IMPORT_DECLARATIONS);
        }
        if (!this.hasErrorResults()) {
            this.myImportChecker.checkImportModuleInModuleInfo(statement);
        }
        if (!this.hasErrorResults()) {
            this.myModuleChecker.checkModuleReference(statement);
        }
    }

    public void visitImportStaticReferenceElement(@NotNull PsiImportStaticReferenceElement ref) {
        if (ref == null) {
            JavaErrorVisitor.$$$reportNull$$$0(56);
        }
        this.myImportChecker.checkImportStaticReferenceElement(ref);
    }

    public void visitImportStatement(@NotNull PsiImportStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(57);
        }
        super.visitImportStatement(statement);
        if (!this.hasErrorResults()) {
            this.myImportChecker.checkSingleImportClassConflict(statement);
        }
        if (!this.hasErrorResults()) {
            this.checkPreviewFeature((PsiElement)statement);
        }
    }

    public void visitResourceList(@NotNull PsiResourceList resourceList) {
        if (resourceList == null) {
            JavaErrorVisitor.$$$reportNull$$$0(58);
        }
        super.visitResourceList(resourceList);
        if (!this.hasErrorResults()) {
            this.checkFeature((PsiElement)resourceList, JavaFeature.TRY_WITH_RESOURCES);
        }
    }

    public void visitResourceVariable(@NotNull PsiResourceVariable resource) {
        if (resource == null) {
            JavaErrorVisitor.$$$reportNull$$$0(59);
        }
        super.visitResourceVariable(resource);
        if (!this.hasErrorResults()) {
            this.myStatementChecker.checkTryResourceIsAutoCloseable((PsiResourceListElement)resource);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkUnhandledCloserExceptions((PsiResourceListElement)resource);
        }
    }

    public void visitResourceExpression(@NotNull PsiResourceExpression resource) {
        if (resource == null) {
            JavaErrorVisitor.$$$reportNull$$$0(60);
        }
        super.visitResourceExpression(resource);
        if (!this.hasErrorResults()) {
            this.checkFeature((PsiElement)resource, JavaFeature.REFS_AS_RESOURCE);
        }
        if (!this.hasErrorResults()) {
            this.myStatementChecker.checkTryResourceIsAutoCloseable((PsiResourceListElement)resource);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkUnhandledCloserExceptions((PsiResourceListElement)resource);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkResourceVariableIsFinal(resource);
        }
    }

    public void visitImportStaticStatement(@NotNull PsiImportStaticStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(61);
        }
        this.visitElement((PsiElement)statement);
        this.checkFeature((PsiElement)statement, JavaFeature.STATIC_IMPORTS);
        if (!this.hasErrorResults()) {
            this.myImportChecker.checkStaticOnDemandImportResolvesToClass(statement);
        }
        if (!this.hasErrorResults()) {
            PsiElement referenceNameElement;
            PsiJavaCodeReferenceElement importReference = statement.getImportReference();
            PsiClass targetClass = statement.resolveTargetClass();
            if (importReference != null && (referenceNameElement = importReference.getReferenceNameElement()) != null && targetClass != null) {
                this.myGenericsChecker.checkClassSupersAccessibility(targetClass, referenceNameElement, this.myPsiFile.getResolveScope());
            }
        }
        if (!this.hasErrorResults()) {
            this.checkPreviewFeature((PsiElement)statement);
        }
    }

    public void visitClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaErrorVisitor.$$$reportNull$$$0(62);
        }
        super.visitClass(aClass);
        if (aClass instanceof PsiSyntheticClass) {
            return;
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkDuplicateTopLevelClass(aClass);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkMustNotBeLocal(aClass);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkClassAndPackageConflict(aClass);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkPublicClassInRightFile(aClass);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkSealedClassInheritors(aClass);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkSealedSuper(aClass);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkImplicitThisReferenceBeforeSuper(aClass);
        }
        if (!this.hasErrorResults()) {
            this.myGenericsChecker.checkInterfaceMultipleInheritance(aClass);
        }
        if (!this.hasErrorResults()) {
            this.myGenericsChecker.checkClassSupersAccessibility(aClass);
        }
        if (!this.hasErrorResults()) {
            this.myRecordChecker.checkRecordHeader(aClass);
        }
        if (!this.hasErrorResults()) {
            this.myGenericsChecker.checkTypeParameterOverrideEquivalentMethods(aClass);
        }
    }

    public void visitVariable(@NotNull PsiVariable variable) {
        if (variable == null) {
            JavaErrorVisitor.$$$reportNull$$$0(63);
        }
        super.visitVariable(variable);
        if (variable instanceof PsiPatternVariable) {
            PsiPatternVariable patternVariable = (PsiPatternVariable)variable;
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiInstanceOfExpression.class, PsiCaseLabelElementList.class, PsiForeachPatternStatement.class});
            if (!(context instanceof PsiForeachPatternStatement)) {
                JavaFeature feature = context instanceof PsiInstanceOfExpression ? JavaFeature.PATTERNS : JavaFeature.PATTERNS_IN_SWITCH;
                this.checkFeature((PsiElement)patternVariable.getNameIdentifier(), feature);
            }
        }
        if (!this.hasErrorResults()) {
            this.myTypeChecker.checkVarTypeApplicability(variable);
        }
        if (!this.hasErrorResults()) {
            this.myTypeChecker.checkVariableInitializerType(variable);
        }
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        PsiMethodCallExpression methodCallExpression;
        JavaResolveResult[] results;
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(64);
        }
        this.visitElement((PsiElement)expression);
        JavaResolveResult resultForIncompleteCode = this.doVisitReferenceElement((PsiJavaCodeReferenceElement)expression);
        if (!this.hasErrorResults()) {
            this.visitExpression((PsiExpression)expression);
            if (this.hasErrorResults()) {
                return;
            }
        }
        if ((results = this.resolveOptimised(expression)) == null) {
            return;
        }
        JavaResolveResult result = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        PsiElement resolved = result.getElement();
        PsiElement parent = expression.getParent();
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        if (resolved instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)resolved;
            if (resolved.getContainingFile() == expression.getContainingFile()) {
                boolean isFinal;
                if (!this.hasErrorResults() && resolved instanceof PsiLocalVariable) {
                    PsiLocalVariable localVariable = (PsiLocalVariable)resolved;
                    this.myExpressionChecker.checkVarTypeSelfReferencing(localVariable, expression);
                }
                if ((isFinal = variable.hasModifierProperty("final")) && !variable.hasInitializer() && !(variable instanceof PsiPatternVariable) && !this.hasErrorResults()) {
                    this.myControlFlowChecker.checkFinalVariableMightAlreadyHaveBeenAssignedTo(variable, expression);
                }
                if (!this.hasErrorResults()) {
                    this.myControlFlowChecker.checkVariableInitializedBeforeUsage(variable, expression);
                }
            }
        }
        if (!(!(parent instanceof PsiMethodCallExpression) || (methodCallExpression = (PsiMethodCallExpression)parent).getMethodExpression() != expression || result.isAccessible() && result.isStaticsScopeCorrect())) {
            PsiElement nameElement;
            this.myExpressionChecker.checkAmbiguousMethodCallIdentifier(results, result, methodCallExpression);
            if (!PsiTreeUtil.findChildrenOfType((PsiElement)methodCallExpression.getArgumentList(), PsiLambdaExpression.class).isEmpty() && (nameElement = expression.getReferenceNameElement()) != null) {
                this.myExpressionChecker.checkAmbiguousMethodCallArguments(results, result, methodCallExpression);
            }
        }
        if (!this.hasErrorResults() && this.myJavaModule == null && qualifierExpression != null) {
            PsiClass psiClass;
            if (parent instanceof PsiMethodCallExpression && (psiClass = RefactoringChangeUtil.getQualifierClass((PsiReferenceExpression)expression)) != null) {
                this.myGenericsChecker.checkClassSupersAccessibility(psiClass, (PsiElement)expression, this.myPsiFile.getResolveScope());
            }
            if (!this.hasErrorResults()) {
                this.myGenericsChecker.checkMemberSignatureTypesAccessibility(expression);
            }
        }
        if (!this.hasErrorResults() && resultForIncompleteCode != null && this.isApplicable(JavaFeature.PATTERNS_IN_SWITCH)) {
            this.myPatternChecker.checkPatternVariableRequired(expression, resultForIncompleteCode);
        }
        if (!this.hasErrorResults() && resultForIncompleteCode != null) {
            this.myExpressionChecker.checkExpressionRequired(expression, resultForIncompleteCode);
        }
        if (!this.hasErrorResults() && resolved instanceof PsiField) {
            PsiField field = (PsiField)resolved;
            this.myExpressionChecker.checkIllegalForwardReferenceToField(expression, field);
        }
        if (!this.hasErrorResults()) {
            this.myGenericsChecker.checkAccessStaticFieldFromEnumConstructor(expression, result);
        }
        this.myExpressionChecker.checkUnqualifiedSuperInDefaultMethod(expression, qualifierExpression);
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkClassReferenceAfterQualifier(expression, resolved);
        }
        if (!this.hasErrorResults() && resolved instanceof PsiModifierListOwner) {
            this.checkPreviewFeature((PsiElement)expression);
        }
    }

    public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expression) {
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(65);
        }
        super.visitArrayInitializerExpression(expression);
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkArrayInitializerApplicable(expression);
        }
        if (!(expression.getParent() instanceof PsiNewExpression) && !this.hasErrorResults()) {
            this.myGenericsChecker.checkGenericArrayCreation((PsiElement)expression, expression.getType());
        }
    }

    public void visitPatternVariable(@NotNull PsiPatternVariable variable) {
        if (variable == null) {
            JavaErrorVisitor.$$$reportNull$$$0(66);
        }
        super.visitPatternVariable(variable);
        this.myPatternChecker.checkDeconstructionVariable(variable);
    }

    public void visitDeconstructionPattern(@NotNull PsiDeconstructionPattern deconstructionPattern) {
        if (deconstructionPattern == null) {
            JavaErrorVisitor.$$$reportNull$$$0(67);
        }
        super.visitDeconstructionPattern(deconstructionPattern);
        this.myPatternChecker.checkDeconstructionPattern(deconstructionPattern);
    }

    public void visitDeconstructionList(@NotNull PsiDeconstructionList deconstructionList) {
        if (deconstructionList == null) {
            JavaErrorVisitor.$$$reportNull$$$0(68);
        }
        super.visitDeconstructionList(deconstructionList);
        PsiElement psiElement = deconstructionList.getParent();
        if (psiElement instanceof PsiDeconstructionPattern) {
            PsiDeconstructionPattern pattern = (PsiDeconstructionPattern)psiElement;
            this.myPatternChecker.checkMalformedDeconstructionPatternInCase(pattern);
        }
    }

    public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(69);
        }
        super.visitInstanceOfExpression(expression);
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkInstanceOfApplicable(expression);
        }
        if (!this.hasErrorResults()) {
            this.myGenericsChecker.checkInstanceOfGenericType(expression);
        }
        if (!this.hasErrorResults() && this.isApplicable(JavaFeature.PATTERNS) && !this.isApplicable(JavaFeature.PATTERN_GUARDS_AND_RECORD_PATTERNS)) {
            this.myPatternChecker.checkInstanceOfPatternSupertype(expression);
        }
    }

    public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
        PsiExpression[] sides;
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(70);
        }
        super.visitConditionalExpression(expression);
        if (!this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) || !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)expression)) {
            return;
        }
        PsiExpression thenExpression = expression.getThenExpression();
        PsiExpression elseExpression = expression.getElseExpression();
        if (thenExpression == null || elseExpression == null) {
            return;
        }
        PsiType conditionalType = expression.getType();
        if (conditionalType == null) {
            return;
        }
        for (PsiExpression side : sides = new PsiExpression[]{thenExpression, elseExpression}) {
            PsiType sideType = side.getType();
            if (sideType == null || TypeConversionUtil.isAssignable((PsiType)conditionalType, (PsiType)sideType)) continue;
            this.myExpressionChecker.checkAssignability(conditionalType, sideType, side, (PsiElement)side);
        }
    }

    public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
        PsiElement psiElement;
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(71);
        }
        this.checkFeature((PsiElement)expression, JavaFeature.LAMBDA_EXPRESSIONS);
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
        if (JavaErrorVisitor.toReportFunctionalExpressionProblemOnParent(parent)) {
            return;
        }
        if (!this.hasErrorResults() && !LambdaUtil.isValidLambdaContext((PsiElement)parent)) {
            this.report(JavaErrorKinds.LAMBDA_NOT_EXPECTED.create(expression));
        }
        if (!this.hasErrorResults()) {
            this.myFunctionChecker.checkConsistentParameterDeclaration(expression);
        }
        PsiType functionalInterfaceType = null;
        if (!this.hasErrorResults()) {
            functionalInterfaceType = expression.getFunctionalInterfaceType();
            if (functionalInterfaceType != null) {
                this.myFunctionChecker.checkExtendsSealedClass((PsiFunctionalExpression)expression, functionalInterfaceType);
                if (!this.hasErrorResults()) {
                    this.myFunctionChecker.checkInterfaceFunctional((PsiFunctionalExpression)expression, functionalInterfaceType);
                }
                if (!this.hasErrorResults()) {
                    this.myFunctionChecker.checkFunctionalInterfaceTypeAccessible((PsiFunctionalExpression)expression, functionalInterfaceType);
                }
            } else if (LambdaUtil.getFunctionalInterfaceType((PsiElement)expression, (boolean)true) != null) {
                this.report(JavaErrorKinds.LAMBDA_TYPE_INFERENCE_FAILURE.create((PsiFunctionalExpression)expression));
            }
        }
        if (!this.hasErrorResults() && functionalInterfaceType != null) {
            this.myFunctionChecker.checkLambdaTypeApplicability(expression, parent, functionalInterfaceType);
        }
        if (!this.hasErrorResults() && functionalInterfaceType != null) {
            this.myFunctionChecker.checkParametersCompatible(expression, functionalInterfaceType);
        }
        if (!this.hasErrorResults() && (psiElement = expression.getBody()) instanceof PsiCodeBlock) {
            PsiCodeBlock block = (PsiCodeBlock)psiElement;
            this.myControlFlowChecker.checkUnreachableStatement(block);
        }
    }

    private static boolean toReportFunctionalExpressionProblemOnParent(@Nullable PsiElement parent) {
        if (parent instanceof PsiLocalVariable) {
            PsiLocalVariable variable = (PsiLocalVariable)parent;
            return variable.getTypeElement().isInferredType();
        }
        return parent instanceof PsiExpressionStatement && !(parent.getParent() instanceof PsiSwitchLabeledRuleStatement);
    }

    public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(72);
        }
        super.visitTypeCastExpression(expression);
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkIntersectionInTypeCast(expression);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkInconvertibleTypeCast(expression);
        }
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement ref) {
        JavaResolveResult result;
        if (ref == null) {
            JavaErrorVisitor.$$$reportNull$$$0(73);
        }
        JavaResolveResult javaResolveResult = result = ref instanceof PsiExpression ? JavaErrorVisitor.resolveOptimised(ref, this.myPsiFile) : this.doVisitReferenceElement(ref);
        if (result != null) {
            PsiElement resolved = result.getElement();
            if (!this.hasErrorResults() && resolved instanceof PsiClass) {
                PsiClass aClass = (PsiClass)resolved;
                this.mySwitchChecker.checkLocalClassReferencedFromAnotherSwitchBranch(ref, aClass);
            }
            if (!this.hasErrorResults()) {
                this.myGenericsChecker.checkRawOnParameterizedType(ref, resolved);
            }
            if (!this.hasErrorResults()) {
                this.myExpressionChecker.checkAmbiguousConstructorCall(ref, resolved);
            }
            if (!this.hasErrorResults() && resolved instanceof PsiModifierListOwner) {
                this.checkPreviewFeature((PsiElement)ref);
            }
        }
    }

    public void visitSwitchLabelStatement(@NotNull PsiSwitchLabelStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(74);
        }
        super.visitSwitchLabelStatement(statement);
        if (!this.hasErrorResults()) {
            this.mySwitchChecker.checkCaseStatement((PsiSwitchLabelStatementBase)statement);
        }
        if (!this.hasErrorResults()) {
            this.mySwitchChecker.checkGuard((PsiSwitchLabelStatementBase)statement);
        }
    }

    public void visitSwitchLabeledRuleStatement(@NotNull PsiSwitchLabeledRuleStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(75);
        }
        super.visitSwitchLabeledRuleStatement(statement);
        if (!this.hasErrorResults()) {
            this.mySwitchChecker.checkCaseStatement((PsiSwitchLabelStatementBase)statement);
        }
        if (!this.hasErrorResults()) {
            this.mySwitchChecker.checkGuard((PsiSwitchLabelStatementBase)statement);
        }
    }

    private JavaResolveResult doVisitReferenceElement(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiAnonymousClass psiAnonymousClass;
        PsiClass psiClass;
        PsiNewExpression newExpression;
        JavaResolveResult result;
        if (ref == null) {
            JavaErrorVisitor.$$$reportNull$$$0(76);
        }
        if ((result = JavaErrorVisitor.resolveOptimised(ref, this.myPsiFile)) == null) {
            return null;
        }
        PsiElement resolved = result.getElement();
        PsiElement parent = ref.getParent();
        this.myExpressionChecker.checkReference(ref, result);
        if (resolved != null && parent instanceof PsiReferenceList) {
            PsiReferenceList referenceList = (PsiReferenceList)parent;
            if (!this.hasErrorResults()) {
                this.checkElementInReferenceList(ref, referenceList, result);
            }
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkSelectFromTypeParameter(ref, resolved);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkAbstractInstantiation(ref);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkExtendsDuplicate(ref, resolved);
        }
        if (!this.hasErrorResults()) {
            this.myClassChecker.checkClassExtendsForeignInnerClass(ref, resolved);
        }
        if (!this.hasErrorResults()) {
            this.myGenericsChecker.checkSelectStaticClassFromParameterizedType(resolved, ref);
        }
        if (parent instanceof PsiNewExpression) {
            newExpression = (PsiNewExpression)parent;
            if (!this.hasErrorResults()) {
                this.myGenericsChecker.checkDiamondTypeNotAllowed(newExpression);
            }
            if (!this.hasErrorResults() && !(resolved instanceof PsiClass) && resolved instanceof PsiNamedElement && newExpression.getClassOrAnonymousClassReference() == ref) {
                this.report(JavaErrorKinds.REFERENCE_UNRESOLVED.create(ref));
            }
        }
        if (!(this.hasErrorResults() || parent instanceof PsiNewExpression && (newExpression = (PsiNewExpression)parent).isArrayCreation())) {
            this.myGenericsChecker.checkParameterizedReferenceTypeArguments(resolved, ref, result.getSubstitutor());
        }
        if (!this.hasErrorResults() && resolved instanceof PsiClass) {
            psiClass = (PsiClass)resolved;
            PsiClass aClass = psiClass.getContainingClass();
            if (aClass != null) {
                Object place;
                PsiElement qualifier = ref.getQualifier();
                if (qualifier instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)qualifier;
                    place = element.resolve();
                } else {
                    PsiNewExpression newExpression2;
                    PsiExpression newQualifier;
                    place = parent instanceof PsiNewExpression ? ((newQualifier = (newExpression2 = (PsiNewExpression)parent).getQualifier()) == null ? ref : PsiUtil.resolveClassInType((PsiType)newQualifier.getType())) : ref;
                }
                if (place != null && PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)place, (boolean)false) && aClass.hasTypeParameters() && !PsiUtil.isInsideJavadocComment((PsiElement)place)) {
                    this.myExpressionChecker.checkCreateInnerClassFromStaticContext((PsiElement)ref, (PsiElement)place, psiClass);
                }
            } else if (resolved instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)resolved;
                this.myGenericsChecker.checkTypeParameterReference(ref, typeParameter);
            }
        }
        if (parent instanceof PsiAnonymousClass && ref.equals((Object)(psiAnonymousClass = (PsiAnonymousClass)parent).getBaseClassReference())) {
            JavaCompilationError<PsiMember, ?> error;
            if (!this.hasErrorResults()) {
                this.myGenericsChecker.checkGenericCannotExtendException(psiAnonymousClass);
            }
            if (!this.hasErrorResults() && (error = this.myGenericsChecker.computeOverrideEquivalentMethodErrors((PsiClass)psiAnonymousClass).get(psiAnonymousClass)) != null) {
                this.report(error);
            }
        }
        if (!this.hasErrorResults() && resolved instanceof PsiClass) {
            psiClass = (PsiClass)resolved;
            this.myExpressionChecker.checkRestrictedIdentifierReference(ref, psiClass);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkMemberReferencedBeforeConstructorCalled((PsiElement)ref, resolved);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkPackageAndClassConflict(ref);
        }
        return result;
    }

    private void checkShebangComment(@NotNull PsiComment comment) {
        VirtualFile file;
        if (comment == null) {
            JavaErrorVisitor.$$$reportNull$$$0(77);
        }
        if (comment.getTextOffset() != 0) {
            return;
        }
        if (comment.getText().startsWith("#!") && (file = PsiUtilCore.getVirtualFile((PsiElement)comment)) != null && "java".equals(file.getExtension())) {
            this.report(JavaErrorKinds.COMMENT_SHEBANG_JAVA_FILE.create(comment));
        }
    }

    private void checkUnclosedComment(@NotNull PsiComment comment) {
        if (comment == null) {
            JavaErrorVisitor.$$$reportNull$$$0(78);
        }
        if (!(comment instanceof PsiDocComment) && comment.getTokenType() != JavaTokenType.C_STYLE_COMMENT) {
            return;
        }
        String text = comment.getText();
        if (text.startsWith("/*") && !text.endsWith("*/")) {
            this.report(JavaErrorKinds.COMMENT_UNCLOSED.create(comment));
        }
    }

    private void checkIllegalUnicodeEscapes(@NotNull PsiElement element) {
        if (element == null) {
            JavaErrorVisitor.$$$reportNull$$$0(79);
        }
        LiteralChecker.parseUnicodeEscapes(element.getText(), (start, end) -> this.report(JavaErrorKinds.ILLEGAL_UNICODE_ESCAPE.create(element, TextRange.create((int)start, (int)end))));
    }

    private void checkElementInReferenceList(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiReferenceList referenceList, @NotNull JavaResolveResult resolveResult) {
        PsiMethod method;
        if (ref == null) {
            JavaErrorVisitor.$$$reportNull$$$0(80);
        }
        if (referenceList == null) {
            JavaErrorVisitor.$$$reportNull$$$0(81);
        }
        if (resolveResult == null) {
            JavaErrorVisitor.$$$reportNull$$$0(82);
        }
        PsiElement resolved = resolveResult.getElement();
        PsiElement refGrandParent = referenceList.getParent();
        if (resolved instanceof PsiClass) {
            PsiMethod method2;
            PsiClass aClass = (PsiClass)resolved;
            if (refGrandParent instanceof PsiClass) {
                PsiClass parentClass = (PsiClass)refGrandParent;
                if (refGrandParent instanceof PsiTypeParameter) {
                    PsiTypeParameter typeParameter = (PsiTypeParameter)refGrandParent;
                    this.myGenericsChecker.checkElementInTypeParameterExtendsList(referenceList, typeParameter, resolveResult, ref);
                } else if (referenceList.equals((Object)parentClass.getImplementsList()) || referenceList.equals((Object)parentClass.getExtendsList())) {
                    this.myClassChecker.checkExtendsClassAndImplementsInterface(referenceList, aClass, ref);
                    if (!this.hasErrorResults() && referenceList.equals((Object)parentClass.getExtendsList())) {
                        this.myClassChecker.checkValueClassExtends(aClass, parentClass, ref);
                    }
                    if (!this.hasErrorResults()) {
                        this.myClassChecker.checkCannotInheritFromFinal(aClass, ref);
                    }
                    if (!this.hasErrorResults()) {
                        this.myClassChecker.checkExtendsProhibitedClass(aClass, parentClass, ref);
                    }
                    if (!this.hasErrorResults()) {
                        this.myClassChecker.checkExtendsSealedClass(parentClass, aClass, ref);
                    }
                    if (!this.hasErrorResults()) {
                        this.myGenericsChecker.checkCannotInheritFromTypeParameter(aClass, ref);
                    }
                }
            } else if (refGrandParent instanceof PsiMethod && (method2 = (PsiMethod)refGrandParent).getThrowsList() == referenceList) {
                this.myMethodChecker.checkMustBeThrowable(aClass, ref);
            }
        } else if (refGrandParent instanceof PsiMethod && referenceList == (method = (PsiMethod)refGrandParent).getThrowsList()) {
            this.report(JavaErrorKinds.METHOD_THROWS_CLASS_NAME_EXPECTED.create(ref));
        }
    }

    private JavaResolveResult @Nullable [] resolveOptimised(@NotNull PsiReferenceExpression expression) {
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(83);
        }
        try {
            if (expression instanceof PsiReferenceExpressionImpl) {
                PsiReferenceExpressionImpl.OurGenericsResolver resolver = PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE;
                return JavaResolveUtil.resolveWithContainingFile((PsiPolyVariantReference)expression, (ResolveCache.PolyVariantContextResolver)resolver, (boolean)true, (boolean)true, (PsiFile)this.myPsiFile);
            }
            return expression.multiResolve(true);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Nullable
    static JavaResolveResult resolveOptimised(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiFile containingFile) {
        if (ref == null) {
            JavaErrorVisitor.$$$reportNull$$$0(84);
        }
        if (containingFile == null) {
            JavaErrorVisitor.$$$reportNull$$$0(85);
        }
        try {
            if (ref instanceof PsiReferenceExpressionImpl) {
                PsiReferenceExpressionImpl.OurGenericsResolver resolver = PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE;
                JavaResolveResult[] results = JavaResolveUtil.resolveWithContainingFile((PsiPolyVariantReference)ref, (ResolveCache.PolyVariantContextResolver)resolver, (boolean)true, (boolean)true, (PsiFile)containingFile);
                return results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
            }
            return ref.advancedResolve(true);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    public void visitReferenceList(@NotNull PsiReferenceList list) {
        if (list == null) {
            JavaErrorVisitor.$$$reportNull$$$0(86);
        }
        super.visitReferenceList(list);
        if (list.getFirstChild() == null) {
            return;
        }
        PsiElement parent = list.getParent();
        if (!(parent instanceof PsiTypeParameter)) {
            this.myAnnotationChecker.checkAnnotationDeclaration(parent, list);
            if (!this.hasErrorResults()) {
                this.myClassChecker.checkExtendsAllowed(list);
            }
            if (!this.hasErrorResults()) {
                this.myClassChecker.checkImplementsAllowed(list);
            }
            if (!this.hasErrorResults()) {
                this.myClassChecker.checkClassExtendsOnlyOneClass(list);
            }
            if (!this.hasErrorResults()) {
                this.myClassChecker.checkPermitsList(list);
            }
            if (!this.hasErrorResults()) {
                this.myGenericsChecker.checkGenericCannotExtendException(list);
            }
        }
    }

    public void visitClassObjectAccessExpression(@NotNull PsiClassObjectAccessExpression expression) {
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(87);
        }
        super.visitClassObjectAccessExpression(expression);
        if (!this.hasErrorResults()) {
            this.myGenericsChecker.checkClassObjectAccessExpression(expression);
        }
    }

    public void visitExpression(@NotNull PsiExpression expression) {
        PsiNewExpression newExpression;
        PsiThrowStatement statement;
        PsiElement psiElement;
        PsiElement psiElement2;
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(88);
        }
        ProgressManager.checkCanceled();
        super.visitExpression(expression);
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            return;
        }
        if (!this.hasErrorResults()) {
            this.myAnnotationChecker.checkConstantExpression(expression);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkMustBeBoolean(expression);
        }
        if (!this.hasErrorResults()) {
            this.myStatementChecker.checkAssertStatementTypes(expression);
        }
        if (!this.hasErrorResults()) {
            this.myStatementChecker.checkSynchronizedStatementType(expression);
        }
        if ((psiElement2 = expression.getParent()) instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression arrayInitializer = (PsiArrayInitializerExpression)psiElement2;
            if (!this.hasErrorResults()) {
                this.myExpressionChecker.checkArrayInitializer(expression, arrayInitializer);
            }
        }
        if (!this.hasErrorResults() && expression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression accessExpression = (PsiArrayAccessExpression)expression;
            this.myExpressionChecker.checkValidArrayAccessExpression(accessExpression);
        }
        PsiType type = expression.getType();
        if (!this.hasErrorResults() && (psiElement = expression.getParent()) instanceof PsiThrowStatement && (statement = (PsiThrowStatement)psiElement).getException() == expression) {
            this.myTypeChecker.checkMustBeThrowable((PsiElement)expression, type);
        }
        if (!this.hasErrorResults() && parent instanceof PsiNewExpression && (newExpression = (PsiNewExpression)parent).getQualifier() != expression && newExpression.getArrayInitializer() != expression) {
            this.myExpressionChecker.checkAssignability((PsiType)PsiTypes.intType(), type, expression, (PsiElement)expression);
        }
        if (!this.hasErrorResults()) {
            this.myStatementChecker.checkForeachExpressionTypeIsIterable(expression);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkVariableExpected(expression);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkConditionalExpressionBranchTypesMatch(expression, type);
        }
        if (!this.hasErrorResults()) {
            this.myControlFlowChecker.checkCannotWriteToFinal(expression);
        }
    }

    public void visitExpressionList(@NotNull PsiExpressionList list) {
        PsiMethodCallExpression expression;
        if (list == null) {
            JavaErrorVisitor.$$$reportNull$$$0(89);
        }
        super.visitExpressionList(list);
        PsiElement parent = list.getParent();
        if (parent instanceof PsiMethodCallExpression && (expression = (PsiMethodCallExpression)parent).getArgumentList() == list) {
            JavaResolveResult result;
            PsiReferenceExpression referenceExpression = expression.getMethodExpression();
            JavaResolveResult[] results = this.resolveOptimised(referenceExpression);
            if (results == null) {
                return;
            }
            JavaResolveResult javaResolveResult = result = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
            if (!(result.isAccessible() && result.isStaticsScopeCorrect() || referenceExpression.getParent() != expression || !PsiTreeUtil.findChildrenOfType((PsiElement)expression.getArgumentList(), PsiLambdaExpression.class).isEmpty())) {
                this.myExpressionChecker.checkAmbiguousMethodCallArguments(results, result, expression);
            }
        }
    }

    public void visitAnnotationArrayInitializer(@NotNull PsiArrayInitializerMemberValue initializer) {
        if (initializer == null) {
            JavaErrorVisitor.$$$reportNull$$$0(90);
        }
        super.visitAnnotationArrayInitializer(initializer);
        this.myAnnotationChecker.checkArrayInitializer(initializer);
    }

    public void visitParameterList(@NotNull PsiParameterList list) {
        if (list == null) {
            JavaErrorVisitor.$$$reportNull$$$0(91);
        }
        super.visitParameterList(list);
        if (!this.hasErrorResults()) {
            this.myAnnotationChecker.checkAnnotationMethodParameters(list);
        }
    }

    public void visitForStatement(@NotNull PsiForStatement statement) {
        if (statement == null) {
            JavaErrorVisitor.$$$reportNull$$$0(92);
        }
        this.myStatementChecker.checkForStatement(statement);
    }

    public void visitTypeTestPattern(@NotNull PsiTypeTestPattern pattern) {
        if (pattern == null) {
            JavaErrorVisitor.$$$reportNull$$$0(93);
        }
        super.visitTypeTestPattern(pattern);
        if (pattern.getParent() instanceof PsiCaseLabelElementList) {
            this.checkFeature((PsiElement)pattern, JavaFeature.PATTERNS_IN_SWITCH);
        }
    }

    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        if (assignment == null) {
            JavaErrorVisitor.$$$reportNull$$$0(94);
        }
        super.visitAssignmentExpression(assignment);
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkAssignmentCompatibleTypes(assignment);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkAssignmentOperatorApplicable(assignment);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkOutsideDeclaredCantBeAssignmentInGuard(assignment.getLExpression());
        }
    }

    public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(95);
        }
        super.visitPolyadicExpression(expression);
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkPolyadicOperatorApplicable(expression);
        }
    }

    public void visitUnaryExpression(@NotNull PsiUnaryExpression expression) {
        if (expression == null) {
            JavaErrorVisitor.$$$reportNull$$$0(96);
        }
        super.visitUnaryExpression(expression);
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkUnaryOperatorApplicable(expression);
        }
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkOutsideDeclaredCantBeAssignmentInGuard(expression.getOperand());
        }
    }

    public void visitUnnamedPattern(@NotNull PsiUnnamedPattern pattern) {
        if (pattern == null) {
            JavaErrorVisitor.$$$reportNull$$$0(97);
        }
        super.visitUnnamedPattern(pattern);
        this.checkFeature((PsiElement)pattern, JavaFeature.UNNAMED_PATTERNS_AND_VARIABLES);
    }

    public void visitSuperExpression(@NotNull PsiSuperExpression expr) {
        if (expr == null) {
            JavaErrorVisitor.$$$reportNull$$$0(98);
        }
        this.myExpressionChecker.checkSuperExpressionInIllegalContext(expr);
        if (!this.hasErrorResults()) {
            this.myExpressionChecker.checkMemberReferencedBeforeConstructorCalled((PsiElement)expr, null);
        }
        if (!this.hasErrorResults()) {
            this.visitExpression((PsiExpression)expr);
        }
    }

    public void visitThisExpression(@NotNull PsiThisExpression expr) {
        if (expr == null) {
            JavaErrorVisitor.$$$reportNull$$$0(99);
        }
        if (!(expr.getParent() instanceof PsiReceiverParameter)) {
            this.myExpressionChecker.checkThisExpressionInIllegalContext(expr);
            if (!this.hasErrorResults()) {
                this.myExpressionChecker.checkMemberReferencedBeforeConstructorCalled((PsiElement)expr, null);
            }
            if (!this.hasErrorResults()) {
                this.visitExpression((PsiExpression)expr);
            }
        }
    }

    public void visitMethod(@NotNull PsiMethod method) {
        if (method == null) {
            JavaErrorVisitor.$$$reportNull$$$0(100);
        }
        super.visitMethod(method);
        PsiClass aClass = method.getContainingClass();
        if (!this.hasErrorResults() && (method.hasModifierProperty("default") || aClass != null && aClass.isInterface() && method.hasModifierProperty("static"))) {
            this.checkFeature((PsiElement)method, JavaFeature.EXTENSION_METHODS);
        }
        if (!this.hasErrorResults() && aClass != null) {
            this.myMethodChecker.checkDuplicateMethod(aClass, method);
        }
        if (!this.hasErrorResults() && method.isConstructor()) {
            this.myClassChecker.checkThingNotAllowedInInterface((PsiMember)method);
        }
        if (!this.hasErrorResults()) {
            this.myRecordChecker.checkRecordAccessorDeclaration(method);
        }
        if (!this.hasErrorResults()) {
            this.myRecordChecker.checkRecordConstructorDeclaration(method);
        }
        if (!this.hasErrorResults()) {
            this.myMethodChecker.checkConstructorInImplicitClass(method);
        }
        if (!this.hasErrorResults()) {
            this.myMethodChecker.checkConstructorHandleSuperClassExceptions(method);
        }
        if (!this.hasErrorResults()) {
            this.myControlFlowChecker.checkUnreachableStatement(method.getBody());
        }
    }

    public void visitAnnotationMethod(@NotNull PsiAnnotationMethod method) {
        PsiTypeElement typeElement;
        if (method == null) {
            JavaErrorVisitor.$$$reportNull$$$0(101);
        }
        PsiType returnType = method.getReturnType();
        PsiAnnotationMemberValue value = method.getDefaultValue();
        if (returnType != null && value != null) {
            this.myAnnotationChecker.checkMemberValueType(value, returnType, method);
        }
        if ((typeElement = method.getReturnTypeElement()) != null) {
            this.myAnnotationChecker.checkValidAnnotationType(returnType, typeElement);
        }
        PsiClass aClass = method.getContainingClass();
        if (typeElement != null && aClass != null) {
            this.myAnnotationChecker.checkCyclicMemberType(typeElement, aClass);
        }
        this.myAnnotationChecker.checkClashesWithSuperMethods(method);
        if (!this.hasErrorResults() && aClass != null) {
            this.myMethodChecker.checkDuplicateMethod(aClass, (PsiMethod)method);
        }
    }

    void checkFeature(@NotNull PsiElement element, @NotNull JavaFeature feature) {
        if (element == null) {
            JavaErrorVisitor.$$$reportNull$$$0(102);
        }
        if (feature == null) {
            JavaErrorVisitor.$$$reportNull$$$0(103);
        }
        if (!this.isApplicable(feature)) {
            this.report(JavaErrorKinds.UNSUPPORTED_FEATURE.create(element, feature));
        }
    }

    boolean reportIncompatibleType(@NotNull PsiType lType, @Nullable PsiType rType, @NotNull PsiElement elementToHighlight) {
        if (lType == null) {
            JavaErrorVisitor.$$$reportNull$$$0(104);
        }
        if (elementToHighlight == null) {
            JavaErrorVisitor.$$$reportNull$$$0(105);
        }
        if (rType instanceof PsiLambdaParameterType || lType instanceof PsiLambdaParameterType) {
            return true;
        }
        this.report(JavaErrorKinds.TYPE_INCOMPATIBLE.create(elementToHighlight, new JavaIncompatibleTypeErrorContext(lType, rType)));
        return false;
    }

    private void checkPreviewFeature(@NotNull PsiElement element) {
        if (element == null) {
            JavaErrorVisitor.$$$reportNull$$$0(106);
        }
        if (this.myLanguageLevel.isPreview()) {
            return;
        }
        JavaPreviewFeatureUtil.PreviewFeatureUsage usage = JavaPreviewFeatureUtil.getPreviewFeatureUsage((PsiElement)element);
        if (usage == null || usage.isReflective()) {
            return;
        }
        if (!this.isApplicable(usage.feature())) {
            this.report(JavaErrorKinds.PREVIEW_API_USAGE.create(element, usage));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 3: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/highlighting/JavaErrorVisitor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 79: 
            case 102: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordComponent";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 35: 
            case 42: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 61: 
            case 74: 
            case 75: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumConstant";
                break;
            }
            case 26: 
            case 28: 
            case 32: 
            case 34: 
            case 41: 
            case 47: 
            case 64: 
            case 65: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 83: 
            case 87: 
            case 88: 
            case 95: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 29: 
            case 30: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 33: 
            case 36: 
            case 43: 
            case 86: 
            case 89: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 39: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 56: 
            case 73: 
            case 76: 
            case 80: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceList";
                break;
            }
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deconstructionPattern";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deconstructionList";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceList";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 93: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 98: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 100: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/highlighting/JavaErrorVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "file";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "project";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "factory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "languageLevel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sdkVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkUnicodeBadCharacter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitErrorElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitRecordComponent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitStatement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitTryStatement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitBreakStatement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitYieldStatement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitExpressionStatement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitContinueStatement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitParameter";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotation";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitPackageStatement";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitReceiverParameter";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitNameValuePair";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitEnumConstant";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitTemplateExpression";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitTemplate";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitNewExpression";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitComment";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitDocComment";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitFragment";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitLiteralExpression";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeParameterList";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitMethodReferenceExpression";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowStatement";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitModifierList";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitJavaFile";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitJavaToken";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitClassInitializer";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitField";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitMethodCallExpression";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnStatement";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceParameterList";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitIdentifier";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "visitKeyword";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledStatement";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchExpression";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchStatement";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "visitModule";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "visitProvidesStatement";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "visitRequiresStatement";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "visitPackageAccessibilityStatement";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "visitModuleStatement";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "visitUsesStatement";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "visitImportModuleStatement";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "visitImportStaticReferenceElement";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "visitImportStatement";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "visitResourceList";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "visitResourceVariable";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "visitResourceExpression";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "visitImportStaticStatement";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "visitVariable";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceExpression";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayInitializerExpression";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "visitPatternVariable";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "visitDeconstructionPattern";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "visitDeconstructionList";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "visitInstanceOfExpression";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "visitConditionalExpression";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "visitLambdaExpression";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeCastExpression";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceElement";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchLabelStatement";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchLabeledRuleStatement";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "doVisitReferenceElement";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "checkShebangComment";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "checkUnclosedComment";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "checkIllegalUnicodeEscapes";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "checkElementInReferenceList";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "resolveOptimised";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceList";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "visitClassObjectAccessExpression";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "visitExpression";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "visitExpressionList";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotationArrayInitializer";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "visitParameterList";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "visitForStatement";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeTestPattern";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "visitAssignmentExpression";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "visitPolyadicExpression";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "visitUnaryExpression";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "visitUnnamedPattern";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "visitSuperExpression";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "visitThisExpression";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "visitMethod";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotationMethod";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "checkFeature";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "reportIncompatibleType";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "checkPreviewFeature";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

