/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFragment;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LiteralChecker {
    private static final Pattern FP_LITERAL_PARTS = Pattern.compile("(?:0x([_\\p{XDigit}]*)\\.?([_\\p{XDigit}]*)p[+-]?([_\\d]*)|([_\\d]*)\\.?([_\\d]*)e?[+-]?([_\\d]*))[fd]?");
    @NotNull
    private final JavaErrorVisitor myVisitor;

    LiteralChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            LiteralChecker.$$$reportNull$$$0(0);
        }
        this.myVisitor = visitor;
    }

    void getLiteralExpressionParsingError(@NotNull PsiLiteralExpression expression) {
        if (expression == null) {
            LiteralChecker.$$$reportNull$$$0(1);
        }
        PsiElement literal = expression.getFirstChild();
        assert (literal instanceof PsiJavaToken) : literal;
        IElementType type = ((PsiJavaToken)literal).getTokenType();
        if (type == JavaTokenType.TRUE_KEYWORD || type == JavaTokenType.FALSE_KEYWORD || type == JavaTokenType.NULL_KEYWORD) {
            return;
        }
        boolean isInt = ElementType.INTEGER_LITERALS.contains(type);
        boolean isFP = ElementType.REAL_LITERALS.contains(type);
        String rawText = isInt || isFP ? StringUtil.toLowerCase((String)literal.getText()) : literal.getText();
        String text = LiteralChecker.parseUnicodeEscapes(rawText, null);
        Object value = expression.getValue();
        if (isFP && text.startsWith("0x")) {
            this.myVisitor.checkFeature((PsiElement)expression, JavaFeature.HEX_FP_LITERALS);
        } else if (isInt && text.startsWith("0b")) {
            this.myVisitor.checkFeature((PsiElement)expression, JavaFeature.BIN_LITERALS);
        }
        if ((isInt || isFP) && text.contains("_")) {
            this.myVisitor.checkFeature((PsiElement)expression, JavaFeature.UNDERSCORES);
            if (!this.myVisitor.hasErrorResults()) {
                this.checkUnderscores(expression, text, isInt);
            }
        }
        if (this.myVisitor.hasErrorResults()) {
            return;
        }
        PsiElement parent = expression.getParent();
        if (type == JavaTokenType.INTEGER_LITERAL) {
            PsiPrefixExpression prefixExpression;
            String cleanText = StringUtil.replace((String)text, (String)"_", (String)"");
            if (!cleanText.equals(PsiLiteralUtil._2_IN_31) || !(parent instanceof PsiPrefixExpression) || (prefixExpression = (PsiPrefixExpression)parent).getOperationTokenType() != JavaTokenType.MINUS) {
                if (cleanText.equals("0x")) {
                    this.myVisitor.report(JavaErrorKinds.LITERAL_HEXADECIMAL_NO_DIGITS.create(expression));
                } else if (cleanText.equals("0b")) {
                    this.myVisitor.report(JavaErrorKinds.LITERAL_BINARY_NO_DIGITS.create(expression));
                } else if (value == null || cleanText.equals(PsiLiteralUtil._2_IN_31)) {
                    this.myVisitor.report(JavaErrorKinds.LITERAL_INTEGER_TOO_LARGE.create(expression));
                }
            }
        } else if (type == JavaTokenType.LONG_LITERAL) {
            PsiPrefixExpression prefixExpression;
            String cleanText = StringUtil.replace((String)StringUtil.trimEnd((String)text, (char)'l'), (String)"_", (String)"");
            if (!cleanText.equals(PsiLiteralUtil._2_IN_63) || !(parent instanceof PsiPrefixExpression) || (prefixExpression = (PsiPrefixExpression)parent).getOperationTokenType() != JavaTokenType.MINUS) {
                if (cleanText.equals("0x")) {
                    this.myVisitor.report(JavaErrorKinds.LITERAL_HEXADECIMAL_NO_DIGITS.create(expression));
                } else if (cleanText.equals("0b")) {
                    this.myVisitor.report(JavaErrorKinds.LITERAL_BINARY_NO_DIGITS.create(expression));
                } else if (value == null || cleanText.equals(PsiLiteralUtil._2_IN_63)) {
                    this.myVisitor.report(JavaErrorKinds.LITERAL_LONG_TOO_LARGE.create(expression));
                }
            }
        } else if (isFP) {
            if (value == null) {
                this.myVisitor.report(JavaErrorKinds.LITERAL_FLOATING_MALFORMED.create(expression));
            } else if (value instanceof Float) {
                Float number = (Float)value;
                if (number.isInfinite()) {
                    this.myVisitor.report(JavaErrorKinds.LITERAL_FLOATING_TOO_LARGE.create(expression));
                } else if (number.floatValue() == 0.0f && !TypeConversionUtil.isFPZero((String)text)) {
                    this.myVisitor.report(JavaErrorKinds.LITERAL_FLOATING_TOO_SMALL.create(expression));
                }
            } else if (value instanceof Double) {
                Double number = (Double)value;
                if (number.isInfinite()) {
                    this.myVisitor.report(JavaErrorKinds.LITERAL_FLOATING_TOO_LARGE.create(expression));
                } else if (number == 0.0 && !TypeConversionUtil.isFPZero((String)text)) {
                    this.myVisitor.report(JavaErrorKinds.LITERAL_FLOATING_TOO_SMALL.create(expression));
                }
            }
        } else if (type == JavaTokenType.CHARACTER_LITERAL) {
            int length;
            int[] offsets;
            if (!StringUtil.startsWithChar((CharSequence)text, (char)'\'')) {
                return;
            }
            if (!StringUtil.endsWithChar((CharSequence)text, (char)'\'') || text.length() == 1) {
                this.myVisitor.report(JavaErrorKinds.LITERAL_CHARACTER_UNCLOSED.create(expression));
                return;
            }
            int rawLength = rawText.length();
            StringBuilder chars = new StringBuilder(rawLength);
            boolean success = CodeInsightUtilCore.parseStringCharacters((String)rawText, (StringBuilder)chars, (int[])(offsets = new int[rawLength + 1]), (boolean)false);
            if (!success) {
                this.myVisitor.report(JavaErrorKinds.LITERAL_CHARACTER_ILLEGAL_ESCAPE.create(expression, LiteralChecker.calculateErrorRange(rawText, offsets[chars.length()])));
            }
            if ((length = chars.length()) > 3) {
                this.myVisitor.report(JavaErrorKinds.LITERAL_CHARACTER_TOO_LONG.create(expression));
            } else if (length == 2) {
                this.myVisitor.report(JavaErrorKinds.LITERAL_CHARACTER_EMPTY.create(expression));
            } else {
                this.checkTextBlockEscapes(expression, rawText);
            }
        } else if (type == JavaTokenType.STRING_LITERAL || type == JavaTokenType.TEXT_BLOCK_LITERAL) {
            if (type == JavaTokenType.STRING_LITERAL) {
                int[] offsets;
                for (PsiElement element = expression.getFirstChild(); element != null; element = element.getNextSibling()) {
                    if (!(element instanceof OuterLanguageElement)) continue;
                    return;
                }
                if (!StringUtil.startsWithChar((CharSequence)text, (char)'\"')) {
                    return;
                }
                if (!StringUtil.endsWithChar((CharSequence)text, (char)'\"') || text.length() == 1) {
                    this.myVisitor.report(JavaErrorKinds.LITERAL_STRING_ILLEGAL_LINE_END.create((PsiLiteralValue)expression));
                    return;
                }
                int length = rawText.length();
                StringBuilder chars = new StringBuilder(length);
                boolean success = CodeInsightUtilCore.parseStringCharacters((String)rawText, (StringBuilder)chars, (int[])(offsets = new int[length + 1]), (boolean)false);
                if (!success) {
                    this.myVisitor.report(JavaErrorKinds.LITERAL_STRING_ILLEGAL_ESCAPE.create((PsiLiteralValue)expression, LiteralChecker.calculateErrorRange(rawText, offsets[chars.length()])));
                } else {
                    this.checkTextBlockEscapes(expression, rawText);
                }
            } else if (!text.endsWith("\"\"\"")) {
                this.myVisitor.report(JavaErrorKinds.LITERAL_TEXT_BLOCK_UNCLOSED.create(expression));
            } else if (text.length() > 3) {
                int[] offsets;
                this.checkTextBlockNewlineAfterOpeningQuotes((PsiLiteralValue)expression, text);
                if (this.myVisitor.hasErrorResults()) {
                    return;
                }
                int rawLength = rawText.length();
                StringBuilder chars = new StringBuilder(rawLength);
                boolean success = CodeInsightUtilCore.parseStringCharacters((String)rawText, (StringBuilder)chars, (int[])(offsets = new int[rawLength + 1]), (boolean)true);
                if (!success) {
                    this.myVisitor.report(JavaErrorKinds.LITERAL_STRING_ILLEGAL_ESCAPE.create((PsiLiteralValue)expression, LiteralChecker.calculateErrorRange(rawText, offsets[chars.length()])));
                }
            }
        }
    }

    private void checkTextBlockEscapes(@NotNull PsiLiteralExpression expression, @NotNull String text) {
        if (expression == null) {
            LiteralChecker.$$$reportNull$$$0(2);
        }
        if (text == null) {
            LiteralChecker.$$$reportNull$$$0(3);
        }
        if (this.myVisitor.isApplicable(JavaFeature.TEXT_BLOCK_ESCAPES)) {
            return;
        }
        TextRange errorRange = PsiLiteralUtil.findSlashS((String)text);
        if (errorRange != null) {
            this.myVisitor.report(JavaErrorKinds.UNSUPPORTED_FEATURE.create((PsiElement)expression, JavaFeature.TEXT_BLOCK_ESCAPES));
        }
    }

    private void checkTextBlockNewlineAfterOpeningQuotes(@NotNull PsiLiteralValue expression, @NotNull String text) {
        if (expression == null) {
            LiteralChecker.$$$reportNull$$$0(4);
        }
        if (text == null) {
            LiteralChecker.$$$reportNull$$$0(5);
        }
        int i = 3;
        char c = text.charAt(i);
        while (PsiLiteralUtil.isTextBlockWhiteSpace((char)c)) {
            c = text.charAt(++i);
        }
        if (c != '\n' && c != '\r') {
            this.myVisitor.report(JavaErrorKinds.LITERAL_TEXT_BLOCK_NO_NEW_LINE.create(expression));
        }
    }

    private void checkUnderscores(@NotNull PsiLiteralExpression expression, @NotNull String text, boolean isInt) {
        String[] parts;
        if (expression == null) {
            LiteralChecker.$$$reportNull$$$0(6);
        }
        if (text == null) {
            LiteralChecker.$$$reportNull$$$0(7);
        }
        if (isInt) {
            int start = 0;
            if (text.startsWith("0x") || text.startsWith("0b")) {
                start += 2;
            }
            int end = text.length();
            if (StringUtil.endsWithChar((CharSequence)text, (char)'l')) {
                --end;
            }
            parts = new String[]{text.substring(start, end)};
        } else {
            Matcher matcher = FP_LITERAL_PARTS.matcher(text);
            if (matcher.matches()) {
                parts = new String[matcher.groupCount()];
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    parts[i] = matcher.group(i + 1);
                }
            } else {
                parts = ArrayUtilRt.EMPTY_STRING_ARRAY;
            }
        }
        for (String part : parts) {
            if (part == null || !StringUtil.startsWithChar((CharSequence)part, (char)'_') && !StringUtil.endsWithChar((CharSequence)part, (char)'_')) continue;
            this.myVisitor.report(JavaErrorKinds.LITERAL_ILLEGAL_UNDERSCORE.create(expression));
            return;
        }
    }

    void checkFragmentError(@NotNull PsiFragment fragment) {
        int[] offsets;
        StringBuilder chars;
        boolean success;
        if (fragment == null) {
            LiteralChecker.$$$reportNull$$$0(8);
        }
        String text = InjectedLanguageManager.getInstance((Project)this.myVisitor.project()).getUnescapedText((PsiElement)fragment);
        if (fragment.getTokenType() == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN) {
            this.checkTextBlockNewlineAfterOpeningQuotes((PsiLiteralValue)fragment, text);
            if (this.myVisitor.hasErrorResults()) {
                return;
            }
        }
        int length = text.length();
        if (!(fragment.getTokenType() != JavaTokenType.STRING_TEMPLATE_END || StringUtil.endsWithChar((CharSequence)text, (char)'\"') && length != 1)) {
            this.myVisitor.report(JavaErrorKinds.LITERAL_STRING_ILLEGAL_LINE_END.create((PsiLiteralValue)fragment));
            return;
        }
        if (text.endsWith("\\{")) {
            text = text.substring(0, length - 2);
            length -= 2;
        }
        if (!(success = CodeInsightUtilCore.parseStringCharacters((String)text, (StringBuilder)(chars = new StringBuilder(length)), (int[])(offsets = new int[length + 1]), (boolean)fragment.isTextBlock()))) {
            this.myVisitor.report(JavaErrorKinds.LITERAL_STRING_ILLEGAL_ESCAPE.create((PsiLiteralValue)fragment, LiteralChecker.calculateErrorRange(text, offsets[chars.length()])));
        }
    }

    @NotNull
    static String parseUnicodeEscapes(@NotNull String text, @Nullable BiConsumer<? super Integer, ? super Integer> illegalEscapeConsumer) {
        if (text == null) {
            LiteralChecker.$$$reportNull$$$0(9);
        }
        if (!text.contains("\\u")) {
            String string = text;
            if (string == null) {
                LiteralChecker.$$$reportNull$$$0(10);
            }
            return string;
        }
        StringBuilder result = new StringBuilder();
        boolean escape = false;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                if (escape) {
                    result.append("\\\\");
                }
                escape = !escape;
                continue;
            }
            if (!escape) {
                result.append(c);
                continue;
            }
            if (c != 'u') {
                result.append('\\').append(c);
                escape = false;
                continue;
            }
            int startOfUnicodeEscape = i - 1;
            do {
                if (++i != length) continue;
                if (illegalEscapeConsumer != null) {
                    illegalEscapeConsumer.accept((Integer)startOfUnicodeEscape, (Integer)i);
                }
                String string = result.toString();
                if (string == null) {
                    LiteralChecker.$$$reportNull$$$0(11);
                }
                return string;
            } while ((c = text.charAt(i)) == 'u');
            int value = 0;
            for (int j = 0; j < 4; ++j) {
                if (i + j >= length) {
                    if (illegalEscapeConsumer != null) {
                        illegalEscapeConsumer.accept((Integer)startOfUnicodeEscape, (Integer)(i + j));
                    }
                    String string = result.toString();
                    if (string == null) {
                        LiteralChecker.$$$reportNull$$$0(12);
                    }
                    return string;
                }
                value <<= 4;
                c = text.charAt(i + j);
                if ('0' <= c && c <= '9') {
                    value += c - 48;
                    continue;
                }
                if ('a' <= c && c <= 'f') {
                    value += c - 97 + 10;
                    continue;
                }
                if ('A' <= c && c <= 'F') {
                    value += c - 65 + 10;
                    continue;
                }
                if (illegalEscapeConsumer != null) {
                    illegalEscapeConsumer.accept((Integer)startOfUnicodeEscape, (Integer)(i + j));
                }
                value = -1;
                break;
            }
            if (value != -1) {
                i += 3;
                result.appendCodePoint(value);
            }
            escape = false;
        }
        String string = result.toString();
        if (string == null) {
            LiteralChecker.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static TextRange calculateErrorRange(@NotNull String rawText, int start) {
        int end;
        if (rawText == null) {
            LiteralChecker.$$$reportNull$$$0(14);
        }
        if (rawText.charAt(start + 1) == 'u') {
            end = start + 2;
            while (rawText.charAt(end) == 'u') {
                ++end;
            }
            end += 4;
        } else {
            end = start + 2;
        }
        return new TextRange(start, end);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/highlighting/LiteralChecker";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/highlighting/LiteralChecker";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parseUnicodeEscapes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralExpressionParsingError";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkTextBlockEscapes";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkTextBlockNewlineAfterOpeningQuotes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkUnderscores";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkFragmentError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseUnicodeEscapes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calculateErrorRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

