/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.codeInsight.ClassUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.java.codeserver.core.JavaPsiMethodUtil;
import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.errors.JavaCompilationError;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.IncompleteModelUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MethodChecker {
    @NotNull
    private final JavaErrorVisitor myVisitor;
    @NotNull
    private final Map<PsiClass, MostlySingularMultiMap<MethodSignature, PsiMethod>> myDuplicateMethods;
    private static final TokenSet BRACKET_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.LBRACKET, JavaTokenType.RBRACKET});

    MethodChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            MethodChecker.$$$reportNull$$$0(0);
        }
        this.myDuplicateMethods = new HashMap<PsiClass, MostlySingularMultiMap<MethodSignature, PsiMethod>>();
        this.myVisitor = visitor;
    }

    @NotNull
    private MostlySingularMultiMap<MethodSignature, PsiMethod> getDuplicateMethods(@NotNull PsiClass aClass) {
        MostlySingularMultiMap signatures;
        if (aClass == null) {
            MethodChecker.$$$reportNull$$$0(1);
        }
        if ((signatures = this.myDuplicateMethods.get(aClass)) == null) {
            signatures = new MostlySingularMultiMap();
            for (PsiMethod method : aClass.getMethods()) {
                if (method instanceof ExternallyDefinedPsiElement) continue;
                MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
                signatures.add((Object)signature, (Object)method);
            }
            this.myDuplicateMethods.put(aClass, (MostlySingularMultiMap<MethodSignature, PsiMethod>)signatures);
        }
        MostlySingularMultiMap mostlySingularMultiMap = signatures;
        if (mostlySingularMultiMap == null) {
            MethodChecker.$$$reportNull$$$0(2);
        }
        return mostlySingularMultiMap;
    }

    void checkMustBeThrowable(@NotNull PsiClass aClass, @NotNull PsiJavaCodeReferenceElement context) {
        if (aClass == null) {
            MethodChecker.$$$reportNull$$$0(3);
        }
        if (context == null) {
            MethodChecker.$$$reportNull$$$0(4);
        }
        if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Throwable")) {
            PsiElementFactory factory = this.myVisitor.factory();
            PsiClassType type = factory.createType(aClass);
            PsiClassType throwable = factory.createTypeByFQClassName("java.lang.Throwable", context.getResolveScope());
            if (this.myVisitor.isIncompleteModel() && IncompleteModelUtil.isPotentiallyConvertible((PsiType)throwable, (PsiType)type, (PsiElement)context)) {
                return;
            }
            this.myVisitor.reportIncompatibleType((PsiType)throwable, (PsiType)type, (PsiElement)context);
        }
    }

    void checkMethodCanHaveBody(@NotNull PsiMethod method) {
        if (method == null) {
            MethodChecker.$$$reportNull$$$0(5);
        }
        PsiClass aClass = method.getContainingClass();
        boolean hasNoBody = method.getBody() == null;
        boolean isInterface = aClass != null && aClass.isInterface();
        boolean isExtension = method.hasModifierProperty("default");
        boolean isStatic = method.hasModifierProperty("static");
        boolean isPrivate = method.hasModifierProperty("private");
        boolean isConstructor = method.isConstructor();
        if (hasNoBody) {
            if (isExtension) {
                this.myVisitor.report(JavaErrorKinds.METHOD_DEFAULT_SHOULD_HAVE_BODY.create(method));
            } else if (isInterface) {
                if (isStatic && this.myVisitor.isApplicable(JavaFeature.STATIC_INTERFACE_CALLS)) {
                    this.myVisitor.report(JavaErrorKinds.METHOD_STATIC_IN_INTERFACE_SHOULD_HAVE_BODY.create(method));
                } else if (isPrivate && this.myVisitor.isApplicable(JavaFeature.PRIVATE_INTERFACE_METHODS)) {
                    this.myVisitor.report(JavaErrorKinds.METHOD_PRIVATE_IN_INTERFACE_SHOULD_HAVE_BODY.create(method));
                }
            }
        } else if (isInterface) {
            if (!(isExtension || isStatic || isPrivate || isConstructor)) {
                this.myVisitor.report(JavaErrorKinds.METHOD_INTERFACE_BODY.create(method));
            }
        } else if (isExtension) {
            this.myVisitor.report(JavaErrorKinds.METHOD_DEFAULT_IN_CLASS.create(method));
        } else if (method.hasModifierProperty("abstract")) {
            this.myVisitor.report(JavaErrorKinds.METHOD_ABSTRACT_BODY.create(method));
        } else if (method.hasModifierProperty("native")) {
            this.myVisitor.report(JavaErrorKinds.METHOD_NATIVE_BODY.create(method));
        }
    }

    void checkMethodMustHaveBody(@NotNull PsiMethod method) {
        if (method == null) {
            MethodChecker.$$$reportNull$$$0(6);
        }
        PsiClass aClass = method.getContainingClass();
        if (method.getBody() != null || method.hasModifierProperty("abstract") || method.hasModifierProperty("native") || aClass == null || aClass.isInterface() || PsiUtilCore.hasErrorElementChild((PsiElement)method)) {
            return;
        }
        boolean abstractAllowed = !aClass.isRecord() && !method.isConstructor() && !(aClass instanceof PsiAnonymousClass);
        this.myVisitor.report(abstractAllowed ? JavaErrorKinds.METHOD_SHOULD_HAVE_BODY_OR_ABSTRACT.create(method) : JavaErrorKinds.METHOD_SHOULD_HAVE_BODY.create(method));
    }

    void checkStaticMethodOverride(@NotNull PsiMethod method) {
        if (method == null) {
            MethodChecker.$$$reportNull$$$0(7);
        }
        if (method.isConstructor()) {
            return;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return;
        }
        HierarchicalMethodSignature methodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature((PsiMethod)method);
        List superSignatures = methodSignature.getSuperSignatures();
        if (superSignatures.isEmpty()) {
            return;
        }
        boolean isStatic = method.hasModifierProperty("static");
        for (HierarchicalMethodSignature signature : superSignatures) {
            PsiMethod superMethod = signature.getMethod();
            PsiClass superClass = superMethod.getContainingClass();
            if (superClass == null) continue;
            this.checkStaticMethodOverride(aClass, method, isStatic, superClass, superMethod);
        }
    }

    private void checkStaticMethodOverride(@NotNull PsiClass aClass, @NotNull PsiMethod method, boolean isMethodStatic, @NotNull PsiClass superClass, @NotNull PsiMethod superMethod) {
        PsiModifierList superModifierList;
        if (aClass == null) {
            MethodChecker.$$$reportNull$$$0(8);
        }
        if (method == null) {
            MethodChecker.$$$reportNull$$$0(9);
        }
        if (superClass == null) {
            MethodChecker.$$$reportNull$$$0(10);
        }
        if (superMethod == null) {
            MethodChecker.$$$reportNull$$$0(11);
        }
        if ((superModifierList = superMethod.getModifierList()).hasModifierProperty("private")) {
            return;
        }
        if (superModifierList.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance((Project)this.myVisitor.project()).arePackagesTheSame((PsiElement)aClass, (PsiElement)superClass)) {
            return;
        }
        boolean isSuperMethodStatic = superModifierList.hasModifierProperty("static");
        if (isMethodStatic != isSuperMethodStatic) {
            JavaErrorKind.Parameterized<PsiMember, JavaErrorKinds.OverrideClashContext> errorKind = isMethodStatic ? JavaErrorKinds.METHOD_STATIC_OVERRIDES_INSTANCE : JavaErrorKinds.METHOD_INSTANCE_OVERRIDES_STATIC;
            this.myVisitor.report(errorKind.create((PsiMember)method, new JavaErrorKinds.OverrideClashContext(method, superMethod)));
            return;
        }
        if (isMethodStatic) {
            if (superClass.isInterface()) {
                return;
            }
            this.checkIsWeaker((PsiMember)method, method, superMethod);
            if (!this.myVisitor.hasErrorResults()) {
                this.checkSuperMethodIsFinal(method, superMethod);
            }
        }
    }

    private void checkSuperMethodIsFinal(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            MethodChecker.$$$reportNull$$$0(12);
        }
        if (superMethod == null) {
            MethodChecker.$$$reportNull$$$0(13);
        }
        if (superMethod.hasModifierProperty("final")) {
            this.myVisitor.report(JavaErrorKinds.METHOD_OVERRIDES_FINAL.create(method, superMethod));
        }
    }

    private void checkIsWeaker(@NotNull PsiMember anchor, @NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        int superAccessLevel;
        PsiModifierList modifierList;
        int accessLevel;
        if (anchor == null) {
            MethodChecker.$$$reportNull$$$0(14);
        }
        if (method == null) {
            MethodChecker.$$$reportNull$$$0(15);
        }
        if (superMethod == null) {
            MethodChecker.$$$reportNull$$$0(16);
        }
        if ((accessLevel = PsiUtil.getAccessLevel((PsiModifierList)(modifierList = method.getModifierList()))) < (superAccessLevel = PsiUtil.getAccessLevel((PsiModifierList)superMethod.getModifierList()))) {
            this.myVisitor.report(JavaErrorKinds.METHOD_INHERITANCE_WEAKER_PRIVILEGES.create(anchor, new JavaErrorKinds.OverrideClashContext(method, superMethod)));
        }
    }

    void checkOverrideEquivalentInheritedMethods(@NotNull PsiClass aClass) {
        if (aClass == null) {
            MethodChecker.$$$reportNull$$$0(17);
        }
        Collection visibleSignatures = aClass.getVisibleSignatures();
        if (aClass.getImplementsListTypes().length == 0 && aClass.getExtendsListTypes().length == 0) {
            return;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)this.myVisitor.project()).getResolveHelper();
        for (HierarchicalMethodSignature signature : visibleSignatures) {
            PsiMethod method = signature.getMethod();
            if (!resolveHelper.isAccessible((PsiMember)method, (PsiElement)aClass, null)) continue;
            ArrayList<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
            boolean allAbstracts = method.hasModifierProperty("abstract");
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || aClass.equals((Object)containingClass) || aClass.isInterface() && !containingClass.isInterface()) continue;
            if (allAbstracts) {
                superSignatures = new ArrayList<HierarchicalMethodSignature>(superSignatures);
                superSignatures.add(0, signature);
                this.checkInterfaceInheritedMethodsReturnTypes(aClass, superSignatures);
            } else {
                this.checkMethodIncompatibleReturnType((PsiMember)aClass, (MethodSignatureBackedByPsiMethod)signature, superSignatures);
            }
            if (method.hasModifierProperty("static") && (!aClass.isInterface() || aClass.getManager().areElementsEquivalent((PsiElement)aClass, (PsiElement)method.getContainingClass()))) {
                for (HierarchicalMethodSignature superSignature : superSignatures) {
                    PsiMethod superMethod = superSignature.getMethod();
                    if (superMethod.hasModifierProperty("static")) continue;
                    this.myVisitor.report(JavaErrorKinds.METHOD_STATIC_OVERRIDES_INSTANCE.create((PsiMember)aClass, new JavaErrorKinds.OverrideClashContext(method, superMethod)));
                    return;
                }
                continue;
            }
            if (!this.myVisitor.hasErrorResults()) {
                this.checkMethodIncompatibleThrows((PsiMember)aClass, (MethodSignatureBackedByPsiMethod)signature, superSignatures, aClass);
            }
            if (this.myVisitor.hasErrorResults()) continue;
            this.checkMethodWeakerPrivileges((PsiMember)aClass, (MethodSignatureBackedByPsiMethod)signature, superSignatures);
        }
    }

    void checkMethodWeakerPrivileges(@NotNull PsiMember anchor, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures) {
        PsiMethod method;
        PsiModifierList modifierList;
        if (anchor == null) {
            MethodChecker.$$$reportNull$$$0(18);
        }
        if (methodSignature == null) {
            MethodChecker.$$$reportNull$$$0(19);
        }
        if (superMethodSignatures == null) {
            MethodChecker.$$$reportNull$$$0(20);
        }
        if ((modifierList = (method = methodSignature.getMethod()).getModifierList()).hasModifierProperty("public")) {
            return;
        }
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            if (method.hasModifierProperty("abstract") && !MethodSignatureUtil.isSuperMethod((PsiMethod)superMethod, (PsiMethod)method) || !PsiUtil.isAccessible((Project)this.myVisitor.project(), (PsiMember)superMethod, (PsiElement)method, null) || anchor instanceof PsiClass && MethodSignatureUtil.isSuperMethod((PsiMethod)superMethod, (PsiMethod)method)) continue;
            this.checkIsWeaker(anchor, method, superMethod);
        }
    }

    void checkMethodIncompatibleThrows(@NotNull PsiMember anchor, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures, @NotNull PsiClass analyzedClass) {
        PsiMethod method;
        PsiClass aClass;
        if (anchor == null) {
            MethodChecker.$$$reportNull$$$0(21);
        }
        if (methodSignature == null) {
            MethodChecker.$$$reportNull$$$0(22);
        }
        if (superMethodSignatures == null) {
            MethodChecker.$$$reportNull$$$0(23);
        }
        if (analyzedClass == null) {
            MethodChecker.$$$reportNull$$$0(24);
        }
        if ((aClass = (method = methodSignature.getMethod()).getContainingClass()) == null) {
            return;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aClass, (PsiClass)analyzedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        PsiClassType[] exceptions = method.getThrowsList().getReferencedTypes();
        PsiJavaCodeReferenceElement[] referenceElements = anchor == method ? method.getThrowsList().getReferenceElements() : null;
        ArrayList<PsiJavaCodeReferenceElement> exceptionContexts = new ArrayList<PsiJavaCodeReferenceElement>();
        ArrayList<PsiClassType> checkedExceptions = new ArrayList<PsiClassType>();
        for (int i = 0; i < exceptions.length; ++i) {
            PsiClassType psiClassType = exceptions[i];
            if (ExceptionUtil.isUncheckedException((PsiClassType)psiClassType)) continue;
            checkedExceptions.add(psiClassType);
            if (referenceElements == null || i >= referenceElements.length) continue;
            PsiJavaCodeReferenceElement exceptionRef = referenceElements[i];
            exceptionContexts.add(exceptionRef);
        }
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            PsiClass superContainingClass;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            int index = MethodChecker.getExtraExceptionNum((MethodSignature)methodSignature, methodSignatureBackedByPsiMethod, checkedExceptions, superSubstitutor);
            if (index == -1 || aClass.isInterface() && ((superContainingClass = superMethod.getContainingClass()) != null && !superContainingClass.isInterface() || superContainingClass != null && !aClass.isInheritor(superContainingClass, true))) continue;
            PsiClassType exception = (PsiClassType)checkedExceptions.get(index);
            this.myVisitor.report(JavaErrorKinds.METHOD_INHERITANCE_CLASH_DOES_NOT_THROW.create(anchor, new JavaErrorKinds.IncompatibleOverrideExceptionContext(method, superMethod, exception, exceptionContexts.isEmpty() ? null : (PsiJavaCodeReferenceElement)exceptionContexts.get(index))));
            return;
        }
    }

    void checkMethodIncompatibleReturnType(@NotNull PsiMember anchor, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures) {
        JavaCompilationError<PsiMember, ?> error;
        if (anchor == null) {
            MethodChecker.$$$reportNull$$$0(25);
        }
        if (methodSignature == null) {
            MethodChecker.$$$reportNull$$$0(26);
        }
        if (superMethodSignatures == null) {
            MethodChecker.$$$reportNull$$$0(27);
        }
        if ((error = MethodChecker.getMethodIncompatibleReturnType(anchor, methodSignature, superMethodSignatures)) != null) {
            this.myVisitor.report(error);
        }
    }

    @Nullable
    static JavaCompilationError<PsiMember, ?> getMethodIncompatibleReturnType(@NotNull PsiMember anchor, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures) {
        if (anchor == null) {
            MethodChecker.$$$reportNull$$$0(28);
        }
        if (methodSignature == null) {
            MethodChecker.$$$reportNull$$$0(29);
        }
        if (superMethodSignatures == null) {
            MethodChecker.$$$reportNull$$$0(30);
        }
        PsiMethod method = methodSignature.getMethod();
        PsiType returnType = methodSignature.getSubstitutor().substitute(method.getReturnType());
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            JavaCompilationError<PsiMember, ?> error;
            PsiClass superClass;
            PsiType declaredReturnType;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            PsiType superReturnType = declaredReturnType = superMethod.getReturnType();
            if (methodSignatureBackedByPsiMethod.isRaw()) {
                superReturnType = TypeConversionUtil.erasure((PsiType)declaredReturnType);
            }
            if (returnType == null || superReturnType == null || method == superMethod || (superClass = superMethod.getContainingClass()) == null || (error = MethodChecker.getSuperMethodSignatureError(anchor, superMethod, methodSignatureBackedByPsiMethod, superReturnType, method, methodSignature, returnType)) == null) continue;
            return error;
        }
        return null;
    }

    @Nullable
    private static JavaCompilationError<PsiMember, ?> getSuperMethodSignatureError(@NotNull PsiMember anchor, @NotNull PsiMethod superMethod, @NotNull MethodSignatureBackedByPsiMethod superMethodSignature, @NotNull PsiType superReturnType, @NotNull PsiMethod method, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull PsiType returnType) {
        PsiSubstitutor unifyingSubstitutor;
        PsiClass containingClass;
        PsiClass superContainingClass;
        if (anchor == null) {
            MethodChecker.$$$reportNull$$$0(31);
        }
        if (superMethod == null) {
            MethodChecker.$$$reportNull$$$0(32);
        }
        if (superMethodSignature == null) {
            MethodChecker.$$$reportNull$$$0(33);
        }
        if (superReturnType == null) {
            MethodChecker.$$$reportNull$$$0(34);
        }
        if (method == null) {
            MethodChecker.$$$reportNull$$$0(35);
        }
        if (methodSignature == null) {
            MethodChecker.$$$reportNull$$$0(36);
        }
        if (returnType == null) {
            MethodChecker.$$$reportNull$$$0(37);
        }
        if ((superContainingClass = superMethod.getContainingClass()) != null && "java.lang.Object".equals(superContainingClass.getQualifiedName()) && !superMethod.hasModifierProperty("public") && (containingClass = method.getContainingClass()) != null && containingClass.isInterface() && !superContainingClass.isInterface()) {
            return null;
        }
        boolean hasGenerics = PsiUtil.isAvailable((JavaFeature)JavaFeature.GENERICS, (PsiElement)method);
        PsiType substitutedSuperReturnType = hasGenerics && !superMethodSignature.isRaw() && superMethodSignature.equals((Object)methodSignature) ? ((unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superMethodSignature)) == null ? superReturnType : unifyingSubstitutor.substitute(superReturnType)) : TypeConversionUtil.erasure((PsiType)superMethodSignature.getSubstitutor().substitute(superReturnType));
        if (returnType.equals(substitutedSuperReturnType)) {
            return null;
        }
        if (!(returnType instanceof PsiPrimitiveType) && substitutedSuperReturnType.getDeepComponentType() instanceof PsiClassType && hasGenerics && ((Boolean)LambdaUtil.performWithSubstitutedParameterBounds((PsiTypeParameter[])methodSignature.getTypeParameters(), (PsiSubstitutor)methodSignature.getSubstitutor(), () -> TypeConversionUtil.isAssignable((PsiType)substitutedSuperReturnType, (PsiType)returnType))).booleanValue()) {
            return null;
        }
        return JavaErrorKinds.METHOD_INHERITANCE_CLASH_INCOMPATIBLE_RETURN_TYPES.create(anchor, new JavaErrorKinds.IncompatibleOverrideReturnTypeContext(method, returnType, superMethod, substitutedSuperReturnType));
    }

    private void checkInterfaceInheritedMethodsReturnTypes(@NotNull PsiClass aClass, @NotNull List<HierarchicalMethodSignature> superMethodSignatures) {
        if (aClass == null) {
            MethodChecker.$$$reportNull$$$0(38);
        }
        if (superMethodSignatures == null) {
            MethodChecker.$$$reportNull$$$0(39);
        }
        if (superMethodSignatures.size() < 2) {
            return;
        }
        MethodSignatureBackedByPsiMethod[] returnTypeSubstitutable = new MethodSignatureBackedByPsiMethod[]{(MethodSignatureBackedByPsiMethod)superMethodSignatures.get(0)};
        for (int i = 1; i < superMethodSignatures.size(); ++i) {
            PsiMethod currentMethod = returnTypeSubstitutable[0].getMethod();
            PsiType currentType = returnTypeSubstitutable[0].getSubstitutor().substitute(currentMethod.getReturnType());
            MethodSignatureBackedByPsiMethod otherSuperSignature = (MethodSignatureBackedByPsiMethod)superMethodSignatures.get(i);
            PsiMethod otherSuperMethod = otherSuperSignature.getMethod();
            PsiSubstitutor otherSubstitutor = otherSuperSignature.getSubstitutor();
            PsiType otherSuperReturnType = otherSubstitutor.substitute(otherSuperMethod.getReturnType());
            PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)returnTypeSubstitutable[0], (MethodSignature)otherSuperSignature);
            if (unifyingSubstitutor != null) {
                otherSuperReturnType = unifyingSubstitutor.substitute(otherSuperReturnType);
                currentType = unifyingSubstitutor.substitute(currentType);
            }
            if (otherSuperReturnType == null || currentType == null || otherSuperReturnType.equals(currentType)) continue;
            PsiType otherReturnType = otherSuperReturnType;
            PsiType curType = currentType;
            LambdaUtil.performWithSubstitutedParameterBounds((PsiTypeParameter[])otherSuperMethod.getTypeParameters(), (PsiSubstitutor)otherSubstitutor, () -> {
                if (this.myVisitor.languageLevel().isAtLeast(LanguageLevel.JDK_1_5)) {
                    if (!(otherReturnType instanceof PsiPrimitiveType) && !(curType instanceof PsiPrimitiveType)) {
                        if (otherReturnType.isAssignableFrom(curType)) {
                            return null;
                        }
                        if (curType.isAssignableFrom(otherReturnType)) {
                            returnTypeSubstitutable[0] = otherSuperSignature;
                            return null;
                        }
                    }
                    if (otherSuperMethod.getTypeParameters().length > 0 && JavaGenericsUtil.isRawToGeneric((PsiType)otherReturnType, (PsiType)curType)) {
                        return null;
                    }
                }
                this.myVisitor.report(JavaErrorKinds.METHOD_INHERITANCE_CLASH_UNRELATED_RETURN_TYPES.create(aClass, new JavaErrorKinds.OverrideClashContext(currentMethod, otherSuperMethod)));
                return null;
            });
        }
    }

    void checkVarArgParameterWellFormed(@NotNull PsiParameter parameter) {
        PsiMethod psiMethod;
        PsiParameter[] params;
        PsiElement declarationScope;
        if (parameter == null) {
            MethodChecker.$$$reportNull$$$0(40);
        }
        if ((declarationScope = parameter.getDeclarationScope()) instanceof PsiMethod && (params = (psiMethod = (PsiMethod)declarationScope).getParameterList().getParameters())[params.length - 1] != parameter) {
            this.myVisitor.report(JavaErrorKinds.VARARG_NOT_LAST_PARAMETER.create(parameter));
            return;
        }
        TextRange range = MethodChecker.getCStyleDeclarationRange((PsiVariable)parameter);
        if (range != null) {
            this.myVisitor.report(JavaErrorKinds.VARARG_CSTYLE_DECLARATION.create(parameter, range));
        }
    }

    void checkConstructorName(PsiMethod method) {
        PsiClass aClass = method.getContainingClass();
        if (aClass != null) {
            String className = aClass.getName();
            if (method.getName().equals(className)) {
                return;
            }
            if (aClass.isInterface() || aClass instanceof PsiAnonymousClass || className == null) {
                this.myVisitor.report(JavaErrorKinds.METHOD_MISSING_RETURN_TYPE_NOT_CONSTRUCTOR.create(method));
            } else {
                this.myVisitor.report(JavaErrorKinds.METHOD_MISSING_RETURN_TYPE.create(method, className));
            }
        }
    }

    void checkAbstractMethodInConcreteClass(@NotNull PsiMethod method, @NotNull PsiKeyword elementToHighlight) {
        if (method == null) {
            MethodChecker.$$$reportNull$$$0(41);
        }
        if (elementToHighlight == null) {
            MethodChecker.$$$reportNull$$$0(42);
        }
        PsiClass aClass = method.getContainingClass();
        if (method.hasModifierProperty("abstract") && aClass != null && (aClass.isEnum() || !aClass.hasModifierProperty("abstract")) && !PsiUtilCore.hasErrorElementChild((PsiElement)method)) {
            if (aClass.isEnum()) {
                for (PsiField field : aClass.getFields()) {
                    if (!(field instanceof PsiEnumConstant)) continue;
                    return;
                }
            }
            this.myVisitor.report(JavaErrorKinds.METHOD_ABSTRACT_IN_NON_ABSTRACT_CLASS.create(elementToHighlight, method));
        }
    }

    void checkConstructorInImplicitClass(@NotNull PsiMethod method) {
        if (method == null) {
            MethodChecker.$$$reportNull$$$0(43);
        }
        if (!method.isConstructor() || !(method.getContainingClass() instanceof PsiImplicitClass)) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.CONSTRUCTOR_IN_IMPLICIT_CLASS.create(method));
    }

    void checkConstructorHandleSuperClassExceptions(@NotNull PsiMethod method) {
        PsiStatement[] statements;
        if (method == null) {
            MethodChecker.$$$reportNull$$$0(44);
        }
        if (!method.isConstructor()) {
            return;
        }
        PsiCodeBlock body = method.getBody();
        PsiStatement[] psiStatementArray = statements = body == null ? null : body.getStatements();
        if (statements == null) {
            return;
        }
        Collection unhandled = ExceptionUtil.collectUnhandledExceptions((PsiElement)method, (PsiElement)method.getContainingClass());
        if (unhandled.isEmpty()) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.EXCEPTION_UNHANDLED.create((PsiElement)method, unhandled));
    }

    @Nullable
    static TextRange getCStyleDeclarationRange(@NotNull PsiVariable variable) {
        if (variable == null) {
            MethodChecker.$$$reportNull$$$0(45);
        }
        PsiIdentifier identifier = variable.getNameIdentifier();
        TextRange range = null;
        if (identifier != null) {
            PsiElement start = null;
            PsiElement end = null;
            for (PsiElement element = identifier.getNextSibling(); element != null; element = element.getNextSibling()) {
                if (!PsiUtil.isJavaToken((PsiElement)element, (TokenSet)BRACKET_TOKENS)) continue;
                if (start == null) {
                    start = element;
                }
                end = element;
            }
            if (start != null) {
                range = TextRange.create((int)start.getTextRange().getStartOffset(), (int)end.getTextRange().getEndOffset()).shiftLeft(variable.getTextRange().getStartOffset());
            }
        }
        return range;
    }

    void checkMethodOverridesFinal(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures) {
        if (methodSignature == null) {
            MethodChecker.$$$reportNull$$$0(46);
        }
        if (superMethodSignatures == null) {
            MethodChecker.$$$reportNull$$$0(47);
        }
        PsiMethod method = methodSignature.getMethod();
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            this.checkSuperMethodIsFinal(method, superMethod);
            if (!this.myVisitor.hasErrorResults()) continue;
            return;
        }
    }

    private static int getExtraExceptionNum(@NotNull MethodSignature methodSignature, @NotNull MethodSignatureBackedByPsiMethod superSignature, @NotNull List<? extends PsiClassType> checkedExceptions, @NotNull PsiSubstitutor substitutorForDerivedClass) {
        if (methodSignature == null) {
            MethodChecker.$$$reportNull$$$0(48);
        }
        if (superSignature == null) {
            MethodChecker.$$$reportNull$$$0(49);
        }
        if (checkedExceptions == null) {
            MethodChecker.$$$reportNull$$$0(50);
        }
        if (substitutorForDerivedClass == null) {
            MethodChecker.$$$reportNull$$$0(51);
        }
        PsiMethod superMethod = superSignature.getMethod();
        PsiSubstitutor substitutorForMethod = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superSignature);
        for (int i = 0; i < checkedExceptions.size(); ++i) {
            PsiClassType checkedEx = checkedExceptions.get(i);
            PsiType substituted = substitutorForMethod == null ? TypeConversionUtil.erasure((PsiType)checkedEx) : substitutorForMethod.substitute((PsiType)checkedEx);
            PsiType exception = substitutorForDerivedClass.substitute(substituted);
            if (MethodChecker.isMethodThrows(superMethod, substitutorForMethod, exception, substitutorForDerivedClass)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isMethodThrows(@NotNull PsiMethod method, @Nullable PsiSubstitutor substitutorForMethod, @NotNull PsiType exception, @NotNull PsiSubstitutor substitutorForDerivedClass) {
        PsiClassType[] thrownExceptions;
        if (method == null) {
            MethodChecker.$$$reportNull$$$0(52);
        }
        if (exception == null) {
            MethodChecker.$$$reportNull$$$0(53);
        }
        if (substitutorForDerivedClass == null) {
            MethodChecker.$$$reportNull$$$0(54);
        }
        for (PsiClassType thrownException1 : thrownExceptions = method.getThrowsList().getReferencedTypes()) {
            PsiType thrownException = substitutorForMethod != null ? substitutorForMethod.substitute((PsiType)thrownException1) : TypeConversionUtil.erasure((PsiType)thrownException1);
            if (!TypeConversionUtil.isAssignable((PsiType)(thrownException = substitutorForDerivedClass.substitute(thrownException)), (PsiType)exception)) continue;
            return true;
        }
        return false;
    }

    void checkDuplicateMethod(@NotNull PsiClass aClass, @NotNull PsiMethod method) {
        MethodSignature methodSignature;
        if (aClass == null) {
            MethodChecker.$$$reportNull$$$0(55);
        }
        if (method == null) {
            MethodChecker.$$$reportNull$$$0(56);
        }
        if (method instanceof ExternallyDefinedPsiElement) {
            return;
        }
        MostlySingularMultiMap<MethodSignature, PsiMethod> duplicateMethods = this.getDuplicateMethods(aClass);
        List methods = (List)duplicateMethods.get((Object)(methodSignature = method.getSignature(PsiSubstitutor.EMPTY)));
        if (methods.size() > 1) {
            this.myVisitor.report(JavaErrorKinds.METHOD_DUPLICATE.create(method, new JavaErrorKinds.DuplicateMethodsContext(methods)));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    void checkUnrelatedDefaultMethods(@NotNull PsiClass aClass) {
        if (aClass == null) {
            MethodChecker.$$$reportNull$$$0(57);
        }
        Map overrideEquivalent = PsiSuperMethodUtil.collectOverrideEquivalents((PsiClass)aClass);
        for (Set overrideEquivalentMethods : overrideEquivalent.values()) {
            PsiMethod abstractMethod = JavaPsiMethodUtil.getAbstractMethodToImplementWhenDefaultPresent((PsiClass)aClass, (Collection)overrideEquivalentMethods, (boolean)false);
            if (abstractMethod != null) {
                PsiClass containingClass;
                PsiMethod anyAbstractMethod = ClassUtil.getAnyAbstractMethod((PsiClass)aClass);
                if (anyAbstractMethod != null && (containingClass = anyAbstractMethod.getContainingClass()) != null && containingClass != aClass) continue;
                this.myVisitor.report(JavaErrorKinds.CLASS_NO_ABSTRACT_METHOD.create((PsiMember)aClass, abstractMethod));
                continue;
            }
            @NotNull Couple pair = JavaPsiMethodUtil.getUnrelatedSuperMethods((PsiClass)aClass, (Collection)overrideEquivalentMethods);
            if (pair == null || MethodSignatureUtil.findMethodBySuperMethod((PsiClass)aClass, (PsiMethod)((PsiMethod)overrideEquivalentMethods.iterator().next()), (boolean)false) != null) continue;
            JavaErrorKind.Parameterized<PsiClass, JavaErrorKinds.OverrideClashContext> kind = ((PsiMethod)pair.getSecond()).hasModifierProperty("abstract") ? JavaErrorKinds.CLASS_INHERITS_ABSTRACT_AND_DEFAULT : JavaErrorKinds.CLASS_INHERITS_UNRELATED_DEFAULTS;
            this.myVisitor.report(kind.create(aClass, new JavaErrorKinds.OverrideClashContext((PsiMethod)pair.getFirst(), (PsiMethod)pair.getSecond())));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 17: 
            case 38: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/highlighting/MethodChecker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 35: 
            case 41: 
            case 43: 
            case 44: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 14: 
            case 18: 
            case 21: 
            case 25: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 19: 
            case 22: 
            case 26: 
            case 29: 
            case 36: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSignature";
                break;
            }
            case 20: 
            case 23: 
            case 27: 
            case 30: 
            case 39: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodSignatures";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analyzedClass";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodSignature";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superReturnType";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSignature";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedExceptions";
                break;
            }
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutorForDerivedClass";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/highlighting/MethodChecker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDuplicateMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicateMethods";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkMustBeThrowable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodCanHaveBody";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodMustHaveBody";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkStaticMethodOverride";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperMethodIsFinal";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkIsWeaker";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkOverrideEquivalentInheritedMethods";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodWeakerPrivileges";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodIncompatibleThrows";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodIncompatibleReturnType";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getMethodIncompatibleReturnType";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSuperMethodSignatureError";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkInterfaceInheritedMethodsReturnTypes";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkVarArgParameterWellFormed";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkAbstractMethodInConcreteClass";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorInImplicitClass";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorHandleSuperClassExceptions";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getCStyleDeclarationRange";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodOverridesFinal";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getExtraExceptionNum";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isMethodThrows";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateMethod";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "checkUnrelatedDefaultMethods";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

