/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.java.codeserver.core.JavaPatternExhaustivenessUtil;
import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.java.codeserver.highlighting.errors.JavaIncompatibleTypeErrorContext;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachPatternStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.IncompleteModelUtil;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PatternChecker {
    @NotNull
    private final JavaErrorVisitor myVisitor;

    PatternChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            PatternChecker.$$$reportNull$$$0(0);
        }
        this.myVisitor = visitor;
    }

    void checkDeconstructionVariable(@NotNull PsiPatternVariable variable) {
        if (variable == null) {
            PatternChecker.$$$reportNull$$$0(1);
        }
        if (variable.getPattern() instanceof PsiDeconstructionPattern) {
            this.myVisitor.report(JavaErrorKinds.PATTERN_DECONSTRUCTION_VARIABLE.create(variable));
        }
    }

    void checkPatternVariableRequired(@NotNull PsiReferenceExpression expression, @NotNull JavaResolveResult resultForIncompleteCode) {
        if (expression == null) {
            PatternChecker.$$$reportNull$$$0(2);
        }
        if (resultForIncompleteCode == null) {
            PatternChecker.$$$reportNull$$$0(3);
        }
        if (!(expression.getParent() instanceof PsiCaseLabelElementList)) {
            return;
        }
        PsiClass resolved = (PsiClass)ObjectUtils.tryCast((Object)resultForIncompleteCode.getElement(), PsiClass.class);
        if (resolved == null) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.PATTERN_TYPE_PATTERN_EXPECTED.create(expression, resolved));
    }

    void checkDeconstructionPattern(@NotNull PsiDeconstructionPattern deconstructionPattern) {
        if (deconstructionPattern == null) {
            PatternChecker.$$$reportNull$$$0(4);
        }
        PsiTreeUtil.processElements((PsiElement)deconstructionPattern.getTypeElement(), PsiAnnotation.class, annotation -> {
            this.myVisitor.report(JavaErrorKinds.PATTERN_DECONSTRUCTION_ANNOTATION.create((PsiAnnotation)annotation));
            return true;
        });
        PsiElement parent = deconstructionPattern.getParent();
        if (parent instanceof PsiForeachPatternStatement) {
            PsiType itemType;
            PsiForeachPatternStatement forEach = (PsiForeachPatternStatement)parent;
            this.myVisitor.checkFeature((PsiElement)deconstructionPattern, JavaFeature.RECORD_PATTERNS_IN_FOR_EACH);
            if (this.myVisitor.hasErrorResults()) {
                return;
            }
            PsiTypeElement typeElement = JavaPsiPatternUtil.getPatternTypeElement((PsiCaseLabelElement)deconstructionPattern);
            if (typeElement == null) {
                return;
            }
            PsiType patternType = typeElement.getType();
            PsiExpression iteratedValue = forEach.getIteratedValue();
            PsiType psiType = itemType = iteratedValue == null ? null : JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue);
            if (itemType == null) {
                return;
            }
            this.checkForEachPatternApplicable(deconstructionPattern, patternType, itemType);
            if (this.myVisitor.hasErrorResults()) {
                return;
            }
            PsiClass selectorClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)TypeConversionUtil.erasure((PsiType)itemType));
            if (selectorClass != null && (selectorClass.hasModifierProperty("sealed") || selectorClass.isRecord())) {
                if (!JavaPatternExhaustivenessUtil.checkRecordExhaustiveness(Collections.singletonList(deconstructionPattern), (PsiType)patternType, (PsiElement)forEach).isExhaustive()) {
                    this.myVisitor.report(JavaErrorKinds.PATTERN_NOT_EXHAUSTIVE.create(deconstructionPattern, new JavaErrorKinds.PatternTypeContext(itemType, patternType)));
                }
            } else {
                this.myVisitor.report(JavaErrorKinds.PATTERN_NOT_EXHAUSTIVE.create(deconstructionPattern, new JavaErrorKinds.PatternTypeContext(itemType, patternType)));
            }
        } else {
            this.myVisitor.checkFeature((PsiElement)deconstructionPattern, JavaFeature.PATTERN_GUARDS_AND_RECORD_PATTERNS);
        }
    }

    boolean checkUncheckedPatternConversion(@NotNull PsiPattern pattern) {
        PsiType contextType;
        PsiDeconstructionPattern subPattern;
        PsiJavaCodeReferenceElement element;
        PsiType patternType;
        if (pattern == null) {
            PatternChecker.$$$reportNull$$$0(5);
        }
        if ((patternType = JavaPsiPatternUtil.getPatternType((PsiCaseLabelElement)pattern)) == null) {
            return false;
        }
        if (pattern instanceof PsiDeconstructionPattern && (element = (subPattern = (PsiDeconstructionPattern)pattern).getTypeElement().getInnermostComponentReferenceElement()) != null && element.getTypeParameterCount() == 0 && patternType instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)patternType;
            patternType = classType.rawType();
        }
        if ((contextType = JavaPsiPatternUtil.getContextType((PsiPattern)pattern)) == null) {
            return false;
        }
        if (contextType instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)contextType;
            contextType = wildcardType.getExtendsBound();
        }
        if (!JavaGenericsUtil.isUncheckedCast((PsiType)patternType, (PsiType)contextType)) {
            return false;
        }
        this.myVisitor.report(JavaErrorKinds.PATTERN_UNSAFE_CAST.create(pattern, new JavaErrorKinds.PatternTypeContext(contextType, patternType)));
        return true;
    }

    private void checkForEachPatternApplicable(@NotNull PsiDeconstructionPattern pattern, @NotNull PsiType patternType, @NotNull PsiType itemType) {
        if (pattern == null) {
            PatternChecker.$$$reportNull$$$0(6);
        }
        if (patternType == null) {
            PatternChecker.$$$reportNull$$$0(7);
        }
        if (itemType == null) {
            PatternChecker.$$$reportNull$$$0(8);
        }
        if (!(TypeConversionUtil.areTypesConvertible((PsiType)itemType, (PsiType)patternType) || this.myVisitor.isIncompleteModel() && IncompleteModelUtil.isPotentiallyConvertible((PsiType)patternType, (PsiType)itemType, (PsiElement)pattern))) {
            this.myVisitor.reportIncompatibleType(itemType, patternType, (PsiElement)pattern);
            return;
        }
        this.checkUncheckedPatternConversion((PsiPattern)pattern);
        if (this.myVisitor.hasErrorResults()) {
            return;
        }
        this.checkDeconstructionErrors(pattern);
    }

    void checkDeconstructionErrors(@Nullable PsiDeconstructionPattern deconstructionPattern) {
        PsiClassType.ClassResolveResult classResolveResult;
        if (deconstructionPattern == null) {
            return;
        }
        PsiTypeElement typeElement = deconstructionPattern.getTypeElement();
        PsiType recordType = typeElement.getType();
        if (recordType instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)recordType;
            classResolveResult = classType.resolveGenerics();
        } else {
            classResolveResult = PsiClassType.ClassResolveResult.EMPTY;
        }
        PsiClassType.ClassResolveResult resolveResult = classResolveResult;
        PsiClass recordClass = resolveResult.getElement();
        if (recordClass == null || !recordClass.isRecord()) {
            this.myVisitor.report(JavaErrorKinds.PATTERN_DECONSTRUCTION_REQUIRES_RECORD.create(typeElement));
            return;
        }
        if (resolveResult.getInferenceError() != null) {
            this.myVisitor.report(JavaErrorKinds.PATTERN_CANNOT_INFER_TYPE.create(typeElement, resolveResult.getInferenceError()));
            return;
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        PsiRecordComponent[] recordComponents = recordClass.getRecordComponents();
        PsiPattern[] deconstructionComponents = deconstructionPattern.getDeconstructionList().getDeconstructionComponents();
        boolean hasMismatchedPattern = false;
        for (int i = 0; i < Math.min(recordComponents.length, deconstructionComponents.length); ++i) {
            LanguageLevel languageLevel;
            PsiType deconstructionComponentType;
            PsiPattern deconstructionComponent = deconstructionComponents[i];
            PsiType recordComponentType = recordComponents[i].getType();
            PsiType substitutedRecordComponentType = substitutor.substitute(recordComponentType);
            if (!PatternChecker.isApplicableForRecordComponent(substitutedRecordComponentType, deconstructionComponentType = JavaPsiPatternUtil.getPatternType((PsiCaseLabelElement)deconstructionComponent), languageLevel = PsiUtil.getLanguageLevel((PsiElement)deconstructionPattern))) {
                hasMismatchedPattern = true;
                if (recordComponents.length == deconstructionComponents.length) {
                    if (PatternChecker.isApplicableForRecordComponent(substitutedRecordComponentType, deconstructionComponentType, JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS.getMinimumLevel())) {
                        this.myVisitor.report(JavaErrorKinds.UNSUPPORTED_FEATURE.create((PsiElement)deconstructionComponent, JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS));
                        continue;
                    }
                    if ((substitutedRecordComponentType instanceof PsiPrimitiveType || deconstructionComponentType instanceof PsiPrimitiveType) && JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS.isSufficient(languageLevel)) {
                        this.myVisitor.report(JavaErrorKinds.CAST_INCONVERTIBLE.create((PsiElement)deconstructionComponent, new JavaIncompatibleTypeErrorContext(substitutedRecordComponentType, deconstructionComponentType)));
                        continue;
                    }
                    if (this.myVisitor.isIncompleteModel() && (IncompleteModelUtil.hasUnresolvedComponent((PsiType)substitutedRecordComponentType) || IncompleteModelUtil.hasUnresolvedComponent((PsiType)deconstructionComponentType))) continue;
                    this.myVisitor.reportIncompatibleType(substitutedRecordComponentType, deconstructionComponentType, (PsiElement)deconstructionComponent);
                }
            } else {
                hasMismatchedPattern |= this.checkUncheckedPatternConversion(deconstructionComponent);
            }
            if (recordComponents.length != deconstructionComponents.length && hasMismatchedPattern) break;
            if (!(deconstructionComponent instanceof PsiDeconstructionPattern)) continue;
            PsiDeconstructionPattern deconstructionComponentPattern = (PsiDeconstructionPattern)deconstructionComponent;
            this.checkDeconstructionErrors(deconstructionComponentPattern);
        }
        if (recordComponents.length != deconstructionComponents.length) {
            this.myVisitor.report(JavaErrorKinds.PATTERN_DECONSTRUCTION_COUNT_MISMATCH.create(deconstructionPattern.getDeconstructionList(), new JavaErrorKinds.DeconstructionCountMismatchContext(deconstructionComponents, recordComponents, hasMismatchedPattern)));
        }
    }

    void checkMalformedDeconstructionPatternInCase(@NotNull PsiDeconstructionPattern pattern) {
        PsiElement grandParent;
        if (pattern == null) {
            PatternChecker.$$$reportNull$$$0(9);
        }
        if (!((grandParent = pattern.getParent()) instanceof PsiCaseLabelElementList)) {
            return;
        }
        PsiTypeElement typeElement = pattern.getTypeElement();
        PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)typeElement, PsiJavaCodeReferenceElement.class);
        if (ref == null) {
            return;
        }
        if (ref.multiResolve(true).length == 0) {
            PsiElementFactory elementFactory = this.myVisitor.factory();
            if (pattern.getPatternVariable() == null && pattern.getDeconstructionList().getDeconstructionComponents().length == 0) {
                PsiExpression expression;
                PsiMethodCallExpression call;
                PsiClassType type = (PsiClassType)ObjectUtils.tryCast((Object)pattern.getTypeElement().getType(), PsiClassType.class);
                if (type != null) {
                    if (ContainerUtil.exists((Object[])type.getParameters(), PsiWildcardType.class::isInstance)) {
                        return;
                    }
                }
                if ((call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)(expression = elementFactory.createExpressionFromText(pattern.getText(), grandParent)), PsiMethodCallExpression.class)) == null) {
                    return;
                }
                if (call.getMethodExpression().resolve() != null) {
                    this.myVisitor.report(JavaErrorKinds.CALL_PARSED_AS_DECONSTRUCTION_PATTERN.create(pattern));
                }
            }
        }
    }

    void checkInstanceOfPatternSupertype(@NotNull PsiInstanceOfExpression expression) {
        PsiPrimaryPattern expressionPattern;
        PsiTypeTestPattern pattern;
        if (expression == null) {
            PatternChecker.$$$reportNull$$$0(10);
        }
        if ((pattern = (PsiTypeTestPattern)ObjectUtils.tryCast((Object)(expressionPattern = expression.getPattern()), PsiTypeTestPattern.class)) == null) {
            return;
        }
        PsiPatternVariable variable = pattern.getPatternVariable();
        if (variable == null) {
            return;
        }
        PsiTypeElement typeElement = pattern.getCheckType();
        if (typeElement == null) {
            return;
        }
        PsiType checkType = typeElement.getType();
        PsiType expressionType = expression.getOperand().getType();
        if (expressionType != null && checkType.isAssignableFrom(expressionType)) {
            if (checkType.equals(expressionType)) {
                this.myVisitor.report(JavaErrorKinds.PATTERN_INSTANCEOF_EQUALS.create(pattern, checkType));
            } else {
                this.myVisitor.report(JavaErrorKinds.PATTERN_INSTANCEOF_SUPERTYPE.create(pattern, new JavaIncompatibleTypeErrorContext(checkType, expressionType)));
            }
        }
    }

    private static boolean isApplicableForRecordComponent(@NotNull PsiType recordComponentType, @Nullable PsiType patternType, @NotNull LanguageLevel languageLevel) {
        if (recordComponentType == null) {
            PatternChecker.$$$reportNull$$$0(11);
        }
        if (languageLevel == null) {
            PatternChecker.$$$reportNull$$$0(12);
        }
        if ((recordComponentType instanceof PsiPrimitiveType || patternType instanceof PsiPrimitiveType) && !JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS.isSufficient(languageLevel)) {
            return recordComponentType.equals(patternType);
        }
        return patternType != null && TypeConversionUtil.areTypesConvertible((PsiType)recordComponentType, (PsiType)patternType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultForIncompleteCode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deconstructionPattern";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordComponentType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/highlighting/PatternChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDeconstructionVariable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPatternVariableRequired";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDeconstructionPattern";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUncheckedPatternConversion";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForEachPatternApplicable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMalformedDeconstructionPatternInCase";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInstanceOfPatternSupertype";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableForRecordComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

