/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ReceiverChecker {
    @NotNull
    private final JavaErrorVisitor myVisitor;

    ReceiverChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            ReceiverChecker.$$$reportNull$$$0(0);
        }
        this.myVisitor = visitor;
    }

    void checkReceiver(@NotNull PsiReceiverParameter parameter) {
        if (parameter == null) {
            ReceiverChecker.$$$reportNull$$$0(1);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.myVisitor.checkFeature((PsiElement)parameter, JavaFeature.RECEIVERS);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkReceiverPlacement(parameter);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkReceiverType(parameter);
        }
    }

    private void checkReceiverType(@NotNull PsiReceiverParameter parameter) {
        PsiElement owner;
        if (parameter == null) {
            ReceiverChecker.$$$reportNull$$$0(2);
        }
        if (!((owner = parameter.getParent().getParent()) instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)owner;
        PsiClass enclosingClass = method.getContainingClass();
        boolean isConstructor = method.isConstructor();
        if (isConstructor && enclosingClass != null) {
            enclosingClass = enclosingClass.getContainingClass();
        }
        if (enclosingClass == null) {
            return;
        }
        PsiClassType type = this.myVisitor.factory().createType(enclosingClass, PsiSubstitutor.EMPTY);
        if (!type.equals((Object)parameter.getType())) {
            this.myVisitor.report(JavaErrorKinds.RECEIVER_TYPE_MISMATCH.create(parameter, (PsiType)type));
            return;
        }
        PsiThisExpression identifier = parameter.getIdentifier();
        if (!enclosingClass.equals((Object)PsiUtil.resolveClassInType((PsiType)identifier.getType()))) {
            String className;
            Object name = isConstructor ? ((className = enclosingClass.getName()) != null ? className + ".this" : null) : "this";
            this.myVisitor.report(JavaErrorKinds.RECEIVER_NAME_MISMATCH.create(parameter, (String)name));
        }
    }

    private void checkReceiverPlacement(@NotNull PsiReceiverParameter parameter) {
        PsiElement owner;
        if (parameter == null) {
            ReceiverChecker.$$$reportNull$$$0(3);
        }
        if ((owner = parameter.getParent().getParent()) == null) {
            return;
        }
        if (!(owner instanceof PsiMethod)) {
            this.myVisitor.report(JavaErrorKinds.RECEIVER_WRONG_CONTEXT.create(parameter));
            return;
        }
        PsiMethod method = (PsiMethod)owner;
        if (ReceiverChecker.isStatic((PsiModifierListOwner)method) || method.isConstructor() && ReceiverChecker.isStatic((PsiModifierListOwner)method.getContainingClass())) {
            this.myVisitor.report(JavaErrorKinds.RECEIVER_STATIC_CONTEXT.create(parameter));
            return;
        }
        if (!PsiUtil.isJavaToken((PsiElement)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)parameter), (IElementType)JavaTokenType.LPARENTH)) {
            this.myVisitor.report(JavaErrorKinds.RECEIVER_WRONG_POSITION.create(parameter));
        }
    }

    private static boolean isStatic(@Nullable PsiModifierListOwner owner) {
        PsiClass psiClass;
        if (owner == null) {
            return false;
        }
        if (owner instanceof PsiClass && ClassUtil.isTopLevelClass((PsiClass)(psiClass = (PsiClass)owner))) {
            return true;
        }
        PsiModifierList modifierList = owner.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty("static");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/highlighting/ReceiverChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReceiver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReceiverType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReceiverPlacement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

