/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.MethodChecker;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.java.codeserver.highlighting.errors.JavaIncompatibleTypeErrorContext;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.light.LightRecordMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.AccessModifier;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class RecordChecker {
    @NotNull
    private final JavaErrorVisitor myVisitor;

    RecordChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            RecordChecker.$$$reportNull$$$0(0);
        }
        this.myVisitor = visitor;
    }

    void checkRecordHeader(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            RecordChecker.$$$reportNull$$$0(1);
        }
        PsiRecordHeader header = psiClass.getRecordHeader();
        if (!psiClass.isRecord()) {
            if (header != null) {
                this.myVisitor.report(JavaErrorKinds.RECORD_HEADER_REGULAR_CLASS.create(header));
            }
            return;
        }
        PsiIdentifier identifier = psiClass.getNameIdentifier();
        if (identifier == null) {
            return;
        }
        if (header == null) {
            this.myVisitor.report(JavaErrorKinds.RECORD_NO_HEADER.create(psiClass));
        }
    }

    void checkRecordComponentWellFormed(@NotNull PsiRecordComponent component) {
        if (component == null) {
            RecordChecker.$$$reportNull$$$0(2);
        }
        if (component.isVarArgs() && PsiTreeUtil.getNextSiblingOfType((PsiElement)component, PsiRecordComponent.class) != null) {
            this.myVisitor.report(JavaErrorKinds.RECORD_COMPONENT_VARARG_NOT_LAST.create(component));
            return;
        }
        TextRange range = MethodChecker.getCStyleDeclarationRange((PsiVariable)component);
        if (range != null) {
            this.myVisitor.report(JavaErrorKinds.RECORD_COMPONENT_CSTYLE_DECLARATION.create(component, range));
            return;
        }
        PsiIdentifier identifier = component.getNameIdentifier();
        if (identifier != null && JavaPsiRecordUtil.ILLEGAL_RECORD_COMPONENT_NAMES.contains(identifier.getText())) {
            this.myVisitor.report(JavaErrorKinds.RECORD_COMPONENT_RESTRICTED_NAME.create(component));
        }
    }

    void checkRecordAccessorReturnType(@NotNull PsiRecordComponent component) {
        PsiMethod[] methods;
        if (component == null) {
            RecordChecker.$$$reportNull$$$0(3);
        }
        String componentName = component.getName();
        PsiTypeElement typeElement = component.getTypeElement();
        if (typeElement == null) {
            return;
        }
        PsiClass containingClass = component.getContainingClass();
        if (containingClass == null) {
            return;
        }
        for (PsiMethod method : methods = containingClass.findMethodsByName(componentName, false)) {
            if (!(method instanceof LightRecordMethod)) continue;
            List superSignatures = PsiSuperMethodImplUtil.getHierarchicalMethodSignature((PsiMethod)method, (GlobalSearchScope)method.getResolveScope()).getSuperSignatures();
            MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            this.myVisitor.myMethodChecker.checkMethodIncompatibleReturnType((PsiMember)component, signature, superSignatures);
        }
    }

    void checkRecordAccessorDeclaration(@NotNull PsiMethod method) {
        PsiRecordComponent component;
        if (method == null) {
            RecordChecker.$$$reportNull$$$0(4);
        }
        if ((component = JavaPsiRecordUtil.getRecordComponentForAccessor((PsiMethod)method)) == null) {
            return;
        }
        PsiIdentifier identifier = method.getNameIdentifier();
        if (identifier == null) {
            return;
        }
        PsiType componentType = component.getType();
        PsiType methodType = method.getReturnType();
        if (methodType == null) {
            return;
        }
        if (componentType instanceof PsiEllipsisType) {
            PsiEllipsisType ellipsisType = (PsiEllipsisType)componentType;
            componentType = ellipsisType.getComponentType().createArrayType();
        }
        if (!componentType.equals(methodType)) {
            this.myVisitor.report(JavaErrorKinds.RECORD_ACCESSOR_WRONG_RETURN_TYPE.create(method, new JavaIncompatibleTypeErrorContext(componentType, methodType)));
            return;
        }
        if (!method.hasModifierProperty("public")) {
            this.myVisitor.report(JavaErrorKinds.RECORD_ACCESSOR_NON_PUBLIC.create(method));
            return;
        }
        this.checkRecordSpecialMethodDeclaration(method);
    }

    private void checkRecordSpecialMethodDeclaration(@NotNull PsiMethod method) {
        PsiReferenceList throwsList;
        PsiIdentifier identifier;
        if (method == null) {
            RecordChecker.$$$reportNull$$$0(5);
        }
        if ((identifier = method.getNameIdentifier()) == null) {
            return;
        }
        PsiTypeParameterList typeParameterList = method.getTypeParameterList();
        if (typeParameterList != null && typeParameterList.getTypeParameters().length > 0) {
            this.myVisitor.report(JavaErrorKinds.RECORD_SPECIAL_METHOD_TYPE_PARAMETERS.create(typeParameterList));
            return;
        }
        if (method.isConstructor()) {
            AccessModifier classModifier;
            AccessModifier modifier = AccessModifier.fromModifierList((PsiModifierList)method.getModifierList());
            PsiModifierList classModifierList = Objects.requireNonNull(method.getContainingClass()).getModifierList();
            if (classModifierList != null && (classModifier = AccessModifier.fromModifierList((PsiModifierList)classModifierList)).isWeaker(modifier)) {
                this.myVisitor.report(JavaErrorKinds.RECORD_CONSTRUCTOR_STRONGER_ACCESS.create(method, classModifier));
                return;
            }
        }
        if ((throwsList = method.getThrowsList()).getReferenceElements().length > 0) {
            this.myVisitor.report(JavaErrorKinds.RECORD_SPECIAL_METHOD_THROWS.create(throwsList));
        }
    }

    void checkRecordConstructorDeclaration(@NotNull PsiMethod method) {
        if (method == null) {
            RecordChecker.$$$reportNull$$$0(6);
        }
        if (!method.isConstructor()) {
            return;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return;
        }
        PsiIdentifier identifier = method.getNameIdentifier();
        if (identifier == null) {
            return;
        }
        if (!aClass.isRecord()) {
            if (JavaPsiRecordUtil.isCompactConstructor((PsiMethod)method)) {
                this.myVisitor.report(JavaErrorKinds.METHOD_NO_PARAMETER_LIST.create(method));
            }
            return;
        }
        if (JavaPsiRecordUtil.isExplicitCanonicalConstructor((PsiMethod)method)) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiRecordComponent[] components = aClass.getRecordComponents();
            assert (parameters.length == components.length);
            for (int i = 0; i < parameters.length; ++i) {
                PsiRecordComponent component = components[i];
                PsiParameter parameter = parameters[i];
                if (!parameter.getType().equals(component.getType())) {
                    this.myVisitor.report(JavaErrorKinds.RECORD_CANONICAL_CONSTRUCTOR_WRONG_PARAMETER_TYPE.create(parameter, component));
                    continue;
                }
                if (parameter.getName().equals(component.getName())) continue;
                this.myVisitor.report(JavaErrorKinds.RECORD_CANONICAL_CONSTRUCTOR_WRONG_PARAMETER_NAME.create(parameter, component));
            }
            this.checkRecordSpecialMethodDeclaration(method);
            return;
        }
        if (JavaPsiRecordUtil.isCompactConstructor((PsiMethod)method)) {
            this.checkRecordSpecialMethodDeclaration(method);
            return;
        }
        PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method);
        if (call == null || JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)call)) {
            this.myVisitor.report(JavaErrorKinds.RECORD_NO_CONSTRUCTOR_CALL_IN_NON_CANONICAL.create(method));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/highlighting/RecordChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRecordHeader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRecordComponentWellFormed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRecordAccessorReturnType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRecordAccessorDeclaration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRecordSpecialMethodDeclaration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRecordConstructorDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

