/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.core.JavaPsiBundle;
import com.intellij.java.codeserver.core.JavaPatternExhaustivenessUtil;
import com.intellij.java.codeserver.core.JavaPsiSwitchUtil;
import com.intellij.java.codeserver.highlighting.ControlFlowChecker;
import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.java.codeserver.highlighting.errors.JavaIncompatibleTypeErrorContext;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiDefaultCaseLabelElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.IncompleteModelUtil;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SwitchChecker {
    @NotNull
    private final JavaErrorVisitor myVisitor;

    SwitchChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            SwitchChecker.$$$reportNull$$$0(0);
        }
        this.myVisitor = visitor;
    }

    void checkSwitchBlock(@NotNull PsiSwitchBlock block) {
        if (block == null) {
            SwitchChecker.$$$reportNull$$$0(1);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkSwitchBlockStatements(block);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkSwitchSelectorType(block);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkLabelSelectorCompatibility(block);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkDuplicates(block);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkFallthroughLegality(block);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkDominance(block);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkNoDefaultBranchAllowed(block);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkExhaustiveness(block);
        }
    }

    void checkSwitchExpressionReturnTypeCompatible(@NotNull PsiSwitchExpression switchExpression) {
        if (switchExpression == null) {
            SwitchChecker.$$$reportNull$$$0(2);
        }
        if (!PsiPolyExpressionUtil.isPolyExpression((PsiExpression)switchExpression)) {
            return;
        }
        PsiType switchExpressionType = switchExpression.getType();
        if (switchExpressionType != null) {
            for (PsiExpression expression : PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)switchExpression)) {
                PsiType expressionType = expression.getType();
                if (expressionType == null || TypeConversionUtil.areTypesAssignmentCompatible((PsiType)switchExpressionType, (PsiExpression)expression)) continue;
                this.myVisitor.report(JavaErrorKinds.SWITCH_EXPRESSION_INCOMPATIBLE_TYPE.create(expression, new JavaIncompatibleTypeErrorContext(switchExpressionType, expressionType)));
            }
            if (PsiTypes.voidType().equals((Object)switchExpressionType)) {
                this.myVisitor.report(JavaErrorKinds.SWITCH_EXPRESSION_CANNOT_BE_VOID.create(switchExpression));
            }
        }
    }

    private void checkSwitchBlockStatements(@NotNull PsiSwitchBlock block) {
        PsiCodeBlock body;
        if (block == null) {
            SwitchChecker.$$$reportNull$$$0(3);
        }
        if ((body = block.getBody()) == null) {
            return;
        }
        PsiElement first = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)body.getLBrace());
        if (first != null && !(first instanceof PsiSwitchLabelStatementBase) && !PsiUtil.isJavaToken((PsiElement)first, (IElementType)JavaTokenType.RBRACE)) {
            this.myVisitor.report(JavaErrorKinds.SWITCH_LABEL_EXPECTED.create(first));
        }
        PsiElement element = first;
        PsiStatement alien = null;
        boolean classicLabels = false;
        boolean enhancedLabels = false;
        boolean levelChecked = false;
        while (element != null && !PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.RBRACE)) {
            PsiSwitchLabelStatementBase label;
            PsiCaseLabelElementList values;
            if (element instanceof PsiSwitchLabeledRuleStatement) {
                if (!levelChecked) {
                    this.myVisitor.checkFeature(element, JavaFeature.ENHANCED_SWITCH);
                    if (this.myVisitor.hasErrorResults()) {
                        return;
                    }
                    levelChecked = true;
                }
                if (classicLabels) {
                    alien = (PsiStatement)element;
                    break;
                }
                enhancedLabels = true;
            } else if (element instanceof PsiStatement) {
                PsiStatement statement = (PsiStatement)element;
                if (enhancedLabels) {
                    PsiErrorElement errorElement;
                    PsiElement psiElement;
                    PsiSwitchLabelStatement labelStatement;
                    if (statement instanceof PsiSwitchLabelStatement && (labelStatement = (PsiSwitchLabelStatement)statement).getChildren().length != 0 && (psiElement = labelStatement.getChildren()[labelStatement.getChildren().length - 1]) instanceof PsiErrorElement && (errorElement = (PsiErrorElement)psiElement).getErrorDescription().startsWith(JavaPsiBundle.message((String)"expected.colon.or.arrow", (Object[])new Object[0]))) break;
                    alien = statement;
                    break;
                }
                classicLabels = true;
            }
            if (!levelChecked && element instanceof PsiSwitchLabelStatementBase && (values = (label = (PsiSwitchLabelStatementBase)element).getCaseLabelElementList()) != null && values.getElementCount() > 1) {
                this.myVisitor.checkFeature((PsiElement)values, JavaFeature.ENHANCED_SWITCH);
                if (this.myVisitor.hasErrorResults()) {
                    return;
                }
                levelChecked = true;
            }
            element = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
        }
        if (alien == null) {
            return;
        }
        if (enhancedLabels && !(alien instanceof PsiSwitchLabelStatementBase)) {
            this.myVisitor.report(JavaErrorKinds.SWITCH_LABEL_EXPECTED.create((PsiElement)alien));
            return;
        }
        this.myVisitor.report(JavaErrorKinds.SWITCH_DIFFERENT_CASE_KINDS.create(alien));
    }

    private void checkSwitchSelectorType(@NotNull PsiSwitchBlock block) {
        PsiClass member;
        PsiExpression selector;
        if (block == null) {
            SwitchChecker.$$$reportNull$$$0(4);
        }
        if ((selector = block.getExpression()) == null) {
            return;
        }
        PsiType selectorType = selector.getType();
        if (selectorType == null) {
            return;
        }
        JavaPsiSwitchUtil.SelectorKind kind = JavaPsiSwitchUtil.getSwitchSelectorKind((PsiType)selectorType);
        JavaFeature requiredFeature = kind.getFeature();
        if ((kind == JavaPsiSwitchUtil.SelectorKind.INVALID || requiredFeature != null && !this.myVisitor.isApplicable(requiredFeature)) && !PsiTreeUtil.hasErrorElements((PsiElement)block)) {
            this.myVisitor.report(JavaErrorKinds.SWITCH_SELECTOR_TYPE_INVALID.create(selector, kind));
        }
        if ((member = PsiUtil.resolveClassInClassTypeOnly((PsiType)selectorType)) != null && !PsiUtil.isAccessible((Project)member.getProject(), (PsiMember)member, (PsiElement)selector, null)) {
            this.myVisitor.report(JavaErrorKinds.TYPE_INACCESSIBLE.create((PsiElement)selector, member));
        }
    }

    void checkSwitchExpressionHasResult(@NotNull PsiSwitchExpression switchExpression) {
        PsiCodeBlock switchBody;
        if (switchExpression == null) {
            SwitchChecker.$$$reportNull$$$0(5);
        }
        if ((switchBody = switchExpression.getBody()) != null) {
            PsiStatement lastStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)switchBody.getRBrace(), PsiStatement.class);
            boolean hasResult = false;
            if (lastStatement instanceof PsiSwitchLabeledRuleStatement) {
                PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)lastStatement;
                boolean reported = false;
                while (rule != null) {
                    PsiStatement ruleBody = rule.getBody();
                    if (ruleBody instanceof PsiExpressionStatement) {
                        hasResult = true;
                    }
                    if (ruleBody instanceof PsiBlockStatement) {
                        ControlFlow flow = ControlFlowChecker.getControlFlow((PsiElement)ruleBody);
                        if (flow != null && ControlFlowUtil.canCompleteNormally((ControlFlow)flow, (int)0, (int)flow.getSize())) {
                            this.myVisitor.report(JavaErrorKinds.SWITCH_RULE_SHOULD_PRODUCE_RESULT.create(rule));
                            reported = true;
                        } else if (!hasResult && SwitchChecker.hasYield(switchExpression, (PsiElement)ruleBody)) {
                            hasResult = true;
                        }
                    }
                    rule = (PsiSwitchLabeledRuleStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)rule, PsiSwitchLabeledRuleStatement.class);
                }
                if (reported) {
                    return;
                }
            } else {
                if (lastStatement != null) {
                    boolean canCompleteNormally;
                    if (lastStatement instanceof PsiSwitchLabelStatement) {
                        canCompleteNormally = true;
                    } else {
                        ControlFlow flow = ControlFlowChecker.getControlFlow((PsiElement)lastStatement);
                        boolean bl = canCompleteNormally = flow != null && ControlFlowUtil.canCompleteNormally((ControlFlow)flow, (int)0, (int)flow.getSize());
                    }
                    if (canCompleteNormally) {
                        this.myVisitor.report(JavaErrorKinds.SWITCH_EXPRESSION_SHOULD_PRODUCE_RESULT.create(switchExpression));
                        return;
                    }
                }
                hasResult = SwitchChecker.hasYield(switchExpression, (PsiElement)switchBody);
            }
            if (!hasResult && PsiTreeUtil.getChildOfType((PsiElement)switchBody, PsiSwitchLabelStatementBase.class) != null) {
                this.myVisitor.report(JavaErrorKinds.SWITCH_EXPRESSION_NO_RESULT.create(switchExpression));
            }
        }
    }

    private static boolean hasYield(@NotNull PsiSwitchExpression switchExpression, @NotNull PsiElement scope) {
        if (switchExpression == null) {
            SwitchChecker.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            SwitchChecker.$$$reportNull$$$0(7);
        }
        class YieldFinder
        extends JavaRecursiveElementWalkingVisitor {
            private boolean hasYield;
            final /* synthetic */ PsiSwitchExpression val$switchExpression;

            YieldFinder(PsiSwitchExpression psiSwitchExpression) {
                this.val$switchExpression = psiSwitchExpression;
            }

            public void visitYieldStatement(@NotNull PsiYieldStatement statement) {
                if (statement == null) {
                    YieldFinder.$$$reportNull$$$0(0);
                }
                if (statement.findEnclosingExpression() == this.val$switchExpression) {
                    this.hasYield = true;
                    this.stopWalking();
                }
            }

            public void visitDeclarationStatement(@NotNull PsiDeclarationStatement statement) {
                if (statement == null) {
                    YieldFinder.$$$reportNull$$$0(1);
                }
            }

            public void visitExpression(@NotNull PsiExpression expression) {
                if (expression == null) {
                    YieldFinder.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/java/codeserver/highlighting/SwitchChecker$1YieldFinder";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitYieldStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDeclarationStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        YieldFinder finder = new YieldFinder(switchExpression);
        scope.accept((PsiElementVisitor)finder);
        return finder.hasYield;
    }

    void checkLocalClassReferencedFromAnotherSwitchBranch(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiClass aClass) {
        PsiCodeBlock codeBlock;
        PsiDeclarationStatement declarationStatement;
        PsiElement psiElement;
        if (ref == null) {
            SwitchChecker.$$$reportNull$$$0(8);
        }
        if (aClass == null) {
            SwitchChecker.$$$reportNull$$$0(9);
        }
        if (!((psiElement = aClass.getParent()) instanceof PsiDeclarationStatement && (psiElement = (declarationStatement = (PsiDeclarationStatement)psiElement).getParent()) instanceof PsiCodeBlock && (codeBlock = (PsiCodeBlock)psiElement).getParent() instanceof PsiSwitchBlock)) {
            return;
        }
        boolean classSeen = false;
        for (PsiStatement statement : codeBlock.getStatements()) {
            if (classSeen) {
                if (PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)ref, (boolean)true)) break;
                if (!(statement instanceof PsiSwitchLabelStatement)) continue;
                this.myVisitor.report(JavaErrorKinds.REFERENCE_LOCAL_CLASS_OTHER_SWITCH_BRANCH.create(ref, aClass));
                return;
            }
            if (statement != declarationStatement) continue;
            classSeen = true;
        }
    }

    void checkYieldOutsideSwitchExpression(@NotNull PsiYieldStatement statement) {
        if (statement == null) {
            SwitchChecker.$$$reportNull$$$0(10);
        }
        if (statement.findEnclosingExpression() == null) {
            this.myVisitor.report(JavaErrorKinds.YIELD_UNEXPECTED.create(statement));
        }
    }

    void checkCaseStatement(@NotNull PsiSwitchLabelStatementBase statement) {
        PsiSwitchBlock switchBlock;
        if (statement == null) {
            SwitchChecker.$$$reportNull$$$0(11);
        }
        if ((switchBlock = statement.getEnclosingSwitchBlock()) == null) {
            this.myVisitor.report(JavaErrorKinds.STATEMENT_CASE_OUTSIDE_SWITCH.create(statement));
        }
    }

    void checkGuard(@NotNull PsiSwitchLabelStatementBase statement) {
        PsiExpression guardingExpr;
        if (statement == null) {
            SwitchChecker.$$$reportNull$$$0(12);
        }
        if ((guardingExpr = statement.getGuardExpression()) == null) {
            return;
        }
        this.myVisitor.checkFeature((PsiElement)guardingExpr, JavaFeature.PATTERN_GUARDS_AND_RECORD_PATTERNS);
        if (this.myVisitor.hasErrorResults()) {
            return;
        }
        PsiCaseLabelElementList list = statement.getCaseLabelElementList();
        if (list != null && !ContainerUtil.exists((Object[])list.getElements(), e -> e instanceof PsiPattern)) {
            this.myVisitor.report(JavaErrorKinds.GUARD_MISPLACED.create(guardingExpr));
            return;
        }
        if (!TypeConversionUtil.isBooleanType((PsiType)guardingExpr.getType())) {
            this.myVisitor.reportIncompatibleType((PsiType)PsiTypes.booleanType(), guardingExpr.getType(), (PsiElement)guardingExpr);
            return;
        }
        Object constVal = JavaPsiFacade.getInstance((Project)this.myVisitor.project()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)guardingExpr);
        if (Boolean.FALSE.equals(constVal)) {
            this.myVisitor.report(JavaErrorKinds.GUARD_EVALUATED_TO_FALSE.create(guardingExpr));
        }
    }

    void checkYieldExpressionType(@NotNull PsiExpression expression) {
        if (expression == null) {
            SwitchChecker.$$$reportNull$$$0(13);
        }
        if (PsiTypes.voidType().equals((Object)expression.getType())) {
            this.myVisitor.report(JavaErrorKinds.YIELD_VOID.create(expression));
        }
    }

    private void checkLabelSelectorCompatibility(@NotNull PsiSwitchBlock block) {
        PsiCodeBlock body;
        if (block == null) {
            SwitchChecker.$$$reportNull$$$0(14);
        }
        if ((body = block.getBody()) == null) {
            return;
        }
        PsiExpression selector = block.getExpression();
        if (selector == null) {
            return;
        }
        PsiType selectorType = selector.getType();
        if (selectorType == null) {
            return;
        }
        boolean patterns = this.myVisitor.isApplicable(JavaFeature.PATTERNS_IN_SWITCH);
        for (PsiStatement st : body.getStatements()) {
            PsiCaseLabelElementList labelElementList;
            PsiSwitchLabelStatementBase labelStatement;
            if (!(st instanceof PsiSwitchLabelStatementBase) || (labelStatement = (PsiSwitchLabelStatementBase)st).isDefaultCase() || (labelElementList = labelStatement.getCaseLabelElementList()) == null) continue;
            for (PsiCaseLabelElement label : labelElementList.getElements()) {
                if (!(label instanceof PsiParenthesizedExpression) && ExpressionUtil.isNullLiteral((PsiElement)label)) {
                    if (!(selectorType instanceof PsiPrimitiveType) || PsiTypes.nullType().equals(selectorType)) continue;
                    this.myVisitor.report(JavaErrorKinds.SWITCH_NULL_TYPE_INCOMPATIBLE.create(label, selectorType));
                    continue;
                }
                if (label instanceof PsiExpression) {
                    PsiReferenceExpression ref;
                    String enumConstName;
                    PsiExpression expr = (PsiExpression)label;
                    if (selectorType.equals(PsiTypes.nullType())) {
                        this.myVisitor.reportIncompatibleType(selectorType, expr.getType(), (PsiElement)expr);
                        continue;
                    }
                    if (label instanceof PsiReferenceExpression && (enumConstName = SwitchChecker.evaluateEnumConstantName(ref = (PsiReferenceExpression)label)) != null) {
                        if (this.myVisitor.isApplicable(JavaFeature.ENUM_QUALIFIED_NAME_IN_SWITCH) || ref.getQualifier() == null) continue;
                        this.myVisitor.report(JavaErrorKinds.SWITCH_LABEL_QUALIFIED_ENUM.create(ref));
                        continue;
                    }
                    if (!this.myVisitor.myExpressionChecker.checkAssignability(selectorType, expr.getType(), expr, (PsiElement)expr)) continue;
                }
                if (patterns) {
                    this.checkLabelAndSelectorCompatibilityPattern(label, selectorType);
                    continue;
                }
                this.checkLabelAndSelectorCompatibility(label, labelElementList, selectorType);
            }
        }
    }

    @Nullable
    static String evaluateEnumConstantName(@NotNull PsiReferenceExpression expr) {
        String string;
        PsiElement psiElement;
        if (expr == null) {
            SwitchChecker.$$$reportNull$$$0(15);
        }
        if ((psiElement = expr.resolve()) instanceof PsiEnumConstant) {
            PsiEnumConstant enumConstant = (PsiEnumConstant)psiElement;
            string = enumConstant.getName();
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    private static Object evaluateConstant(@NotNull PsiCaseLabelElement constant) {
        if (constant == null) {
            SwitchChecker.$$$reportNull$$$0(16);
        }
        return JavaPsiFacade.getInstance((Project)constant.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)constant, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkLabelAndSelectorCompatibility(@NotNull PsiCaseLabelElement label, @NotNull PsiCaseLabelElementList labelElementList, @NotNull PsiType selectorType) {
        if (label == null) {
            SwitchChecker.$$$reportNull$$$0(17);
        }
        if (labelElementList == null) {
            SwitchChecker.$$$reportNull$$$0(18);
        }
        if (selectorType == null) {
            SwitchChecker.$$$reportNull$$$0(19);
        }
        if (label instanceof PsiExpression) {
            PsiReferenceExpression ref;
            String enumConstName;
            PsiExpression expr = (PsiExpression)label;
            Object value = null;
            if (expr instanceof PsiReferenceExpression && (enumConstName = SwitchChecker.evaluateEnumConstantName(ref = (PsiReferenceExpression)expr)) != null) {
                value = enumConstName;
            }
            if (value == null) {
                value = ConstantExpressionUtil.computeCastTo((PsiExpression)expr, (PsiType)selectorType);
            }
            if (value != null) return;
            this.myVisitor.report(JavaErrorKinds.SWITCH_LABEL_CONSTANT_EXPECTED.create(expr));
            return;
        }
        if (label instanceof PsiDefaultCaseLabelElement) {
            PsiDefaultCaseLabelElement defaultElement = (PsiDefaultCaseLabelElement)label;
            if (labelElementList.getElementCount() == 1) {
                this.myVisitor.report(JavaErrorKinds.SWITCH_DEFAULT_LABEL_CONTAINS_CASE.create(defaultElement, labelElementList));
                return;
            }
        }
        if (!(label instanceof PsiPattern)) return;
    }

    private void checkLabelAndSelectorCompatibilityPattern(@NotNull PsiCaseLabelElement label, @NotNull PsiType selectorType) {
        if (label == null) {
            SwitchChecker.$$$reportNull$$$0(20);
        }
        if (selectorType == null) {
            SwitchChecker.$$$reportNull$$$0(21);
        }
        if (label instanceof PsiDefaultCaseLabelElement) {
            return;
        }
        if (label instanceof PsiExpression) {
            PsiExpression expr = (PsiExpression)label;
            Object constValue = SwitchChecker.evaluateConstant((PsiCaseLabelElement)expr);
            if (constValue == null) {
                this.myVisitor.report(JavaErrorKinds.SWITCH_LABEL_CONSTANT_EXPECTED.create(expr));
                return;
            }
            JavaPsiSwitchUtil.SelectorKind kind = JavaPsiSwitchUtil.getSwitchSelectorKind((PsiType)selectorType);
            if (kind.getFeature() == JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS) {
                PsiPrimitiveType unboxedType;
                if ((kind == JavaPsiSwitchUtil.SelectorKind.LONG && !(constValue instanceof Long) || kind == JavaPsiSwitchUtil.SelectorKind.DOUBLE && !(constValue instanceof Double) || kind == JavaPsiSwitchUtil.SelectorKind.FLOAT && !(constValue instanceof Float) || kind == JavaPsiSwitchUtil.SelectorKind.BOOLEAN && !(constValue instanceof Boolean)) && (unboxedType = PsiPrimitiveType.getOptionallyUnboxedType((PsiType)selectorType)) != null) {
                    this.myVisitor.reportIncompatibleType((PsiType)unboxedType, expr.getType(), (PsiElement)expr);
                }
                return;
            }
            if (ConstantExpressionUtil.computeCastTo((Object)constValue, (PsiType)selectorType) == null) {
                this.myVisitor.reportIncompatibleType(selectorType, expr.getType(), (PsiElement)expr);
                return;
            }
            if (kind == JavaPsiSwitchUtil.SelectorKind.INT || kind == JavaPsiSwitchUtil.SelectorKind.STRING) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.SWITCH_LABEL_PATTERN_EXPECTED.create(expr, selectorType));
            return;
        }
        if (label instanceof PsiPattern) {
            PsiPrimaryPattern elementToReport = JavaPsiPatternUtil.getTypedPattern((PsiCaseLabelElement)label);
            if (elementToReport == null) {
                return;
            }
            PsiTypeElement typeElement = JavaPsiPatternUtil.getPatternTypeElement((PsiCaseLabelElement)elementToReport);
            if (typeElement == null) {
                return;
            }
            PsiType patternType = typeElement.getType();
            boolean primitivesAllowed = this.myVisitor.isApplicable(JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS);
            if (!(patternType instanceof PsiClassType || patternType instanceof PsiArrayType || primitivesAllowed)) {
                if (patternType instanceof PsiPrimitiveType) {
                    this.myVisitor.checkFeature((PsiElement)elementToReport, JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS);
                    return;
                }
                this.myVisitor.report(JavaErrorKinds.PATTERN_EXPECTED_CLASS_OR_ARRAY_TYPE.create((PsiPattern)elementToReport));
                return;
            }
            if (!(ContainerUtil.and((Iterable)JavaPsiPatternUtil.deconstructSelectorType((PsiType)selectorType), type -> TypeConversionUtil.areTypesConvertible((PsiType)type, (PsiType)patternType)) && (!(selectorType instanceof PsiPrimitiveType) || !this.myVisitor.isApplicable(JavaFeature.PATTERN_GUARDS_AND_RECORD_PATTERNS) || primitivesAllowed) || selectorType.equals(PsiTypes.nullType()) || IncompleteModelUtil.isIncompleteModel((PsiElement)label) && IncompleteModelUtil.isPotentiallyConvertible((PsiType)selectorType, (PsiType)patternType, (PsiElement)label))) {
                if (selectorType instanceof PsiPrimitiveType && !primitivesAllowed) {
                    this.myVisitor.report(JavaErrorKinds.UNSUPPORTED_FEATURE.create((PsiElement)elementToReport, JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS));
                } else {
                    this.myVisitor.reportIncompatibleType(selectorType, patternType, (PsiElement)elementToReport);
                }
                return;
            }
            this.myVisitor.myPatternChecker.checkUncheckedPatternConversion((PsiPattern)elementToReport);
            PsiDeconstructionPattern deconstructionPattern = JavaPsiPatternUtil.findDeconstructionPattern((PsiCaseLabelElement)elementToReport);
            this.myVisitor.myPatternChecker.checkDeconstructionErrors(deconstructionPattern);
            return;
        }
        this.myVisitor.report(JavaErrorKinds.SWITCH_LABEL_UNEXPECTED.create(label));
    }

    private void checkDuplicates(@NotNull PsiSwitchBlock block) {
        if (block == null) {
            SwitchChecker.$$$reportNull$$$0(22);
        }
        for (Map.Entry entry : JavaPsiSwitchUtil.getValuesAndLabels((PsiSwitchBlock)block).entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            Object duplicateKey = entry.getKey();
            for (PsiElement duplicateElement : (Collection)entry.getValue()) {
                this.myVisitor.report(JavaErrorKinds.SWITCH_LABEL_DUPLICATE.create(duplicateElement, duplicateKey));
            }
        }
    }

    private void checkFallthroughLegality(@NotNull PsiSwitchBlock block) {
        if (block == null) {
            SwitchChecker.$$$reportNull$$$0(23);
        }
        if (!this.myVisitor.isApplicable(JavaFeature.PATTERNS_IN_SWITCH)) {
            return;
        }
        PsiCodeBlock body = block.getBody();
        if (body == null) {
            return;
        }
        SmartList elementsToCheckFallThroughLegality = new SmartList();
        int switchBlockGroupCounter = 0;
        for (PsiStatement st : body.getStatements()) {
            Object switchLabels;
            if (!(st instanceof PsiSwitchLabelStatementBase)) continue;
            PsiSwitchLabelStatementBase labelStatement = (PsiSwitchLabelStatementBase)st;
            if (switchBlockGroupCounter < elementsToCheckFallThroughLegality.size()) {
                switchLabels = (List)elementsToCheckFallThroughLegality.get(switchBlockGroupCounter);
            } else {
                switchLabels = new SmartList();
                elementsToCheckFallThroughLegality.add(switchLabels);
            }
            switchLabels.add(labelStatement);
            if (PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)labelStatement) instanceof PsiSwitchLabelStatement) continue;
            ++switchBlockGroupCounter;
        }
        HashSet<PsiElement> alreadyFallThroughElements = new HashSet<PsiElement>();
        this.checkFallThroughFromPatternWithSeveralLabels((List<? extends List<PsiSwitchLabelStatementBase>>)elementsToCheckFallThroughLegality, alreadyFallThroughElements);
        this.checkFallThroughToPatternPrecedingCompleteNormally((List<? extends List<? extends PsiSwitchLabelStatementBase>>)elementsToCheckFallThroughLegality, alreadyFallThroughElements);
    }

    private void checkFallThroughFromPatternWithSeveralLabels(@NotNull List<? extends List<PsiSwitchLabelStatementBase>> switchBlockGroup, @NotNull Set<? super PsiElement> alreadyFallThroughElements) {
        if (switchBlockGroup == null) {
            SwitchChecker.$$$reportNull$$$0(24);
        }
        if (alreadyFallThroughElements == null) {
            SwitchChecker.$$$reportNull$$$0(25);
        }
        if (switchBlockGroup.isEmpty()) {
            return;
        }
        for (List<PsiSwitchLabelStatementBase> list : switchBlockGroup) {
            for (PsiSwitchLabelStatementBase switchLabelElement : list) {
                PsiElement nextNotLabel;
                PsiCaseLabelElement[] elements;
                PsiCaseLabelElement first;
                PsiCaseLabelElementList labelElementList = switchLabelElement.getCaseLabelElementList();
                if (labelElementList == null || labelElementList.getElementCount() == 0 || this.checkCaseLabelCombination(labelElementList) || !JavaPsiPatternUtil.containsNamedPatternVariable((PsiCaseLabelElement)(first = (elements = labelElementList.getElements())[0])) || !((nextNotLabel = PsiTreeUtil.skipSiblingsForward((PsiElement)switchLabelElement, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class, PsiSwitchLabelStatement.class})) instanceof PsiStatement) || !(PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)switchLabelElement) instanceof PsiSwitchLabelStatement) && !(PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)switchLabelElement) instanceof PsiSwitchLabelStatement)) continue;
                alreadyFallThroughElements.add((PsiElement)first);
                this.myVisitor.report(JavaErrorKinds.SWITCH_MULTIPLE_LABELS_WITH_PATTERN_VARIABLES.create(first));
            }
        }
    }

    private boolean checkCaseLabelCombination(@NotNull PsiCaseLabelElementList labelElementList) {
        if (labelElementList == null) {
            SwitchChecker.$$$reportNull$$$0(26);
        }
        PsiCaseLabelElement elements = labelElementList.getElements();
        PsiCaseLabelElement firstElement = elements[0];
        if (((PsiCaseLabelElement[])elements).length == 1) {
            if (firstElement instanceof PsiDefaultCaseLabelElement) {
                PsiDefaultCaseLabelElement defaultLabel = (PsiDefaultCaseLabelElement)firstElement;
                this.myVisitor.report(JavaErrorKinds.SWITCH_DEFAULT_LABEL_CONTAINS_CASE.create(defaultLabel, labelElementList));
                return true;
            }
            return false;
        }
        if (((PsiCaseLabelElement[])elements).length == 2) {
            PsiExpression expr;
            if (firstElement instanceof PsiDefaultCaseLabelElement) {
                PsiExpression expr2;
                PsiDefaultCaseLabelElement defaultLabel = (PsiDefaultCaseLabelElement)firstElement;
                PsiCaseLabelElement psiCaseLabelElement = elements[1];
                if (psiCaseLabelElement instanceof PsiExpression && ExpressionUtil.isNullLiteral((PsiElement)(expr2 = (PsiExpression)psiCaseLabelElement))) {
                    this.myVisitor.report(JavaErrorKinds.SWITCH_DEFAULT_NULL_ORDER.create(defaultLabel, labelElementList));
                    return true;
                }
            }
            if (firstElement instanceof PsiExpression && ExpressionUtil.isNullLiteral((PsiElement)(expr = (PsiExpression)firstElement)) && elements[1] instanceof PsiDefaultCaseLabelElement) {
                return false;
            }
        }
        boolean unnamedAllowed = this.myVisitor.isApplicable(JavaFeature.UNNAMED_PATTERNS_AND_VARIABLES);
        boolean reported = false;
        for (PsiCaseLabelElement element : elements) {
            PsiExpression expr;
            if (element instanceof PsiDefaultCaseLabelElement) {
                PsiDefaultCaseLabelElement defaultLabel = (PsiDefaultCaseLabelElement)element;
                this.myVisitor.report(JavaErrorKinds.SWITCH_DEFAULT_LABEL_NOT_ALLOWED.create(defaultLabel));
                reported = true;
                continue;
            }
            if (element instanceof PsiExpression && ExpressionUtil.isNullLiteral((PsiElement)(expr = (PsiExpression)element))) {
                this.myVisitor.report(JavaErrorKinds.SWITCH_NULL_LABEL_NOT_ALLOWED.create(expr));
                reported = true;
                continue;
            }
            if (!(element instanceof PsiPattern)) continue;
            PsiPattern pattern = (PsiPattern)element;
            if (!(firstElement instanceof PsiExpression)) continue;
            JavaErrorKind.Simple<PsiCaseLabelElement> kind = unnamedAllowed ? JavaErrorKinds.SWITCH_LABEL_COMBINATION_CONSTANTS_AND_PATTERNS_UNNAMED : JavaErrorKinds.SWITCH_LABEL_COMBINATION_CONSTANTS_AND_PATTERNS;
            this.myVisitor.report(kind.create((PsiCaseLabelElement)pattern));
            reported = true;
        }
        if (reported) {
            return true;
        }
        if (firstElement instanceof PsiPattern) {
            PsiCaseLabelElement nonPattern = (PsiCaseLabelElement)ContainerUtil.find((Object[])elements, e -> !(e instanceof PsiPattern));
            if (nonPattern != null) {
                JavaErrorKind.Simple<PsiCaseLabelElement> kind = unnamedAllowed ? JavaErrorKinds.SWITCH_LABEL_COMBINATION_CONSTANTS_AND_PATTERNS_UNNAMED : JavaErrorKinds.SWITCH_LABEL_COMBINATION_CONSTANTS_AND_PATTERNS;
                this.myVisitor.report(kind.create(nonPattern));
                return true;
            }
            if (!unnamedAllowed) {
                this.myVisitor.report(JavaErrorKinds.SWITCH_LABEL_MULTIPLE_PATTERNS.create(elements[1]));
                return true;
            }
            PsiCaseLabelElement patternVarElement = (PsiCaseLabelElement)ContainerUtil.find((Object[])elements, JavaPsiPatternUtil::containsNamedPatternVariable);
            if (patternVarElement != null) {
                this.myVisitor.report(JavaErrorKinds.SWITCH_LABEL_MULTIPLE_PATTERNS_UNNAMED.create(patternVarElement));
                return true;
            }
        }
        return false;
    }

    private void checkFallThroughToPatternPrecedingCompleteNormally(@NotNull List<? extends List<? extends PsiSwitchLabelStatementBase>> switchBlockGroup, @NotNull Set<PsiElement> alreadyFallThroughElements) {
        if (switchBlockGroup == null) {
            SwitchChecker.$$$reportNull$$$0(27);
        }
        if (alreadyFallThroughElements == null) {
            SwitchChecker.$$$reportNull$$$0(28);
        }
        for (int i = 1; i < switchBlockGroup.size(); ++i) {
            List<? extends PsiSwitchLabelStatementBase> switchLabels = switchBlockGroup.get(i);
            PsiSwitchLabelStatementBase firstSwitchLabelInGroup = switchLabels.get(0);
            for (PsiSwitchLabelStatementBase psiSwitchLabelStatementBase : switchLabels) {
                ControlFlow flow;
                PsiStatement prevStatement;
                List patternElements;
                if (!(psiSwitchLabelStatementBase instanceof PsiSwitchLabelStatement)) {
                    return;
                }
                PsiCaseLabelElementList labelElementList = psiSwitchLabelStatementBase.getCaseLabelElementList();
                if (labelElementList == null || (patternElements = ContainerUtil.filter((Object[])labelElementList.getElements(), labelElement -> JavaPsiPatternUtil.containsNamedPatternVariable((PsiCaseLabelElement)labelElement))).isEmpty() || (prevStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)firstSwitchLabelInGroup, PsiStatement.class)) == null || (flow = ControlFlowChecker.getControlFlow((PsiElement)prevStatement)) == null || !ControlFlowUtil.canCompleteNormally((ControlFlow)flow, (int)0, (int)flow.getSize())) continue;
                List elements = ContainerUtil.filter((Collection)patternElements, patternElement -> !alreadyFallThroughElements.contains(patternElement));
                for (PsiCaseLabelElement patternElement2 : elements) {
                    this.myVisitor.report(JavaErrorKinds.SWITCH_FALLTHROUGH_TO_PATTERN.create(patternElement2));
                }
            }
        }
    }

    private void checkDominance(@NotNull PsiSwitchBlock block) {
        if (block == null) {
            SwitchChecker.$$$reportNull$$$0(29);
        }
        Map dominatedLabels = JavaPsiSwitchUtil.findDominatedLabels((PsiSwitchBlock)block);
        for (Map.Entry entry : dominatedLabels.entrySet()) {
            PsiCaseLabelElement overWhom = (PsiCaseLabelElement)entry.getKey();
            PsiElement who = (PsiElement)entry.getValue();
            this.myVisitor.report(JavaErrorKinds.SWITCH_DOMINANCE_VIOLATION.create(overWhom, who));
        }
    }

    private void checkNoDefaultBranchAllowed(@NotNull PsiSwitchBlock block) {
        if (block == null) {
            SwitchChecker.$$$reportNull$$$0(30);
        }
        if (!this.myVisitor.isApplicable(JavaFeature.PATTERNS_IN_SWITCH)) {
            return;
        }
        PsiCaseLabelElement elementCoversType = JavaPsiSwitchUtil.getUnconditionalPatternLabel((PsiSwitchBlock)block);
        PsiElement defaultElement = JavaPsiSwitchUtil.findDefaultElement((PsiSwitchBlock)block);
        if (defaultElement != null && elementCoversType != null) {
            this.myVisitor.report(JavaErrorKinds.SWITCH_UNCONDITIONAL_PATTERN_AND_DEFAULT.create(defaultElement.getFirstChild()));
            this.myVisitor.report(JavaErrorKinds.SWITCH_UNCONDITIONAL_PATTERN_AND_DEFAULT.create((PsiElement)elementCoversType));
            return;
        }
        if ((defaultElement != null || elementCoversType != null) && JavaPsiSwitchUtil.isBooleanSwitchWithTrueAndFalse((PsiSwitchBlock)block)) {
            if (defaultElement != null) {
                this.myVisitor.report(JavaErrorKinds.SWITCH_DEFAULT_AND_BOOLEAN.create(defaultElement.getFirstChild()));
            }
            if (elementCoversType != null) {
                this.myVisitor.report(JavaErrorKinds.SWITCH_UNCONDITIONAL_PATTERN_AND_BOOLEAN.create(elementCoversType));
            }
        }
    }

    void checkExhaustiveness(@NotNull PsiSwitchBlock block) {
        PsiCodeBlock body;
        if (block == null) {
            SwitchChecker.$$$reportNull$$$0(31);
        }
        if ((body = block.getBody()) == null) {
            return;
        }
        if (!ExpressionUtil.isEnhancedSwitch((PsiSwitchBlock)block)) {
            return;
        }
        if (JavaPsiSwitchUtil.getUnconditionalPatternLabel((PsiSwitchBlock)block) != null) {
            return;
        }
        if (JavaPsiSwitchUtil.findDefaultElement((PsiSwitchBlock)block) != null) {
            return;
        }
        if (!JavaPatternExhaustivenessUtil.hasExhaustivenessError((PsiSwitchBlock)block)) {
            return;
        }
        boolean hasAnyCaseLabels = JavaPsiSwitchUtil.hasAnyCaseLabels((PsiSwitchBlock)block);
        JavaErrorKind.Simple<PsiSwitchBlock> kind = hasAnyCaseLabels ? JavaErrorKinds.SWITCH_INCOMPLETE : JavaErrorKinds.SWITCH_EMPTY;
        this.myVisitor.report(kind.create(block));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 14: 
            case 22: 
            case 23: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelElementList";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorType";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlockGroup";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyFallThroughElements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/highlighting/SwitchChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSwitchBlock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSwitchExpressionReturnTypeCompatible";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSwitchBlockStatements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSwitchSelectorType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSwitchExpressionHasResult";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hasYield";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLocalClassReferencedFromAnotherSwitchBranch";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkYieldOutsideSwitchExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCaseStatement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "checkGuard";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "checkYieldExpressionType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLabelSelectorCompatibility";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateEnumConstantName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateConstant";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLabelAndSelectorCompatibility";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLabelAndSelectorCompatibilityPattern";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDuplicates";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFallthroughLegality";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFallThroughFromPatternWithSeveralLabels";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCaseLabelCombination";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFallThroughToPatternPrecedingCompleteNormally";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDominance";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNoDefaultBranchAllowed";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "checkExhaustiveness";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

