/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting.errors;

import com.intellij.java.codeserver.highlighting.JavaCompilationErrorBundle;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorFormatUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public record JavaAmbiguousCallContext(@NotNull @NotNull JavaResolveResult @NotNull [] results, @NotNull MethodCandidateInfo methodCandidate1, @NotNull MethodCandidateInfo methodCandidate2) {
    @NotNull
    private final @NotNull JavaResolveResult @NotNull [] results;
    @NotNull
    private final MethodCandidateInfo methodCandidate1;
    @NotNull
    private final MethodCandidateInfo methodCandidate2;

    public JavaAmbiguousCallContext(@NotNull @NotNull JavaResolveResult @NotNull [] results, @NotNull MethodCandidateInfo methodCandidate1, @NotNull MethodCandidateInfo methodCandidate2) {
        if (methodCandidate1 == null) {
            JavaAmbiguousCallContext.$$$reportNull$$$0(0);
        }
        if (methodCandidate2 == null) {
            JavaAmbiguousCallContext.$$$reportNull$$$0(1);
        }
        if (results == null) {
            JavaAmbiguousCallContext.$$$reportNull$$$0(2);
        }
    }

    @NotNull
    @Nls
    String description() {
        VirtualFile virtualFile2;
        PsiMethod element1 = this.methodCandidate1.getElement();
        Object m1 = PsiFormatUtil.formatMethod((PsiMethod)element1, (PsiSubstitutor)this.methodCandidate1.getSubstitutor(false), (int)4353, (int)2);
        PsiMethod element2 = this.methodCandidate2.getElement();
        Object m2 = PsiFormatUtil.formatMethod((PsiMethod)element2, (PsiSubstitutor)this.methodCandidate2.getSubstitutor(false), (int)4353, (int)2);
        VirtualFile virtualFile1 = PsiUtilCore.getVirtualFile((PsiElement)element1);
        if (!Comparing.equal((Object)virtualFile1, (Object)(virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)element2)))) {
            if (virtualFile1 != null) {
                m1 = (String)m1 + " (In " + virtualFile1.getPresentableUrl() + ")";
            }
            if (virtualFile2 != null) {
                m2 = (String)m2 + " (In " + virtualFile2.getPresentableUrl() + ")";
            }
        }
        String string = JavaCompilationErrorBundle.message("call.ambiguous", m1, m2);
        if (string == null) {
            JavaAmbiguousCallContext.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    HtmlChunk tooltip() {
        HtmlChunk htmlChunk = HtmlChunk.raw((String)JavaCompilationErrorBundle.message("call.ambiguous.tooltip", this.methodCandidate1.getElement().getParameterList().getParametersCount() + 2, JavaAmbiguousCallContext.createAmbiguousMethodHtmlTooltipMethodRow(this.methodCandidate1), JavaAmbiguousCallContext.getContainingClassName(this.methodCandidate1), JavaAmbiguousCallContext.createAmbiguousMethodHtmlTooltipMethodRow(this.methodCandidate2), JavaAmbiguousCallContext.getContainingClassName(this.methodCandidate2)));
        if (htmlChunk == null) {
            JavaAmbiguousCallContext.$$$reportNull$$$0(4);
        }
        return htmlChunk;
    }

    @NotNull
    private static String getContainingClassName(@NotNull MethodCandidateInfo methodCandidate) {
        PsiMethod method;
        PsiClass containingClass;
        if (methodCandidate == null) {
            JavaAmbiguousCallContext.$$$reportNull$$$0(5);
        }
        String string = (containingClass = (method = methodCandidate.getElement()).getContainingClass()) == null ? method.getContainingFile().getName() : JavaErrorFormatUtil.formatClass(containingClass, false);
        if (string == null) {
            JavaAmbiguousCallContext.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static HtmlChunk createAmbiguousMethodHtmlTooltipMethodRow(@NotNull MethodCandidateInfo methodCandidate) {
        if (methodCandidate == null) {
            JavaAmbiguousCallContext.$$$reportNull$$$0(7);
        }
        PsiMethod method = methodCandidate.getElement();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
        HtmlBuilder row = new HtmlBuilder().append((HtmlChunk)HtmlChunk.tag((String)"td").child((HtmlChunk)HtmlChunk.tag((String)"b").addText(method.getName())));
        for (int j = 0; j < parameters.length; ++j) {
            PsiParameter parameter = parameters[j];
            PsiType type = substitutor.substitute(parameter.getType());
            String typeText = (j == 0 ? "(" : "") + type.getPresentableText() + (j == parameters.length - 1 ? ")" : ",");
            row.append((HtmlChunk)HtmlChunk.tag((String)"td").child((HtmlChunk)HtmlChunk.tag((String)"b").addText(typeText)));
        }
        if (parameters.length == 0) {
            row.append((HtmlChunk)HtmlChunk.tag((String)"td").child((HtmlChunk)HtmlChunk.tag((String)"b").addText("()")));
        }
        HtmlChunk htmlChunk = row.toFragment();
        if (htmlChunk == null) {
            JavaAmbiguousCallContext.$$$reportNull$$$0(8);
        }
        return htmlChunk;
    }

    @NotNull
    public @NotNull JavaResolveResult @NotNull [] results() {
        if (this.results == null) {
            JavaAmbiguousCallContext.$$$reportNull$$$0(9);
        }
        return this.results;
    }

    @NotNull
    public MethodCandidateInfo methodCandidate1() {
        MethodCandidateInfo methodCandidateInfo = this.methodCandidate1;
        if (methodCandidateInfo == null) {
            JavaAmbiguousCallContext.$$$reportNull$$$0(10);
        }
        return methodCandidateInfo;
    }

    @NotNull
    public MethodCandidateInfo methodCandidate2() {
        MethodCandidateInfo methodCandidateInfo = this.methodCandidate2;
        if (methodCandidateInfo == null) {
            JavaAmbiguousCallContext.$$$reportNull$$$0(11);
        }
        return methodCandidateInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCandidate1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCandidate2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaAmbiguousCallContext";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCandidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaAmbiguousCallContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "description";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "tooltip";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingClassName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createAmbiguousMethodHtmlTooltipMethodRow";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "results";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "methodCandidate1";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "methodCandidate2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClassName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createAmbiguousMethodHtmlTooltipMethodRow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

