/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting.errors;

import com.intellij.java.codeserver.highlighting.errors.JavaErrorHighlightType;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiElement;
import java.util.Optional;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public record JavaCompilationError<Psi extends PsiElement, Context>(@NotNull JavaErrorKind<Psi, Context> kind, @NotNull Psi psi, Context context) {
    @NotNull
    private final JavaErrorKind<Psi, Context> kind;
    @NotNull
    private final Psi psi;
    public static final String JAVA_DISPLAY_INFORMATION = "--java-display-information";
    public static final String JAVA_DISPLAY_GRAYED = "--java-display-grayed";
    public static final String JAVA_DISPLAY_PARAMETER = "--java-display-parameter";
    public static final String JAVA_DISPLAY_ERROR = "--java-display-error";

    public JavaCompilationError(@NotNull JavaErrorKind<Psi, Context> kind, @NotNull Psi psi, Context context) {
        if (kind == null) {
            JavaCompilationError.$$$reportNull$$$0(0);
        }
        if (psi == null) {
            JavaCompilationError.$$$reportNull$$$0(1);
        }
    }

    @NotNull
    public Project project() {
        Project project = this.psi.getProject();
        if (project == null) {
            JavaCompilationError.$$$reportNull$$$0(2);
        }
        return project;
    }

    @NotNull
    public TextRange range() {
        TextRange textRange = this.kind.range(this.psi, this.context);
        if (textRange == null) {
            JavaCompilationError.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    public int navigationShift() {
        return this.kind.navigationShift(this.psi, this.context);
    }

    @NotNull
    public JavaErrorHighlightType highlightType() {
        JavaErrorHighlightType javaErrorHighlightType = this.kind.highlightType(this.psi, this.context);
        if (javaErrorHighlightType == null) {
            JavaCompilationError.$$$reportNull$$$0(4);
        }
        return javaErrorHighlightType;
    }

    @NotNull
    @Nls
    public String description() {
        String string = this.kind.description(this.psi, this.context);
        if (string == null) {
            JavaCompilationError.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public HtmlChunk tooltip() {
        HtmlChunk htmlChunk = this.kind.tooltip(this.psi, this.context);
        if (htmlChunk == null) {
            JavaCompilationError.$$$reportNull$$$0(6);
        }
        return htmlChunk;
    }

    @SafeVarargs
    @NotNull
    public final <WantedPsi extends PsiElement> Optional<WantedPsi> psiForKind(JavaErrorKind<? extends WantedPsi, ?> ... kinds) {
        for (JavaErrorKind<WantedPsi, ?> javaErrorKind : kinds) {
            if (!javaErrorKind.equals(this.kind)) continue;
            Optional<Psi> optional = Optional.of(this.psi);
            if (optional == null) {
                JavaCompilationError.$$$reportNull$$$0(7);
            }
            return optional;
        }
        Optional optional = Optional.empty();
        if (optional == null) {
            JavaCompilationError.$$$reportNull$$$0(8);
        }
        return optional;
    }

    @SafeVarargs
    @NotNull
    public final <WantedPsi extends PsiElement, WantedContext> Optional<JavaCompilationError<WantedPsi, WantedContext>> forKind(JavaErrorKind<? extends WantedPsi, ? extends WantedContext> ... kinds) {
        for (JavaErrorKind<WantedPsi, WantedContext> javaErrorKind : kinds) {
            if (!javaErrorKind.equals(this.kind)) continue;
            Optional<JavaCompilationError<WantedPsi, WantedContext>> optional = Optional.of(this);
            if (optional == null) {
                JavaCompilationError.$$$reportNull$$$0(9);
            }
            return optional;
        }
        Optional<JavaCompilationError<WantedPsi, WantedContext>> optional = Optional.empty();
        if (optional == null) {
            JavaCompilationError.$$$reportNull$$$0(10);
        }
        return optional;
    }

    @NotNull
    public JavaErrorKind<Psi, Context> kind() {
        JavaErrorKind<Psi, Context> javaErrorKind = this.kind;
        if (javaErrorKind == null) {
            JavaCompilationError.$$$reportNull$$$0(11);
        }
        return javaErrorKind;
    }

    @NotNull
    public Psi psi() {
        Psi Psi = this.psi;
        if (Psi == null) {
            JavaCompilationError.$$$reportNull$$$0(12);
        }
        return Psi;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaCompilationError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaCompilationError";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "project";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "range";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "description";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "tooltip";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "psiForKind";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "forKind";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "kind";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

