/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting.errors;

import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.java.codeserver.highlighting.JavaCompilationErrorBundle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JavaErrorFormatUtil {
    JavaErrorFormatUtil() {
    }

    @NlsContexts.DetailedDescription
    @NotNull
    static String formatClashMethodMessage(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        if (method1 == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(0);
        }
        if (method2 == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(1);
        }
        PsiClass class1 = method1.getContainingClass();
        PsiClass class2 = method2.getContainingClass();
        if (class1 != null && class2 != null && !class1.isEquivalentTo((PsiElement)class2)) {
            String string = JavaCompilationErrorBundle.message("clash.methods.message.show.classes", JavaErrorFormatUtil.formatMethod(method1), JavaErrorFormatUtil.formatMethod(method2), JavaErrorFormatUtil.formatClass(class1), JavaErrorFormatUtil.formatClass(class2));
            if (string == null) {
                JavaErrorFormatUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = JavaCompilationErrorBundle.message("clash.methods.message", JavaErrorFormatUtil.formatMethod(method1), JavaErrorFormatUtil.formatMethod(method2));
        if (string == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    static String formatMethod(@NotNull PsiMethod method) {
        if (method == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(4);
        }
        String string = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
        if (string == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    static String formatClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(6);
        }
        return JavaErrorFormatUtil.formatClass(aClass, true);
    }

    @NotNull
    static String formatClass(@NotNull PsiClass aClass, boolean fqn) {
        if (aClass == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(7);
        }
        String string = PsiFormatUtil.formatClass((PsiClass)aClass, (int)(0x8001 | (fqn ? 2048 : 0)));
        if (string == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    static String formatField(@NotNull PsiField field) {
        if (field == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(9);
        }
        String string = PsiFormatUtil.formatVariable((PsiVariable)field, (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (string == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    static String formatResolvedSymbol(@NotNull JavaResolveResult result) {
        PsiElement element;
        if (result == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(11);
        }
        String symbolName = (element = result.getElement()) == null ? null : HighlightMessageUtil.getSymbolName((PsiElement)element, (PsiSubstitutor)result.getSubstitutor());
        String string = symbolName == null ? "?" : symbolName;
        if (string == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static PsiElement getContainer(@NotNull PsiElement refElement) {
        if (refElement == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(13);
        }
        for (ContainerProvider provider : ContainerProvider.EP_NAME.getExtensionList()) {
            PsiElement container = provider.getContainer(refElement);
            if (container == null) continue;
            return container;
        }
        return refElement.getParent();
    }

    @NotNull
    static String formatResolvedSymbolContainer(@NotNull JavaResolveResult result) {
        PsiElement element;
        if (result == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(14);
        }
        PsiElement container = (element = result.getElement()) == null ? null : JavaErrorFormatUtil.getContainer(element);
        String symbolName = container == null ? null : HighlightMessageUtil.getSymbolName((PsiElement)container, (PsiSubstitutor)result.getSubstitutor());
        String string = symbolName == null ? "?" : symbolName;
        if (string == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    static String formatArgumentTypes(@Nullable PsiExpressionList list, boolean shortNames) {
        if (list == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        PsiExpression[] args = list.getExpressions();
        for (int i = 0; i < args.length; ++i) {
            PsiType argType;
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((argType = args[i].getType()) != null ? (shortNames ? argType.getPresentableText() : JavaErrorFormatUtil.formatType(argType)) : "?");
        }
        builder.append(")");
        String string = builder.toString();
        if (string == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    @Nls
    static String getRecordMethodKind(@NotNull PsiMethod method) {
        if (method == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(17);
        }
        if (JavaPsiRecordUtil.isCompactConstructor((PsiMethod)method)) {
            String string = JavaCompilationErrorBundle.message("record.compact.constructor", new Object[0]);
            if (string == null) {
                JavaErrorFormatUtil.$$$reportNull$$$0(18);
            }
            return string;
        }
        if (JavaPsiRecordUtil.isCanonicalConstructor((PsiMethod)method)) {
            String string = JavaCompilationErrorBundle.message("record.canonical.constructor", new Object[0]);
            if (string == null) {
                JavaErrorFormatUtil.$$$reportNull$$$0(19);
            }
            return string;
        }
        if (JavaPsiRecordUtil.getRecordComponentForAccessor((PsiMethod)method) != null) {
            String string = JavaCompilationErrorBundle.message("record.accessor", new Object[0]);
            if (string == null) {
                JavaErrorFormatUtil.$$$reportNull$$$0(20);
            }
            return string;
        }
        throw new IllegalArgumentException("Record special method expected: " + String.valueOf(method));
    }

    @NotNull
    static TextRange getRange(@NotNull PsiElement element) {
        PsiJavaCodeReferenceElement ref;
        PsiMethodCallExpression callExpression;
        PsiElement nameElement;
        PsiNewExpression newExpression;
        PsiJavaCodeReferenceElement reference;
        if (element == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(21);
        }
        if (element instanceof PsiMember) {
            PsiMember member = (PsiMember)element;
            TextRange range = JavaErrorFormatUtil.getMemberDeclarationTextRange(member);
            TextRange textRange = range == null ? TextRange.create((int)0, (int)element.getTextLength()) : range;
            if (textRange == null) {
                JavaErrorFormatUtil.$$$reportNull$$$0(22);
            }
            return textRange;
        }
        if (element instanceof PsiJavaModule) {
            PsiJavaModule module = (PsiJavaModule)element;
            return JavaErrorFormatUtil.getModuleRange(module);
        }
        if (element instanceof PsiNewExpression && (reference = (newExpression = (PsiNewExpression)element).getClassReference()) != null) {
            TextRange textRange = reference.getTextRangeInParent();
            if (textRange == null) {
                JavaErrorFormatUtil.$$$reportNull$$$0(23);
            }
            return textRange;
        }
        if (element instanceof PsiMethodCallExpression && (nameElement = (callExpression = (PsiMethodCallExpression)element).getMethodExpression().getReferenceNameElement()) != null) {
            TextRange textRange = nameElement.getTextRangeInParent();
            if (textRange == null) {
                JavaErrorFormatUtil.$$$reportNull$$$0(24);
            }
            return textRange;
        }
        if (element instanceof PsiJavaCodeReferenceElement && (nameElement = (ref = (PsiJavaCodeReferenceElement)element).getReferenceNameElement()) != null) {
            TextRange textRange = nameElement.getTextRangeInParent();
            if (textRange == null) {
                JavaErrorFormatUtil.$$$reportNull$$$0(25);
            }
            return textRange;
        }
        PsiElement nextSibling = element.getNextSibling();
        if (PsiUtil.isJavaToken((PsiElement)nextSibling, (IElementType)JavaTokenType.SEMICOLON)) {
            TextRange textRange = TextRange.create((int)0, (int)(element.getTextLength() + 1));
            if (textRange == null) {
                JavaErrorFormatUtil.$$$reportNull$$$0(26);
            }
            return textRange;
        }
        TextRange textRange = TextRange.create((int)0, (int)element.getTextLength());
        if (textRange == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(27);
        }
        return textRange;
    }

    @NotNull
    static TextRange getMethodDeclarationTextRange(@NotNull PsiMethod method) {
        if (method == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(28);
        }
        if (method instanceof SyntheticElement) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                JavaErrorFormatUtil.$$$reportNull$$$0(29);
            }
            return textRange;
        }
        int start = JavaErrorFormatUtil.stripAnnotationsFromModifierList((PsiElement)method.getModifierList());
        int end = method.getBody() == null ? method.getTextRange().getEndOffset() : method.getThrowsList().getTextRange().getEndOffset();
        TextRange textRange = new TextRange(start, end).shiftLeft(method.getTextRange().getStartOffset());
        if (textRange == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(30);
        }
        return textRange;
    }

    @NotNull
    private static TextRange getModuleRange(@NotNull PsiJavaModule module) {
        PsiKeyword kw;
        if (module == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(31);
        }
        return new TextRange((kw = (PsiKeyword)PsiTreeUtil.getChildOfType((PsiElement)module, PsiKeyword.class)) != null ? kw.getTextRangeInParent().getStartOffset() : 0, module.getNameIdentifier().getTextRangeInParent().getEndOffset());
    }

    @Nullable
    static TextRange getMemberDeclarationTextRange(@NotNull PsiMember member) {
        TextRange textRange;
        if (member == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(32);
        }
        if (member instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)member;
            textRange = JavaErrorFormatUtil.getClassDeclarationTextRange(psiClass);
        } else if (member instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member;
            textRange = JavaErrorFormatUtil.getMethodDeclarationTextRange(psiMethod);
        } else if (member instanceof PsiField) {
            PsiField psiField = (PsiField)member;
            textRange = JavaErrorFormatUtil.getFieldDeclarationTextRange(psiField);
        } else {
            textRange = null;
        }
        return textRange;
    }

    @NotNull
    static TextRange getFieldDeclarationTextRange(@NotNull PsiField field) {
        if (field == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(33);
        }
        PsiModifierList modifierList = field.getModifierList();
        TextRange range = field.getTextRange();
        int start = modifierList == null || modifierList.getParent() != field ? range.getStartOffset() : JavaErrorFormatUtil.stripAnnotationsFromModifierList((PsiElement)modifierList);
        int end = field.getNameIdentifier().getTextRange().getEndOffset();
        TextRange textRange = new TextRange(start, end).shiftLeft(range.getStartOffset());
        if (textRange == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(34);
        }
        return textRange;
    }

    @NotNull
    static TextRange getClassDeclarationTextRange(@NotNull PsiClass aClass) {
        PsiReferenceList endElement;
        PsiJavaCodeReferenceElement psiElement;
        if (aClass == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(35);
        }
        if (aClass instanceof PsiEnumConstantInitializer) {
            throw new IllegalArgumentException();
        }
        if (aClass instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            v0 = anonymousClass.getBaseClassReference();
        } else {
            v0 = psiElement = aClass.getModifierList() == null ? aClass.getNameIdentifier() : aClass.getModifierList();
        }
        if (psiElement == null) {
            return new TextRange(0, 0);
        }
        int start = JavaErrorFormatUtil.stripAnnotationsFromModifierList((PsiElement)psiElement);
        if (aClass instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            v1 = anonymousClass.getBaseClassReference();
        } else {
            v1 = endElement = aClass.getImplementsList();
        }
        if (endElement == null) {
            endElement = aClass.getNameIdentifier();
        }
        TextRange endTextRange = endElement == null ? null : endElement.getTextRange();
        int end = endTextRange == null ? start : endTextRange.getEndOffset();
        TextRange textRange = new TextRange(start, end).shiftLeft(aClass.getTextRange().getStartOffset());
        if (textRange == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(36);
        }
        return textRange;
    }

    private static int stripAnnotationsFromModifierList(@NotNull PsiElement element) {
        TextRange textRange;
        if (element == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(37);
        }
        if ((textRange = element.getTextRange()) == null) {
            return 0;
        }
        PsiAnnotation lastAnnotation = null;
        for (PsiElement child = element.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!(child instanceof PsiAnnotation)) continue;
            lastAnnotation = (PsiAnnotation)child;
            break;
        }
        if (lastAnnotation == null) {
            return textRange.getStartOffset();
        }
        ASTNode node = lastAnnotation.getNode();
        if (node != null) {
            while ((node = TreeUtil.nextLeaf((ASTNode)node)) != null && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(node.getElementType())) {
            }
        }
        if (node != null) {
            return node.getTextRange().getStartOffset();
        }
        return textRange.getStartOffset();
    }

    @NotNull
    static String formatTypes(@NotNull Collection<? extends PsiClassType> unhandled) {
        if (unhandled == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(38);
        }
        String string = StringUtil.join(unhandled, JavaErrorFormatUtil::formatType, (String)", ");
        if (string == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    static String formatType(@Nullable PsiType type) {
        String string = type == null ? "null" : PsiTypesUtil.removeExternalAnnotations((PsiType)type).getInternalCanonicalText();
        if (string == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    static String format(@NotNull PsiElement element) {
        if (element == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(41);
        }
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            return JavaErrorFormatUtil.formatClass(psiClass);
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            return JavaErrorFormatUtil.formatMethod(psiMethod);
        }
        if (element instanceof PsiField) {
            PsiField psiField = (PsiField)element;
            return JavaErrorFormatUtil.formatField(psiField);
        }
        if (element instanceof PsiLabeledStatement) {
            PsiLabeledStatement statement = (PsiLabeledStatement)element;
            String string = statement.getName() + ":";
            if (string == null) {
                JavaErrorFormatUtil.$$$reportNull$$$0(42);
            }
            return string;
        }
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)HighlightUsagesDescriptionLocation.INSTANCE);
        if (string == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    static String formatClassOrType(@NotNull PsiType type) {
        PsiClass psiClass;
        if (type == null) {
            JavaErrorFormatUtil.$$$reportNull$$$0(44);
        }
        return (psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type)) == null ? type.getPresentableText() : JavaErrorFormatUtil.formatClass(psiClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 8, 10, 12, 15, 16, 18, 19, 20, 22, 23, 24, 25, 26, 27, 29, 30, 34, 36, 39, 40, 42, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method2";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorFormatUtil";
                break;
            }
            case 4: 
            case 17: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: 
            case 7: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 9: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 21: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unhandled";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorFormatUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatClashMethodMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMethod";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "formatClass";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "formatField";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "formatResolvedSymbol";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "formatResolvedSymbolContainer";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "formatArgumentTypes";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordMethodKind";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodDeclarationTextRange";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldDeclarationTextRange";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDeclarationTextRange";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTypes";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "formatType";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatClashMethodMessage";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatMethod";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatField";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "formatResolvedSymbol";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getContainer";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "formatResolvedSymbolContainer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRecordMethodKind";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRange";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDeclarationTextRange";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getModuleRange";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getMemberDeclarationTextRange";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFieldDeclarationTextRange";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclarationTextRange";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "stripAnnotationsFromModifierList";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "formatTypes";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "formatClassOrType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 8, 10, 12, 15, 16, 18, 19, 20, 22, 23, 24, 25, 26, 27, 29, 30, 34, 36, 39, 40, 42, 43 -> new IllegalStateException(string);
        };
    }
}

