/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.AbstractQuery;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryParameters;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class ClassInheritorsSearch
extends ExtensibleQueryFactory<PsiClass, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor<PsiClass, SearchParameters>> EP_NAME = ExtensionPointName.create((String)"com.intellij.classInheritorsSearch");
    public static final ClassInheritorsSearch INSTANCE = new ClassInheritorsSearch();

    private ClassInheritorsSearch() {
        super(EP_NAME);
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
        if (aClass == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(1);
        }
        return ClassInheritorsSearch.search(new SearchParameters(aClass, scope, checkDeep, checkInheritance, includeAnonymous));
    }

    @NotNull
    public static Query<PsiClass> search(final @NotNull SearchParameters parameters) {
        if (parameters == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(2);
        }
        if (!parameters.isCheckDeep()) {
            FilteredQuery directQuery = DirectClassInheritorsSearch.search(new DirectClassInheritorsSearch.SearchParameters(parameters.getClassToProcess(), parameters.getScope(), parameters.isIncludeAnonymous(), true){

                @Override
                public boolean shouldSearchInLanguage(@NotNull Language language) {
                    if (language == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return parameters.shouldSearchInLanguage(language);
                }

                @Override
                public SearchParameters getOriginalParameters() {
                    return parameters;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/search/searches/ClassInheritorsSearch$1", "shouldSearchInLanguage"));
                }
            });
            if (parameters.getNameCondition() != Conditions.alwaysTrue()) {
                directQuery = new FilteredQuery(directQuery, psiClass -> parameters.getNameCondition().value(ReadAction.compute(() -> ((PsiClass)psiClass).getName())));
            }
            Query query = AbstractQuery.wrapInReadAction(directQuery);
            if (query == null) {
                ClassInheritorsSearch.$$$reportNull$$$0(3);
            }
            return query;
        }
        Query query = INSTANCE.createUniqueResultsQuery(parameters, psiClass -> (SmartPsiElementPointer)ReadAction.compute(() -> SmartPointerManager.getInstance((Project)psiClass.getProject()).createSmartPsiElementPointer((PsiElement)psiClass)));
        if (query == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(4);
        }
        return query;
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep) {
        if (aClass == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(6);
        }
        return ClassInheritorsSearch.search(aClass, scope, checkDeep, true, true);
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, boolean checkDeep) {
        if (aClass == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(7);
        }
        return ClassInheritorsSearch.search(aClass, (SearchScope)ReadAction.compute(() -> {
            if (!aClass.isValid()) {
                throw new ProcessCanceledException();
            }
            PsiFile file = aClass.getContainingFile();
            return PsiSearchHelper.getInstance((Project)aClass.getProject()).getUseScope((PsiElement)(file != null ? file : aClass));
        }), checkDeep);
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(8);
        }
        return ClassInheritorsSearch.search(aClass, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/searches/ClassInheritorsSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/searches/ClassInheritorsSearch";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "search";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class SearchParameters
    implements QueryParameters {
        @NotNull
        private final PsiClass myClass;
        @NotNull
        private final SearchScope myScope;
        private final boolean myCheckDeep;
        private final boolean myCheckInheritance;
        private final boolean myIncludeAnonymous;
        @NotNull
        private final Condition<? super String> myNameCondition;
        @NotNull
        private final Project myProject;

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
            if (aClass == null) {
                SearchParameters.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(1);
            }
            this(aClass, scope, checkDeep, checkInheritance, includeAnonymous, (Condition<? super String>)Conditions.alwaysTrue());
        }

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous, @NotNull Condition<? super String> nameCondition) {
            if (aClass == null) {
                SearchParameters.$$$reportNull$$$0(2);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(3);
            }
            if (nameCondition == null) {
                SearchParameters.$$$reportNull$$$0(4);
            }
            this.myClass = aClass;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
            this.myCheckInheritance = checkInheritance;
            assert (checkInheritance);
            this.myIncludeAnonymous = includeAnonymous;
            this.myNameCondition = nameCondition;
            this.myProject = PsiUtilCore.getProjectInReadAction((PsiElement)this.myClass);
        }

        @NotNull
        public PsiClass getClassToProcess() {
            PsiClass psiClass = this.myClass;
            if (psiClass == null) {
                SearchParameters.$$$reportNull$$$0(5);
            }
            return psiClass;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                SearchParameters.$$$reportNull$$$0(6);
            }
            return project;
        }

        public boolean isQueryValid() {
            return this.myClass.isValid();
        }

        @NotNull
        public Condition<? super String> getNameCondition() {
            Condition<? super String> condition = this.myNameCondition;
            if (condition == null) {
                SearchParameters.$$$reportNull$$$0(7);
            }
            return condition;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = this.myScope;
            if (searchScope == null) {
                SearchParameters.$$$reportNull$$$0(8);
            }
            return searchScope;
        }

        public boolean isCheckInheritance() {
            return this.myCheckInheritance;
        }

        public boolean isIncludeAnonymous() {
            return this.myIncludeAnonymous;
        }

        @ApiStatus.Experimental
        public boolean shouldSearchInLanguage(@NotNull Language language) {
            if (language == null) {
                SearchParameters.$$$reportNull$$$0(9);
            }
            return true;
        }

        public String toString() {
            return "'" + this.myClass.getQualifiedName() + "' scope=" + String.valueOf(this.myScope) + (this.myCheckDeep ? " (deep)" : "") + (this.myCheckInheritance ? " (check inheritance)" : "") + (this.myIncludeAnonymous ? " (anonymous)" : "") + (String)(this.myNameCondition == Conditions.alwaysTrue() ? "" : " condition: " + String.valueOf(this.myNameCondition));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchParameters that = (SearchParameters)o;
            if (this.myCheckDeep != that.myCheckDeep) {
                return false;
            }
            if (this.myCheckInheritance != that.myCheckInheritance) {
                return false;
            }
            if (this.myIncludeAnonymous != that.myIncludeAnonymous) {
                return false;
            }
            if (!this.myClass.equals((Object)that.myClass)) {
                return false;
            }
            if (!this.myScope.equals(that.myScope)) {
                return false;
            }
            return this.myNameCondition.equals(that.myNameCondition);
        }

        public int hashCode() {
            int result = this.myClass.hashCode();
            result = 31 * result + this.myScope.hashCode();
            result = 31 * result + (this.myCheckDeep ? 1 : 0);
            result = 31 * result + (this.myCheckInheritance ? 1 : 0);
            result = 31 * result + (this.myIncludeAnonymous ? 1 : 0);
            result = 31 * result + this.myNameCondition.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameCondition";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassToProcess";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameCondition";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldSearchInLanguage";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }
}

