/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DirectClassInheritorsSearch
extends ExtensibleQueryFactory<PsiClass, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor<PsiClass, SearchParameters>> EP_NAME = ExtensionPointName.create((String)"com.intellij.directClassInheritorsSearch");
    public static final DirectClassInheritorsSearch INSTANCE = new DirectClassInheritorsSearch();

    private DirectClassInheritorsSearch() {
        super(EP_NAME);
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass) {
        if (aClass == null) {
            DirectClassInheritorsSearch.$$$reportNull$$$0(0);
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)aClass));
        scope = GlobalSearchScopeUtil.includeContainingFile((GlobalSearchScope)scope, (PsiElement)aClass);
        return DirectClassInheritorsSearch.search(aClass, (SearchScope)scope);
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
        if (aClass == null) {
            DirectClassInheritorsSearch.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            DirectClassInheritorsSearch.$$$reportNull$$$0(2);
        }
        return DirectClassInheritorsSearch.search(aClass, scope, true);
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean includeAnonymous) {
        if (aClass == null) {
            DirectClassInheritorsSearch.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            DirectClassInheritorsSearch.$$$reportNull$$$0(4);
        }
        return DirectClassInheritorsSearch.search(new SearchParameters(aClass, scope, includeAnonymous, true));
    }

    @NotNull
    public static Query<PsiClass> searchAllSealedInheritors(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
        if (aClass == null) {
            DirectClassInheritorsSearch.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            DirectClassInheritorsSearch.$$$reportNull$$$0(6);
        }
        return DirectClassInheritorsSearch.search(new SearchParameters(aClass, scope, true, true, false));
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull SearchParameters parameters) {
        if (parameters == null) {
            DirectClassInheritorsSearch.$$$reportNull$$$0(7);
        }
        Query query = INSTANCE.createUniqueResultsQuery(parameters);
        if (query == null) {
            DirectClassInheritorsSearch.$$$reportNull$$$0(8);
        }
        return query;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/searches/DirectClassInheritorsSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/searches/DirectClassInheritorsSearch";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "search";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "searchAllSealedInheritors";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    public static class SearchParameters {
        @NotNull
        private final PsiClass myClass;
        @NotNull
        private final SearchScope myScope;
        private final boolean myIncludeAnonymous;
        private final boolean myCheckInheritance;
        private final boolean myRestrictSealedHierarchy;

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean includeAnonymous, boolean checkInheritance, boolean restrictSealedHierarchy) {
            if (aClass == null) {
                SearchParameters.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(1);
            }
            this.myClass = aClass;
            this.myScope = scope;
            this.myIncludeAnonymous = includeAnonymous;
            this.myCheckInheritance = checkInheritance;
            this.myRestrictSealedHierarchy = restrictSealedHierarchy;
        }

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean includeAnonymous, boolean checkInheritance) {
            if (aClass == null) {
                SearchParameters.$$$reportNull$$$0(2);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(3);
            }
            this(aClass, scope, includeAnonymous, checkInheritance, true);
        }

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean includeAnonymous) {
            if (aClass == null) {
                SearchParameters.$$$reportNull$$$0(4);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(5);
            }
            this(aClass, scope, includeAnonymous, true);
        }

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
            if (aClass == null) {
                SearchParameters.$$$reportNull$$$0(6);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(7);
            }
            this(aClass, scope, true);
        }

        @NotNull
        public PsiClass getClassToProcess() {
            PsiClass psiClass = this.myClass;
            if (psiClass == null) {
                SearchParameters.$$$reportNull$$$0(8);
            }
            return psiClass;
        }

        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = this.myScope;
            if (searchScope == null) {
                SearchParameters.$$$reportNull$$$0(9);
            }
            return searchScope;
        }

        public boolean isCheckInheritance() {
            return this.myCheckInheritance;
        }

        public boolean includeAnonymous() {
            return this.myIncludeAnonymous;
        }

        public boolean restrictSealedHierarchy() {
            return this.myRestrictSealedHierarchy;
        }

        @Nullable
        public ClassInheritorsSearch.SearchParameters getOriginalParameters() {
            return null;
        }

        @ApiStatus.Experimental
        public boolean shouldSearchInLanguage(@NotNull Language language) {
            if (language == null) {
                SearchParameters.$$$reportNull$$$0(10);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/searches/DirectClassInheritorsSearch$SearchParameters";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/searches/DirectClassInheritorsSearch$SearchParameters";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassToProcess";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: 
                case 9: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldSearchInLanguage";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 9 -> new IllegalStateException(string);
            };
        }
    }
}

