/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public final class OverridingMethodsSearch
extends ExtensibleQueryFactory<PsiMethod, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor<PsiMethod, SearchParameters>> EP_NAME = ExtensionPointName.create((String)"com.intellij.overridingMethodsSearch");
    public static final OverridingMethodsSearch INSTANCE = new OverridingMethodsSearch();

    private OverridingMethodsSearch() {
        super(EP_NAME);
    }

    @NotNull
    public static Query<PsiMethod> search(@NotNull PsiMethod method, @NotNull SearchScope scope, boolean checkDeep) {
        if (method == null) {
            OverridingMethodsSearch.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            OverridingMethodsSearch.$$$reportNull$$$0(1);
        }
        if (((Boolean)ReadAction.compute(() -> !PsiUtil.canBeOverridden((PsiMethod)method))).booleanValue()) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                OverridingMethodsSearch.$$$reportNull$$$0(2);
            }
            return query;
        }
        Query query = INSTANCE.createUniqueResultsQuery(new SearchParameters(method, scope, checkDeep));
        if (query == null) {
            OverridingMethodsSearch.$$$reportNull$$$0(3);
        }
        return query;
    }

    @NotNull
    public static Query<PsiMethod> search(@NotNull PsiMethod method, boolean checkDeep) {
        if (method == null) {
            OverridingMethodsSearch.$$$reportNull$$$0(4);
        }
        return OverridingMethodsSearch.search(method, (SearchScope)ReadAction.compute(() -> ((PsiMethod)method).getUseScope()), checkDeep);
    }

    @NotNull
    public static Query<PsiMethod> search(@NotNull PsiMethod method) {
        if (method == null) {
            OverridingMethodsSearch.$$$reportNull$$$0(5);
        }
        return OverridingMethodsSearch.search(method, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/searches/OverridingMethodsSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/searches/OverridingMethodsSearch";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "search";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class SearchParameters {
        @NotNull
        private final PsiMethod myMethod;
        @NotNull
        private final SearchScope myScope;
        private final boolean myCheckDeep;

        public SearchParameters(@NotNull PsiMethod method, @NotNull SearchScope scope, boolean checkDeep) {
            if (method == null) {
                SearchParameters.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(1);
            }
            this.myMethod = method;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
        }

        @NotNull
        public PsiMethod getMethod() {
            PsiMethod psiMethod = this.myMethod;
            if (psiMethod == null) {
                SearchParameters.$$$reportNull$$$0(2);
            }
            return psiMethod;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = this.myScope;
            if (searchScope == null) {
                SearchParameters.$$$reportNull$$$0(3);
            }
            return searchScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/searches/OverridingMethodsSearch$SearchParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/searches/OverridingMethodsSearch$SearchParameters";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethod";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

