/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.extensions;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.extensions.ExtensionPointDescriptor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001b\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u0010\u001a\u00020\u0011R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/extensions/ProjectExtensionDescriptor;", "T", "", "Lorg/jetbrains/kotlin/extensions/ExtensionPointDescriptor;", "name", "", "extensionClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/String;Ljava/lang/Class;)V", "extensionPointName", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "getExtensionPointName", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "registerExtensionPoint", "", "project", "Lcom/intellij/openapi/project/Project;", "registerExtension", "extension", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Object;)V", "getInstances", "", "util"})
public class ProjectExtensionDescriptor<T>
extends ExtensionPointDescriptor<T> {
    @NotNull
    private final ExtensionPointName<T> extensionPointName;

    public ProjectExtensionDescriptor(@NotNull String name2, @NotNull Class<T> extensionClass) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(extensionClass, (String)"extensionClass");
        super(name2, extensionClass);
        this.extensionPointName = ExtensionPointName.Companion.create(name2);
    }

    @NotNull
    public final ExtensionPointName<T> getExtensionPointName() {
        return this.extensionPointName;
    }

    public final void registerExtensionPoint(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)project.getExtensionArea(), (String)this.extensionPointName.getName(), this.getExtensionClass());
    }

    public final void registerExtension(@NotNull Project project, @NotNull T extension) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        ExtensionPoint extensionPoint = project.getExtensionArea().getExtensionPoint(this.extensionPointName);
        Object[] objectArray = extensionPoint.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getExtensions(...)");
        if (!ArraysKt.contains((Object[])objectArray, extension)) {
            extensionPoint.registerExtension(extension, (Disposable)project);
        }
    }

    @NotNull
    public final List<T> getInstances(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ExtensionsArea extensionsArea = project.getExtensionArea();
        Intrinsics.checkNotNullExpressionValue((Object)extensionsArea, (String)"getExtensionArea(...)");
        ExtensionsArea projectArea = extensionsArea;
        if (!projectArea.hasExtensionPoint(this.extensionPointName.getName())) {
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = projectArea.getExtensionPoint(this.extensionPointName).getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getExtensions(...)");
        return ArraysKt.toList((Object[])objectArray);
    }
}

