/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.writer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.FileKt;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;
import org.jetbrains.kotlin.library.KlibFormat;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.library.impl.KlibManifestComponentWriterImpl;
import org.jetbrains.kotlin.library.impl.KlibResourcesComponentWriterImpl;
import org.jetbrains.kotlin.library.writer.KlibComponentWriter;
import org.jetbrains.kotlin.library.writer.KlibManifestWriterSpec;
import org.jetbrains.kotlin.library.writer.KlibWriterSpec;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001e\u0012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0012R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/library/writer/KlibWriter;", "", "init", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/library/writer/KlibWriterSpec;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)V", "builtInsPlatform", "Lorg/jetbrains/kotlin/library/impl/BuiltInsPlatform;", "componentWriters", "", "Lorg/jetbrains/kotlin/library/writer/KlibComponentWriter;", "customProperties", "Ljava/util/Properties;", "format", "Lorg/jetbrains/kotlin/library/KlibFormat;", "moduleName", "", "targetNames", "", "versions", "Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;", "validateManifestPropertiesAndCreateComponentWriter", "Lorg/jetbrains/kotlin/library/impl/KlibManifestComponentWriterImpl;", "writeTo", "destinationPath", "Companion", "kotlin-util-klib"})
@SourceDebugExtension(value={"SMAP\nKlibWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibWriter.kt\norg/jetbrains/kotlin/library/writer/KlibWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1#2:173\n*E\n"})
public final class KlibWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private KlibFormat format;
    @NotNull
    private final List<KlibComponentWriter> componentWriters;
    @Nullable
    private String moduleName;
    @Nullable
    private KotlinLibraryVersioning versions;
    @Nullable
    private BuiltInsPlatform builtInsPlatform;
    @NotNull
    private List<String> targetNames;
    @NotNull
    private final Properties customProperties;

    public KlibWriter(@NotNull Function1<? super KlibWriterSpec, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this.format = KlibFormat.Directory.INSTANCE;
        this.componentWriters = new ArrayList();
        this.targetNames = CollectionsKt.emptyList();
        this.customProperties = new Properties();
        init.invoke((Object)new KlibWriterSpec(){

            @Override
            public void format(KlibFormat format) {
                Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                format = format;
            }

            @Override
            public void include(KlibComponentWriter ... writers) {
                Intrinsics.checkNotNullParameter((Object)writers, (String)"writers");
                CollectionsKt.addAll((Collection)componentWriters, (Object[])writers);
            }

            @Override
            public void include(Collection<? extends KlibComponentWriter> writers) {
                Intrinsics.checkNotNullParameter(writers, (String)"writers");
                CollectionsKt.addAll((Collection)componentWriters, (Iterable)writers);
            }

            @Override
            public void manifest(Function1<? super KlibManifestWriterSpec, Unit> init) {
                Intrinsics.checkNotNullParameter(init, (String)"init");
                init.invoke((Object)this);
            }

            @Override
            public void moduleName(String moduleName) {
                Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
                moduleName = moduleName;
            }

            @Override
            public void versions(KotlinLibraryVersioning versions) {
                Intrinsics.checkNotNullParameter((Object)versions, (String)"versions");
                versions = versions;
            }

            @Override
            public void platformAndTargets(BuiltInsPlatform builtInsPlatform, Collection<String> targetNames) {
                Intrinsics.checkNotNullParameter((Object)((Object)builtInsPlatform), (String)"builtInsPlatform");
                Intrinsics.checkNotNullParameter(targetNames, (String)"targetNames");
                builtInsPlatform = builtInsPlatform;
                targetNames = CollectionsKt.toList((Iterable)targetNames);
            }

            @Override
            public void platformAndTargets(BuiltInsPlatform builtInsPlatform, String ... targetNames) {
                Intrinsics.checkNotNullParameter((Object)((Object)builtInsPlatform), (String)"builtInsPlatform");
                Intrinsics.checkNotNullParameter((Object)targetNames, (String)"targetNames");
                this.platformAndTargets(builtInsPlatform, ArraysKt.asList((Object[])targetNames));
            }

            @Override
            public void customProperties(Function1<? super Properties, Unit> init) {
                Intrinsics.checkNotNullParameter(init, (String)"init");
                init.invoke((Object)customProperties);
            }
        });
    }

    public final void writeTo(@NotNull String destinationPath) {
        List list;
        Intrinsics.checkNotNullParameter((Object)destinationPath, (String)"destinationPath");
        List $this$writeTo_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$writeTo_u24lambda_u240, (Iterable)this.componentWriters);
        ((Collection)$this$writeTo_u24lambda_u240).add(this.validateManifestPropertiesAndCreateComponentWriter());
        ((Collection)$this$writeTo_u24lambda_u240).add(KlibResourcesComponentWriterImpl.INSTANCE);
        List allComponentWriters = CollectionsKt.build((List)list);
        File destination = new File(destinationPath);
        if (destination.getExists()) {
            destination.deleteRecursively();
        } else {
            destination.getParentFile().mkdirs();
        }
        KlibFormat klibFormat = this.format;
        if (Intrinsics.areEqual((Object)klibFormat, (Object)KlibFormat.Directory.INSTANCE)) {
            KlibWriter.Companion.writeComponents(allComponentWriters, destination);
        } else if (Intrinsics.areEqual((Object)klibFormat, (Object)KlibFormat.ZipArchive.INSTANCE)) {
            File temporaryDir = FileKt.createTempDir("klib");
            KlibWriter.Companion.writeComponents(allComponentWriters, temporaryDir);
            ZipUtilKt.zipDirAs(temporaryDir, destination);
            temporaryDir.deleteRecursively();
        }
    }

    private final KlibManifestComponentWriterImpl validateManifestPropertiesAndCreateComponentWriter() {
        String string = this.moduleName;
        if (string == null) {
            boolean $i$a$-checkNotNull-KlibWriter$validateManifestPropertiesAndCreateComponentWriter$moduleName$22 = false;
            String $i$a$-checkNotNull-KlibWriter$validateManifestPropertiesAndCreateComponentWriter$moduleName$22 = "Module name is not specified. Use `KlibWriter { manifest { moduleName(...) } }` to set it.";
            throw new IllegalStateException($i$a$-checkNotNull-KlibWriter$validateManifestPropertiesAndCreateComponentWriter$moduleName$22.toString());
        }
        String moduleName = string;
        if (!(!StringsKt.isBlank((CharSequence)moduleName))) {
            boolean $i$a$-check-KlibWriter$validateManifestPropertiesAndCreateComponentWriter$42 = false;
            String $i$a$-check-KlibWriter$validateManifestPropertiesAndCreateComponentWriter$42 = "Module name cannot be empty.";
            throw new IllegalStateException($i$a$-check-KlibWriter$validateManifestPropertiesAndCreateComponentWriter$42.toString());
        }
        KotlinLibraryVersioning kotlinLibraryVersioning = this.versions;
        if (kotlinLibraryVersioning == null) {
            boolean $i$a$-checkNotNull-KlibWriter$validateManifestPropertiesAndCreateComponentWriter$versions$22 = false;
            String $i$a$-checkNotNull-KlibWriter$validateManifestPropertiesAndCreateComponentWriter$versions$22 = "Klib versions are not specified. Use `KlibWriter { manifest { versions(...) } }` to set them.";
            throw new IllegalStateException($i$a$-checkNotNull-KlibWriter$validateManifestPropertiesAndCreateComponentWriter$versions$22.toString());
        }
        KotlinLibraryVersioning versions = kotlinLibraryVersioning;
        BuiltInsPlatform builtInsPlatform = this.builtInsPlatform;
        if (builtInsPlatform == null) {
            boolean $i$a$-checkNotNull-KlibWriter$validateManifestPropertiesAndCreateComponentWriter$builtInsPlatform$22 = false;
            String $i$a$-checkNotNull-KlibWriter$validateManifestPropertiesAndCreateComponentWriter$builtInsPlatform$22 = "Klib platform is not specified. Use `KlibWriter { manifest { platformAndTargets(...) } }` to set it along with targets.";
            throw new IllegalStateException($i$a$-checkNotNull-KlibWriter$validateManifestPropertiesAndCreateComponentWriter$builtInsPlatform$22.toString());
        }
        BuiltInsPlatform builtInsPlatform2 = builtInsPlatform;
        if (!(this.targetNames.isEmpty() || KlibManifestComponentWriterImpl.Companion.getPropertyNameForListOfTargetNames$kotlin_util_klib(builtInsPlatform2) != null)) {
            boolean bl = false;
            String string2 = "Non-empty list of target names is specified for a platform that doesn't support them: " + (Object)((Object)builtInsPlatform2);
            throw new IllegalStateException(string2.toString());
        }
        Set<String> set = this.customProperties.stringPropertyNames();
        Intrinsics.checkNotNullExpressionValue(set, (String)"customProperties.stringPropertyNames()");
        Set nonCustomizedPropertyNames = CollectionsKt.intersect((Iterable)set, (Iterable)KlibManifestComponentWriterImpl.Companion.getNON_CUSTOMIZED_PROPERTY_NAMES$kotlin_util_klib());
        if (!nonCustomizedPropertyNames.isEmpty()) {
            boolean bl = false;
            String string3 = "Custom properties " + nonCustomizedPropertyNames + " are not allowed to be added through `KlibWriter { manifest { customProperties(...) } }`. Use other functions to set them.";
            throw new IllegalStateException(string3.toString());
        }
        return new KlibManifestComponentWriterImpl(moduleName, versions, builtInsPlatform2, this.targetNames, this.customProperties);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/library/writer/KlibWriter$Companion;", "", "()V", "writeComponents", "", "allComponentWriters", "", "Lorg/jetbrains/kotlin/library/writer/KlibComponentWriter;", "root", "Lorg/jetbrains/kotlin/konan/file/File;", "kotlin-util-klib"})
    public static final class Companion {
        private Companion() {
        }

        private final void writeComponents(List<? extends KlibComponentWriter> allComponentWriters, File root) {
            for (KlibComponentWriter klibComponentWriter : allComponentWriters) {
                klibComponentWriter.writeTo(root);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

