/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.platform;

import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.platform.PlatformUtilKt;
import org.jetbrains.kotlin.platform.SimplePlatform;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\r\u001a\u00020\u000eH\u0096\u0080\u0004J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0082\u0004J\n\u0010\u0013\u001a\u00020\nH\u0096\u0080\u0004J\u0010\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0096\u0083\u0004R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/platform/TargetPlatform;", "", "Lorg/jetbrains/kotlin/platform/SimplePlatform;", "componentPlatforms", "", "<init>", "(Ljava/util/Set;)V", "getComponentPlatforms", "()Ljava/util/Set;", "size", "", "getSize", "()I", "toString", "", "equals", "", "other", "", "hashCode", "iterator", "", "compiler.common"})
public class TargetPlatform
implements Iterable<SimplePlatform>,
KMappedMarker {
    @NotNull
    private final Set<SimplePlatform> componentPlatforms;

    public TargetPlatform(@NotNull Set<? extends SimplePlatform> componentPlatforms) {
        Intrinsics.checkNotNullParameter(componentPlatforms, (String)"componentPlatforms");
        this.componentPlatforms = componentPlatforms;
        if (this.componentPlatforms.isEmpty()) {
            throw new IllegalArgumentException("Don't instantiate TargetPlatform with empty set of platforms");
        }
    }

    @NotNull
    public final Set<SimplePlatform> getComponentPlatforms() {
        return this.componentPlatforms;
    }

    public final int getSize() {
        return this.componentPlatforms.size();
    }

    @NotNull
    public String toString() {
        return PlatformUtilKt.getPresentableDescription(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TargetPlatform)) {
            return false;
        }
        return Intrinsics.areEqual(this.componentPlatforms, ((TargetPlatform)other).componentPlatforms);
    }

    public int hashCode() {
        return ((Object)this.componentPlatforms).hashCode();
    }

    @Override
    @NotNull
    public Iterator<SimplePlatform> iterator() {
        return this.componentPlatforms.iterator();
    }
}

