/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.types.model.FlexibleTypeMarker;
import org.jetbrains.kotlin.types.model.K2Only;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.RigidTypeMarker;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u001c\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0003b\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\u000b*\u00020\rH\u0003b\u0002\b\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/JvmTypeSpecificityComparator;", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "context", "Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getContext", "()Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;", "isDefinitelyLessSpecific", "", "specific", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "general", "isDefinitelyLessSpecificForFlexibleSpecific", "isDefinitelyLessSpecificForSameEnhancedNotNullable", "Lorg/jetbrains/kotlin/types/model/K2Only;", "isPrimitiveInJava", "resolution.common.jvm"})
public class JvmTypeSpecificityComparator
implements TypeSpecificityComparator {
    @NotNull
    private final TypeSystemInferenceExtensionContext context;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public JvmTypeSpecificityComparator(@NotNull TypeSystemInferenceExtensionContext context, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.context = context;
        this.languageVersionSettings = languageVersionSettings;
    }

    @NotNull
    public TypeSystemInferenceExtensionContext getContext() {
        return this.context;
    }

    @Override
    public boolean isDefinitelyLessSpecific(@NotNull KotlinTypeMarker specific, @NotNull KotlinTypeMarker general) {
        Intrinsics.checkNotNullParameter((Object)specific, (String)"specific");
        Intrinsics.checkNotNullParameter((Object)general, (String)"general");
        if (this.isDefinitelyLessSpecificForFlexibleSpecific(specific, general)) {
            return true;
        }
        if (!this.getContext().isK2() || !this.languageVersionSettings.supportsFeature(LanguageFeature.OverloadResolutionSpecificityForEnhancedJvmPrimitiveWrappers)) {
            return false;
        }
        return this.isDefinitelyLessSpecificForSameEnhancedNotNullable(specific, general);
    }

    private final boolean isDefinitelyLessSpecificForFlexibleSpecific(KotlinTypeMarker specific, KotlinTypeMarker general) {
        TypeSystemInferenceExtensionContext $this$isDefinitelyLessSpecificForFlexibleSpecific_u24lambda_u240 = this.getContext();
        boolean bl = false;
        RigidTypeMarker simpleGeneral = $this$isDefinitelyLessSpecificForFlexibleSpecific_u24lambda_u240.asRigidType(general);
        if (!$this$isDefinitelyLessSpecificForFlexibleSpecific_u24lambda_u240.isFlexible(specific) || simpleGeneral == null) {
            return false;
        }
        FlexibleTypeMarker flexibleTypeMarker = $this$isDefinitelyLessSpecificForFlexibleSpecific_u24lambda_u240.asFlexibleType(specific);
        Intrinsics.checkNotNull((Object)flexibleTypeMarker);
        FlexibleTypeMarker flexibility = flexibleTypeMarker;
        if (!$this$isDefinitelyLessSpecificForFlexibleSpecific_u24lambda_u240.isPrimitiveType(simpleGeneral) || !$this$isDefinitelyLessSpecificForFlexibleSpecific_u24lambda_u240.isPrimitiveType($this$isDefinitelyLessSpecificForFlexibleSpecific_u24lambda_u240.lowerBound(flexibility))) {
            return false;
        }
        return !$this$isDefinitelyLessSpecificForFlexibleSpecific_u24lambda_u240.isMarkedNullable(simpleGeneral);
    }

    @K2Only
    private final boolean isDefinitelyLessSpecificForSameEnhancedNotNullable(KotlinTypeMarker specific, KotlinTypeMarker general) {
        TypeSystemInferenceExtensionContext $this$isDefinitelyLessSpecificForSameEnhancedNotNullable_u24lambda_u240 = this.getContext();
        boolean bl = false;
        if (!this.isPrimitiveInJava(general)) {
            return false;
        }
        if (!$this$isDefinitelyLessSpecificForSameEnhancedNotNullable_u24lambda_u240.areEqualTypeConstructors($this$isDefinitelyLessSpecificForSameEnhancedNotNullable_u24lambda_u240.typeConstructor(specific), $this$isDefinitelyLessSpecificForSameEnhancedNotNullable_u24lambda_u240.typeConstructor(general))) {
            return false;
        }
        return !this.isPrimitiveInJava(specific);
    }

    @K2Only
    private final boolean isPrimitiveInJava(KotlinTypeMarker $this$isPrimitiveInJava) {
        TypeSystemInferenceExtensionContext $this$isPrimitiveInJava_u24lambda_u240 = this.getContext();
        boolean bl = false;
        RigidTypeMarker rigidTypeMarker = $this$isPrimitiveInJava_u24lambda_u240.asRigidType($this$isPrimitiveInJava);
        if (rigidTypeMarker == null) {
            return false;
        }
        RigidTypeMarker rigid = rigidTypeMarker;
        if ($this$isPrimitiveInJava_u24lambda_u240.isNullableType(rigid) || $this$isPrimitiveInJava_u24lambda_u240.hasEnhancedNullability(rigid)) {
            return false;
        }
        return $this$isPrimitiveInJava_u24lambda_u240.isPrimitiveType(rigid);
    }
}

