/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/InconsistentOperatorFromJavaCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "CONCURRENT_HASH_MAP_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
public final class InconsistentOperatorFromJavaCallChecker
implements CallChecker {
    @NotNull
    public static final InconsistentOperatorFromJavaCallChecker INSTANCE = new InconsistentOperatorFromJavaCallChecker();
    @NotNull
    private static final FqName CONCURRENT_HASH_MAP_FQ_NAME = new FqName("java.util.concurrent.ConcurrentHashMap");

    private InconsistentOperatorFromJavaCallChecker() {
    }

    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CallableDescriptor callableDescriptor = resolvedCall.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getCandidateDescriptor(...)");
        CallableDescriptor candidateDescriptor = callableDescriptor;
        if (!Intrinsics.areEqual((Object)candidateDescriptor.getName(), (Object)OperatorNameConventions.CONTAINS)) {
            return;
        }
        List list = candidateDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.singleOrNull((List)list);
        if (!(valueParameterDescriptor != null && (valueParameterDescriptor = valueParameterDescriptor.getType()) != null ? TypeUtilsKt.isAnyOrNullableAny((KotlinType)valueParameterDescriptor) : false)) {
            return;
        }
        if (!(resolvedCall.getCall().getCallElement() instanceof KtBinaryExpression) || !resolvedCall.getStatus().possibleTransformToSuccess()) {
            return;
        }
        for (CallableDescriptor callableDescriptor2 : DescriptorUtilsKt.overriddenTreeUniqueAsSequence((CallableDescriptor)candidateDescriptor, (boolean)false)) {
            ClassDescriptor containingClass;
            DeclarationDescriptor declarationDescriptor = callableDescriptor2.getContainingDeclaration();
            ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (classDescriptor == null || !Intrinsics.areEqual((Object)DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)(containingClass = classDescriptor))), (Object)CONCURRENT_HASH_MAP_FQ_NAME)) continue;
            context.getTrace().report((Diagnostic)ErrorsJvm.CONCURRENT_HASH_MAP_CONTAINS_OPERATOR.on(context.getLanguageVersionSettings(), reportOn));
            break;
        }
    }
}

