/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.logging.BuildLoggingManager;
import org.jetbrains.jps.incremental.CompilerEncodingConfiguration;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.ProjectStamps;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;

public final class ProjectDescriptor {
    private final JpsProject myProject;
    private final JpsModel myModel;
    public final BuildFSState fsState;
    public final BuildDataManager dataManager;
    private final BuildLoggingManager myLoggingManager;
    private final ModuleExcludeIndex myModuleExcludeIndex;
    private int myUseCounter = 1;
    private final Set<JpsSdk<?>> myProjectJavaSdks;
    private final CompilerEncodingConfiguration myEncodingConfiguration;
    private final BuildRootIndex myBuildRootIndex;
    private final BuildTargetIndex myBuildTargetIndex;
    private final IgnoredFileIndex myIgnoredFileIndex;

    @ApiStatus.Internal
    @TestOnly
    public ProjectDescriptor(JpsModel model, BuildFSState fsState, ProjectStamps projectStamps, BuildDataManager dataManager, BuildLoggingManager loggingManager, ModuleExcludeIndex moduleExcludeIndex, BuildTargetIndex buildTargetIndex, BuildRootIndex buildRootIndex, IgnoredFileIndex ignoredFileIndex) {
        this(model, fsState, dataManager, loggingManager, moduleExcludeIndex, buildTargetIndex, buildRootIndex, ignoredFileIndex);
        assert (dataManager.getFileStampService() == null);
        dataManager.setFileStampService(projectStamps);
    }

    @ApiStatus.Internal
    public ProjectDescriptor(JpsModel model, BuildFSState fsState, BuildDataManager dataManager, BuildLoggingManager loggingManager, ModuleExcludeIndex moduleExcludeIndex, BuildTargetIndex buildTargetIndex, BuildRootIndex buildRootIndex, IgnoredFileIndex ignoredFileIndex) {
        this.myModel = model;
        this.myIgnoredFileIndex = ignoredFileIndex;
        this.myProject = model.getProject();
        this.fsState = fsState;
        this.dataManager = dataManager;
        this.myBuildTargetIndex = buildTargetIndex;
        this.myBuildRootIndex = buildRootIndex;
        this.myLoggingManager = loggingManager;
        this.myModuleExcludeIndex = moduleExcludeIndex;
        this.myProjectJavaSdks = new HashSet();
        this.myEncodingConfiguration = new CompilerEncodingConfiguration(model, buildRootIndex);
        for (JpsModule module : this.myProject.getModules()) {
            JpsSdk sdk = module.getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
            if (sdk == null || this.myProjectJavaSdks.contains(sdk) || sdk.getVersionString() == null || sdk.getHomePath() == null) continue;
            this.myProjectJavaSdks.add(sdk);
        }
    }

    public BuildRootIndex getBuildRootIndex() {
        return this.myBuildRootIndex;
    }

    public BuildTargetIndex getBuildTargetIndex() {
        return this.myBuildTargetIndex;
    }

    public IgnoredFileIndex getIgnoredFileIndex() {
        return this.myIgnoredFileIndex;
    }

    public CompilerEncodingConfiguration getEncodingConfiguration() {
        return this.myEncodingConfiguration;
    }

    public Set<JpsSdk<?>> getProjectJavaSdks() {
        return this.myProjectJavaSdks;
    }

    public BuildLoggingManager getLoggingManager() {
        return this.myLoggingManager;
    }

    public synchronized void incUsageCounter() {
        ++this.myUseCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        boolean shouldClose;
        ProjectDescriptor projectDescriptor = this;
        synchronized (projectDescriptor) {
            --this.myUseCounter;
            shouldClose = this.myUseCounter == 0;
        }
        if (shouldClose) {
            try {
                this.dataManager.close();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public ModuleExcludeIndex getModuleExcludeIndex() {
        return this.myModuleExcludeIndex;
    }

    public JpsModel getModel() {
        return this.myModel;
    }

    public JpsProject getProject() {
        return this.myProject;
    }

    @Deprecated(forRemoval=true)
    public ProjectStamps getProjectStamps() {
        return Objects.requireNonNull(this.dataManager.getFileStampService());
    }
}

