/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.dependencies;

import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hashing;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SmartHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.dependency.Delta;
import org.jetbrains.jps.dependency.DependencyGraph;
import org.jetbrains.jps.dependency.DifferentiateParameters;
import org.jetbrains.jps.dependency.DifferentiateResult;
import org.jetbrains.jps.dependency.GraphConfiguration;
import org.jetbrains.jps.dependency.LogConsumer;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.NodeSourcePathMapper;
import org.jetbrains.jps.dependency.impl.DifferentiateParametersBuilder;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.dependencies.LibraryDef;
import org.jetbrains.jps.incremental.dependencies.LibraryNodesBuilder;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.dataTypes.LibraryRoots;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JavaModuleIndex;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.Iterators;

@ApiStatus.Internal
public final class LibraryDependenciesUpdater {
    private static final Logger LOG = Logger.getInstance(LibraryDependenciesUpdater.class);
    private static final String MODULE_INFO_FILE = "module-info.java";
    private static final GlobalContextKey<Set<BuildTarget<?>>> PROCESSED_TARGETS_KEY = GlobalContextKey.create("__library_deps_updater_processed_targets__");
    private boolean myIsInitialized;
    private final Map<String, List<Path>> myDeletedRoots = new HashMap<String, List<Path>>();
    private final Map<Path, String> myNamespaces = new HashMap<Path, String>();
    private final Set<Path> myProcessedRoots = new HashSet<Path>();
    private long myTotalTimeNano = 0L;

    public synchronized boolean update(CompileContext context, ModuleChunk chunk) throws IOException {
        if (!JavaBuilderUtil.isTrackLibraryDependenciesEnabled() || context.isCanceled()) {
            return true;
        }
        long start = System.nanoTime();
        ProjectDescriptor pd = context.getProjectDescriptor();
        BuildDataManager dataManager = pd.dataManager;
        GraphConfiguration graphConfig = Objects.requireNonNull(dataManager.getDependencyGraph());
        DependencyGraph graph = graphConfig.getGraph();
        NodeSourcePathMapper pathMapper = graphConfig.getPathMapper();
        boolean isFullRebuild = JavaBuilderUtil.isForcedRecompilationAllJavaModules(context);
        SmartHashSet deletedRoots = new SmartHashSet();
        SmartHashSet updatedRoots = new SmartHashSet();
        LibraryRoots libraryRoots = dataManager.getLibraryRoots();
        boolean errorsDetected = false;
        Set<ModuleBuildTarget> chunkTargets = chunk.getTargets();
        try {
            if (!this.myIsInitialized) {
                this.myIsInitialized = true;
                HashMap present = new HashMap();
                for (Object library : JpsJavaExtensionService.dependencies((JpsProject)pd.getProject()).getLibraries()) {
                    for (Path libRoot : Iterators.filter((Iterable)library.getPaths(JpsOrderRootType.COMPILED), LibraryDef::isLibraryPath)) {
                        present.computeIfAbsent(libRoot, k -> new SmartList()).add(library.getName());
                    }
                }
                HashStream64 hash = null;
                for (Map.Entry entry : present.entrySet()) {
                    if (hash == null) {
                        hash = Hashing.komihash5_0().hashStream();
                    } else {
                        hash.reset();
                    }
                    List libNames = (List)entry.getValue();
                    Collections.sort(libNames);
                    for (String name : libNames) {
                        hash.putString(name);
                    }
                    this.myNamespaces.put((Path)entry.getKey(), Long.toUnsignedString(hash.getAsLong(), 36));
                }
                Set<Path> past = libraryRoots.getRoots(new HashSet<Path>());
                past.removeAll(present.keySet());
                Iterator iterator = past.iterator();
                while (iterator.hasNext()) {
                    Path deletedRoot = (Path)iterator.next();
                    this.myDeletedRoots.computeIfAbsent(libraryRoots.getNamespace(deletedRoot), k -> new SmartList()).add(deletedRoot);
                }
                HashSet<String> hashSet = new HashSet<String>(this.myDeletedRoots.keySet());
                hashSet.removeAll(this.myNamespaces.values());
                for (String ns : hashSet) {
                    deletedRoots.addAll((Collection)this.myDeletedRoots.remove(ns));
                }
                LOG.info("LibraryDependencyUpdater initialized in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " ms");
            }
            for (JpsLibrary library : Iterators.uniqueBy((Iterable)Iterators.flat((Iterable)Iterators.map(chunk.getModules(), m -> JpsJavaExtensionService.dependencies((JpsModule)m).recursivelyExportedOnly().getLibraries())), () -> {
                HashSet processed = new HashSet();
                return lib -> processed.add(lib.getName());
            })) {
                for (Path path : Iterators.filter((Iterable)library.getPaths(JpsOrderRootType.COMPILED), LibraryDef::isLibraryPath)) {
                    BasicFileAttributes attribs;
                    if (!this.myProcessedRoots.add(path)) continue;
                    String namespace = this.myNamespaces.get(path);
                    Collection deleted = this.myDeletedRoots.remove(namespace);
                    if (deleted != null) {
                        deletedRoots.addAll(deleted);
                    }
                    if ((attribs = FSOperations.getAttributes(path)) != null) {
                        if (!attribs.isRegularFile() || !libraryRoots.update(path, namespace, FSOperations.lastModified(path, attribs))) continue;
                        updatedRoots.add(path);
                        continue;
                    }
                    deletedRoots.add(path);
                }
            }
            if (updatedRoots.isEmpty() && Iterators.isEmpty((Iterable)deletedRoots)) {
                boolean present = true;
                return present;
            }
            LibraryDependenciesUpdater.sendProgress(context, JpsBuildBundle.message("progress.message.updating.library.state", updatedRoots.size(), Iterators.count((Iterable)deletedRoots), chunk.getPresentableShortName()));
            List toUpdate = (List)Iterators.collect((Iterable)Iterators.map((Iterable)updatedRoots, root -> Pair.create((Object)root, (Object)pathMapper.toNodeSource(root))), new ArrayList());
            Delta delta = graph.createDelta(Iterators.map((Iterable)toUpdate, p -> (NodeSource)p.getSecond()), Iterators.map((Iterable)deletedRoots, arg_0 -> ((NodeSourcePathMapper)pathMapper).toNodeSource(arg_0)), false);
            LibraryNodesBuilder nodesBuilder = new LibraryNodesBuilder(graphConfig);
            for (Pair pair : toUpdate) {
                Path libRoot = (Path)pair.getFirst();
                NodeSource src = (NodeSource)pair.getSecond();
                Set<NodeSource> sources = Set.of(src);
                int nodeCount = 0;
                for (Node<?, ?> node : nodesBuilder.processLibraryRoot(this.myNamespaces.get(libRoot), src)) {
                    ++nodeCount;
                    delta.associate(node, sources);
                }
                LibraryDependenciesUpdater.sendProgress(context, JpsBuildBundle.message("progress.message.processing.library", libRoot.getFileName(), nodeCount));
            }
            Set<BuildTarget<?>> set = Collections.unmodifiableSet(LibraryDependenciesUpdater.getProcessedTargets(context));
            Predicate<? super NodeSource> affectionFilter = LibraryDependenciesUpdater.excludedFrom(set, context, pathMapper);
            DifferentiateParameters diffParams = DifferentiateParametersBuilder.create((String)("libraries of " + chunk.getName())).withScopeFilter(affectionFilter).withAffectionFilter(affectionFilter).calculateAffected(!isFullRebuild).withChunkStructureFilter(LibraryDependenciesUpdater.includedIn(chunkTargets, context, pathMapper)).withLogConsumer(LogConsumer.createJULogConsumer((Level)Level.FINE)).get();
            DifferentiateResult diffResult = graph.differentiate(delta, diffParams);
            if (!diffResult.isIncremental()) {
                if (!isFullRebuild) {
                    LibraryDependenciesUpdater.sendProgress(context, "Non-incremental mode: " + JpsBuildBundle.message("progress.message.marking.0.and.direct.dependants.for.recompilation", chunk.getPresentableShortName()));
                    FSOperations.markDirtyRecursively(context, CompilationRound.CURRENT, chunk, null);
                }
            } else if (diffParams.isCalculateAffected()) {
                Iterable affectedSources = diffResult.getAffectedSources();
                LibraryDependenciesUpdater.sendProgress(context, JpsBuildBundle.message("progress.message.dependency.analysis.found.0.affected.files", Iterators.count((Iterable)affectedSources)));
                LibraryDependenciesUpdater.markAffectedFilesDirty(context, chunk, Iterators.map((Iterable)affectedSources, arg_0 -> ((NodeSourcePathMapper)pathMapper).toPath(arg_0)));
            }
            graph.integrate(diffResult);
            for (Path deletedRoot : deletedRoots) {
                libraryRoots.remove(deletedRoot);
            }
            boolean bl = diffResult.isIncremental();
            return bl;
        }
        catch (Throwable e) {
            errorsDetected = true;
            for (Path path : updatedRoots) {
                libraryRoots.remove(path);
            }
            throw e;
        }
        finally {
            if (!errorsDetected) {
                LibraryDependenciesUpdater.getProcessedTargets(context).addAll(chunkTargets);
            }
            this.myTotalTimeNano += System.nanoTime() - start;
            if (LOG.isDebugEnabled()) {
                LOG.debug("LibraryDependencyUpdater took " + TimeUnit.NANOSECONDS.toSeconds(this.myTotalTimeNano) + " seconds so far");
            }
        }
    }

    private static Set<BuildTarget<?>> getProcessedTargets(CompileContext context) {
        return PROCESSED_TARGETS_KEY.getOrCreate(context, () -> new HashSet());
    }

    private static Predicate<? super NodeSource> excludedFrom(Set<? extends BuildTarget<?>> targets, CompileContext context, NodeSourcePathMapper pathMapper) {
        return s -> {
            BuildTarget<?> fileTarget = LibraryDependenciesUpdater.getFileTarget(context, pathMapper.toPath(s));
            return fileTarget != null && !targets.contains(fileTarget);
        };
    }

    private static Predicate<? super NodeSource> includedIn(Set<? extends BuildTarget<?>> targets, CompileContext context, NodeSourcePathMapper pathMapper) {
        return s -> {
            BuildTarget<?> fileTarget = LibraryDependenciesUpdater.getFileTarget(context, pathMapper.toPath(s));
            return fileTarget != null && targets.contains(fileTarget);
        };
    }

    @Nullable
    private static BuildTarget<?> getFileTarget(CompileContext context, Path path) {
        JavaSourceRootDescriptor rd = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, path.toFile());
        return rd != null ? rd.target : null;
    }

    private static void markAffectedFilesDirty(CompileContext context, ModuleChunk chunk, Iterable<? extends Path> affectedFiles) throws IOException {
        if (Iterators.isEmpty(affectedFiles)) {
            return;
        }
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        BuildRootIndex buildRootIndex = projectDescriptor.getBuildRootIndex();
        JavaModuleIndex moduleIndex = JpsJavaExtensionService.getInstance().getJavaModuleIndex(projectDescriptor.getProject());
        SmartHashSet targetsToMark = new SmartHashSet();
        for (Path path : affectedFiles) {
            if (MODULE_INFO_FILE.equals(path.getFileName().toString())) {
                ModuleBuildTarget target;
                File asFile = path.toFile();
                JavaSourceRootDescriptor rootDescr = buildRootIndex.findJavaRootDescriptor(context, asFile);
                if (rootDescr == null || !FileUtil.filesEqual((File)moduleIndex.getModuleInfoFile((target = rootDescr.getTarget()).getModule(), target.isTests()), (File)asFile)) continue;
                targetsToMark.add(target);
                continue;
            }
            FSOperations.markDirtyIfNotDeleted(context, CompilationRound.CURRENT, path);
        }
        if (Iterators.find(chunk.getTargets(), ((Set)targetsToMark)::contains) != null) {
            targetsToMark.addAll(chunk.getTargets());
        }
        for (ModuleBuildTarget moduleBuildTarget : targetsToMark) {
            context.markNonIncremental(moduleBuildTarget);
            FSOperations.markDirty(context, CompilationRound.CURRENT, moduleBuildTarget, null);
        }
    }

    private static void sendProgress(CompileContext context, @NlsSafe String message) {
        LOG.info(message);
        context.processMessage(new ProgressMessage(message));
    }
}

