/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.ModuleSourceSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.util.Chunk;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class ModuleCompilerUtil {
    private ModuleCompilerUtil() {
    }

    public static Module @NotNull [] getDependencies(Module module) {
        Module[] moduleArray = ModuleRootManager.getInstance((Module)module).getDependencies();
        if (moduleArray == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(0);
        }
        return moduleArray;
    }

    public static @Unmodifiable @NotNull List<Chunk<ModuleSourceSet>> getCyclicDependencies(@NotNull Project project, @NotNull List<? extends Module> modules) {
        if (project == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(1);
        }
        if (modules == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(2);
        }
        List<Chunk<ModuleSourceSet>> chunks = ModuleCompilerUtil.computeSourceSetCycles((ModulesProvider)new DefaultModulesProvider(project));
        HashSet<? extends Module> modulesSet = new HashSet<Module>(modules);
        List list = ContainerUtil.filter(chunks, chunk -> {
            for (ModuleSourceSet sourceSet : chunk.getNodes()) {
                if (!modulesSet.contains(sourceSet.getModule())) continue;
                return true;
            }
            return false;
        });
        if (list == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static Graph<ModuleSourceSet> createModuleSourceDependenciesGraph(final @NotNull RootModelProvider provider) {
        if (provider == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(4);
        }
        Graph graph = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<ModuleSourceSet>(){

            @NotNull
            public Collection<ModuleSourceSet> getNodes() {
                Module[] modules = provider.getModules();
                ArrayList<ModuleSourceSet> result = new ArrayList<ModuleSourceSet>(modules.length * 2);
                for (Module module : modules) {
                    result.add(new ModuleSourceSet(module, ModuleSourceSet.Type.PRODUCTION));
                    result.add(new ModuleSourceSet(module, ModuleSourceSet.Type.TEST));
                }
                ArrayList<ModuleSourceSet> arrayList = result;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            @NotNull
            public Iterator<ModuleSourceSet> getIn(ModuleSourceSet n) {
                ModuleRootModel model = provider.getRootModel(n.getModule());
                OrderEnumerator enumerator = model.orderEntries().compileOnly();
                if (n.getType() == ModuleSourceSet.Type.PRODUCTION) {
                    enumerator = enumerator.productionOnly();
                }
                ArrayList<ModuleSourceSet> deps = new ArrayList<ModuleSourceSet>();
                enumerator.forEachModule(module -> {
                    deps.add(new ModuleSourceSet((Module)module, n.getType()));
                    return true;
                });
                if (n.getType() == ModuleSourceSet.Type.TEST) {
                    deps.add(new ModuleSourceSet(n.getModule(), ModuleSourceSet.Type.PRODUCTION));
                }
                Iterator<ModuleSourceSet> iterator = deps.iterator();
                if (iterator == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/compiler/ModuleCompilerUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }));
        if (graph == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(5);
        }
        return graph;
    }

    public static @Unmodifiable @NotNull List<Chunk<ModuleSourceSet>> computeSourceSetCycles(@NotNull ModulesProvider provider) {
        if (provider == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(6);
        }
        Graph<ModuleSourceSet> graph = ModuleCompilerUtil.createModuleSourceDependenciesGraph((RootModelProvider)provider);
        Collection chunks = GraphAlgorithms.getInstance().computeStronglyConnectedComponents(graph);
        List<Chunk<ModuleSourceSet>> list = ModuleCompilerUtil.removeSingleElementChunks(ModuleCompilerUtil.removeDummyNodes(ModuleCompilerUtil.filterDuplicates(ModuleCompilerUtil.removeSingleElementChunks(chunks)), provider));
        if (list == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static List<Chunk<ModuleSourceSet>> removeDummyNodes(List<? extends Chunk<ModuleSourceSet>> chunks, ModulesProvider modulesProvider) {
        ArrayList<Chunk<ModuleSourceSet>> result = new ArrayList<Chunk<ModuleSourceSet>>(chunks.size());
        for (Chunk<ModuleSourceSet> chunk : chunks) {
            LinkedHashSet<ModuleSourceSet> nodes = new LinkedHashSet<ModuleSourceSet>();
            for (ModuleSourceSet sourceSet : chunk.getNodes()) {
                if (ModuleCompilerUtil.isDummy(sourceSet, modulesProvider)) continue;
                nodes.add(sourceSet);
            }
            result.add((Chunk<ModuleSourceSet>)new Chunk(nodes));
        }
        return result;
    }

    private static boolean isDummy(ModuleSourceSet set, ModulesProvider modulesProvider) {
        JavaSourceRootType type = set.getType().isTest() ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        ModuleRootModel rootModel = modulesProvider.getRootModel(set.getModule());
        for (ContentEntry entry : rootModel.getContentEntries()) {
            if (entry.getSourceFolders((JpsModuleSourceRootType)type).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static @Unmodifiable List<Chunk<ModuleSourceSet>> removeSingleElementChunks(Collection<? extends Chunk<ModuleSourceSet>> chunks) {
        return ContainerUtil.filter(chunks, chunk -> chunk.getNodes().size() > 1);
    }

    private static @Unmodifiable @NotNull List<Chunk<ModuleSourceSet>> filterDuplicates(@NotNull Collection<? extends Chunk<ModuleSourceSet>> sourceSetCycles) {
        if (sourceSetCycles == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(8);
        }
        ArrayList<Set<Module>> productionCycles = new ArrayList<Set<Module>>();
        for (Chunk<ModuleSourceSet> chunk2 : sourceSetCycles) {
            ModuleSourceSet.Type type = ModuleCompilerUtil.getCommonType(chunk2);
            if (type != ModuleSourceSet.Type.PRODUCTION) continue;
            productionCycles.add(ModuleSourceSet.getModules(chunk2.getNodes()));
        }
        List list = ContainerUtil.filter(sourceSetCycles, chunk -> {
            if (ModuleCompilerUtil.getCommonType((Chunk<? extends ModuleSourceSet>)chunk) != ModuleSourceSet.Type.TEST) {
                return true;
            }
            for (Set productionCycle : productionCycles) {
                if (!productionCycle.containsAll(ModuleSourceSet.getModules(chunk.getNodes()))) continue;
                return false;
            }
            return true;
        });
        if (list == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    private static ModuleSourceSet.Type getCommonType(@NotNull Chunk<? extends ModuleSourceSet> cycle) {
        if (cycle == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(10);
        }
        ModuleSourceSet.Type type = null;
        for (ModuleSourceSet set : cycle.getNodes()) {
            if (type == null) {
                type = set.getType();
                continue;
            }
            if (type == set.getType()) continue;
            return null;
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 6, 8, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/ModuleCompilerUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetCycles";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cycle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/ModuleCompilerUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCyclicDependencies";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleSourceDependenciesGraph";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSourceSetCycles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDuplicates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCyclicDependencies";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModuleSourceDependenciesGraph";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeSourceSetCycles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterDuplicates";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCommonType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 6, 8, 10 -> new IllegalArgumentException(string);
        };
    }
}

