/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationWithAlternativeJre;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.JavaSyntheticLibrary;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class AlternativeSdkRootsProvider
extends AdditionalLibraryRootsProvider {
    private static final Key<Collection<SyntheticLibrary>> ALTERNATIVE_SDK_LIBS_KEY = Key.create((String)"ALTERNATIVE_SDK_LIBS_KEY");

    public @Unmodifiable @NotNull Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        if (project == null) {
            AlternativeSdkRootsProvider.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.map(AlternativeSdkRootsProvider.getAdditionalProjectJdksToIndex(project), AlternativeSdkRootsProvider::createSdkLibrary);
        if (list == null) {
            AlternativeSdkRootsProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    private static JavaSyntheticLibrary createSdkLibrary(@NotNull Sdk sdk) {
        if (sdk == null) {
            AlternativeSdkRootsProvider.$$$reportNull$$$0(2);
        }
        return new JavaSyntheticLibrary(sdk.getName(), Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.SOURCES)), Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.CLASSES)), Collections.emptySet());
    }

    public static boolean shouldIndexAlternativeJre() {
        return Registry.is((String)"index.run.configuration.jre");
    }

    public static boolean hasEnabledAlternativeJre(@NotNull RunnerAndConfigurationSettings settings) {
        ConfigurationWithAlternativeJre jreConf;
        RunConfiguration runConfiguration;
        if (settings == null) {
            AlternativeSdkRootsProvider.$$$reportNull$$$0(3);
        }
        return (runConfiguration = settings.getConfiguration()) instanceof ConfigurationWithAlternativeJre && (jreConf = (ConfigurationWithAlternativeJre)runConfiguration).isAlternativeJrePathEnabled();
    }

    @NotNull
    public static List<Sdk> getAdditionalProjectJdksToIndex(@NotNull Project project) {
        if (project == null) {
            AlternativeSdkRootsProvider.$$$reportNull$$$0(4);
        }
        if (AlternativeSdkRootsProvider.shouldIndexAlternativeJre()) {
            return AlternativeSdkRootsProvider.getAdditionalProjectJdks(project);
        }
        List<Sdk> list = Collections.emptyList();
        if (list == null) {
            AlternativeSdkRootsProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static List<Sdk> getAdditionalProjectJdks(@NotNull Project project) {
        if (project == null) {
            AlternativeSdkRootsProvider.$$$reportNull$$$0(6);
        }
        List<Sdk> list = RunManager.getInstance((Project)project).getAllConfigurationsList().stream().map(conf -> {
            ConfigurationWithAlternativeJre jreConf;
            return conf instanceof ConfigurationWithAlternativeJre && (jreConf = (ConfigurationWithAlternativeJre)conf).isAlternativeJrePathEnabled() ? jreConf.getAlternativeJrePath() : null;
        }).filter(Objects::nonNull).map(arg_0 -> ((ProjectJdkTable)ProjectJdkTable.getInstance((Project)project)).findJdk(arg_0)).filter(Objects::nonNull).distinct().toList();
        if (list == null) {
            AlternativeSdkRootsProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reindexIfNeeded(@NotNull Project project) {
        boolean update;
        if (project == null) {
            AlternativeSdkRootsProvider.$$$reportNull$$$0(8);
        }
        if (!Registry.is((String)"index.run.configuration.jre")) {
            return;
        }
        AlternativeSdkRootsProvider provider = Objects.requireNonNull((AlternativeSdkRootsProvider)((Object)EP_NAME.findExtension(AlternativeSdkRootsProvider.class)));
        Collection<SyntheticLibrary> additionalProjectLibraries = provider.getAdditionalProjectLibraries(project);
        Key<Collection<SyntheticLibrary>> key = ALTERNATIVE_SDK_LIBS_KEY;
        synchronized (key) {
            boolean res;
            boolean bl = res = additionalProjectLibraries != project.getUserData(ALTERNATIVE_SDK_LIBS_KEY);
            if (res) {
                project.putUserData(ALTERNATIVE_SDK_LIBS_KEY, additionalProjectLibraries);
            }
            update = res;
        }
        if (update) {
            AppUIUtil.invokeOnEdt(() -> WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)project).makeRootsChange(EmptyRunnable.getInstance(), RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/AlternativeSdkRootsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/AlternativeSdkRootsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProjectLibraries";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProjectJdksToIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProjectJdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProjectLibraries";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createSdkLibrary";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasEnabledAlternativeJre";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProjectJdksToIndex";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProjectJdks";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reindexIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 7 -> new IllegalStateException(string);
        };
    }
}

