/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.java.codeserver.core.JavaPsiSingleFileSourceUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractApplicationConfigurationProducer<T extends ApplicationConfiguration>
extends JavaRunConfigurationProducerBase<T> {
    protected boolean setupConfigurationFromContext(@NotNull T configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Location contextLocation;
        if (configuration == null) {
            AbstractApplicationConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AbstractApplicationConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            AbstractApplicationConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((contextLocation = context.getLocation()) == null) {
            return false;
        }
        if (contextLocation.getPsiElement() instanceof PsiCompiledElement) {
            return false;
        }
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        if (!element.isPhysical()) {
            return false;
        }
        PsiClass aClass = ApplicationConfigurationType.getMainClass(element);
        if (aClass == null) {
            return false;
        }
        PsiFile containingFile = aClass.getContainingFile();
        if (JavaPsiSingleFileSourceUtil.isJavaHashBangScript((PsiFile)containingFile)) {
            return false;
        }
        PsiMethod method = PsiMethodUtil.findMainInClass((PsiClass)aClass);
        if (method != null && PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)element, (boolean)false)) {
            sourceElement.set((Object)method);
        } else {
            sourceElement.set((Object)aClass);
        }
        this.setupConfiguration(configuration, aClass, context);
        return true;
    }

    private void setupConfiguration(T configuration, PsiClass aClass, ConfigurationContext context) {
        if (aClass instanceof PsiImplicitClass) {
            ((ApplicationConfiguration)configuration).setImplicitClassConfiguration(true);
        }
        ((ApplicationConfiguration)configuration).setMainClassName(aClass.getQualifiedName());
        configuration.setGeneratedName();
        this.setupConfigurationModule(context, configuration);
    }

    public boolean isConfigurationFromContext(@NotNull T appConfiguration, @NotNull ConfigurationContext context) {
        PsiCompiledElement compiledElement;
        Location location;
        if (appConfiguration == null) {
            AbstractApplicationConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            AbstractApplicationConfigurationProducer.$$$reportNull$$$0(4);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        PsiElement psiElement = location.getPsiElement();
        if (psiElement instanceof PsiCompiledElement && (compiledElement = (PsiCompiledElement)psiElement).getCachedMirror() == null) {
            return false;
        }
        Location singleClassLocation = JavaExecutionUtil.stepIntoSingleClass((Location)location);
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)singleClassLocation.getPsiElement(), PsiClass.class, (boolean)false);
        if (aClass != null) {
            String className = aClass.getQualifiedName();
            if (!Objects.equals(className, ((ApplicationConfiguration)appConfiguration).getMainClassName())) {
                return false;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context.getPsiLocation(), PsiMethod.class, (boolean)false);
            if (method != null && TestFrameworks.getInstance().isTestMethod(method)) {
                return false;
            }
            Module configurationModule = ((JavaRunConfigurationModule)appConfiguration.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)context.getModule(), (Object)configurationModule)) {
                return true;
            }
            ApplicationConfiguration template = (ApplicationConfiguration)context.getRunManager().getConfigurationTemplate(this.getConfigurationFactory()).getConfiguration();
            Module predefinedModule = ((JavaRunConfigurationModule)template.getConfigurationModule()).getModule();
            return Comparing.equal((Object)predefinedModule, (Object)configurationModule);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfiguration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/application/AbstractApplicationConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationFromContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

