/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.application.BaseJavaApplicationCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.java.JavaPluginDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.util.ExceptionUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class ApplicationCommandLineState<T extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element> & ConfigurationWithCommandLineShortener>
extends BaseJavaApplicationCommandLineState<T> {
    public ApplicationCommandLineState(@NotNull T configuration, ExecutionEnvironment environment) {
        if (configuration == null) {
            ApplicationCommandLineState.$$$reportNull$$$0(0);
        }
        super(environment, configuration);
    }

    @Override
    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters params = new JavaParameters();
        ModuleBasedConfiguration configuration = (ModuleBasedConfiguration)this.getConfiguration();
        params.setMainClass((String)ReadAction.compute(() -> ((CommonJavaRunConfigurationParameters)((ModuleBasedConfiguration)this.myConfiguration)).getRunClass()));
        String mainClass = params.getMainClass();
        try {
            JavaParametersUtil.configureConfiguration((SimpleJavaParameters)params, (CommonJavaRunConfigurationParameters)this.myConfiguration);
        }
        catch (ProgramParametersConfigurator.ParametersConfiguratorException e) {
            throw new ExecutionException((Throwable)e);
        }
        JavaRunConfigurationModule module = (JavaRunConfigurationModule)((ModuleBasedConfiguration)this.myConfiguration).getConfigurationModule();
        try {
            ReadAction.nonBlocking(() -> {
                String jreHome;
                String string = jreHome = this.getTargetEnvironmentRequest() == null && ((CommonJavaRunConfigurationParameters)((ModuleBasedConfiguration)this.myConfiguration)).isAlternativeJrePathEnabled() ? ((CommonJavaRunConfigurationParameters)((ModuleBasedConfiguration)this.myConfiguration)).getAlternativeJrePath() : null;
                if (module.getModule() != null) {
                    DumbService.getInstance((Project)module.getProject()).runWithAlternativeResolveEnabled(() -> {
                        if (mainClass == null) {
                            throw new CantRunException(ExecutionBundle.message((String)"no.main.class.defined.error.message", (Object[])new Object[0]));
                        }
                        int classPathType = JavaParametersUtil.getClasspathType((RunConfigurationModule)module, mainClass, false, this.isProvidedScopeIncluded());
                        JavaParametersUtil.configureModule((RunConfigurationModule)module, params, classPathType, jreHome);
                    });
                } else {
                    JavaParametersUtil.configureProject(module.getProject(), params, 7, jreHome);
                }
                return null;
            }).expireWith((Disposable)JavaPluginDisposable.getInstance((Project)configuration.getProject())).executeSynchronously();
        }
        catch (Exception e) {
            ExecutionException executionException = (ExecutionException)((Object)ExceptionUtil.findCause((Throwable)e, ExecutionException.class));
            if (executionException != null) {
                throw executionException;
            }
            throw e;
        }
        ApplicationCommandLineState.setupModulePath(params, module);
        params.setShortenCommandLine(((ConfigurationWithCommandLineShortener)configuration).getShortenCommandLine(), configuration.getProject());
        this.setupJavaParameters(params);
        return params;
    }

    @Override
    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        OSProcessHandler processHandler = super.startProcess();
        if (processHandler instanceof KillableProcessHandler && DebuggerSettings.getInstance().KILL_PROCESS_IMMEDIATELY) {
            ((KillableProcessHandler)processHandler).setShouldKillProcessSoftly(false);
        }
        OSProcessHandler oSProcessHandler = processHandler;
        if (oSProcessHandler == null) {
            ApplicationCommandLineState.$$$reportNull$$$0(1);
        }
        return oSProcessHandler;
    }

    private static void setupModulePath(JavaParameters params, JavaRunConfigurationModule module) {
        DumbService dumbService;
        PsiJavaModule mainModule;
        if (JavaSdkUtil.isJdkAtLeast((Sdk)params.getJdk(), (JavaSdkVersion)JavaSdkVersion.JDK_1_9) && (mainModule = (PsiJavaModule)ReadAction.compute(() -> ApplicationCommandLineState.lambda$setupModulePath$4(dumbService = DumbService.getInstance((Project)module.getProject()), module, params))) != null) {
            boolean inLibrary;
            boolean bl = inLibrary = mainModule instanceof PsiCompiledElement || mainModule instanceof LightJavaModule;
            if (!inLibrary || ReadAction.compute(() -> JavaModuleGraphUtil.findNonAutomaticDescriptorByModule((Module)module.getModule(), (boolean)false)) != null) {
                boolean isExcluded;
                boolean bl2 = isExcluded = !(mainModule instanceof LightJavaModule) && CompilerConfiguration.getInstance((Project)module.getProject()).isExcludedFromCompilation(mainModule.getContainingFile().getVirtualFile());
                if (!isExcluded) {
                    params.setModuleName((String)ReadAction.compute(() -> mainModule.getName()));
                    dumbService.runReadActionInSmartMode(() -> JavaParametersUtil.putDependenciesOnModulePath(params, mainModule, false));
                }
            }
        }
    }

    protected abstract boolean isProvidedScopeIncluded();

    private static /* synthetic */ PsiJavaModule lambda$setupModulePath$4(DumbService dumbService, JavaRunConfigurationModule module, JavaParameters params) throws RuntimeException {
        return (PsiJavaModule)dumbService.computeWithAlternativeResolveEnabled(() -> JavaModuleGraphUtil.findDescriptorByElement((PsiElement)module.findClass(params.getMainClass())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/application/ApplicationCommandLineState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/application/ApplicationCommandLineState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

