/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.ArgumentFileFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.JdkUtil;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJavaApplicationCommandLineState<T extends RunConfigurationBase>
extends JavaCommandLineState {
    @NotNull
    protected final T myConfiguration;

    public BaseJavaApplicationCommandLineState(ExecutionEnvironment environment, @NotNull T configuration) {
        if (configuration == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(0);
        }
        super(environment);
        this.myConfiguration = configuration;
    }

    protected void setupJavaParameters(@NotNull JavaParameters params) throws ExecutionException {
        if (params == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(1);
        }
        ReadAction.run(() -> JavaRunConfigurationExtensionManager.getInstance().updateJavaParameters(this.getConfiguration(), params, this.getRunnerSettings(), this.getEnvironment().getExecutor()));
    }

    @Override
    public void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest request, @NotNull TargetProgressIndicator targetProgressIndicator) throws ExecutionException {
        if (request == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(2);
        }
        if (targetProgressIndicator == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(3);
        }
        if (this.myConfiguration.getProjectPathOnTarget() != null) {
            request.setProjectPathOnTarget(this.myConfiguration.getProjectPathOnTarget());
        }
        super.prepareTargetEnvironmentRequest(request, targetProgressIndicator);
    }

    @Override
    @NotNull
    protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request) throws ExecutionException {
        if (request == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(4);
        }
        TargetedCommandLineBuilder line = super.createTargetedCommandLine(request);
        File inputFile = InputRedirectAware.getInputFile(this.myConfiguration);
        if (inputFile != null) {
            line.setInputFile(request.getDefaultVolume().createUpload(inputFile.getAbsolutePath()));
        }
        TargetedCommandLineBuilder targetedCommandLineBuilder = line;
        if (targetedCommandLineBuilder == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(5);
        }
        return targetedCommandLineBuilder;
    }

    @Nullable
    protected ConsoleView createConsole(@NotNull Executor executor) throws ExecutionException {
        ConsoleView console;
        if (executor == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(6);
        }
        if ((console = super.createConsole(executor)) == null) {
            return null;
        }
        return JavaRunConfigurationExtensionManager.getInstance().decorateExecutionConsole(this.getConfiguration(), this.getRunnerSettings(), console, executor);
    }

    @Override
    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        TargetEnvironment remoteEnvironment = this.getEnvironment().getPreparedTargetEnvironment((RunProfileState)this, TargetProgressIndicator.EMPTY);
        TargetedCommandLineBuilder targetedCommandLineBuilder = this.getTargetedCommandLine();
        TargetedCommandLine targetedCommandLine = targetedCommandLineBuilder.build();
        Process process = remoteEnvironment.createProcess(targetedCommandLine, (ProgressIndicator)new EmptyProgressIndicator());
        Map content = (Map)targetedCommandLineBuilder.getUserData(JdkUtil.COMMAND_LINE_CONTENT);
        if (content != null) {
            content.forEach((key, value) -> this.addConsoleFilters(new Filter[]{new ArgumentFileFilter(key, value)}));
        }
        OSProcessHandler handler = this.createProcessHandler(remoteEnvironment, targetedCommandLineBuilder, targetedCommandLine, process);
        ProcessTerminatedListener.attach((ProcessHandler)handler);
        JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.getConfiguration(), (ProcessHandler)handler, this.getRunnerSettings());
        OSProcessHandler oSProcessHandler = handler;
        if (oSProcessHandler == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(7);
        }
        return oSProcessHandler;
    }

    @NotNull
    protected OSProcessHandler createProcessHandler(TargetEnvironment remoteEnvironment, TargetedCommandLineBuilder targetedCommandLineBuilder, TargetedCommandLine targetedCommandLine, Process process) throws ExecutionException {
        return new KillableColoredProcessHandler.Silent(process, targetedCommandLine.getCommandPresentation(remoteEnvironment), targetedCommandLine.getCharset(), targetedCommandLineBuilder.getFilesToDeleteOnTermination());
    }

    @NotNull
    protected T getConfiguration() {
        T t = this.myConfiguration;
        if (t == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(8);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProgressIndicator";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/application/BaseJavaApplicationCommandLineState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/application/BaseJavaApplicationCommandLineState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetedCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupJavaParameters";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareTargetEnvironmentRequest";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTargetedCommandLine";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

