/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.codeInspection;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.Location;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.execution.testframework.JavaTestLocator;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.ClassUtil;
import com.intellij.testIntegration.TestFailedLineManager;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0003$%&B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\rH\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0086\u0001\u0010\n\u001az\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f\u0012$\u0012\"\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e \t*\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000b0\u000b \t*;\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f\u0012$\u0012\"\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e \t*\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000b0\u000b0\u0010\u00a2\u0006\u0002\b\u000f0\u000b\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/execution/codeInspection/TestFailedLineManagerImpl;", "Lcom/intellij/testIntegration/TestFailedLineManager;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "testStorage", "Lcom/intellij/execution/TestStateStorage;", "kotlin.jvm.PlatformType", "cache", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lcom/intellij/execution/codeInspection/TestFailedLineManagerImpl$TestInfoCache;", "Lorg/jetbrains/annotations/NotNull;", "", "fileClosed", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "getTestInfo", "Lcom/intellij/testIntegration/TestFailedLineManager$TestInfo;", "element", "Lcom/intellij/psi/PsiElement;", "matchesJvmName", "", "jvmName", "sourceName", "method", "Lorg/jetbrains/uast/UMethod;", "getRunQuickFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "getDebugQuickFix", "topStacktraceLine", "TestInfoCache", "RunActionFix", "DebugActionFix", "intellij.java.execution.impl"})
@SourceDebugExtension(value={"SMAP\nTestFailedLineManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestFailedLineManagerImpl.kt\ncom/intellij/execution/codeInspection/TestFailedLineManagerImpl\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n221#2,2:163\n176#3:165\n1807#4,3:166\n*S KotlinDebug\n*F\n+ 1 TestFailedLineManagerImpl.kt\ncom/intellij/execution/codeInspection/TestFailedLineManagerImpl\n*L\n54#1:163,2\n58#1:165\n79#1:166,3\n*E\n"})
public final class TestFailedLineManagerImpl
implements TestFailedLineManager,
FileEditorManagerListener {
    private final TestStateStorage testStorage;
    @NotNull
    private final Map<VirtualFile, Map<String, TestInfoCache>> cache;

    public TestFailedLineManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.testStorage = TestStateStorage.getInstance((Project)project);
        Map map = FactoryMap.create(arg_0 -> TestFailedLineManagerImpl.cache$lambda$1(TestFailedLineManagerImpl::cache$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"create(...)");
        this.cache = map;
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)this);
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Map<String, TestInfoCache> map = this.cache.remove(file);
            if (map == null) break block1;
            Map<String, TestInfoCache> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, TestInfoCache>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, TestInfoCache> element$iv;
                Map.Entry<String, TestInfoCache> entry = element$iv = iterator.next();
                boolean bl = false;
                String s = entry.getKey();
                TestInfoCache info = entry.getValue();
                this.testStorage.writeState(s, info.getRecord());
            }
        }
    }

    @Nullable
    public TestFailedLineManager.TestInfo getTestInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$toUElementOfType$iv = element;
        boolean $i$f$toUElementOfType = false;
        UCallExpression uCallExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UCallExpression.class);
        if (uCallExpression == null) {
            return null;
        }
        UCallExpression call = uCallExpression;
        UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)call));
        if (uMethod == null) {
            return null;
        }
        UMethod containingMethod = uMethod;
        PsiElement psiElement = call.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement callSourcePsi = psiElement;
        UFile uFile = UastUtils.getContainingUFile((UElement)((UElement)call));
        if (uFile == null || (uFile = uFile.getSourcePsi()) == null) {
            return null;
        }
        UFile file = uFile;
        TestInfoCache testInfoCache = this.getTestInfo(containingMethod);
        if (testInfoCache == null) {
            return null;
        }
        TestInfoCache info = testInfoCache;
        Document document = PsiDocumentManager.getInstance((Project)callSourcePsi.getProject()).getDocument((PsiFile)file);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        PsiElement psiElement2 = info.getPointer();
        if (psiElement2 != null && (psiElement2 = psiElement2.getElement()) != null) {
            PsiElement pointerElem = psiElement2;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)callSourcePsi, (Object)pointerElem)) {
                info.getRecord().failedLine = document2.getLineNumber(callSourcePsi.getTextOffset()) + 1;
                return info;
            }
        }
        if (info.getRecord().failedLine == -1 || StringUtil.isEmpty((String)info.getRecord().failedMethod)) {
            return null;
        }
        TextRange textRange = callSourcePsi.getTextRange();
        IntRange lineRange = new IntRange(document2.getLineNumber(textRange.getStartOffset()), document2.getLineNumber(textRange.getEndOffset()));
        int n = lineRange.getFirst();
        int n2 = lineRange.getLast();
        int n3 = info.getRecord().failedLine - 1;
        if (!(n <= n3 ? n3 <= n2 : false)) {
            return null;
        }
        String string = info.getRecord().failedMethod;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"failedMethod");
        if (!this.matchesJvmName(string, call.getMethodName())) {
            return null;
        }
        info.setPointer((SmartPsiElementPointer<PsiElement>)SmartPointerManager.createPointer((PsiElement)callSourcePsi));
        return info.getRecord().magnitude <= TestStateInfo.Magnitude.IGNORED_INDEX.getValue() ? null : (TestFailedLineManager.TestInfo)info;
    }

    private final boolean matchesJvmName(String jvmName, String sourceName) {
        boolean bl;
        block3: {
            String[] stringArray = new String[]{"$"};
            Iterable $this$any$iv = StringsKt.split$default((CharSequence)jvmName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)sourceName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final TestInfoCache getTestInfo(UMethod method) {
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)method));
        if (uClass == null) {
            return null;
        }
        UClass containingClass = uClass;
        PsiClass javaClazz = containingClass.getJavaPsi();
        TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)javaClazz);
        if (testFramework == null) {
            return null;
        }
        TestFramework framework = testFramework;
        if (!framework.isTestMethod((PsiElement)method.getJavaPsi(), false)) {
            return null;
        }
        String string = ClassUtil.getJVMClassName((PsiClass)javaClazz);
        if (string == null) {
            return null;
        }
        String className = string;
        String string2 = JavaTestLocator.createLocationUrl("java:test", className, method.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"createLocationUrl(...)");
        String url = string2;
        TestStateStorage.Record record = this.testStorage.getState(url);
        if (record == null) {
            return null;
        }
        TestStateStorage.Record state = record;
        UFile uFile = UastUtils.getContainingUFile((UElement)((UElement)method));
        if (uFile == null || (uFile = uFile.getSourcePsi()) == null || (uFile = uFile.getVirtualFile()) == null) {
            return null;
        }
        UFile vFile = uFile;
        Map<String, TestInfoCache> map = this.cache.get(vFile);
        if (map == null) {
            return null;
        }
        Map<String, TestInfoCache> infoInFile = map;
        TestInfoCache info = infoInFile.get(url);
        if (info == null || !Intrinsics.areEqual((Object)state.date, (Object)info.getRecord().date)) {
            info = new TestInfoCache(state, null, 2, null);
            infoInFile.put(url, info);
        }
        return info;
    }

    @Nullable
    public LocalQuickFix getRunQuickFix(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = new ConfigurationContext(element).getConfiguration();
        if (runnerAndConfigurationSettings == null) {
            return null;
        }
        RunnerAndConfigurationSettings configuration = runnerAndConfigurationSettings;
        return new RunActionFix("Run", configuration);
    }

    @Nullable
    public LocalQuickFix getDebugQuickFix(@NotNull PsiElement element, @NotNull String topStacktraceLine) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)topStacktraceLine, (String)"topStacktraceLine");
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = new ConfigurationContext(element).getConfiguration();
        if (runnerAndConfigurationSettings == null) {
            return null;
        }
        RunnerAndConfigurationSettings configuration = runnerAndConfigurationSettings;
        return new DebugActionFix(topStacktraceLine, "Debug", configuration);
    }

    private static final Map cache$lambda$0(VirtualFile it) {
        return new HashMap();
    }

    private static final Map cache$lambda$1(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/execution/codeInspection/TestFailedLineManagerImpl$DebugActionFix;", "Lcom/intellij/execution/codeInspection/TestFailedLineManagerImpl$RunActionFix;", "topStacktraceLine", "", "executorId", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/execution/RunnerAndConfigurationSettings;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "intellij.java.execution.impl"})
    private static final class DebugActionFix
    extends RunActionFix {
        @NotNull
        private final String topStacktraceLine;

        public DebugActionFix(@NotNull String topStacktraceLine, @NotNull String executorId, @NotNull RunnerAndConfigurationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)topStacktraceLine, (String)"topStacktraceLine");
            Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            super(executorId, settings);
            this.topStacktraceLine = topStacktraceLine;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            StackTraceLine line = new StackTraceLine(project, this.topStacktraceLine);
            Location<PsiMethod> location = line.getMethodLocation(project);
            if (location != null) {
                Location<PsiMethod> location2 = location;
                boolean bl = false;
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(((PsiMethod)location2.getPsiElement()).getContainingFile());
                if (document != null) {
                    Document document2 = document;
                    boolean bl2 = false;
                    DebuggerManagerEx.getInstanceEx((Project)project).getBreakpointManager().addLineBreakpoint(document2, line.getLineNumber());
                }
            }
            super.applyFix(project, descriptor);
        }

        @Override
        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
            return (IntentionPreviewInfo)new IntentionPreviewInfo.Html(ExecutionBundle.message((String)"test.failed.line.debug.preview", (Object[])new Object[0]));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0012\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000e\u001a\u00130\u0004\u00a2\u0006\u000e\b\u000f\u0012\n\b\u0010\u0012\u0006\b\n0\u00118\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0018H\u0016R\u0016\u0010\u0005\u001a\u00020\u00068\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/execution/codeInspection/TestFailedLineManagerImpl$RunActionFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/openapi/util/Iconable;", "executorId", "", "configuration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "<init>", "(Ljava/lang/String;Lcom/intellij/execution/RunnerAndConfigurationSettings;)V", "getConfiguration", "()Lcom/intellij/execution/RunnerAndConfigurationSettings;", "executor", "Lcom/intellij/execution/Executor;", "Lorg/jetbrains/annotations/Nullable;", "getFamilyName", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Sentence", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getIcon", "Ljavax/swing/Icon;", "flags", "", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "intellij.java.execution.impl"})
    private static class RunActionFix
    implements LocalQuickFix,
    Iconable {
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final RunnerAndConfigurationSettings configuration;
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final Executor executor;

        public RunActionFix(@NotNull String executorId, @NotNull RunnerAndConfigurationSettings configuration) {
            Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            this.configuration = configuration;
            Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
            if (executor == null) {
                throw new IllegalStateException("Could not create action because executor " + executorId + " was not found");
            }
            this.executor = executor;
        }

        @NotNull
        protected final RunnerAndConfigurationSettings getConfiguration() {
            return this.configuration;
        }

        @NotNull
        public String getFamilyName() {
            String string = UIUtil.removeMnemonic((String)this.executor.getStartActionText(this.configuration.getName()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeMnemonic(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)this.configuration, (Executor)this.executor);
        }

        @NotNull
        public Icon getIcon(int flags) {
            Icon icon = this.executor.getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
            return icon;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
            return (IntentionPreviewInfo)new IntentionPreviewInfo.Html(ExecutionBundle.message((String)"test.failed.line.run.preview", (Object[])new Object[0]));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\"\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/intellij/execution/codeInspection/TestFailedLineManagerImpl$TestInfoCache;", "Lcom/intellij/testIntegration/TestFailedLineManager$TestInfo;", "record", "Lcom/intellij/execution/TestStateStorage$Record;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/execution/TestStateStorage$Record;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getRecord", "()Lcom/intellij/execution/TestStateStorage$Record;", "setRecord", "(Lcom/intellij/execution/TestStateStorage$Record;)V", "getPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "setPointer", "(Lcom/intellij/psi/SmartPsiElementPointer;)V", "getMagnitude", "", "getErrorMessage", "", "getTopStackTraceLine", "intellij.java.execution.impl"})
    private static final class TestInfoCache
    implements TestFailedLineManager.TestInfo {
        @NotNull
        private TestStateStorage.Record record;
        @Nullable
        private SmartPsiElementPointer<PsiElement> pointer;

        public TestInfoCache(@NotNull TestStateStorage.Record record, @Nullable SmartPsiElementPointer<PsiElement> pointer) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            this.record = record;
            this.pointer = pointer;
        }

        public /* synthetic */ TestInfoCache(TestStateStorage.Record record, SmartPsiElementPointer smartPsiElementPointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                smartPsiElementPointer = null;
            }
            this(record, (SmartPsiElementPointer<PsiElement>)smartPsiElementPointer);
        }

        @NotNull
        public final TestStateStorage.Record getRecord() {
            return this.record;
        }

        public final void setRecord(@NotNull TestStateStorage.Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"<set-?>");
            this.record = record;
        }

        @Nullable
        public final SmartPsiElementPointer<PsiElement> getPointer() {
            return this.pointer;
        }

        public final void setPointer(@Nullable SmartPsiElementPointer<PsiElement> smartPsiElementPointer) {
            this.pointer = smartPsiElementPointer;
        }

        public int getMagnitude() {
            return this.record.magnitude;
        }

        @NotNull
        public String getErrorMessage() {
            String string = this.record.errorMessage;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"errorMessage");
            return string;
        }

        @NotNull
        public String getTopStackTraceLine() {
            String string = this.record.topStacktraceLine;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"topStacktraceLine");
            return string;
        }
    }
}

