/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.attach.JavaDebuggerAttachUtil;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ThreadDumpProvider;
import com.intellij.execution.impl.statistics.ProgramRunnerUsageCollector;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.JavaProgramPatcher;
import com.intellij.execution.runners.JvmPatchableProgramRunner;
import com.intellij.execution.runners.PreferredPlace;
import com.intellij.execution.runners.ProcessProxy;
import com.intellij.execution.runners.ProcessProxyFactory;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.runners.RunTab;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.threadDumpParser.ThreadDumpParser;
import com.intellij.threadDumpParser.ThreadState;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.unscramble.ThreadDumpConsoleFactory;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class DefaultJavaProgramRunner
implements JvmPatchableProgramRunner<RunnerSettings> {
    private static final Logger LOG = Logger.getInstance(DefaultJavaProgramRunner.class);
    private static final String ourWiseThreadDumpProperty = "idea.java.run.wise.thread.dump";
    public static final String DEFAULT_JAVA_RUNNER_ID = "Run";

    public static ProgramRunner<?> getInstance() {
        return ProgramRunner.findRunnerById((String)DEFAULT_JAVA_RUNNER_ID);
    }

    @NotNull
    public String getRunnerId() {
        return DEFAULT_JAVA_RUNNER_ID;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(1);
        }
        return executorId.equals(DEFAULT_JAVA_RUNNER_ID) && profile instanceof ModuleRunProfile && !(profile instanceof RunConfigurationWithSuppressedDefaultRunAction);
    }

    public void execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
        RunProfileState currentState;
        if (environment == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(2);
        }
        if ((currentState = environment.getState()) == null) {
            return;
        }
        Project project = environment.getProject();
        ExecutionManager executionManager = ExecutionManager.getInstance((Project)project);
        RunProfile runProfile = environment.getRunProfile();
        StructuredIdeActivity activity = ProgramRunnerUsageCollector.INSTANCE.startExecute(project, (ProgramRunner)this, runProfile);
        if (runProfile instanceof TargetEnvironmentAwareRunProfile && currentState instanceof TargetEnvironmentAwareRunProfileState) {
            executionManager.startRunProfileWithPromise(environment, currentState, ignored -> this.doExecuteAsync((TargetEnvironmentAwareRunProfileState)currentState, environment).onSuccess(descr -> ProgramRunnerUsageCollector.INSTANCE.finishExecute(activity, (ProgramRunner)this, runProfile, true)));
        } else {
            executionManager.startRunProfile(environment, currentState, ignored -> this.doExecute(currentState, environment));
            ProgramRunnerUsageCollector.INSTANCE.finishExecute(activity, (ProgramRunner)this, runProfile, false);
        }
    }

    public void patch(@NotNull JavaParameters javaParameters, @Nullable RunnerSettings settings, @NotNull RunProfile runProfile, boolean beforeExecution) {
        if (javaParameters == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(3);
        }
        if (runProfile == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(4);
        }
        JavaProgramPatcher.runCustomPatchers((JavaParameters)javaParameters, (Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunProfile)runProfile);
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(5);
        }
        if (env == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(6);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ProcessProxy proxy = null;
        if (state instanceof JavaCommandLine) {
            if (!JavaProgramPatcher.patchJavaCommandLineParamsUnderProgress((Project)env.getProject(), () -> this.patchJavaCommandLineParams((JavaCommandLine)state, env))) {
                return null;
            }
            proxy = ProcessProxyFactory.getInstance().createCommandLineProxy((JavaCommandLine)state);
        }
        return this.executeJavaState(state, env, proxy);
    }

    private void patchJavaCommandLineParams(@NotNull JavaCommandLine state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        ParametersList parametersList;
        if (state == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(7);
        }
        if (env == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(8);
        }
        JavaParameters parameters = state.getJavaParameters();
        this.patch(parameters, env.getRunnerSettings(), env.getRunProfile(), true);
        if (Registry.is((String)"execution.java.always.debug") && DebuggerSettings.getInstance().ALWAYS_DEBUG && !ContainerUtil.exists((Iterable)(parametersList = parameters.getVMParametersList()).getList(), s -> s.startsWith("-agentlib:jdwp"))) {
            parametersList.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,quiet=y");
        }
    }

    protected @NotNull Promise<@Nullable RunContentDescriptor> doExecuteAsync(@NotNull TargetEnvironmentAwareRunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        boolean isLocal;
        if (state == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(9);
        }
        if (env == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(10);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        boolean bl = isLocal = !((TargetEnvironmentAwareRunProfile)env.getRunProfile()).needPrepareTarget();
        if (!isLocal && !DefaultJavaProgramRunner.isExecutorSupportedOnTarget(env)) {
            throw new ExecutionException(ExecutionBundle.message((String)"run.configuration.action.is.supported.for.local.machine.only", (Object[])new Object[]{env.getExecutor().getActionName()}));
        }
        Promise promise = state.prepareTargetToCommandExecution(env, LOG, "Failed to execute java run configuration async", () -> {
            ProcessProxy proxy = null;
            if (state instanceof JavaCommandLine) {
                this.patchJavaCommandLineParams((JavaCommandLine)state, env);
                if (isLocal) {
                    proxy = ProcessProxyFactory.getInstance().createCommandLineProxy((JavaCommandLine)state);
                }
            }
            return this.executeJavaState((RunProfileState)state, env, proxy);
        });
        if (promise == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(11);
        }
        return promise;
    }

    private static boolean isExecutorSupportedOnTarget(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(12);
        }
        Executor executor = env.getExecutor();
        return env.getTargetEnvironmentRequest() instanceof LocalTargetEnvironmentRequest || executor.isSupportedOnTarget();
    }

    @Nullable
    private RunContentDescriptor executeJavaState(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env, final @Nullable ProcessProxy proxy) throws ExecutionException {
        if (state == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(13);
        }
        if (env == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(14);
        }
        ExecutionResult executionResult = state.execute(env.getExecutor(), (ProgramRunner)this);
        if (proxy != null) {
            ProcessHandler handler;
            ProcessHandler processHandler = handler = executionResult != null ? executionResult.getProcessHandler() : null;
            if (handler != null) {
                proxy.attach(handler);
                handler.addProcessListener(new ProcessListener(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        proxy.destroy();
                        handler.removeProcessListener((ProcessListener)this);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/impl/DefaultJavaProgramRunner$1", "processTerminated"));
                    }
                });
            } else {
                proxy.destroy();
            }
        }
        if (executionResult == null) {
            return null;
        }
        AtomicReference result = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            RunContentBuilder contentBuilder = new RunContentBuilder(executionResult, env);
            if (!(state instanceof JavaCommandLineState) || ((JavaCommandLineState)state).shouldAddJavaProgramRunnerActions()) {
                DefaultJavaProgramRunner.addDefaultActions(contentBuilder, executionResult, state instanceof JavaCommandLine);
            }
            result.set(contentBuilder.showRunContent(env.getContentToReuse()));
        });
        return (RunContentDescriptor)result.get();
    }

    private static void addDefaultActions(@NotNull RunContentBuilder contentBuilder, @NotNull ExecutionResult executionResult, boolean isJavaCommandLine) {
        ExecutionConsole executionConsole;
        if (contentBuilder == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(15);
        }
        if (executionResult == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(16);
        }
        final JComponent consoleComponent = (executionConsole = executionResult.getExecutionConsole()) != null ? executionConsole.getComponent() : null;
        final ProcessHandler processHandler = executionResult.getProcessHandler();
        assert (processHandler != null) : executionResult;
        final ControlBreakAction controlBreakAction = new ControlBreakAction();
        if (consoleComponent != null) {
            controlBreakAction.registerCustomShortcutSet(controlBreakAction.getShortcutSet(), consoleComponent);
            processHandler.addProcessListener(new ProcessListener(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    processHandler.removeProcessListener((ProcessListener)this);
                    controlBreakAction.unregisterCustomShortcutSet(consoleComponent);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/impl/DefaultJavaProgramRunner$2", "processTerminated"));
                }
            });
        }
        if (isJavaCommandLine) {
            AttachDebuggerAction.add(contentBuilder, processHandler);
        }
    }

    private static void showThreadDump(String out, List<ThreadState> states, Project project) {
        ThreadDumpConsoleFactory factory = states.size() > 1 ? new ThreadDumpConsoleFactory(project, states) : null;
        String title = JavaCompilerBundle.message((String)"tab.title.thread.dump", (Object[])new Object[]{DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis())});
        ApplicationManager.getApplication().invokeLater(() -> DefaultJavaProgramRunner.lambda$showThreadDump$7(project, (AnalyzeStacktraceUtil.ConsoleFactory)factory, title, out), ModalityState.nonModal());
    }

    private static /* synthetic */ void lambda$showThreadDump$7(Project project, AnalyzeStacktraceUtil.ConsoleFactory factory, String title, String out) {
        AnalyzeStacktraceUtil.addConsole((Project)project, (AnalyzeStacktraceUtil.ConsoleFactory)factory, (String)title, (String)out);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runProfile";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/DefaultJavaProgramRunner";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentBuilder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/DefaultJavaProgramRunner";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doExecuteAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "patch";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "patchJavaCommandLineParams";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doExecuteAsync";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isExecutorSupportedOnTarget";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executeJavaState";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }

    static final class ControlBreakAction
    extends ProxyBasedAction
    implements ActionRemoteBehaviorSpecification.Disabled {
        private final ExecutorService myExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Thread Dumper", (int)1);

        public ControlBreakAction() {
            super(ExecutionBundle.message((String)"run.configuration.dump.threads.action.name", (Object[])new Object[0]), null, AllIcons.Actions.Dump);
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(3, 128)));
        }

        @Override
        protected boolean available(ProcessProxy proxy) {
            return proxy.canSendBreak();
        }

        @Override
        protected void perform(AnActionEvent event, ProcessProxy proxy, ProcessHandler processHandler) {
            Project project = event.getProject();
            if (project == null) {
                return;
            }
            RunnerContentUi runnerContentUi = (RunnerContentUi)event.getData(RunnerContentUi.KEY);
            if (processHandler instanceof BaseProcessHandler && runnerContentUi != null) {
                GlobalSearchScope scope;
                String pid = String.valueOf(((BaseProcessHandler)processHandler).getProcess().pid());
                RunTab runTab = (RunTab)event.getData(RunTab.KEY);
                GlobalSearchScope globalSearchScope = scope = runTab instanceof RunContentBuilder ? ((RunContentBuilder)runTab).getSearchScope() : GlobalSearchScope.allScope((Project)project);
                if (!JavaDebuggerAttachUtil.getAttachedPids((Project)project).contains(pid)) {
                    this.myExecutor.execute(() -> {
                        String dump = ThreadDumpProvider.dump(pid);
                        if (dump != null) {
                            List threads = ThreadDumpParser.parse((String)dump);
                            ApplicationManager.getApplication().invokeLater(() -> DebuggerUtilsEx.addThreadDump((Project)project, (List)threads, (RunnerLayoutUi)runnerContentUi.getRunnerLayoutUi(), (GlobalSearchScope)scope), ModalityState.nonModal());
                        } else {
                            ControlBreakAction.dumpWithBreak(proxy, project, processHandler);
                        }
                    });
                    return;
                }
            }
            ControlBreakAction.dumpWithBreak(proxy, project, processHandler);
        }

        private static void dumpWithBreak(ProcessProxy proxy, Project project, ProcessHandler processHandler) {
            boolean wise = Boolean.getBoolean(DefaultJavaProgramRunner.ourWiseThreadDumpProperty);
            WiseDumpThreadsListener wiseListener = wise ? new WiseDumpThreadsListener(project, processHandler) : null;
            proxy.sendBreak();
            if (wiseListener != null) {
                wiseListener.after();
            }
        }
    }

    protected static final class AttachDebuggerAction
    extends DumbAwareAction {
        private final AtomicBoolean myEnabled = new AtomicBoolean();
        private final AtomicReference<XDebugSession> myAttachedSession = new AtomicReference();
        private final BaseProcessHandler<?> myProcessHandler;
        private MessageBusConnection myConnection = null;

        public AttachDebuggerAction(BaseProcessHandler<?> processHandler) {
            super(ExecutionBundle.message((String)"run.configuration.attach.debugger.action.name", (Object[])new Object[0]), null, AllIcons.Debugger.AttachToProcess);
            this.myProcessHandler = processHandler;
            this.myProcessHandler.addProcessListener(new ProcessListener(){

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!ApplicationManager.getApplication().isUnitTestMode()) {
                        AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> myEnabled.set(!myProcessHandler.isProcessTerminating() && !myProcessHandler.isProcessTerminated() && JavaDebuggerAttachUtil.canAttach(myProcessHandler)), 1L, TimeUnit.SECONDS);
                    }
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (myConnection != null) {
                        myConnection.disconnect();
                    }
                    myProcessHandler.removeProcessListener((ProcessListener)this);
                    XDebugSession attachedSession = myAttachedSession.getAndSet(null);
                    if (attachedSession != null) {
                        attachedSession.stop();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/intellij/execution/impl/DefaultJavaProgramRunner$AttachDebuggerAction$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "startNotified";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.getTemplatePresentation().putClientProperty(RunTab.PREFERRED_PLACE, (Object)PreferredPlace.MORE_GROUP);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                AttachDebuggerAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                AttachDebuggerAction.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) != null && this.myConnection == null) {
                this.myConnection = project.getMessageBus().connect();
                this.myConnection.subscribe(XDebuggerManager.TOPIC, (Object)new XDebuggerManagerListener(){

                    public void processStarted(@NotNull XDebugProcess debugProcess) {
                        if (debugProcess == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        this.processEvent(debugProcess, true);
                    }

                    public void processStopped(@NotNull XDebugProcess debugProcess) {
                        if (debugProcess == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        this.processEvent(debugProcess, false);
                    }

                    void processEvent(@NotNull XDebugProcess debugProcess, boolean started) {
                        RemoteConnection connection;
                        if (debugProcess == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        if (debugProcess instanceof JavaDebugProcess && (connection = ((JavaDebugProcess)debugProcess).getDebuggerSession().getProcess().getConnection()) instanceof PidRemoteConnection && ((PidRemoteConnection)connection).getPid().equals(String.valueOf(myProcessHandler.getProcess().pid()))) {
                            myAttachedSession.set(started ? debugProcess.getSession() : null);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "debugProcess";
                        objectArray2[1] = "com/intellij/execution/impl/DefaultJavaProgramRunner$AttachDebuggerAction$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processStarted";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processStopped";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processEvent";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            if (this.myAttachedSession.get() != null || this.myProcessHandler.isProcessTerminated()) {
                e.getPresentation().setEnabled(false);
                return;
            }
            e.getPresentation().setEnabledAndVisible(Boolean.TRUE.equals(this.myEnabled.get()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AttachDebuggerAction.$$$reportNull$$$0(2);
            }
            JavaDebuggerAttachUtil.attach(this.myProcessHandler, (Project)e.getProject());
        }

        public static void add(RunContentBuilder contentBuilder, ProcessHandler processHandler) {
            if (Registry.is((String)"debugger.attach.to.process.action") && processHandler instanceof BaseProcessHandler && !SystemInfo.isMac) {
                contentBuilder.addAction((AnAction)new AttachDebuggerAction((BaseProcessHandler)processHandler));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/DefaultJavaProgramRunner$AttachDebuggerAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/DefaultJavaProgramRunner$AttachDebuggerAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    static final class SoftExitAction
    extends ProxyBasedAction {
        SoftExitAction() {
            super(ExecutionBundle.message((String)"run.configuration.exit.action.name", (Object[])new Object[0]), null, AllIcons.Actions.Exit);
        }

        @Override
        protected boolean available(ProcessProxy proxy) {
            return proxy.canSendStop();
        }

        @Override
        protected void perform(AnActionEvent e, ProcessProxy proxy, ProcessHandler processHandler) {
            processHandler.putUserData(ProcessHandler.TERMINATION_REQUESTED, (Object)Boolean.TRUE);
            proxy.sendStop();
        }
    }

    private static final class WiseDumpThreadsListener {
        private final Project myProject;
        private final ProcessHandler myProcessHandler;
        private final CapturingProcessAdapter myListener;

        WiseDumpThreadsListener(Project project, ProcessHandler processHandler) {
            this.myProject = project;
            this.myProcessHandler = processHandler;
            this.myListener = new CapturingProcessAdapter();
            this.myProcessHandler.addProcessListener((ProcessListener)this.myListener);
        }

        public void after() {
            if (this.myProject == null) {
                this.myProcessHandler.removeProcessListener((ProcessListener)this.myListener);
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                String stdout;
                if (this.myProcessHandler.isProcessTerminated() || this.myProcessHandler.isProcessTerminating()) {
                    return;
                }
                List threadStates = null;
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() - start < 1000L && (threadStates = ThreadDumpParser.parse((String)(stdout = this.myListener.getOutput().getStdout()))).isEmpty()) {
                    TimeoutUtil.sleep((long)50L);
                    threadStates = null;
                }
                this.myProcessHandler.removeProcessListener((ProcessListener)this.myListener);
                if (threadStates != null && !threadStates.isEmpty()) {
                    DefaultJavaProgramRunner.showThreadDump(this.myListener.getOutput().getStdout(), threadStates, this.myProject);
                }
            });
        }
    }

    private static abstract class ProxyBasedAction
    extends AnAction {
        protected ProxyBasedAction(@NlsActions.ActionText String text, @NlsActions.ActionDescription String description, Icon icon) {
            super(text, description, icon);
        }

        protected ProcessHandler getProcessHandler(@NotNull AnActionEvent e) {
            RunContentDescriptor contentDescriptor;
            if (e == null) {
                ProxyBasedAction.$$$reportNull$$$0(0);
            }
            return (contentDescriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR)) == null ? null : contentDescriptor.getProcessHandler();
        }

        public boolean isDumbAware() {
            return true;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ProxyBasedAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                ProxyBasedAction.$$$reportNull$$$0(2);
            }
            ProcessHandler processHandler = this.getProcessHandler(event);
            ProcessProxy proxy = ProcessProxyFactory.getInstance().getAttachedProxy(processHandler);
            boolean available = proxy != null && this.available(proxy);
            Presentation presentation = event.getPresentation();
            if (!available) {
                presentation.setEnabledAndVisible(false);
            } else {
                presentation.setVisible(true);
                presentation.setEnabled(!processHandler.isProcessTerminated());
            }
        }

        public final void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ProxyBasedAction.$$$reportNull$$$0(3);
            }
            ProcessHandler processHandler = this.getProcessHandler(e);
            ProcessProxy proxy = ProcessProxyFactory.getInstance().getAttachedProxy(processHandler);
            if (proxy != null) {
                this.perform(e, proxy, processHandler);
            }
        }

        protected abstract boolean available(ProcessProxy var1);

        protected abstract void perform(AnActionEvent var1, ProcessProxy var2, ProcessHandler var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/DefaultJavaProgramRunner$ProxyBasedAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/DefaultJavaProgramRunner$ProxyBasedAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getProcessHandler";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

