/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PopupUtilsKt;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class InheritorChooser {
    protected void runForClasses(List<PsiClass> classes, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
        performRunnable.run();
    }

    protected void runForClass(PsiClass aClass, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable) {
        performRunnable.run();
    }

    public boolean runMethodInAbstractClass(ConfigurationContext context, Runnable performRunnable, PsiMethod psiMethod, PsiClass containingClass) {
        return this.runMethodInAbstractClass(context, performRunnable, psiMethod, containingClass, (Condition<? super PsiClass>)((Condition)psiClass -> psiClass.hasModifierProperty("abstract")));
    }

    public boolean runMethodInAbstractClass(ConfigurationContext context, Runnable performRunnable, PsiMethod psiMethod, PsiClass containingClass, Condition<? super PsiClass> acceptAbstractCondition) {
        PsiClass gContainingClass;
        if (containingClass != null && acceptAbstractCondition.value((Object)containingClass)) {
            MethodLocation loc;
            PsiClass aClass;
            Location location = context.getLocation();
            if (location instanceof MethodLocation ? !(aClass = (loc = (MethodLocation)location).getContainingClass()).hasModifierProperty("abstract") : location instanceof PsiMemberParameterizedLocation) {
                return false;
            }
            ArrayList classes = new ArrayList();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> InheritorChooser.collectClasses(containingClass, classes, new HashSet()), ExecutionBundle.message((String)"search.for.0.inheritors", (Object[])new Object[]{containingClass.getQualifiedName()}), true, containingClass.getProject())) {
                return true;
            }
            if (classes.size() == 1) {
                this.runForClass((PsiClass)classes.getFirst(), psiMethod, context, performRunnable);
                return true;
            }
            if (classes.isEmpty()) {
                return false;
            }
            FileEditor fileEditor = (FileEditor)PlatformCoreDataKeys.FILE_EDITOR.getData(context.getDataContext());
            if (fileEditor instanceof TextEditor) {
                TextEditor te = (TextEditor)fileEditor;
                Document document = te.getEditor().getDocument();
                PsiFile containingFile = PsiDocumentManager.getInstance((Project)context.getProject()).getPsiFile(document);
                if (containingFile instanceof PsiClassOwner) {
                    ArrayList<PsiClass> psiClasses = new ArrayList<PsiClass>(Arrays.asList(((PsiClassOwner)containingFile).getClasses()));
                    psiClasses.retainAll(classes);
                    if (psiClasses.size() == 1) {
                        this.runForClass((PsiClass)psiClasses.getFirst(), psiMethod, context, performRunnable);
                        return true;
                    }
                }
            }
            final int numberOfInheritors = classes.size();
            PsiClassListCellRenderer renderer = new PsiClassListCellRenderer(){

                protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    if (value == null) {
                        renderer.append(JavaCompilerBundle.message((String)"all.inheritors", (Object[])new Object[]{numberOfInheritors}));
                        return true;
                    }
                    return super.customizeNonPsiElementLeftRenderer(renderer, list, value, index, selected, hasFocus);
                }
            };
            classes.sort(renderer.getComparator());
            classes.addFirst(null);
            String locationName = psiMethod != null ? psiMethod.getName() : containingClass.getName();
            JBPopupFactory.getInstance().createPopupChooserBuilder(classes).setRenderer((ListCellRenderer)renderer).setTitle(ExecutionBundle.message((String)"test.cases.choosing.popup.title", (Object[])new Object[]{locationName})).setAutoselectOnMouseMove(false).setNamerForFiltering(it -> it == null ? "" : it.getName()).setMovable(true).setResizable(false).setRequestFocus(true).setMinSize((Dimension)JBUI.size((int)270, (int)55)).setItemsChosenCallback(values -> {
                if (values.isEmpty()) {
                    return;
                }
                this.chooseAndPerform(values.toArray(), psiMethod, context, performRunnable, classes);
            }).createPopup().show(PopupUtilsKt.getBestPopupPosition((DataContext)context.getDataContext()));
            return true;
        }
        if (containingClass != null && !containingClass.hasModifierProperty("static") && (gContainingClass = containingClass.getContainingClass()) != null && !containingClass.isInheritor(gContainingClass, true)) {
            return this.runMethodInAbstractClass(context, performRunnable, psiMethod, gContainingClass, acceptAbstractCondition);
        }
        return false;
    }

    private static void collectClasses(PsiClass containingClass, List<? super PsiClass> classes, Set<? super PsiClass> visited) {
        if (!visited.add((PsiClass)containingClass)) {
            return;
        }
        HashSet containers = new HashSet();
        boolean isJUnit5 = (Boolean)ReadAction.compute(() -> JUnitUtil.isJUnit5((PsiElement)containingClass));
        ClassInheritorsSearch.search((PsiClass)containingClass).forEach(aClass -> {
            PsiClass container = aClass.getContainingClass();
            if (container != null && container.hasModifierProperty("abstract")) {
                containers.add(container);
            }
            if (isJUnit5 && JUnitUtil.isJUnit5TestClass(aClass, true) || PsiClassUtil.isRunnableClass((PsiClass)aClass, (boolean)true, (boolean)true)) {
                classes.add((PsiClass)aClass);
            }
            return true;
        });
        for (PsiClass container : containers) {
            InheritorChooser.collectClasses(container, classes, visited);
        }
    }

    private void chooseAndPerform(Object[] values, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable, List<PsiClass> classes) {
        classes.remove(null);
        if (values.length == 1) {
            Object value = values[0];
            if (value instanceof PsiClass) {
                this.runForClass((PsiClass)value, psiMethod, context, performRunnable);
            } else {
                this.runForClasses(classes, psiMethod, context, performRunnable);
            }
            return;
        }
        if (ArrayUtil.contains(null, (Object[])values)) {
            this.runForClasses(classes, psiMethod, context, performRunnable);
        } else {
            ArrayList<PsiClass> selectedClasses = new ArrayList<PsiClass>();
            for (Object value : values) {
                if (!(value instanceof PsiClass)) continue;
                selectedClasses.add((PsiClass)value);
            }
            this.runForClasses(selectedClasses, psiMethod, context, performRunnable);
        }
    }

    public static void chooseAbstractClassInheritors(ConfigurationContext context, PsiClass psiClass, final Consumer<? super List<PsiClass>> onClassesChosen) {
        InheritorChooser inheritorChooser = new InheritorChooser(){

            @Override
            protected void runForClasses(List<PsiClass> classes, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
                onClassesChosen.accept(classes);
            }

            @Override
            protected void runForClass(PsiClass aClass, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable) {
                onClassesChosen.accept(List.of(aClass));
            }
        };
        if (!inheritorChooser.runMethodInAbstractClass(context, () -> {}, null, psiClass)) {
            onClassesChosen.accept(List.of(psiClass));
        }
    }
}

