/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JUnitRecognizer;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JUnitUtil {
    public static final String TEST_CASE_CLASS = "junit.framework.TestCase";
    private static final String TEST_INTERFACE = "junit.framework.Test";
    private static final String TEST_SUITE_CLASS = "junit.framework.TestSuite";
    public static final String TEST_ANNOTATION = "org.junit.Test";
    public static final String RULE_ANNOTATION = "org.junit.Rule";
    public static final String TEST5_PACKAGE_FQN = "org.junit.jupiter.api";
    public static final String TEST5_ANNOTATION = "org.junit.jupiter.api.Test";
    public static final String CUSTOM_TESTABLE_ANNOTATION = "org.junit.platform.commons.annotation.Testable";
    public static final Set<String> CUSTOM_TESTABLE_ANNOTATION_LIST = Collections.singleton("org.junit.platform.commons.annotation.Testable");
    public static final String TEST5_FACTORY_ANNOTATION = "org.junit.jupiter.api.TestFactory";
    public static final String RUN_WITH = "org.junit.runner.RunWith";
    public static final String DATA_POINT = "org.junit.experimental.theories.DataPoint";
    public static final String SUITE_METHOD_NAME = "suite";
    public static final String BEFORE_ANNOTATION_NAME = "org.junit.Before";
    public static final String AFTER_ANNOTATION_NAME = "org.junit.After";
    public static final String BEFORE_EACH_ANNOTATION_NAME = "org.junit.jupiter.api.BeforeEach";
    public static final String AFTER_EACH_ANNOTATION_NAME = "org.junit.jupiter.api.AfterEach";
    public static final String PARAMETRIZED_PARAMETERS_ANNOTATION_NAME = "org.junit.runners.Parameterized.Parameters";
    public static final String PARAMETRIZED_PARAMETER_ANNOTATION_NAME = "org.junit.runners.Parameterized.Parameter";
    public static final String AFTER_CLASS_ANNOTATION_NAME = "org.junit.AfterClass";
    public static final String BEFORE_CLASS_ANNOTATION_NAME = "org.junit.BeforeClass";
    public static final String BEFORE_ALL_ANNOTATION_NAME = "org.junit.jupiter.api.BeforeAll";
    public static final String AFTER_ALL_ANNOTATION_NAME = "org.junit.jupiter.api.AfterAll";
    public static final Collection<String> TEST5_JUPITER_ANNOTATIONS = List.of("org.junit.jupiter.api.Test", "org.junit.jupiter.api.TestFactory");
    private static final List<String> INSTANCE_CONFIGS = Arrays.asList("org.junit.Before", "org.junit.After");
    private static final List<String> INSTANCE_5_CONFIGS = Arrays.asList("org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.AfterEach");
    private static final List<String> STATIC_CONFIGS = Arrays.asList("org.junit.BeforeClass", "org.junit.AfterClass", "org.junit.runners.Parameterized.Parameters");
    private static final List<String> STATIC_5_CONFIGS = Arrays.asList("org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll", "org.junit.platform.suite.api.BeforeSuite", "org.junit.platform.suite.api.AfterSuite");
    private static final Collection<String> CONFIGURATIONS_ANNOTATION_NAME = List.of("org.junit.experimental.theories.DataPoint", "org.junit.After", "org.junit.Before", "org.junit.jupiter.api.AfterEach", "org.junit.jupiter.api.BeforeEach", "org.junit.AfterClass", "org.junit.BeforeClass", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll", "org.junit.Rule", "org.junit.platform.suite.api.AfterSuite", "org.junit.platform.suite.api.BeforeSuite");
    public static final String PARAMETERIZED_CLASS_NAME = "org.junit.runners.Parameterized";
    public static final String SUITE_CLASS_NAME = "org.junit.runners.Suite";
    public static final String JUNIT5_NESTED = "org.junit.jupiter.api.Nested";
    private static final String[] RUNNERS_UNAWARE_OF_INNER_CLASSES = new String[]{"org.junit.runners.Parameterized", "org.junit.runners.BlockJUnit4ClassRunner", "org.junit.runners.JUnit4", "org.junit.internal.runners.JUnit38ClassRunner", "org.junit.internal.runners.JUnit4ClassRunner", "org.junit.runners.Suite"};
    private static final String[] RUNNERS_REQUIRE_ANNOTATION_ON_TEST_METHOD = new String[]{"org.junit.runners.Parameterized", "org.junit.runners.BlockJUnit4ClassRunner", "org.junit.runners.JUnit4", "org.junit.internal.runners.JUnit4ClassRunner", "org.mockito.junit.MockitoJUnitRunner", "org.mockito.junit.MockitoJUnitRunner.StrictStubs", "org.mockito.junit.MockitoJUnitRunner.Silent", "org.mockito.junit.MockitoJUnitRunner.Strict"};
    private static final Logger LOG = Logger.getInstance(JUnitUtil.class);

    public static boolean isSuiteMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            JUnitUtil.$$$reportNull$$$0(0);
        }
        if (!psiMethod.hasModifierProperty("public")) {
            return false;
        }
        if (!psiMethod.hasModifierProperty("static")) {
            return false;
        }
        if (psiMethod.isConstructor()) {
            return false;
        }
        if (!psiMethod.getParameterList().isEmpty()) {
            return false;
        }
        PsiType returnType = psiMethod.getReturnType();
        if (returnType == null || returnType instanceof PsiPrimitiveType) {
            return false;
        }
        return returnType.equalsToText(TEST_INTERFACE) || returnType.equalsToText(TEST_SUITE_CLASS) || InheritanceUtil.isInheritor((PsiType)returnType, (String)TEST_INTERFACE);
    }

    public static boolean isTestMethod(Location<? extends PsiMethod> location) {
        return JUnitUtil.isTestMethod(location, true);
    }

    public static boolean isTestMethod(@NotNull Location<? extends PsiMethod> location, boolean checkAbstract) {
        if (location == null) {
            JUnitUtil.$$$reportNull$$$0(1);
        }
        return JUnitUtil.isTestMethod(location, checkAbstract, true);
    }

    public static boolean isTestMethod(@NotNull Location<? extends PsiMethod> location, boolean checkAbstract, boolean checkRunWith) {
        if (location == null) {
            JUnitUtil.$$$reportNull$$$0(2);
        }
        return JUnitUtil.isTestMethod(location, checkAbstract, checkRunWith, true);
    }

    public static boolean isTestMethod(@NotNull Location<? extends PsiMethod> location, boolean checkAbstract, boolean checkRunWith, boolean checkClass) {
        PsiAnnotation annotation;
        PsiClass aClass;
        if (location == null) {
            JUnitUtil.$$$reportNull$$$0(3);
        }
        PsiMethod psiMethod = (PsiMethod)location.getPsiElement();
        PsiClass psiClass = aClass = location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : psiMethod.getContainingClass();
        if (checkClass && (aClass == null || !JUnitUtil.isTestClass(aClass, checkAbstract, true))) {
            return false;
        }
        if (psiMethod.isConstructor()) {
            return false;
        }
        if (psiMethod.hasModifierProperty("private")) {
            return false;
        }
        if (JUnitUtil.isTestAnnotated(psiMethod, true)) {
            return !psiMethod.hasModifierProperty("static");
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, CONFIGURATIONS_ANNOTATION_NAME, (int)0)) {
            return false;
        }
        if (aClass != null && MetaAnnotationUtil.isMetaAnnotatedInHierarchy((PsiModifierListOwner)aClass, Collections.singletonList(CUSTOM_TESTABLE_ANNOTATION))) {
            return true;
        }
        if (!psiMethod.hasModifierProperty("public")) {
            return false;
        }
        if (psiMethod.hasModifierProperty("abstract")) {
            return false;
        }
        if (checkClass && checkRunWith && (annotation = JUnitUtil.getRunWithAnnotation(aClass)) != null) {
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass == null || "java.lang.Object".equals(containingClass.getQualifiedName())) {
                return false;
            }
            return !JUnitUtil.isOneOf(annotation, RUNNERS_REQUIRE_ANNOTATION_ON_TEST_METHOD);
        }
        if (!psiMethod.getParameterList().isEmpty()) {
            return false;
        }
        if (psiMethod.hasModifierProperty("static")) {
            return false;
        }
        if (!psiMethod.getName().startsWith("test")) {
            return false;
        }
        if (checkClass) {
            PsiClass testCaseClass = JUnitUtil.getTestCaseClassOrNull(aClass);
            if (psiMethod.getContainingClass() == null) {
                return false;
            }
            if (testCaseClass == null || !psiMethod.getContainingClass().isInheritor(testCaseClass, true)) {
                return false;
            }
        }
        return PsiTypes.voidType().equals((Object)psiMethod.getReturnType());
    }

    public static boolean isTestCaseInheritor(PsiClass aClass) {
        if (!aClass.isValid()) {
            return false;
        }
        PsiClass testCaseClass = JUnitUtil.getTestCaseClassOrNull(aClass);
        return testCaseClass != null && aClass.isInheritor(testCaseClass, true);
    }

    public static boolean isTestClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JUnitUtil.$$$reportNull$$$0(4);
        }
        return JUnitUtil.isTestClass(psiClass, true, true);
    }

    private static boolean hasTestableMetaAnnotation(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JUnitUtil.$$$reportNull$$$0(5);
        }
        return JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(CUSTOM_TESTABLE_ANNOTATION, psiClass.getResolveScope()) != null && MetaAnnotationUtil.hasMetaAnnotatedMethods((PsiClass)psiClass, CUSTOM_TESTABLE_ANNOTATION_LIST);
    }

    public static boolean isTestClass(@NotNull PsiClass psiClass, boolean checkAbstract, boolean checkForTestCaseInheritance) {
        PsiAnnotation annotation;
        if (psiClass == null) {
            JUnitUtil.$$$reportNull$$$0(6);
        }
        if (psiClass.getQualifiedName() == null) {
            return false;
        }
        if (JUnitUtil.isJUnit5((PsiElement)psiClass) ? JUnitUtil.isJUnit5TestClass(psiClass, checkAbstract) : JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(CUSTOM_TESTABLE_ANNOTATION, psiClass.getResolveScope()) != null && MetaAnnotationUtil.isMetaAnnotatedInHierarchy((PsiModifierListOwner)psiClass, CUSTOM_TESTABLE_ANNOTATION_LIST) || JUnitUtil.hasTestableMetaAnnotation(psiClass)) {
            return true;
        }
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true, (boolean)checkAbstract)) {
            return false;
        }
        PsiClass topLevelClass = JUnitUtil.getTopmostClass(psiClass);
        if (topLevelClass != null && (annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)topLevelClass, Collections.singleton(RUN_WITH))) != null) {
            if (topLevelClass == psiClass) {
                return true;
            }
            if (!JUnitUtil.isInheritorOrSelfRunner(annotation, RUNNERS_UNAWARE_OF_INNER_CLASSES)) {
                return true;
            }
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)RUN_WITH, (int)1)) {
            return true;
        }
        if (checkForTestCaseInheritance && JUnitUtil.isTestCaseInheritor(psiClass)) {
            return true;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create((Object)JUnitUtil.hasTestOrSuiteMethods(psiClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static boolean hasTestOrSuiteMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JUnitUtil.$$$reportNull$$$0(7);
        }
        for (PsiMethod method : psiClass.getAllMethods()) {
            if (JUnitUtil.isSuiteMethod(method)) {
                return true;
            }
            if (!JUnitUtil.isExplicitlyTestAnnotated(method)) continue;
            return true;
        }
        PsiClass[] classes = psiClass.getInnerClasses();
        if (classes.length > 0 && JUnitUtil.isJUnit5((PsiElement)psiClass)) {
            for (PsiClass innerClass : classes) {
                for (PsiMethod method : innerClass.getAllMethods()) {
                    if (!JUnitUtil.isExplicitlyTestAnnotated(method)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isJUnit3TestClass(PsiClass clazz) {
        return JUnitUtil.hasNonPrivateConstructor(clazz) && PsiClassUtil.isRunnableClass((PsiClass)clazz, (boolean)true, (boolean)false) && JUnitUtil.isTestCaseInheritor(clazz);
    }

    public static boolean isJUnit4TestClass(PsiClass psiClass) {
        return JUnitUtil.isJUnit4TestClass(psiClass, true);
    }

    public static boolean isJUnit4TestClass(PsiClass psiClass, boolean checkAbstract) {
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null) {
            return false;
        }
        if (psiClass.getQualifiedName() == null) {
            return false;
        }
        if (JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(TEST_ANNOTATION, psiClass.getResolveScope()) == null) {
            return false;
        }
        PsiClass topLevelClass = JUnitUtil.getTopmostClass(psiClass);
        if (topLevelClass != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)topLevelClass, (String)RUN_WITH, (int)1)) {
            PsiAnnotation annotation = JUnitUtil.getRunWithAnnotation(topLevelClass);
            if (topLevelClass == psiClass) {
                return true;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)RUN_WITH, (int)1)) {
                return true;
            }
            if (annotation != null && !JUnitUtil.isInheritorOrSelfRunner(annotation, RUNNERS_UNAWARE_OF_INNER_CLASSES)) {
                return true;
            }
        }
        if (!JUnitUtil.hasNonPrivateConstructor(psiClass)) {
            return false;
        }
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true, (boolean)checkAbstract)) {
            return false;
        }
        for (PsiMethod method : psiClass.getAllMethods()) {
            ProgressManager.checkCanceled();
            if (!TestUtils.isExplicitlyJUnit4TestAnnotated((PsiMethod)method) && !JUnitRecognizer.willBeAnnotatedAfterCompilation((PsiMethod)method)) continue;
            return true;
        }
        return false;
    }

    private static PsiClass getTopmostClass(PsiClass psiClass) {
        PsiClass topLevelClass;
        for (topLevelClass = psiClass; topLevelClass != null && topLevelClass.getContainingClass() != null; topLevelClass = topLevelClass.getContainingClass()) {
        }
        return topLevelClass;
    }

    private static boolean hasNonPrivateConstructor(PsiClass psiClass) {
        PsiMethod[] constructors = psiClass.getConstructors();
        if (constructors.length > 0) {
            for (PsiMethod constructor : constructors) {
                if (constructor.getModifierList().hasModifierProperty("private")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isJUnit5TestClass(@NotNull PsiClass psiClass, boolean checkAbstract) {
        PsiModifierList modifierList;
        if (psiClass == null) {
            JUnitUtil.$$$reportNull$$$0(8);
        }
        if ((modifierList = psiClass.getModifierList()) == null) {
            return false;
        }
        if (psiClass.isAnnotationType()) {
            return false;
        }
        boolean isJunitAnnotated = (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            if (psiClass.getContainingClass() != null && !psiClass.hasModifierProperty("private") && !psiClass.hasModifierProperty("static") && MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiClass, Collections.singleton(JUNIT5_NESTED))) {
                return CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            if (MetaAnnotationUtil.isMetaAnnotatedInHierarchy((PsiModifierListOwner)psiClass, CUSTOM_TESTABLE_ANNOTATION_LIST)) {
                return CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (isJunitAnnotated) {
            return true;
        }
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)false, (boolean)checkAbstract)) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            boolean hasAnnotation = AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.junit.jupiter.api.extension.ExtendWith", (int)0);
            if (!hasAnnotation) {
                for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                    ProgressManager.checkCanceled();
                    if (psiMethod.hasModifierProperty("private") || psiMethod.hasModifierProperty("static") || !MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiMethod, CUSTOM_TESTABLE_ANNOTATION_LIST)) continue;
                    hasAnnotation = true;
                    break;
                }
            }
            if (!hasAnnotation) {
                for (PsiMethod psiMethod : psiClass.getAllInnerClasses()) {
                    if (psiMethod.hasModifierProperty("private") || psiMethod.hasModifierProperty("static") || !MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiMethod, Collections.singleton(JUNIT5_NESTED))) continue;
                    hasAnnotation = true;
                    break;
                }
            }
            return CachedValueProvider.Result.create((Object)hasAnnotation, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static boolean isJUnit5(@NotNull PsiElement element) {
        if (element == null) {
            JUnitUtil.$$$reportNull$$$0(9);
        }
        return JUnitUtil.isJUnit5(element.getResolveScope(), element.getProject());
    }

    public static boolean isJUnit5(@NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (scope == null) {
            JUnitUtil.$$$reportNull$$$0(10);
        }
        if (project == null) {
            JUnitUtil.$$$reportNull$$$0(11);
        }
        return JUnitUtil.hasPackageWithDirectories(JavaPsiFacade.getInstance((Project)project), TEST5_PACKAGE_FQN, scope);
    }

    public static boolean isJUnit6(@NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (scope == null) {
            JUnitUtil.$$$reportNull$$$0(12);
        }
        if (project == null) {
            JUnitUtil.$$$reportNull$$$0(13);
        }
        return (Boolean)ReadAction.nonBlocking(() -> {
            DumbService dumbService = DumbService.getInstance((Project)project);
            ThrowableComputable computable = () -> JavaPsiFacade.getInstance((Project)project).findClass("org.junit.jupiter.api.MethodOrderer.Default", scope) != null;
            return dumbService.isAlternativeResolveEnabled() ? (Boolean)computable.compute() : (Boolean)dumbService.computeWithAlternativeResolveEnabled(computable);
        }).executeSynchronously();
    }

    public static boolean hasPackageWithDirectories(JavaPsiFacade facade, String packageQName, GlobalSearchScope globalSearchScope) {
        return (Boolean)ReadAction.nonBlocking(() -> {
            PsiPackage aPackage = facade.findPackage(packageQName);
            return aPackage != null && aPackage.getDirectories(globalSearchScope).length > 0;
        }).executeSynchronously();
    }

    public static boolean isTestAnnotated(PsiMethod method) {
        return JUnitUtil.isTestAnnotated(method, true);
    }

    public static boolean isTestAnnotated(PsiMethod method, boolean includeCustom) {
        if (JUnitUtil.isJUnit4TestAnnotated(method)) {
            return method.hasModifierProperty("public");
        }
        return MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)method, includeCustom ? CUSTOM_TESTABLE_ANNOTATION_LIST : TEST5_JUPITER_ANNOTATIONS);
    }

    private static boolean isExplicitlyTestAnnotated(PsiMethod method) {
        return TestUtils.isExplicitlyJUnit4TestAnnotated((PsiMethod)method) || JUnitRecognizer.willBeAnnotatedAfterCompilation((PsiMethod)method) || MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)method, CUSTOM_TESTABLE_ANNOTATION_LIST);
    }

    public static boolean isJUnit4TestAnnotated(PsiMethod method) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)TEST_ANNOTATION, (int)1) || JUnitRecognizer.willBeAnnotatedAfterCompilation((PsiMethod)method);
    }

    @Nullable
    private static PsiClass getTestCaseClassOrNull(PsiClass psiClass) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true);
        return JUnitUtil.getTestCaseClassOrNull(scope, module.getProject());
    }

    @NotNull
    public static PsiClass getTestCaseClass(Module module) throws NoJUnitException {
        if (module == null) {
            throw new NoJUnitException();
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true);
        return JUnitUtil.getTestCaseClass(scope, module.getProject());
    }

    @NotNull
    public static PsiClass getTestCaseClass(SourceScope scope) throws NoJUnitException {
        if (scope == null) {
            throw new NoJUnitException();
        }
        return JUnitUtil.getTestCaseClass(scope.getLibrariesScope(), scope.getProject());
    }

    public static void checkTestCase(SourceScope scope, Project project) throws NoJUnitException {
        if (scope == null) {
            throw new NoJUnitException();
        }
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage("junit.framework");
        if (aPackage == null || aPackage.getDirectories(scope.getLibrariesScope()).length == 0) {
            throw new NoJUnitException();
        }
    }

    @NotNull
    private static PsiClass getTestCaseClass(@NotNull GlobalSearchScope scope, @NotNull Project project) throws NoJUnitException {
        PsiClass testCaseClass;
        if (scope == null) {
            JUnitUtil.$$$reportNull$$$0(14);
        }
        if (project == null) {
            JUnitUtil.$$$reportNull$$$0(15);
        }
        if ((testCaseClass = JUnitUtil.getTestCaseClassOrNull(scope, project)) == null) {
            throw new NoJUnitException(scope.getDisplayName());
        }
        PsiClass psiClass = testCaseClass;
        if (psiClass == null) {
            JUnitUtil.$$$reportNull$$$0(16);
        }
        return psiClass;
    }

    @Nullable
    private static PsiClass getTestCaseClassOrNull(@NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (scope == null) {
            JUnitUtil.$$$reportNull$$$0(17);
        }
        if (project == null) {
            JUnitUtil.$$$reportNull$$$0(18);
        }
        return JavaPsiFacade.getInstance((Project)project).findClass(TEST_CASE_CLASS, scope);
    }

    public static boolean isTestMethodOrConfig(@NotNull PsiMethod psiMethod) {
        PsiClass containingClass;
        if (psiMethod == null) {
            JUnitUtil.$$$reportNull$$$0(19);
        }
        if ((containingClass = psiMethod.getContainingClass()) == null) {
            return false;
        }
        if (JUnitUtil.isTestMethod((Location<? extends PsiMethod>)PsiLocation.fromPsiElement((PsiElement)psiMethod), false)) {
            if (containingClass.hasModifierProperty("abstract")) {
                boolean[] foundNonAbstractInheritor = new boolean[1];
                ClassInheritorsSearch.search((PsiClass)containingClass).forEach(psiClass -> {
                    if (!psiClass.hasModifierProperty("abstract")) {
                        foundNonAbstractInheritor[0] = true;
                        return false;
                    }
                    return true;
                });
                if (foundNonAbstractInheritor[0]) {
                    return true;
                }
            } else {
                return true;
            }
        }
        String name = psiMethod.getName();
        boolean isPublic = psiMethod.hasModifierProperty("public");
        if (!psiMethod.hasModifierProperty("abstract")) {
            if (isPublic && (SUITE_METHOD_NAME.equals(name) || "setUp".equals(name) || "tearDown".equals(name))) {
                return true;
            }
            if (psiMethod.hasModifierProperty("static")) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, STATIC_CONFIGS, (int)0)) {
                    return isPublic;
                }
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, STATIC_5_CONFIGS, (int)0)) {
                    return true;
                }
            } else {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, INSTANCE_CONFIGS, (int)0)) {
                    return isPublic;
                }
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, INSTANCE_5_CONFIGS, (int)0)) {
                    return true;
                }
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, STATIC_5_CONFIGS, (int)0) && TestUtils.testInstancePerClass((PsiClass)containingClass)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static PsiMethod findFirstTestMethod(PsiClass clazz) {
        PsiMethod testMethod = null;
        for (PsiMethod method : clazz.getMethods()) {
            if (!JUnitUtil.isTestMethod(MethodLocation.elementInClass(method, clazz)) && !JUnitUtil.isSuiteMethod(method)) continue;
            testMethod = method;
            break;
        }
        return testMethod;
    }

    @Nullable
    public static PsiMethod findSuiteMethod(PsiClass clazz) {
        PsiMethod[] suiteMethods;
        for (PsiMethod method : suiteMethods = clazz.findMethodsByName(SUITE_METHOD_NAME, false)) {
            if (!JUnitUtil.isSuiteMethod(method)) continue;
            return method;
        }
        return null;
    }

    public static PsiAnnotation getRunWithAnnotation(PsiClass aClass) {
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)aClass, Collections.singleton(RUN_WITH));
    }

    public static boolean isParameterized(PsiAnnotation annotation) {
        return JUnitUtil.isOneOf(annotation, PARAMETERIZED_CLASS_NAME);
    }

    public static boolean isInheritorOrSelfRunner(PsiAnnotation annotation, String ... runners) {
        PsiAnnotationMemberValue value;
        PsiNameValuePair attribute = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)"value");
        PsiAnnotationMemberValue psiAnnotationMemberValue = value = attribute != null ? attribute.getDetachedValue() : null;
        if (value instanceof PsiClassObjectAccessExpression) {
            PsiTypeElement operand = ((PsiClassObjectAccessExpression)value).getOperand();
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)operand.getType());
            return psiClass != null && ContainerUtil.exists((Object[])runners, runner -> InheritanceUtil.isInheritor((PsiClass)psiClass, (String)runner));
        }
        return false;
    }

    public static boolean isOneOf(PsiAnnotation annotation, String ... runners) {
        String qualifiedName;
        PsiTypeElement operand;
        PsiClass psiClass;
        PsiAnnotationMemberValue value;
        PsiNameValuePair attribute = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)"value");
        PsiAnnotationMemberValue psiAnnotationMemberValue = value = attribute != null ? attribute.getDetachedValue() : null;
        return value instanceof PsiClassObjectAccessExpression && (psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)(operand = ((PsiClassObjectAccessExpression)value).getOperand()).getType())) != null && (qualifiedName = psiClass.getQualifiedName()) != null && ArrayUtil.find((Object[])runners, (Object)qualifiedName) > -1;
    }

    public static PsiPackage getContainingPackage(@NotNull PsiClass psiClass) {
        PsiDirectory directory;
        if (psiClass == null) {
            JUnitUtil.$$$reportNull$$$0(20);
        }
        return (directory = psiClass.getContainingFile().getContainingDirectory()) == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
    }

    public static PsiClass getTestClass(PsiElement element) {
        return JUnitUtil.getTestClass(PsiLocation.fromPsiElement((PsiElement)element));
    }

    public static PsiClass getTestClass(Location<?> location) {
        PsiClass[] classes;
        Iterator iterator = location.getAncestors(PsiClass.class, false);
        while (iterator.hasNext()) {
            Location classLocation = (Location)iterator.next();
            if (!JUnitUtil.isTestClass((PsiClass)classLocation.getPsiElement(), false, true)) continue;
            return (PsiClass)classLocation.getPsiElement();
        }
        PsiElement element = location.getPsiElement();
        if (element instanceof PsiClassOwner && (classes = ((PsiClassOwner)element).getClasses()).length == 1 && JUnitUtil.isTestClass(classes[0], false, true)) {
            return classes[0];
        }
        return null;
    }

    public static PsiMethod getTestMethod(PsiElement element) {
        return JUnitUtil.getTestMethod(element, true);
    }

    public static PsiMethod getTestMethod(PsiElement element, boolean checkAbstract) {
        return JUnitUtil.getTestMethod(element, checkAbstract, true);
    }

    public static PsiMethod getTestMethod(PsiElement element, boolean checkAbstract, boolean checkRunWith) {
        if (element == null) {
            return null;
        }
        PsiManager manager = element.getManager();
        if (element instanceof PsiMethod) {
            Location location = PsiLocation.fromPsiElement((Project)manager.getProject(), (PsiElement)((PsiMethod)element));
            return JUnitUtil.isTestMethod((Location<? extends PsiMethod>)location, checkAbstract, checkRunWith) ? (PsiMethod)element : null;
        }
        Location location = PsiLocation.fromPsiElement((Project)manager.getProject(), (PsiElement)element);
        Iterator iterator = location.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            Location methodLocation = (Location)iterator.next();
            if (!JUnitUtil.isTestMethod((Location<? extends PsiMethod>)methodLocation, checkAbstract, checkRunWith)) continue;
            return (PsiMethod)methodLocation.getPsiElement();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit/JUnitUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit/JUnitUtil";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestCaseClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuiteMethod";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTestMethod";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTestClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasTestableMetaAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasTestOrSuiteMethods";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isJUnit5TestClass";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isJUnit5";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isJUnit6";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTestCaseClass";
                break;
            }
            case 16: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTestCaseClassOrNull";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isTestMethodOrConfig";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getContainingPackage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16 -> new IllegalStateException(string);
        };
    }

    public static class NoJUnitException
    extends CantRunException {
        public NoJUnitException() {
            super(ExecutionBundle.message((String)"no.junit.error.message", (Object[])new Object[0]));
        }

        public NoJUnitException(String message) {
            super(ExecutionBundle.message((String)"no.junit.in.scope.error.message", (Object[])new Object[]{message}));
        }
    }

    public static class TestMethodFilter
    implements Condition<PsiMethod> {
        private final PsiClass myClass;
        private final TestFramework framework;

        public TestMethodFilter(PsiClass aClass) {
            this.myClass = aClass;
            this.framework = TestFrameworks.detectFramework((PsiClass)aClass);
        }

        public boolean value(PsiMethod method) {
            if (this.framework == null) {
                return false;
            }
            if (this.framework instanceof JavaTestFramework) {
                return ((JavaTestFramework)this.framework).isTestMethod(method, this.myClass);
            }
            return this.framework.isTestMethod((PsiElement)method);
        }
    }
}

