/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.SingleClassConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastContextKt;

public final class RefactoringListeners {
    public static RefactoringElementListener getListener(PsiPackage psiPackage, Accessor<PsiPackage> accessor) {
        StringBuilder path = new StringBuilder();
        for (PsiPackage parent = accessor.getPsiElement(); parent != null; parent = parent.getParentPackage()) {
            if (parent.equals((Object)psiPackage)) {
                return new RefactorPackage((Accessor<? super PsiPackage>)accessor, path.toString());
            }
            if (!path.isEmpty()) {
                path.insert(0, '.');
            }
            path.insert(0, parent.getName());
        }
        return null;
    }

    public static RefactoringElementListener getListeners(PsiClass psiClass, Accessor<PsiClass> accessor) {
        PsiClass aClass = accessor.getPsiElement();
        if (aClass == null) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        PsiClass parent = aClass;
        while (parent != null) {
            if (parent.equals((Object)psiClass)) {
                return new RefactorClass((Accessor<? super PsiClass>)accessor, path.toString());
            }
            if (!path.isEmpty()) {
                path.insert(0, '$');
            }
            path.insert(0, parent.getName());
            parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class, (boolean)true);
        }
        return null;
    }

    public static RefactoringElementListener getClassOrPackageListener(PsiElement element, Accessor<PsiClass> accessor) {
        PsiClass aClass;
        if (element instanceof PsiClass) {
            return RefactoringListeners.getListeners((PsiClass)element, accessor);
        }
        if (element instanceof PsiPackage) {
            PsiClass aClass2 = accessor.getPsiElement();
            if (aClass2 == null) {
                return null;
            }
            return RefactoringListeners.getListener((PsiPackage)element, new ClassPackageAccessor(accessor));
        }
        if (element instanceof PsiFile) {
            return null;
        }
        UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)element, UClass.class);
        if (uClass != null && uClass.equals((Object)UastContextKt.toUElement((PsiElement)(aClass = accessor.getPsiElement()), UClass.class))) {
            return new RefactorClass((Accessor<? super PsiClass>)accessor, "");
        }
        return null;
    }

    public static interface Accessor<T extends PsiElement> {
        public void setName(String var1);

        public T getPsiElement();

        public void setPsiElement(T var1);
    }

    private static final class RefactorPackage
    extends RenameElement<PsiPackage> {
        RefactorPackage(Accessor<? super PsiPackage> accessor, String path) {
            super(accessor, path);
        }

        @Override
        public PsiPackage findNewElement(PsiPackage psiPackage, String qualifiedName) {
            return JavaPsiFacade.getInstance((Project)psiPackage.getProject()).findPackage(qualifiedName);
        }

        @Override
        public String getQualifiedName(@NotNull PsiPackage psiPackage) {
            if (psiPackage == null) {
                RefactorPackage.$$$reportNull$$$0(0);
            }
            return psiPackage.getQualifiedName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/execution/junit/RefactoringListeners$RefactorPackage", "getQualifiedName"));
        }
    }

    private static final class RefactorClass
    extends RenameElement<UClass> {
        RefactorClass(Accessor<? super PsiClass> accessor, String path) {
            super(RefactorClass.wrap(accessor), path);
        }

        private static Accessor<? super UClass> wrap(final Accessor<? super PsiClass> accessor) {
            return new Accessor<UClass>(){

                @Override
                public void setName(String qualifiedName) {
                    accessor.setName(qualifiedName);
                }

                @Override
                public UClass getPsiElement() {
                    return (UClass)UastContextKt.toUElement(accessor.getPsiElement(), UClass.class);
                }

                @Override
                public void setPsiElement(UClass uClass) {
                    accessor.setPsiElement(uClass);
                }
            };
        }

        @Override
        protected UClass convertNewElement(PsiElement newElement) {
            return (UClass)UastContextKt.toUElement((PsiElement)newElement, UClass.class);
        }

        @Override
        @Nullable
        public UClass findNewElement(UClass psiClass, String qualifiedName) {
            Module module = JavaExecutionUtil.findModule((PsiClass)psiClass);
            if (module == null) {
                return null;
            }
            return (UClass)UastContextKt.toUElement((PsiElement)JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(qualifiedName.replace('$', '.'), GlobalSearchScope.moduleScope((Module)module)), UClass.class);
        }

        @Override
        public String getQualifiedName(@NotNull UClass psiClass) {
            if (psiClass == null) {
                RefactorClass.$$$reportNull$$$0(0);
            }
            return psiClass.getQualifiedName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/execution/junit/RefactoringListeners$RefactorClass", "getQualifiedName"));
        }
    }

    private static class ClassPackageAccessor
    implements Accessor<PsiPackage> {
        private final PsiPackage myContainingPackage;
        private final Accessor<PsiClass> myAccessor;
        private final String myInpackageName;

        ClassPackageAccessor(Accessor<PsiClass> accessor) {
            String inpackageName;
            String classPackageQName;
            this.myAccessor = accessor;
            PsiClass aClass = this.myAccessor.getPsiElement();
            aClass = (PsiClass)aClass.getOriginalElement();
            this.myContainingPackage = JavaDirectoryService.getInstance().getPackage(aClass.getContainingFile().getContainingDirectory());
            String classQName = aClass.getQualifiedName();
            String string = classPackageQName = this.myContainingPackage != null ? this.myContainingPackage.getQualifiedName() : null;
            this.myInpackageName = classQName != null && classPackageQName != null && classQName.startsWith(classPackageQName) ? (StringUtil.startsWithChar((CharSequence)(inpackageName = classQName.substring(classPackageQName.length())), (char)'.') ? inpackageName.substring(1) : inpackageName) : null;
        }

        @Override
        public PsiPackage getPsiElement() {
            return this.myContainingPackage;
        }

        @Override
        public void setPsiElement(PsiPackage psiPackage) {
            if (this.myInpackageName != null) {
                this.myAccessor.setName(this.getClassQName(psiPackage.getQualifiedName()));
            }
        }

        @Override
        public void setName(String qualifiedName) {
            this.myAccessor.setName(this.getClassQName(qualifiedName));
        }

        private String getClassQName(String packageQName) {
            if (!packageQName.isEmpty()) {
                return packageQName + "." + this.myInpackageName;
            }
            return this.myInpackageName;
        }
    }

    public static final class RefactorPackageByClass
    extends RenameElement<PsiClass> {
        public RefactorPackageByClass(Accessor<? super PsiClass> accessor) {
            super(accessor, "*");
        }

        @Override
        @Nullable
        public PsiClass findNewElement(PsiClass psiClass, String qualifiedName) {
            Module module = JavaExecutionUtil.findModule((PsiClass)psiClass);
            if (module == null) {
                return null;
            }
            return JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(qualifiedName.replace('$', '.').replace("\\*", psiClass.getName()), GlobalSearchScope.moduleScope((Module)module));
        }

        @Override
        public String getQualifiedName(@NotNull PsiClass psiClass) {
            String qualifiedName;
            if (psiClass == null) {
                RefactorPackageByClass.$$$reportNull$$$0(0);
            }
            return (qualifiedName = psiClass.getQualifiedName()) != null ? StringUtil.getPackageName((String)qualifiedName) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/execution/junit/RefactoringListeners$RefactorPackageByClass", "getQualifiedName"));
        }
    }

    @ApiStatus.Internal
    public static abstract class RenameElement<T extends PsiElement>
    extends RefactoringElementAdapter
    implements UndoRefactoringElementListener {
        private final Accessor<? super T> myAccessor;
        private final String myPath;

        RenameElement(Accessor<? super T> accessor, String path) {
            this.myAccessor = accessor;
            this.myPath = path;
        }

        public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
            T newElement1;
            if (newElement == null) {
                RenameElement.$$$reportNull$$$0(0);
            }
            if ((newElement1 = this.convertNewElement(newElement)) == null) {
                return;
            }
            Object qualifiedName = this.getQualifiedName(newElement1);
            if (!this.myPath.isEmpty()) {
                qualifiedName = (String)qualifiedName + "." + this.myPath;
                newElement1 = this.findNewElement(newElement1, (String)qualifiedName);
            }
            if (newElement1 != null) {
                this.myAccessor.setPsiElement(newElement1);
            } else {
                this.myAccessor.setName((String)qualifiedName);
            }
        }

        @Nullable
        protected T convertNewElement(PsiElement newElement) {
            return (T)newElement;
        }

        @Nullable
        protected abstract T findNewElement(T var1, String var2);

        protected abstract String getQualifiedName(@NotNull T var1);

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                RenameElement.$$$reportNull$$$0(1);
            }
            if (oldQualifiedName == null) {
                RenameElement.$$$reportNull$$$0(2);
            }
            this.myAccessor.setName(oldQualifiedName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldQualifiedName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/junit/RefactoringListeners$RenameElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementRenamedOrMoved";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "undoElementMovedOrRenamed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SingleClassConfigurationAccessor
    implements Accessor<PsiClass> {
        private final SingleClassConfiguration myConfiguration;

        public SingleClassConfigurationAccessor(SingleClassConfiguration configuration) {
            this.myConfiguration = configuration;
        }

        @Override
        public PsiClass getPsiElement() {
            return this.myConfiguration.getMainClass();
        }

        @Override
        public void setPsiElement(PsiClass psiClass) {
            this.myConfiguration.setMainClass(psiClass);
        }

        @Override
        public void setName(String qualifiedName) {
            this.myConfiguration.setMainClassName(qualifiedName);
        }
    }
}

