/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.remote;

import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.java.JavaPluginDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.components.DropDownLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class RemoteConfigurable
extends SettingsEditor<RemoteConfiguration> {
    private static final int MIN_PORT_VALUE = 0;
    private static final int MAX_PORT_VALUE = 65535;
    private final JPanel mainPanel;
    private final JTextArea myArgsArea = new JTextArea();
    private final JComboBox<Mode> myModeCombo = new ComboBox((Object[])Mode.values());
    private final JBCheckBox myAutoRestart = new JBCheckBox(ExecutionBundle.message((String)"auto.restart", (Object[])new Object[0]));
    private final JComboBox<Transport> myTransportCombo = new ComboBox((Object[])Transport.values());
    private final ConfigurationModuleSelector myModuleSelector;
    private final JTextField myHostName = new JTextField();
    private final JTextField myAddress = new JTextField();
    private final JTextField myPort = new JTextField(Integer.toString(65535));

    public RemoteConfigurable(Project project) {
        this.myTransportCombo.setSelectedItem((Object)Transport.SOCKET);
        this.myPort.setMinimumSize(this.myPort.getPreferredSize());
        new ComponentValidator((Disposable)JavaPluginDisposable.getInstance((Project)project)).withValidator(() -> {
            String pt = this.myPort.getText();
            if (StringUtil.isNotEmpty((String)pt)) {
                try {
                    int portValue = Integer.parseInt(pt);
                    if (portValue >= 0 && portValue <= 65535) {
                        return null;
                    }
                    return new ValidationInfo(ExecutionBundle.message((String)"incorrect.port.range.set.value.between", (Object[])new Object[0]), (JComponent)this.myPort);
                }
                catch (NumberFormatException nfe) {
                    return new ValidationInfo(ExecutionBundle.message((String)"port.value.should.be.a.number.between", (Object[])new Object[0]), (JComponent)this.myPort);
                }
            }
            return null;
        }).installOn((JComponent)this.myPort);
        this.myPort.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ComponentValidator.getInstance((JComponent)RemoteConfigurable.this.myPort).ifPresent(v -> v.revalidate());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/remote/RemoteConfigurable$1", "textChanged"));
            }
        });
        GridBagConstraints gc = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 0, (Insets)JBUI.insets((int)4, (int)0, (int)0, (int)8), 0, 0);
        this.mainPanel = this.createModePanel(gc);
        JavaSdkVersion version = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)ProjectRootManager.getInstance((Project)project).getProjectSdk());
        JDKVersionItem vi = version != null ? Arrays.stream(JDKVersionItem.values()).filter(v -> version.isAtLeast(v.myVersion)).findFirst().orElse(JDKVersionItem.JDK9) : JDKVersionItem.JDK9;
        this.myArgsArea.setLineWrap(true);
        this.myArgsArea.setWrapStyleWord(true);
        this.myArgsArea.setRows(2);
        this.myArgsArea.setEditable(false);
        this.myArgsArea.setBorder((Border)new SideBorder(JBColor.border(), 15));
        this.myArgsArea.setMinimumSize(this.myArgsArea.getPreferredSize());
        this.myArgsArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                RemoteConfigurable.this.myArgsArea.selectAll();
            }
        });
        this.updateArgsText(vi);
        final DropDownLink ddl = new DropDownLink((Object)vi, Arrays.asList(JDKVersionItem.values()), i -> this.updateArgsText((JDKVersionItem)((Object)i)), true);
        ddl.setToolTipText(ExecutionBundle.message((String)"jvm.arguments.format", (Object[])new Object[0]));
        gc.gridx = 0;
        ++gc.gridy;
        gc.gridwidth = 6;
        gc.weightx = 1.0;
        gc.fill = 2;
        gc.insets = JBUI.insetsTop((int)10);
        this.mainPanel.add((Component)UI.PanelFactory.panel((JComponent)this.myArgsArea).withLabel(ExecutionBundle.message((String)"command.line.arguments.for.remote.jvm", (Object[])new Object[0])).moveLabelOnTop().withTopRightComponent((JComponent)ddl).withComment(ExecutionBundle.message((String)"copy.and.paste.the.arguments.to.the.command.line.when.jvm.is.started", (Object[])new Object[0])).createPanel(), gc);
        ModuleDescriptionsComboBox myModuleCombo = new ModuleDescriptionsComboBox();
        myModuleCombo.allowEmptySelection(JavaCompilerBundle.message((String)"whole.project", (Object[])new Object[0]));
        this.myModuleSelector = new ConfigurationModuleSelector(project, myModuleCombo);
        gc.gridx = 0;
        ++gc.gridy;
        gc.gridwidth = 6;
        gc.weightx = 1.0;
        gc.fill = 2;
        gc.insets = JBUI.insetsTop((int)21);
        this.mainPanel.add((Component)UI.PanelFactory.panel((JComponent)myModuleCombo).withLabel(ExecutionBundle.message((String)"use.module.classpath", (Object[])new Object[0])).withComment(ExecutionBundle.message((String)"first.search.for.sources.of.the.debugged.classes", (Object[])new Object[0])).createPanel(), gc);
        ++gc.gridy;
        gc.fill = 0;
        gc.insets = JBInsets.emptyInsets();
        gc.weighty = 1.0;
        this.mainPanel.add((Component)new JPanel(), gc);
        DocumentAdapter textUpdateListener = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                RemoteConfigurable.this.updateArgsText((JDKVersionItem)((Object)ddl.getSelectedItem()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/remote/RemoteConfigurable$3", "textChanged"));
            }
        };
        this.myAddress.getDocument().addDocumentListener((DocumentListener)textUpdateListener);
        this.myHostName.getDocument().addDocumentListener((DocumentListener)textUpdateListener);
        this.myPort.getDocument().addDocumentListener((DocumentListener)textUpdateListener);
        this.myModeCombo.addActionListener(l -> this.updateArgsText((JDKVersionItem)((Object)((Object)ddl.getSelectedItem()))));
        this.myTransportCombo.addActionListener(l -> this.updateArgsText((JDKVersionItem)((Object)((Object)ddl.getSelectedItem()))));
    }

    private void updateArgsText(@NotNull JDKVersionItem vi) {
        if (vi == null) {
            RemoteConfigurable.$$$reportNull$$$0(0);
        }
        this.myAutoRestart.setVisible(this.myModeCombo.getSelectedItem() == Mode.LISTEN);
        boolean useSockets = this.myTransportCombo.getSelectedItem() == Transport.SOCKET;
        RemoteConnection connection = new RemoteConnection(useSockets, this.myHostName.getText().trim(), useSockets ? this.myPort.getText().trim() : this.myAddress.getText().trim(), this.myModeCombo.getSelectedItem() == Mode.LISTEN);
        this.myArgsArea.setText(vi.getLaunchCommandLine(connection));
    }

    protected void resetEditorFrom(@NotNull RemoteConfiguration rc) {
        if (rc == null) {
            RemoteConfigurable.$$$reportNull$$$0(1);
        }
        this.myModeCombo.setSelectedItem((Object)(rc.SERVER_MODE ? Mode.LISTEN : Mode.ATTACH));
        this.myAutoRestart.setSelected(rc.AUTO_RESTART);
        if (SystemInfo.isWindows) {
            this.myTransportCombo.setSelectedItem((Object)(rc.USE_SOCKET_TRANSPORT ? Transport.SOCKET : Transport.SHMEM));
            if (!rc.USE_SOCKET_TRANSPORT) {
                this.myAddress.setText(rc.SHMEM_ADDRESS);
            }
        }
        if (!SystemInfo.isWindows || rc.USE_SOCKET_TRANSPORT) {
            rc.USE_SOCKET_TRANSPORT = true;
            this.myHostName.setText(rc.HOST);
            this.myPort.setText(rc.PORT);
        }
        this.myModuleSelector.reset(rc);
    }

    protected void applyEditorTo(@NotNull RemoteConfiguration rc) throws ConfigurationException {
        if (rc == null) {
            RemoteConfigurable.$$$reportNull$$$0(2);
        }
        rc.HOST = this.myHostName.getText().trim();
        if (rc.HOST.isEmpty()) {
            rc.HOST = null;
        }
        rc.PORT = this.myPort.getText().trim();
        if (rc.PORT.isEmpty()) {
            rc.PORT = null;
        }
        rc.SHMEM_ADDRESS = this.myAddress.getText().trim();
        if (rc.SHMEM_ADDRESS.isEmpty()) {
            rc.SHMEM_ADDRESS = null;
        }
        boolean bl = rc.USE_SOCKET_TRANSPORT = this.myTransportCombo.getSelectedItem() == Transport.SOCKET;
        if (rc.USE_SOCKET_TRANSPORT) {
            ComponentValidator.getInstance((JComponent)this.myPort).ifPresent(v -> v.revalidate());
        }
        rc.SERVER_MODE = this.myModeCombo.getSelectedItem() == Mode.LISTEN;
        rc.AUTO_RESTART = this.myAutoRestart.isVisible() && this.myAutoRestart.isSelected();
        this.myModuleSelector.applyTo(rc);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            RemoteConfigurable.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private static JLabel createLabelFor(@NlsContexts.Label String labelText, JComponent forComponent) {
        JLabel label = new JLabel();
        LabeledComponent.TextWithMnemonic.fromTextWithMnemonic((String)labelText).setToLabel(label);
        label.setLabelFor(forComponent);
        return label;
    }

    private JPanel createModePanel(GridBagConstraints gc) {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel modeLabel = RemoteConfigurable.createLabelFor(JavaCompilerBundle.message((String)"label.debugger.mode", (Object[])new Object[0]), this.myModeCombo);
        JLabel transportLabel = RemoteConfigurable.createLabelFor(JavaCompilerBundle.message((String)"label.transport", (Object[])new Object[0]), this.myTransportCombo);
        JLabel hostLabel = RemoteConfigurable.createLabelFor(JavaCompilerBundle.message((String)"label.host", (Object[])new Object[0]), this.myHostName);
        JLabel portLabel = RemoteConfigurable.createLabelFor(JavaCompilerBundle.message((String)"label.port", (Object[])new Object[0]), this.myPort);
        gc.gridwidth = 2;
        panel.add((Component)modeLabel, gc);
        gc.gridx += 2;
        gc.gridwidth = 1;
        gc.insets = JBUI.insetsTop((int)4);
        panel.add(this.myModeCombo, gc);
        ++gc.gridx;
        gc.gridwidth = 2;
        gc.fill = 0;
        gc.insets = JBUI.insets((int)4, (int)20, (int)0, (int)8);
        panel.add((Component)this.myAutoRestart, gc);
        gc.gridx += 2;
        gc.gridwidth = 1;
        gc.weightx = 1.0;
        gc.fill = 2;
        gc.insets = JBInsets.emptyInsets();
        panel.add((Component)new JPanel(), gc);
        if (SystemInfo.isWindows) {
            JLabel addressLabel = RemoteConfigurable.createLabelFor(JavaCompilerBundle.message((String)"label.address", (Object[])new Object[0]), this.myAddress);
            addressLabel.setVisible(false);
            this.myAddress.setVisible(false);
            gc.gridx = 0;
            ++gc.gridy;
            gc.weightx = 0.0;
            gc.gridwidth = 2;
            gc.fill = 0;
            gc.insets = JBUI.insets((int)4, (int)0, (int)0, (int)8);
            panel.add((Component)transportLabel, gc);
            gc.gridx += 2;
            gc.gridwidth = 1;
            gc.fill = 2;
            gc.insets = JBUI.insetsTop((int)4);
            panel.add(this.myTransportCombo, gc);
            ++gc.gridx;
            gc.weightx = 1.0;
            gc.gridwidth = 2;
            gc.fill = 0;
            panel.add((Component)new JPanel(), gc);
            ++gc.gridy;
            gc.gridx = 0;
            gc.weightx = 0.0;
            gc.gridwidth = 1;
            gc.insets = JBUI.insets((int)4, (int)0, (int)0, (int)8);
            gc.fill = 0;
            panel.add((Component)addressLabel, gc);
            ++gc.gridx;
            gc.gridwidth = 2;
            gc.insets = JBUI.insetsTop((int)4);
            gc.fill = 2;
            panel.add((Component)this.myAddress, gc);
            this.myTransportCombo.addActionListener(e -> {
                boolean isShmem = this.myTransportCombo.getSelectedItem() == Transport.SHMEM;
                hostLabel.setVisible(!isShmem);
                this.myPort.setVisible(!isShmem);
                this.myHostName.setVisible(!isShmem);
                portLabel.setVisible(!isShmem);
                addressLabel.setVisible(isShmem);
                this.myAddress.setVisible(isShmem);
            });
        }
        ++gc.gridy;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.gridwidth = 1;
        gc.insets = JBUI.insets((int)4, (int)0, (int)0, (int)8);
        gc.fill = 0;
        panel.add((Component)hostLabel, gc);
        ++gc.gridx;
        gc.gridwidth = 2;
        gc.insets = JBUI.insetsTop((int)4);
        gc.fill = 2;
        panel.add((Component)this.myHostName, gc);
        gc.gridx += 2;
        gc.gridwidth = 1;
        gc.fill = 0;
        gc.insets = JBUI.insets((int)4, (int)20, (int)0, (int)8);
        panel.add((Component)portLabel, gc);
        ++gc.gridx;
        gc.insets = JBUI.insetsTop((int)4);
        panel.add((Component)this.myPort, gc);
        ++gc.gridx;
        gc.weightx = 1.0;
        gc.fill = 2;
        gc.insets = JBInsets.emptyInsets();
        panel.add((Component)new JPanel(), gc);
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vi";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rc";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/remote/RemoteConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/remote/RemoteConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateArgsText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static enum Mode {
        ATTACH,
        LISTEN;


        public String toString() {
            return this == ATTACH ? ExecutionBundle.message((String)"combo.attach.to.remote", (Object[])new Object[0]) : ExecutionBundle.message((String)"combo.listen.to.remote", (Object[])new Object[0]);
        }
    }

    private static enum Transport {
        SOCKET("Socket"),
        SHMEM("Shared memory");

        private final String text;

        private Transport(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    private static enum JDKVersionItem {
        JDK9(JavaSdkVersion.JDK_1_9){

            @Override
            String getLaunchCommandLine(RemoteConnection connection) {
                String commandLine = JDK5to8.getLaunchCommandLine(connection);
                if (connection.isUseSockets() && !connection.isServerMode()) {
                    String address = connection.getApplicationAddress();
                    commandLine = commandLine.replace("address=" + address, "address=*:" + address);
                }
                return commandLine;
            }

            public String toString() {
                return ExecutionBundle.message((String)"combo.java.version.9+", (Object[])new Object[0]);
            }
        }
        ,
        JDK5to8(JavaSdkVersion.JDK_1_5){

            @Override
            String getLaunchCommandLine(RemoteConnection connection) {
                return connection.getLaunchCommandLine().replace("-Xdebug", "").replace("-Xrunjdwp:", "-agentlib:jdwp=").trim();
            }

            public String toString() {
                return ExecutionBundle.message((String)"combo.java.version.5.to.8", (Object[])new Object[0]);
            }
        }
        ,
        JDK1_4(JavaSdkVersion.JDK_1_4){

            @Override
            String getLaunchCommandLine(RemoteConnection connection) {
                return connection.getLaunchCommandLine();
            }

            public String toString() {
                return ExecutionBundle.message((String)"combo.java.version.1.4", (Object[])new Object[0]);
            }
        }
        ,
        JDK1_3(JavaSdkVersion.JDK_1_3){

            @Override
            String getLaunchCommandLine(RemoteConnection connection) {
                return "-Xnoagent -Djava.compiler=NONE " + connection.getLaunchCommandLine();
            }

            public String toString() {
                return ExecutionBundle.message((String)"combo.java.version.1.3", (Object[])new Object[0]);
            }
        };

        private final JavaSdkVersion myVersion;

        private JDKVersionItem(JavaSdkVersion version) {
            this.myVersion = version;
        }

        abstract String getLaunchCommandLine(RemoteConnection var1);
    }
}

