/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.indices;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.io.PersistentEnumerator;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class PersistentObjectSeq {
    private static final Logger LOG = Logger.getInstance(PersistentObjectSeq.class);
    private final Collection<PersistentObject> myObjects = ConcurrentCollectionFactory.createConcurrentSet();

    public void add(final InvertedIndex<?, ?, ?> index) {
        this.myObjects.add(new PersistentObject(){

            @Override
            public void flush() throws Exception {
                index.flush();
            }

            @Override
            public void close() {
                index.dispose();
            }
        });
    }

    public void add(final PersistentEnumerator<?> enumerator) {
        this.myObjects.add(new PersistentObject(){

            @Override
            public void flush() {
                if (enumerator.isDirty()) {
                    enumerator.force();
                }
            }

            @Override
            public void close() throws IOException {
                enumerator.close();
            }
        });
    }

    public void close(boolean ignoreCloseProblem) {
        for (PersistentObject object : this.myObjects) {
            try {
                object.close();
            }
            catch (Throwable throwable) {
                if (ignoreCloseProblem) continue;
                throw new RuntimeException(throwable);
            }
        }
    }

    public void flush() {
        for (PersistentObject object : this.myObjects) {
            try {
                object.flush();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void clear() {
        this.myObjects.clear();
    }

    static interface PersistentObject {
        public void flush() throws Exception;

        public void close() throws IOException;
    }
}

