/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.indices;

import com.intellij.execution.testDiscovery.indices.PersistentObjectSeq;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.PersistentHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestModuleIndex {
    private static final Logger LOG = Logger.getInstance(TestModuleIndex.class);
    private final PersistentHashMap<Integer, IntList> myTestNameToRunModule;
    private final PersistentEnumerator<String> myModuleNameEnumerator;

    public TestModuleIndex(@NotNull Path basePath, @NotNull PersistentObjectSeq persistentObjectSeq) throws IOException {
        if (basePath == null) {
            TestModuleIndex.$$$reportNull$$$0(0);
        }
        if (persistentObjectSeq == null) {
            TestModuleIndex.$$$reportNull$$$0(1);
        }
        Path moduleNameEnumeratorFile = basePath.resolve("moduleName.enum");
        this.myModuleNameEnumerator = new PersistentEnumerator(moduleNameEnumeratorFile, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, 64);
        persistentObjectSeq.add(this.myModuleNameEnumerator);
        Path testModuleIndexFile = basePath.resolve("testModule.index");
        this.myTestNameToRunModule = new PersistentHashMap(testModuleIndexFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new IntSeqExternalizer());
    }

    void appendModuleData(int testId, @Nullable String moduleName) throws IOException {
        if (moduleName != null) {
            int moduleId = this.myModuleNameEnumerator.enumerate((Object)moduleName);
            IntList previousRunModules = (IntList)this.myTestNameToRunModule.get((Object)moduleId);
            if (previousRunModules != null && previousRunModules.contains(moduleId)) {
                return;
            }
            this.myTestNameToRunModule.appendData((Object)testId, out -> DataInputOutputUtil.writeINT((DataOutput)out, (int)moduleId));
        }
    }

    @NotNull
    Collection<String> getTestRunModules(int testId) throws IOException {
        IntList moduleIds = (IntList)this.myTestNameToRunModule.get((Object)testId);
        if (moduleIds == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                TestModuleIndex.$$$reportNull$$$0(2);
            }
            return set;
        }
        ArrayList<String> result = new ArrayList<String>(moduleIds.size());
        for (int i = 0; i < moduleIds.size(); ++i) {
            int moduleId = moduleIds.getInt(i);
            String moduleName = (String)this.myModuleNameEnumerator.valueOf(moduleId);
            if (!LOG.assertTrue(moduleName != null)) continue;
            result.add(moduleName);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            TestModuleIndex.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    void removeTest(int testId) throws IOException {
        this.myTestNameToRunModule.remove((Object)testId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentObjectSeq";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/indices/TestModuleIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/indices/TestModuleIndex";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRunModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static final class IntSeqExternalizer
    implements DataExternalizer<IntList> {
        private IntSeqExternalizer() {
        }

        public void save(@NotNull DataOutput dataOutput, IntList testNameIds) throws IOException {
            if (dataOutput == null) {
                IntSeqExternalizer.$$$reportNull$$$0(0);
            }
            IntListIterator intListIterator = testNameIds.iterator();
            while (intListIterator.hasNext()) {
                int testNameId = (Integer)intListIterator.next();
                DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)testNameId);
            }
        }

        public IntList read(@NotNull DataInput dataInput) throws IOException {
            if (dataInput == null) {
                IntSeqExternalizer.$$$reportNull$$$0(1);
            }
            IntOpenHashSet result = new IntOpenHashSet();
            while (((InputStream)((Object)dataInput)).available() > 0) {
                result.add(DataInputOutputUtil.readINT((DataInput)dataInput));
            }
            return new IntArrayList((IntCollection)result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataOutput";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataInput";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/testDiscovery/indices/TestModuleIndex$IntSeqExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

