/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.AbstractJavaTestConfigurationProducer;
import com.intellij.lang.jvm.annotation.JvmAnnotationArrayValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttribute;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttributeValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationConstantValue;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.junit.JUnitCommonClassNames;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInClassConfigurationProducer<T extends JavaTestConfigurationBase>
extends AbstractJavaTestConfigurationProducer<T> {
    private static final Logger LOG = Logger.getInstance(AbstractInClassConfigurationProducer.class);

    protected AbstractInClassConfigurationProducer() {
    }

    public void onFirstRun(final @NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext fromContext, @NotNull Runnable performRunnable) {
        PsiElement psiElement;
        if (configuration == null) {
            AbstractInClassConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (fromContext == null) {
            AbstractInClassConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (performRunnable == null) {
            AbstractInClassConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((psiElement = configuration.getSourceElement()) instanceof PsiMethod || psiElement instanceof PsiClass) {
            PsiClass containingClass;
            PsiMethod psiMethod;
            if (psiElement instanceof PsiMethod) {
                psiMethod = (PsiMethod)psiElement;
                containingClass = psiMethod.getContainingClass();
            } else {
                psiMethod = null;
                containingClass = (PsiClass)psiElement;
            }
            InheritorChooser inheritorChooser = new InheritorChooser(this){

                @Override
                protected void runForClasses(List<PsiClass> classes, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
                    ReadAction.nonBlocking(() -> {
                        ((JavaTestConfigurationBase)configuration.getConfiguration()).bePatternConfiguration(classes, method);
                        if (!classes.isEmpty()) {
                            PsiClass containerClass = psiElement instanceof PsiMethod ? ((PsiMethod)psiElement).getContainingClass() : (PsiClass)psiElement;
                            this.setNestedClass((PsiClass)classes.get(0), containerClass);
                        }
                    }).finishOnUiThread(ModalityState.nonModal(), v -> super.runForClasses(classes, method, context, performRunnable)).submit((Executor)AppExecutorUtil.getAppExecutorService());
                }

                @Override
                protected void runForClass(PsiClass aClass, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable) {
                    PsiClass containerClass;
                    if (psiElement instanceof PsiMethod) {
                        Project project = psiMethod.getProject();
                        MethodLocation methodLocation = new MethodLocation(project, psiMethod, (Location<? extends PsiClass>)PsiLocation.fromPsiElement((PsiElement)aClass));
                        ((JavaTestConfigurationBase)configuration.getConfiguration()).beMethodConfiguration(methodLocation);
                        containerClass = psiMethod.getContainingClass();
                    } else {
                        ((JavaTestConfigurationBase)configuration.getConfiguration()).beClassConfiguration(aClass);
                        containerClass = (PsiClass)psiElement;
                    }
                    this.setNestedClass(aClass, containerClass);
                    super.runForClass(aClass, psiMethod, context, performRunnable);
                }

                private void setNestedClass(PsiClass aClass, PsiClass containerClass) {
                    if (containerClass != null && !aClass.isInheritor(containerClass, true)) {
                        for (PsiClass innerClass : aClass.getAllInnerClasses()) {
                            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)innerClass, (PsiClass)containerClass, (boolean)true)) continue;
                            ((JavaTestConfigurationBase)configuration.getConfiguration()).withNestedClass(innerClass);
                            break;
                        }
                    }
                }
            };
            if (inheritorChooser.runMethodInAbstractClass(fromContext, performRunnable, psiMethod, containingClass, (Condition<? super PsiClass>)((Condition)aClass -> aClass.hasModifierProperty("abstract") && this.isTestClass((PsiClass)aClass)))) {
                return;
            }
        }
        super.onFirstRun(configuration, fromContext, performRunnable);
    }

    protected boolean setupConfigurationFromContext(@NotNull T configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (configuration == null) {
            AbstractInClassConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            AbstractInClassConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (sourceElement == null) {
            AbstractInClassConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (this.isMultipleElementsSelected(context)) {
            return false;
        }
        Location contextLocation = context.getLocation();
        this.setupConfigurationParamName(configuration, contextLocation);
        PsiClass psiClass = null;
        Integer sourceValueIndex = null;
        for (PsiElement element = context.getPsiLocation(); element != null; element = element.getParent()) {
            PsiJavaToken token;
            JvmAnnotationAttribute annotationArrayValue;
            PsiClass cls;
            if (element instanceof PsiClass && this.isTestClass(cls = (PsiClass)element)) {
                psiClass = cls;
                break;
            }
            if (element instanceof PsiMember) {
                PsiMember member = (PsiMember)element;
                if (contextLocation instanceof MethodLocation) {
                    MethodLocation methodLoc = (MethodLocation)contextLocation;
                    v0 = methodLoc.getContainingClass();
                } else if (contextLocation instanceof PsiMemberParameterizedLocation) {
                    PsiMemberParameterizedLocation memberLoc = (PsiMemberParameterizedLocation)contextLocation;
                    v0 = memberLoc.getContainingClass();
                } else {
                    v0 = psiClass = member.getContainingClass();
                }
                if (!this.isTestClass(psiClass)) continue;
                break;
            }
            if (element instanceof PsiClassOwner) {
                PsiClassOwner classOwner = (PsiClassOwner)element;
                PsiClass[] classes = classOwner.getClasses();
                if (classes.length != 1) continue;
                psiClass = classes[0];
                break;
            }
            if (!(element instanceof PsiJavaToken) || (annotationArrayValue = AbstractInClassConfigurationProducer.getAnnotationValue(token = (PsiJavaToken)element)) == null) continue;
            sourceValueIndex = AbstractInClassConfigurationProducer.getSourceValueIndex(token, annotationArrayValue);
        }
        if (!this.isTestClass(psiClass)) {
            return false;
        }
        String classQualifiedName = psiClass.getQualifiedName();
        if (classQualifiedName == null) {
            return false;
        }
        PsiClass psiElement = psiClass;
        RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(context);
        this.setupConfigurationModule(context, configuration);
        Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        ((JavaTestConfigurationBase)configuration).beClassConfiguration(psiClass);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context.getPsiLocation(), PsiMethod.class, (boolean)false);
        while (method != null) {
            if (this.isTestMethod(false, method)) {
                ((JavaTestConfigurationBase)configuration).beMethodConfiguration(MethodLocation.elementInClass(method, psiClass));
                psiElement = method;
            }
            method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)method, PsiMethod.class);
        }
        configuration.restoreOriginalModule(originalModule);
        Module module = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        if (module == null && psiClass.getManager().isInProject((PsiElement)psiClass)) {
            PsiFile containingFile = psiClass.getContainingFile();
            if (LOG.isDebugEnabled()) {
                LOG.info("No module found: generated name:" + configuration.getName() + "; valid: " + psiClass.isValid() + "; physical: " + psiClass.isPhysical() + "; className: " + classQualifiedName + "; file: " + String.valueOf(containingFile) + "; module: " + String.valueOf(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass.getContainingFile())) + "; original module: " + String.valueOf(originalModule));
            }
            return false;
        }
        settings.setName(configuration.getName());
        sourceElement.set((Object)psiElement);
        if (sourceValueIndex != null) {
            String oldParameters = configuration.getProgramParameters() != null ? configuration.getProgramParameters() + " " : "";
            String newProgramParameters = oldParameters + "valueSource " + sourceValueIndex;
            configuration.setProgramParameters(newProgramParameters);
        }
        return true;
    }

    @Nullable
    private static JvmAnnotationAttribute getAnnotationValue(PsiJavaToken token) {
        PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)token, PsiAnnotation.class, (boolean)true, (Class[])new Class[]{PsiMethod.class});
        if (psiAnnotation == null) {
            return null;
        }
        DumbService dumbService = DumbService.getInstance((Project)psiAnnotation.getProject());
        String annotationName = dumbService.isAlternativeResolveEnabled() ? psiAnnotation.getQualifiedName() : (String)dumbService.computeWithAlternativeResolveEnabled(() -> psiAnnotation.getQualifiedName());
        if (annotationName == null) {
            return null;
        }
        boolean match = ContainerUtil.exists((Iterable)JUnitCommonClassNames.SOURCE_ANNOTATIONS, anno -> annotationName.equals(anno));
        if (!match) {
            return null;
        }
        PsiElement annotationContext = psiAnnotation.getContext();
        if (annotationContext == null) {
            return null;
        }
        PsiElement parent = annotationContext.getParent();
        if (parent instanceof PsiModifierListOwner) {
            boolean isMetaAnnotated = MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)parent), Collections.singleton("org.junit.jupiter.params.ParameterizedTest"));
            if (!isMetaAnnotated) {
                return null;
            }
            return (JvmAnnotationAttribute)ContainerUtil.getFirstItem((List)psiAnnotation.getAttributes());
        }
        return null;
    }

    private static Integer getSourceValueIndex(PsiJavaToken token, JvmAnnotationAttribute attribute) {
        String text;
        JvmAnnotationArrayValue values;
        List valuesAttr;
        JvmAnnotationAttributeValue value;
        JvmAnnotationAttributeValue annotationValues = attribute.getAttributeValue();
        if (annotationValues instanceof JvmAnnotationArrayValue && (value = (JvmAnnotationAttributeValue)ContainerUtil.find((Iterable)(valuesAttr = (values = (JvmAnnotationArrayValue)annotationValues).getValues()), arg_0 -> AbstractInClassConfigurationProducer.lambda$getSourceValueIndex$3(text = token.getText(), arg_0))) != null) {
            return valuesAttr.indexOf(value);
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$getSourceValueIndex$3(String text, JvmAnnotationAttributeValue v) {
        if (v instanceof JvmAnnotationConstantValue) {
            Object constantValue = ((JvmAnnotationConstantValue)v).getConstantValue();
            return constantValue != null && text.equals("\"" + String.valueOf(constantValue) + "\"");
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "performRunnable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/AbstractInClassConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onFirstRun";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

